/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.policy;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.policy.FilePathUtil;
import com.ibm.ws.security.policy.Parser;
import com.ibm.ws.security.util.ParserException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;

abstract class ApplicationParser
extends Parser {
    ApplicationParser(Reader reader, boolean bl) {
        super(reader, bl);
    }

    Parser.GrantEntry parseGrantEntry() throws IOException, ParserException {
        Object object;
        Parser.GrantEntry grantEntry = new Parser.GrantEntry(this);
        this.parser.match("grant");
        while (!this.parser.peek("{")) {
            if (this.parser.peek("codeBase")) {
                this.parser.match("codeBase");
                grantEntry.codeBase = this.parser.match("quoted string");
                if (!this.parser.peek(",")) continue;
                this.parser.match(",");
                continue;
            }
            if (this.parser.peek("signedBy")) {
                this.parser.match("signedBy");
                grantEntry.signedBy = this.parser.match("quoted string");
                if (!this.parser.peek(",")) continue;
                this.parser.match(",");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected codeBase or signedBy");
        }
        this.parser.match("{");
        while (!this.parser.peek("}")) {
            if (this.parser.peek("permission")) {
                try {
                    object = this.parsePermissionEntry();
                    grantEntry.add((Parser.PermissionEntry)object);
                }
                catch (Parser.ExpandException expandException) {
                    FFDCFilter.processException((Throwable)expandException, "com.ibm.ws.security.policy.ApplicationParser.parseGrantEntry", "62", this);
                    this.warning("security.policy.appparser.expandperm", new Object[]{expandException});
                    this.parser.skipEntry();
                }
                this.parser.match(";");
                continue;
            }
            throw new ParserException(this.parser.getLineNumber(), "expected permission entry");
        }
        this.parser.match("}");
        try {
            if (grantEntry.codeBase != null) {
                object = this.canonicalizeCodeBase(grantEntry.codeBase);
                grantEntry.codeBase = !this.isStandardSymbl((String)object) ? this.expand((String)object, true) : object;
            }
            grantEntry.signedBy = this.expand(grantEntry.signedBy);
        }
        catch (Parser.ExpandException expandException) {
            FFDCFilter.processException((Throwable)expandException, "com.ibm.ws.security.policy.ApplicationParser.parseGrantEntry", "81", this);
            this.warning("security.policy.appparser.expandgrant", new Object[]{expandException});
            return null;
        }
        return grantEntry;
    }

    private String canonicalizeCodeBase(String string) {
        String string2 = string.toLowerCase();
        String string3 = string;
        if (string2.startsWith("file:")) {
            try {
                URL uRL = new URL(string);
                if (uRL.getProtocol().equalsIgnoreCase("file")) {
                    File file;
                    String string4 = uRL.getFile();
                    if (this.isDebugEnabled()) {
                        this.debug("fileName = " + string4);
                    }
                    if (!(file = new File(string4)).isAbsolute()) {
                        string3 = string4.replace('/', File.separatorChar);
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                this.warning("security.policy.malformedURL", new Object[]{malformedURLException, string3});
            }
        }
        if (this.isDebugEnabled()) {
            this.debug("result = " + string3);
        }
        return string3;
    }

    public boolean isAppSymbol(String string) {
        if (string.equalsIgnoreCase("${app.installed.path}")) {
            return true;
        }
        if (string.equalsIgnoreCase("${was.module.path}")) {
            return true;
        }
        if (string.equalsIgnoreCase("${current.node.name}")) {
            return true;
        }
        if (string.equalsIgnoreCase("${current.cell.name}")) {
            return true;
        }
        return string.equalsIgnoreCase("${current.server.name}");
    }

    public boolean isStandardSymbl(String string) {
        if (string.equalsIgnoreCase("${webcomponent}")) {
            return true;
        }
        if (string.equalsIgnoreCase("${ejbcomponent}")) {
            return true;
        }
        if (string.equalsIgnoreCase("${application}")) {
            return true;
        }
        if (string.equalsIgnoreCase("${jars}")) {
            return true;
        }
        return string.equalsIgnoreCase("${connectorcomponent}");
    }

    String expand(String string, boolean bl) throws Parser.ExpandException {
        if (this.expandProp) {
            int n = 0;
            if (string == null || (n = string.length()) == 0) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(n + 25);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = string.indexOf("${", i);
                if (n2 == -1) {
                    stringBuffer.append(string.substring(i));
                    break;
                }
                stringBuffer.append(string.substring(i, n2));
                i = string.indexOf("}", n2);
                if (i == -1) {
                    stringBuffer.append(string.substring(n2));
                    break;
                }
                String string2 = string.substring(n2 + 2, i);
                if (string2.equals("/")) {
                    stringBuffer.append(File.separator);
                    continue;
                }
                String string3 = System.getProperty(string2);
                if (string3 != null) {
                    if (bl) {
                        string3 = FilePathUtil.encodeFilePath(string3);
                    }
                    stringBuffer.append(string3);
                    continue;
                }
                if (!this.isAppSymbol("${" + string2 + "}")) {
                    StringBuffer stringBuffer2 = new StringBuffer(32);
                    stringBuffer2.append("line ").append(this.parser.getLineNumber()).append(": ");
                    stringBuffer2.append("unable to expand \"").append(string2).append("\"");
                    String string4 = stringBuffer2.toString();
                    this.error("security.policy.parser.encodeFilePath", new Object[]{string4});
                    throw new Parser.ExpandException(this, string4);
                }
                stringBuffer.append("${");
                stringBuffer.append(string2);
                stringBuffer.append("}");
            }
            return stringBuffer.toString();
        }
        return string;
    }
}

