/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.InvalidTokenException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class LTPATokenizer {
    private static final char TOKEN_DELIM = '%';
    private static final char USER_DATA_DELIM = '$';
    private static final char USER_ATTRIB_DELIM = ':';
    private static final String STRING_ATTRIB_DELIM = "|";
    private static final TraceComponent tc = Tr.register(LTPATokenizer.class, null, "com.ibm.ejs.resources.security");

    public static String createUserData(Map map) {
        Iterator iterator = map.keySet().iterator();
        String string = "";
        StringBuffer stringBuffer = new StringBuffer(string);
        if (map.size() > 1) {
            TreeSet treeSet = new TreeSet();
            Iterator<Object> iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                treeSet.add(iterator2.next());
            }
            iterator2 = treeSet.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                ArrayList arrayList = (ArrayList)map.get(string2);
                String string3 = LTPATokenizer.convertArrayListToString(arrayList);
                if (string3 == null) continue;
                stringBuffer.append(string2).append(':').append(string3).append('$');
            }
        } else {
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                ArrayList arrayList = (ArrayList)map.get(string4);
                String string5 = LTPATokenizer.convertArrayListToString(arrayList);
                stringBuffer.append(string4).append(':').append(string5).append('$');
            }
        }
        string = stringBuffer.toString();
        return string.substring(0, string.length() - 1);
    }

    private static String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '$': 
                case '%': 
                case ':': {
                    stringBuffer.append('\\');
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String[] parseToken(String string) throws InvalidTokenException {
        String[] stringArray = new String[3];
        int n = string.length();
        int n2 = -1;
        int n3 = -1;
        try {
            for (int i = n - 1; i > -1; --i) {
                char c = string.charAt(i);
                if (c != '%' || string.charAt(i - 1) == '\\') continue;
                if (n2 == -1) {
                    n2 = i + 1;
                    continue;
                }
                n3 = i + 1;
                break;
            }
            if (n3 == -1) {
                n3 = n2;
                stringArray[0] = string.substring(0, n3 - 1);
                stringArray[1] = string.substring(n3, n);
            } else {
                stringArray[0] = string.substring(0, n3 - 1);
                stringArray[1] = string.substring(n3, n2 - 1);
                stringArray[2] = string.substring(n2, n);
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "Caught an exception when parsing a token. This could mean the token is invalid: ", exception.toString());
            throw new InvalidTokenException(exception.getMessage(), exception);
        }
        return stringArray;
    }

    public static Map parseUserData(String string) throws InvalidTokenException {
        ArrayList arrayList;
        int n;
        int n2;
        String string2;
        int n3 = string.length();
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
        String string3 = "";
        String string4 = "";
        for (n6 = 0; n6 < n3; ++n6) {
            if (string.charAt(n6) != '$' || string.charAt(n6 - 1) == '\\') continue;
            ++n4;
            string2 = string.substring(n5, n6);
            n5 = n6 + 1;
            n2 = 0;
            n = string2.length();
            for (n2 = 0; n2 < n; ++n2) {
                if (string2.charAt(n2) != ':' || string2.charAt(n2 - 1) == '\\') continue;
                string3 = string2.substring(0, n2);
                string4 = string2.substring(n2 + 1, n);
                arrayList = LTPATokenizer.convertStringToArrayList(string4);
                if (arrayList == null) continue;
                hashMap.put(string3, arrayList);
            }
        }
        string2 = string.substring(n5, n3);
        n2 = 0;
        n = string2.length();
        for (n2 = 0; n2 < n; ++n2) {
            if (string2.charAt(n2) != ':' || string2.charAt(n2 - 1) == '\\') continue;
            string3 = string2.substring(0, n2);
            string4 = string2.substring(n2 + 1, n);
            arrayList = LTPATokenizer.convertStringToArrayList(string4);
            if (arrayList == null) continue;
            hashMap.put(string3, arrayList);
        }
        return hashMap;
    }

    private static String convertArrayListToString(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        if (arrayList != null && arrayList.size() > 0) {
            String[] stringArray = null;
            stringArray = arrayList.toArray(new String[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(STRING_ATTRIB_DELIM);
                }
                stringBuffer.append(LTPATokenizer.escape(stringArray[i]));
            }
            return stringBuffer.toString();
        }
        return null;
    }

    private static ArrayList convertStringToArrayList(String string) {
        if (string != null && string.length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, STRING_ATTRIB_DELIM);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = LTPATokenizer.unescape(stringTokenizer.nextToken());
                if (string2 == null) continue;
                arrayList.add(string2);
            }
            return arrayList;
        }
        return null;
    }

    private static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < n - 1) {
                char c2 = string.charAt(i + 1);
                if (c2 == '$' || c2 == ':' || c2 == '%') continue;
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

