/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyPair;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.ltpa.LTPAToken;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.security.Key;
import java.util.Iterator;
import java.util.Map;

public class LTPATokenFactory
implements TokenFactory {
    private static final TraceComponent tc = Tr.register(LTPATokenFactory.class, "Security", "com.ibm.ejs.resources.security");
    private Long _expirationLimit = null;
    private byte[] _sharedKey = null;
    private LTPAPublicKey _publicKey = null;
    private LTPAPrivateKey _privateKey = null;
    private Map _validationKeys = null;

    public void initialize(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        try {
            this._expirationLimit = (Long)map.get("com.ibm.wsspi.security.ltpa.expiration");
            this._sharedKey = (byte[])map.get("com.ibm.wsspi.security.ltpa.ltpa_shared_key");
            this._publicKey = (LTPAPublicKey)map.get("com.ibm.wsspi.security.ltpa.ltpa_public_key");
            this._privateKey = (LTPAPrivateKey)map.get("com.ibm.wsspi.security.ltpa.ltpa_private_key");
            this._validationKeys = (Map)map.get("com.ibm.wsspi.security.ltpa.ltpa_validation_keys");
        }
        catch (Exception exception) {
            Tr.debug(tc, "Exception initializing LTPAToken2Factory.", new Object[]{exception});
            FFDCFilter.processException(exception, "com.ibm.ws.security.ltpa.LTPAToken2Factory.initialize", "56");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public Token validateTokenBytes(byte[] byArray) throws InvalidTokenException, TokenExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateTokenBytes");
        }
        LTPAToken lTPAToken = null;
        if (this._sharedKey != null && this._publicKey != null && this._privateKey != null) {
            lTPAToken = new LTPAToken(byArray, this._sharedKey, this._privateKey, this._publicKey);
            if (lTPAToken != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateTokenBytes (success)");
                }
                return lTPAToken;
            }
        } else if (this._validationKeys != null) {
            Throwable throwable = null;
            Iterator iterator = this._validationKeys.values().iterator();
            while (iterator.hasNext()) {
                Map map = (Map)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validating using keyMap: " + map);
                }
                if (map == null) continue;
                Iterator iterator2 = map.values().iterator();
                byte[] byArray2 = null;
                LTPAPublicKey lTPAPublicKey = null;
                LTPAPrivateKey lTPAPrivateKey = null;
                while (iterator2.hasNext()) {
                    Object v = iterator2.next();
                    if (v instanceof Key) {
                        byArray2 = ((Key)v).getEncoded();
                        continue;
                    }
                    if (!(v instanceof KeyPair)) continue;
                    lTPAPublicKey = new LTPAPublicKey(((KeyPair)v).getPublicKey().getEncoded());
                    lTPAPrivateKey = new LTPAPrivateKey(((KeyPair)v).getPrivateKey().getEncoded());
                }
                if (byArray2 == null || lTPAPublicKey == null || lTPAPrivateKey == null) continue;
                try {
                    lTPAToken = new LTPAToken(byArray, byArray2, lTPAPrivateKey, lTPAPublicKey);
                    if (lTPAToken == null) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateTokenBytes (success)");
                    }
                    return lTPAToken;
                }
                catch (Exception exception) {
                    if (exception instanceof TokenExpiredException) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "validateTokenBytes (expired)");
                        }
                        throw (TokenExpiredException)exception;
                    }
                    throwable = exception;
                    Tr.debug(tc, "Exception validating LTPAToken using validation keys.", new Object[]{exception.getMessage()});
                }
            }
            if (throwable != null && throwable instanceof InvalidTokenException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateTokenBytes (invalid token)");
                }
                throw (InvalidTokenException)throwable;
            }
            if (throwable != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateTokenBytes (" + throwable.getClass().getName() + ")");
                }
                throw new InvalidTokenException(throwable.getMessage(), throwable);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validateTokenBytes (unknown error)");
            }
            throw new InvalidTokenException("Error validating LTPA token.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateTokenBytes (no keys)");
        }
        throw new InvalidTokenException("Token factory not properly initialized.");
    }

    public Token createToken(Map map) throws TokenCreationFailedException {
        String string = (String)map.get("com.ibm.wsspi.security.cred.uniqueId");
        if (string == null || string.length() == 0) {
            throw new TokenCreationFailedException("UniqueID is null.");
        }
        return new LTPAToken(string, this._expirationLimit, this._sharedKey, this._privateKey, this._publicKey);
    }
}

