/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.ltpa.LTPADigSignature;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.ltpa.LTPATokenizer;
import com.ibm.ws.security.ltpa.UserData;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.wsspi.security.ltpa.Token;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;

public class LTPAToken2
implements Token,
Serializable {
    private static final TraceComponent tc = Tr.register(LTPAToken2.class, null, "com.ibm.ejs.resources.security");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yy.MM.dd kk:mm:ss:SSS z");
    private UserData userData;
    private long expiration;
    private int defaultExpirationMins = 120;
    private byte[] signature;
    private String cipher = null;
    public static final String DELIM = "%";
    private byte[] encryptedBytes = null;
    private byte[] sharedKey = null;
    private LTPAPrivateKey privateKey = null;
    private LTPAPublicKey publicKey = null;
    private String userId = null;
    private short version = 1;

    public LTPAToken2(byte[] byArray, byte[] byArray2, LTPAPrivateKey lTPAPrivateKey, LTPAPublicKey lTPAPublicKey) throws InvalidTokenException, TokenExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate LTPAToken2 from byte[]");
        }
        this.expiration = 0L;
        this.sharedKey = byArray2;
        this.privateKey = lTPAPrivateKey;
        this.publicKey = lTPAPublicKey;
        this.encryptedBytes = byArray;
        this.cipher = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.ltpaToken2Cipher");
        this.decrypt();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogInfo().toString());
        }
        if (!this.isValid()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LTPAToken2 failed to validate.");
            }
            throw new InvalidTokenException("LTPAToken2 failed to validate.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate LTPAToken2 from byte[]");
        }
    }

    public LTPAToken2(String string, long l, byte[] byArray, LTPAPrivateKey lTPAPrivateKey, LTPAPublicKey lTPAPublicKey) throws TokenCreationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "new LTPAToken2 from accessID");
        }
        this.sharedKey = byArray;
        this.privateKey = lTPAPrivateKey;
        this.publicKey = lTPAPublicKey;
        this.userData = new UserData(string);
        this.userId = string;
        this.cipher = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.ltpaToken2Cipher");
        this.encryptedBytes = null;
        this.setExpiration(System.currentTimeMillis() + l * 60L * 1000L);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expiration set to: " + new Date(this.getExpiration()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "new LTPAToken2 from accessID");
        }
    }

    protected LTPAToken2(long l, byte[] byArray, LTPAPrivateKey lTPAPrivateKey, LTPAPublicKey lTPAPublicKey, UserData userData) throws TokenCreationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "new LTPAToken2 from clone");
        }
        this.sharedKey = byArray;
        this.privateKey = lTPAPrivateKey;
        this.publicKey = lTPAPublicKey;
        this.userData = userData;
        this.cipher = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.ltpaToken2Cipher");
        this.encryptedBytes = null;
        long l2 = System.currentTimeMillis();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Refreshing expiration of token.");
        }
        Long l3 = (Long)SecurityConfig.getConfig().getValue("security.ltpa.expirydate");
        this.setExpiration(l2 + l3 * 60L * 1000L);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expiration set to: " + new Date(this.getExpiration()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "new LTPAToken2 from clone");
        }
    }

    protected void encrypt() {
        int n;
        byte[] byArray = Base64Coder.base64Encode(this.signature);
        String string = StringUtil.toString(byArray);
        String string2 = this.userData.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "encrypt()\n   ud: " + string2);
        }
        byte[] byArray2 = LTPAToken2.toBytes(string2);
        StringBuffer stringBuffer = new StringBuffer(DELIM);
        stringBuffer.append(this.getExpiration()).append(DELIM).append(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "tokenData before encrypt: " + stringBuffer.toString());
        }
        byte[] byArray3 = StringUtil.getBytes(stringBuffer.toString());
        byte[] byArray4 = new byte[byArray2.length + byArray3.length];
        for (n = 0; n < byArray2.length; ++n) {
            byArray4[n] = byArray2[n];
        }
        for (n = byArray2.length; n < byArray4.length; ++n) {
            byArray4[n] = byArray3[n - byArray2.length];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "encrypt()\n   toBeEnc: " + new String(byArray4));
        }
        LTPACrypto lTPACrypto = new LTPACrypto();
        this.encryptedBytes = LTPACrypto.encrypt(byArray4, this.sharedKey, this.cipher, true);
    }

    protected void decrypt() throws InvalidTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "decrypt");
        }
        LTPACrypto lTPACrypto = new LTPACrypto();
        try {
            byte[] byArray = (byte[])this.encryptedBytes.clone();
            byte[] byArray2 = LTPACrypto.decrypt(byArray, this.sharedKey, this.cipher, true);
            String string = LTPAToken2.toStrings(byArray2);
            String[] stringArray = LTPATokenizer.parseToken(string);
            Map map = LTPATokenizer.parseUserData(stringArray[0]);
            this.userData = new UserData(map);
            String string2 = StringUtil.toString(byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tokenString after decrypt: " + string2);
            }
            String[] stringArray2 = LTPATokenizer.parseToken(string2);
            String[] stringArray3 = this.userData.getAttributes("expire");
            if (stringArray3 != null && stringArray3[stringArray3.length - 1] != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting expiration from userdata area.");
                }
                this.expiration = Long.parseLong(stringArray3[stringArray3.length - 1]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Expiration set to: " + new Date(this.getExpiration()));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting expiration from expiration field.");
                }
                this.expiration = Long.parseLong(stringArray2[1]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Expiration set to: " + new Date(this.getExpiration()));
                }
            }
            String string3 = Base64Coder.base64Decode(stringArray2[2]);
            this.setSignature(StringUtil.getBytes(string3));
        }
        catch (Throwable throwable) {
            ContextManagerFactory.getInstance().setRootException(throwable);
            throw new InvalidTokenException(throwable.getMessage(), throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrypt");
        }
    }

    protected void sign() throws NoSuchAlgorithmException {
        byte[] byArray = null;
        String string = this.getUserData().toString();
        byte[] byArray2 = LTPAToken2.toBytes(string);
        byArray = LTPADigSignature.sign(byArray2, this.privateKey, true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sign()\n   data: " + string);
            Tr.debug(tc, "sign()\n   signature: " + LTPACrypto.toHexString(byArray));
        }
        this.setSignature(byArray);
    }

    public boolean isValid() throws InvalidTokenException, TokenExpiredException {
        Date date = new Date();
        Date date2 = new Date(this.getExpiration());
        boolean bl = date.before(date2);
        if (!bl) {
            StringBuffer stringBuffer = this.getLogInfo();
            stringBuffer.insert(0, "token expired ");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, stringBuffer.toString());
            }
            throw new TokenExpiredException("Token expiration Date: " + date2 + ", current Date: " + date);
        }
        boolean bl2 = false;
        try {
            bl2 = this.verify();
        }
        catch (Exception exception) {
            bl2 = false;
            throw new InvalidTokenException(exception.getMessage(), exception);
        }
        if (!bl2) {
            StringBuffer stringBuffer = this.getLogInfo();
            stringBuffer.insert(0, "invalid signature ");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        return bl && bl2;
    }

    private boolean verify() throws NoSuchAlgorithmException {
        boolean bl = false;
        String string = this.getUserData().toString();
        byte[] byArray = this.getSignature();
        byte[] byArray2 = LTPAToken2.toBytes(string);
        bl = LTPADigSignature.verify(byArray2, byArray, this.publicKey, true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "verify()\n   data: " + string);
            Tr.debug(tc, "verify()\n   publicKey: " + this.publicKey);
            Tr.debug(tc, "verify()\n   signature: " + LTPACrypto.toHexString(byArray));
            Tr.debug(tc, "verify() result: " + bl);
        }
        return bl;
    }

    private static String toStrings(byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug(tc, "to UTF8 Strings =" + unsupportedEncodingException.toString());
        }
        return string;
    }

    private static byte[] toBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug(tc, "to UTF8 bytes =" + unsupportedEncodingException.toString());
        }
        return byArray;
    }

    public byte[] getBytes() throws InvalidTokenException, TokenExpiredException {
        if (this.encryptedBytes != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning existing encrypted bytes from token object.");
            }
            return this.encryptedBytes;
        }
        try {
            this.sign();
            this.encrypt();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "NoSuchAlgorithmException: " + noSuchAlgorithmException.getMessage(), new Object[]{noSuchAlgorithmException});
            }
            throw new InvalidTokenException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        if (!this.isValid() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Expired or invalid LTPA token constructed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogInfo().toString());
        }
        return this.encryptedBytes;
    }

    byte[] getSignature() {
        return this.signature;
    }

    UserData getUserData() {
        return this.userData;
    }

    public String[] addAttribute(String string, String string2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Token was updated thus clearing encrypted bytes to re-encrypt.");
        }
        this.signature = null;
        this.encryptedBytes = null;
        return this.userData.addAttribute(string, string2);
    }

    public String[] getAttributes(String string) {
        return this.userData.getAttributes(string);
    }

    public Enumeration getAttributeNames() {
        return this.userData.getAttributeNames();
    }

    void setSignature(byte[] byArray) {
        this.signature = byArray;
    }

    public String toString() {
        return StringUtil.toString(this.encryptedBytes);
    }

    public short getVersion() {
        return this.version;
    }

    private StringBuffer getLogInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = this.getAttributes(string);
            stringBuffer.append(string);
            stringBuffer.append(": ");
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(" | ");
            }
        }
        stringBuffer.append("Expiration time: ");
        stringBuffer.append(dateFormat.format(new Date(this.getExpiration())));
        return stringBuffer;
    }

    public Object clone() {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expiration passed into cloned token: " + this.getExpiration());
            }
            UserData userData = (UserData)this.userData.clone();
            if (LTPAServerObject.primaryTokenFactoryMap != null && LTPAServerObject.primaryTokenFactoryMap.size() > 0) {
                byte[] byArray = (byte[])LTPAServerObject.primaryTokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_shared_key");
                LTPAPublicKey lTPAPublicKey = (LTPAPublicKey)LTPAServerObject.primaryTokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_public_key");
                LTPAPrivateKey lTPAPrivateKey = (LTPAPrivateKey)LTPAServerObject.primaryTokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_private_key");
                if (byArray != null && lTPAPrivateKey != null && lTPAPublicKey != null) {
                    this.sharedKey = byArray;
                    this.privateKey = lTPAPrivateKey;
                    this.publicKey = lTPAPublicKey;
                }
            }
            if (LTPAServerObject.sharedKey != null && LTPAServerObject.ltpaPrivKey != null && LTPAServerObject.ltpaPubKey != null) {
                this.sharedKey = LTPAServerObject.sharedKey;
                this.privateKey = LTPAServerObject.ltpaPrivKey;
                this.publicKey = LTPAServerObject.ltpaPubKey;
            }
            return new LTPAToken2(this.getExpiration(), this.sharedKey, this.privateKey, this.publicKey, userData);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.ltpa.LTPAToken2.clone", "483");
            return null;
        }
    }

    public long getExpiration() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expiration returned from expire field in token: " + new Date(this.expiration));
        }
        return this.expiration;
    }

    private void setExpiration(long l) {
        this.signature = null;
        if (this.userData != null) {
            this.encryptedBytes = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expiration set in userData of token: " + new Date(l));
            }
            this.userData.addAttribute("expire", Long.toString(l));
            this.expiration = l;
        } else {
            this.encryptedBytes = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expiration set in expiration field of token: " + new Date(l));
            }
            this.expiration = l;
        }
    }
}

