/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.oa.EJSORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyException;
import com.ibm.websphere.crypto.KeyPair;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.crypto.config.KeyReference;
import com.ibm.ws.crypto.config.KeySetGroupManager;
import com.ibm.ws.crypto.config.KeySetManager;
import com.ibm.ws.crypto.config.WSKeyPairReference;
import com.ibm.ws.crypto.config.WSKeyReference;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.crypto.config.WSKeySetGroup;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.KeyEncryptor;
import com.ibm.ws.security.ltpa.LTPACrypto;
import com.ibm.ws.security.ltpa.LTPADigSignature;
import com.ibm.ws.security.ltpa.LTPAKeyPair;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.registry.UnsupportedEntryTypeException;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.Base64Coder;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.WSKeyStore;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.Key;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.crypto.spec.SecretKeySpec;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public final class LTPAServerObject {
    private static final TraceComponent tc = Tr.register(LTPAServerObject.class, "Security", "com.ibm.ejs.resources.security");
    private static final String NONE = "";
    private static final String USERTYPE = "user:";
    private static final String GROUPTYPE = "group:";
    private static final String SERVERTYPE = "server:";
    private static final String ROLETYPE = "role";
    private static final String[] supportedTypes = new String[]{"group:", "user:", "server:"};
    private static final int GROUP = 0;
    private static final int USER = 1;
    private static final int SERVER = 2;
    private static final String realmSeparator = "/";
    private static final String typeSeparator = ":";
    private static final String tokenFactorySeparator = "|";
    private String realm = null;
    private static UserRegistryImpl userRegistry;
    private static long expirationLimit;
    private byte[] adminPassword = null;
    private byte[] new_adminPassword = null;
    protected static LTPAPublicKey ltpaPubKey;
    protected static LTPAPrivateKey ltpaPrivKey;
    protected static byte[] sharedKey;
    private static LTPAPublicKey new_ltpaPubKey;
    private static LTPAPrivateKey new_ltpaPrivKey;
    private byte[] privateKey;
    private byte[] publicKey;
    private byte[] new_sharedKey;
    private byte[] new_privateKey;
    private byte[] new_publicKey;
    private byte[] encryptedPrivateKey;
    private byte[] encryptedSharedKey;
    private byte[] new_encryptedPrivateKey;
    private byte[] new_encryptedSharedKey;
    private static String CURRENT_LTPA_VERSION;
    public static final String SHARED_KEY_PROPERTY = "com.ibm.websphere.ltpa.3DESKey";
    public static final String PUBLIC_KEY_PROPERTY = "com.ibm.websphere.ltpa.PublicKey";
    public static final String PRIVATE_KEY_PROPERTY = "com.ibm.websphere.ltpa.PrivateKey";
    public static final String LTPA_VERSION_PROPERTY = "com.ibm.websphere.ltpa.version";
    public static final String CREATION_DATE_PROPERTY = "com.ibm.websphere.CreationDate";
    public static final String CREATION_HOST_PROPERTY = "com.ibm.websphere.CreationHost";
    public static final String LDAP_REALM_PROPERTY = "com.ibm.websphere.ltpa.Realm";
    protected static LTPAServerObject ltpaServer;
    static boolean _useFIPS;
    static boolean _forceSoftwareJCEProviderForLTPA;
    static String _defaultJCEProvider;
    private ArrayList primaryTokenFactoryList = new ArrayList();
    protected static HashMap primaryTokenFactoryMap;
    private ArrayList secondaryTokenFactoryList = new ArrayList();
    private static HashMap secondaryTokenFactoryMap;
    private String ltpaKeySetGroupName = null;
    private Map generationKeys = null;
    private Map validationKeys = null;
    private ObjectName objName = null;
    private static final ContextManager ctxMgr;
    private static final WebSphereRuntimePermission ACCESS_LTPA_SERVER_OBJECT;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL;
    private static final HashMap tokenFactoryPredictionMap;

    public static LTPAServerObject getLTPAServer() throws LTPAConfigException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLTPAServer");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + ACCESS_LTPA_SERVER_OBJECT.toString());
            }
            securityManager.checkPermission(ACCESS_LTPA_SERVER_OBJECT);
        }
        if (ltpaServer == null) {
            LTPAServerObject.initLTPAServer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLTPAServer");
        }
        return ltpaServer;
    }

    private static void initLTPAServer() throws LTPAConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initLTPAServer");
        }
        Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.authMechForwardCred");
        String string = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism");
        if ("LTPA".equals(string) && Boolean.TRUE.equals(bl)) {
            try {
                String string2;
                String string3 = (String)SecurityConfig.getConfig().getValue("security.ltpa.password");
                Long l = (Long)SecurityConfig.getConfig().getValue("security.ltpa.expirydate");
                String string4 = (String)SecurityConfig.getConfig().getValue(PRIVATE_KEY_PROPERTY);
                String string5 = (String)SecurityConfig.getConfig().getValue(PUBLIC_KEY_PROPERTY);
                String string6 = (String)SecurityConfig.getConfig().getValue(SHARED_KEY_PROPERTY);
                if (l == null) {
                    Tr.error(tc, "security.secsrv.badltpconfig", new Object[]{l != null ? l.toString() : null});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Required LTPA configuration data is unavailable.  Initialization failed.");
                    }
                    throw new LTPAConfigException("Required LTPA configuration data is unavailable.  Initialization failed.");
                }
                long l2 = l;
                byte[] byArray = null;
                if (string3 != null) {
                    byArray = string3.getBytes("UTF8");
                }
                ltpaServer = new LTPAServerObject(l2, byArray, string5, string4, string6);
                String string7 = (String)SecurityConfig.getConfig().getValue("com.ibm.security.useFIPS");
                if (string7.equalsIgnoreCase("true")) {
                    _useFIPS = true;
                    _defaultJCEProvider = Security.getProperty("DEFAULT_JCE_PROVIDER");
                }
                if ((string2 = (String)SecurityConfig.getConfig().getValue("com.ibm.ws.security.ltpa.forceSoftwareJCEProviderForLTPA")) != null && string2.equalsIgnoreCase("true")) {
                    _forceSoftwareJCEProviderForLTPA = true;
                }
            }
            catch (LTPAConfigException lTPAConfigException) {
                FFDCFilter.processException(lTPAConfigException, "com.ibm.ws.security.ltpa.LTPAServerObject.initLTPAServer", "294");
                throw lTPAConfigException;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.security.ltpa.LTPAServerObject.initLTPAServer", "299");
                Tr.error(tc, "security.secsrv.ltpaconfigerr", new Object[]{exception});
                throw new LTPAConfigException(exception.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initLTPAServer");
        }
    }

    private LTPAServerObject(long l, byte[] byArray, String string, String string2, String string3) throws LTPAConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        userRegistry = (UserRegistryImpl)SecurityServerImpl.getRegistryImpl(ctxMgr.getDefaultRealm());
        expirationLimit = l;
        this.adminPassword = byArray;
        if (string != null && string2 != null && string3 != null) {
            try {
                this.encryptedSharedKey = Base64Coder.base64Decode(string3.getBytes("UTF8"));
                this.encryptedPrivateKey = Base64Coder.base64Decode(string2.getBytes("UTF8"));
                this.publicKey = Base64Coder.base64Decode(string.getBytes("UTF8"));
                ltpaPubKey = new LTPAPublicKey(this.publicKey);
                ltpaPrivKey = new LTPAPrivateKey(this.getPrivateKey(byArray, this.encryptedPrivateKey));
                sharedKey = this.getSharedKey(byArray, this.encryptedSharedKey);
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.expiration", new Long(expirationLimit));
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_shared_key", sharedKey);
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_public_key", ltpaPubKey);
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_private_key", ltpaPrivKey);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, "com.ibm.ws.security.ltpa.LTPAServerObject.LTPAServerObject", "339", this);
                Tr.error(tc, "security.ltpa.init.error", new Object[]{unsupportedEncodingException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "LTPAServerObject", unsupportedEncodingException);
                }
                throw new LTPAConfigException(unsupportedEncodingException.getMessage());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.LTPAServerObject", "346", this);
                Tr.error(tc, "security.ltpa.init.error", new Object[]{exception});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "LTPAServerObject", exception);
                }
                throw new LTPAConfigException(exception.getMessage());
            }
        }
        try {
            this.initializeKeySetGroupKeys();
        }
        catch (KeyException keyException) {
            FFDCFilter.processException((Throwable)keyException, "com.ibm.ws.security.ltpa.LTPAServerObject.<init>", "370", this);
            Tr.error(tc, "security.ltpa.init.error", new Object[]{keyException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "LTPAServerObject", keyException);
            }
            throw new LTPAConfigException(keyException.getMessage());
        }
        try {
            String string4 = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.ltpa.tokenFactory");
            StringTokenizer stringTokenizer = new StringTokenizer(string4, tokenFactorySeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                this.findFactory(string5, this.primaryTokenFactoryList, true);
                this.findFactory(string5, this.secondaryTokenFactoryList, false);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.LTPAServerObject", "390", this);
            Tr.error(tc, "security.ltpa.init.error", new Object[]{exception});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "LTPAServerObject", exception);
            }
            throw new LTPAConfigException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public LTPAServerObject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public TokenFactory findFactory(String string, List list, boolean bl) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findFactory", new Object[]{string, new Boolean(bl)});
        }
        TokenFactory tokenFactory = null;
        TokenFactory[] tokenFactoryArray = list.toArray(new TokenFactory[0]);
        if (tokenFactoryArray.length > 0) {
            for (int i = 0; i < tokenFactoryArray.length; ++i) {
                if (!tokenFactoryArray[i].getClass().getName().equals(string)) continue;
                tokenFactory = tokenFactoryArray[i];
            }
        }
        if (tokenFactory == null) {
            try {
                Class<?> clazz = Class.forName(string);
                Object obj = clazz.newInstance();
                tokenFactory = (TokenFactory)obj;
                if (bl) {
                    tokenFactory.initialize(primaryTokenFactoryMap);
                } else {
                    tokenFactory.initialize(secondaryTokenFactoryMap);
                }
                list.add(tokenFactory);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.findPrimaryFactory", "449", this);
                Tr.error(tc, "security.ltpa.factory.init.error", new Object[]{string, exception});
                throw new WSLoginFailedException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findFactory", tokenFactory);
        }
        return tokenFactory;
    }

    /*
     * Unable to fully structure code
     */
    public void refreshTokenFactories() throws LTPAConfigException {
        if (LTPAServerObject.tc.isEntryEnabled()) {
            Tr.entry(LTPAServerObject.tc, "refreshTokenFactories");
        }
        if (LTPAServerObject.sharedKey == null) ** GOTO lbl-1000
        if (LTPAServerObject.ltpaPubKey == null) ** GOTO lbl-1000
        if (LTPAServerObject.ltpaPrivKey != null) {
            if (LTPAServerObject.tc.isDebugEnabled()) {
                Tr.debug(LTPAServerObject.tc, "Refreshing using old key location.");
            }
            LTPAServerObject.primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.expiration", new Long(LTPAServerObject.expirationLimit));
            LTPAServerObject.primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_shared_key", LTPAServerObject.sharedKey);
            LTPAServerObject.primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_public_key", LTPAServerObject.ltpaPubKey);
            LTPAServerObject.primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_private_key", LTPAServerObject.ltpaPrivKey);
        } else lbl-1000:
        // 3 sources

        {
            try {
                this.initializeKeySetGroupKeys();
            }
            catch (KeyException var1_1) {
                FFDCFilter.processException((Throwable)var1_1, "com.ibm.ws.security.ltpa.LTPAServerObject.refreshTokenFactories", "482", this);
                if (LTPAServerObject.tc.isEntryEnabled()) {
                    Tr.exit(LTPAServerObject.tc, "refreshTokenFactories", new Object[]{var1_1});
                }
                throw new LTPAConfigException(var1_1.getMessage());
            }
            var1_2 = this.primaryTokenFactoryList.toArray(new TokenFactory[0]);
            if (var1_2.length > 0) {
                for (var2_3 = 0; var2_3 < var1_2.length; ++var2_3) {
                    if (LTPAServerObject.tc.isDebugEnabled()) {
                        Tr.debug(LTPAServerObject.tc, "Refreshing primary tokenFactory keys for: " + var1_2[var2_3].getClass().getName());
                    }
                    var1_2[var2_3].initialize(LTPAServerObject.primaryTokenFactoryMap);
                }
            }
            if ((var2_4 = this.secondaryTokenFactoryList.toArray(new TokenFactory[0])).length > 0) {
                for (var3_5 = 0; var3_5 < var2_4.length; ++var3_5) {
                    if (LTPAServerObject.tc.isDebugEnabled()) {
                        Tr.debug(LTPAServerObject.tc, "Refreshing secondary tokenFactory keys for: " + var2_4[var3_5].getClass().getName());
                    }
                    var2_4[var3_5].initialize(LTPAServerObject.secondaryTokenFactoryMap);
                }
            }
        }
        if (LTPAServerObject.tc.isEntryEnabled()) {
            Tr.exit(LTPAServerObject.tc, "refreshTokenFactories");
        }
    }

    public void initializeKeySetGroupKeys() throws KeyException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeKeySetGroupKeys");
        }
        LTPAPublicKey lTPAPublicKey = null;
        LTPAPrivateKey lTPAPrivateKey = null;
        byte[] byArray = null;
        this.ltpaKeySetGroupName = (String)SecurityConfig.getConfig().getValue("ltpakeysetgroupname");
        this.generationKeys = KeySetGroupManager.getInstance().getKeySetGroup(this.ltpaKeySetGroupName).getLatestKeys();
        this.traceKeyMap(this.generationKeys);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Latest keys: " + this.generationKeys);
        }
        if (this.generationKeys != null) {
            Iterator iterator = this.generationKeys.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = this.generationKeys.get(string);
                if (v instanceof Key) {
                    byArray = ((Key)v).getEncoded();
                    continue;
                }
                if (!(v instanceof KeyPair)) continue;
                Key key = ((KeyPair)v).getPublicKey();
                lTPAPublicKey = new LTPAPublicKey(key.getEncoded());
                Key key2 = ((KeyPair)v).getPrivateKey();
                lTPAPrivateKey = new LTPAPrivateKey(key2.getEncoded());
            }
            primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.expiration", new Long(expirationLimit));
            if (byArray != null) {
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_shared_key", byArray);
            }
            if (lTPAPublicKey != null) {
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_public_key", lTPAPublicKey);
            }
            if (lTPAPrivateKey != null) {
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_private_key", lTPAPrivateKey);
            }
            this.validationKeys = KeySetGroupManager.getInstance().getKeySetGroup(this.ltpaKeySetGroupName).getAllKeysByVersion();
            this.traceValidationKeys(this.validationKeys);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "All keys: " + this.validationKeys);
            }
        } else {
            throw new KeyException("Could not generateLTPAKeys from the KeySet name: " + this.ltpaKeySetGroupName);
        }
        secondaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.expiration", new Long(expirationLimit));
        secondaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_validation_keys", this.validationKeys);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeKeySetGroupKeys");
        }
    }

    public Token createLTPAToken(String string, String string2) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createLTPAToken", new Object[]{string, string2});
        }
        if (string2 == null) {
            throw new WSLoginFailedException("TokenFactory is null");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
            }
            securityManager.checkPermission(MAP_CREDENTIAL);
        }
        Token token = null;
        try {
            if (LTPAServerObject.getUserRegistry() != null) {
                String string3 = null;
                string3 = string.startsWith(supportedTypes[1]) || string.startsWith(supportedTypes[2]) ? string : LTPAServerObject.getUserRegistry().getUniqueUserId(string);
                if (string3 == null) {
                    Tr.error(tc, "security.ltpa.credmap.failed.nullaccessid");
                    throw new WSLoginFailedException("Cannot create token since accessID is null");
                }
                TokenFactory tokenFactory = this.findFactory(string2, this.primaryTokenFactoryList, true);
                if (tokenFactory == null) {
                    Tr.error(tc, "security.ltpa.factory.null.error", new Object[]{string2});
                    throw new WSLoginFailedException("TokenFactory is null");
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("com.ibm.wsspi.security.cred.uniqueId", string3);
                token = tokenFactory.createToken(hashMap);
                if (token == null) {
                    Tr.error(tc, "security.ltpa.validate.nulltoken");
                    throw new WSLoginFailedException("Token is null");
                }
            }
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", "677", this);
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", "682", this);
            Tr.error(tc, "security.ltpa.factory.tokencreate.error", new Object[]{string2, exception});
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createLTPAToken", token);
        }
        return token;
    }

    public WSCredential createLTPAToken(final WSCredential wSCredential) throws TokenCreationFailedException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createLTPAToken", wSCredential);
        }
        Token token = null;
        String string = (String)SecurityConfig.getConfig().getValue("com.ibm.wsspi.security.token.authenticationTokenFactory");
        try {
            object2 = wSCredential.getAccessId();
            if (object2 == null) {
                Tr.error(tc, "security.ltpa.credmap.failed.nullaccessid");
                throw new TokenCreationFailedException("Cannot create token since accessID is null");
            }
            object = this.findFactory(string, this.primaryTokenFactoryList, true);
            if (object == null) {
                Tr.error(tc, "security.ltpa.factory.null.error", new Object[]{string});
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.wsspi.security.cred.uniqueId", (String)object2);
            token = object.createToken(hashMap);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", "722", this);
            Tr.error(tc, "security.ltpa.factory.tokencreate.error", new Object[]{string, exception});
            throw new TokenCreationFailedException(exception.getMessage());
        }
        object2 = null;
        object = token;
        try {
            object2 = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction((Token)object){
                private final /* synthetic */ Token val$privToken;
                {
                    this.val$privToken = token;
                }

                public Object run() throws Exception {
                    return new WSCredentialImpl(wSCredential, "oid:1.3.18.0.2.30.2", this.val$privToken, true, this.val$privToken.getExpiration());
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", "748", this);
            String string2 = exception != null ? exception.getMessage() : "Exception occurred creating new WS cred.";
            throw new TokenCreationFailedException(string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createLTPAToken", object2);
        }
        return object2;
    }

    public WSCredential authenticate(BasicAuthData basicAuthData) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticate");
        }
        WSCredential wSCredential = null;
        try {
            if (LTPAServerObject.getUserRegistry() == null) {
                wSCredential = ctxMgr.getUnauthenticatedCredential();
            }
            if (wSCredential == null) {
                String string = LTPAServerObject.getUserRegistry().checkPassword(basicAuthData.getUserid(), basicAuthData.getPassword());
                wSCredential = LTPAServerObject.getUserRegistry().createCredential(string);
            }
            if (wSCredential == null) {
                throw new WSLoginFailedException("Credential returned by createCredential is null");
            }
            wSCredential = this.createLTPAToken(wSCredential);
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            throw wSLoginFailedException;
        }
        catch (TokenCreationFailedException tokenCreationFailedException) {
            FFDCFilter.processException((Throwable)tokenCreationFailedException, "com.ibm.ws.security.ltpa.LTPAServerObject.authenticate", "791", this);
            Tr.error(tc, "security.ltpa.authenticate", new Object[]{tokenCreationFailedException.getMessage()});
            throw new WSLoginFailedException(tokenCreationFailedException.getMessage(), tokenCreationFailedException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.authenticate", "797", this);
            Tr.error(tc, "security.ltpa.authenticate", new Object[]{exception.getMessage()});
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticate", wSCredential);
        }
        return wSCredential;
    }

    public WSCredential authenticateLoginToken(byte[] byArray) throws WSLoginFailedException, RemoteException {
        throw new WSLoginFailedException("LTPAServerObject: authenticateLoginToken not implemented");
    }

    public Token validateToken(byte[] byArray) throws WSLoginFailedException {
        Throwable throwable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateToken", byArray);
        }
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate: LTPA validate failed");
            }
            Tr.error(tc, "security.ltpa.validate.nulltoken");
            throw new WSLoginFailedException("LTPAServerObject: token passed in is null.");
        }
        if (LTPAServerObject.getUserRegistry() == null) {
            return null;
        }
        Token token = null;
        WSLoginFailedException wSLoginFailedException = null;
        WSLoginFailedException wSLoginFailedException2 = null;
        try {
            token = this.validateToken(byArray, this.primaryTokenFactoryList, true);
        }
        catch (WSLoginFailedException wSLoginFailedException3) {
            throwable = wSLoginFailedException3.getCause();
            if (throwable instanceof TokenExpiredException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validateToken: token is expired.");
                }
                FFDCFilter.processException((Throwable)wSLoginFailedException3, "com.ibm.ws.security.ltpa.LTPAServerObject.validateToken", "899", this);
                throw wSLoginFailedException3;
            }
            wSLoginFailedException = wSLoginFailedException3;
        }
        if (token == null && this.secondaryTokenFactoryList != null) {
            try {
                token = this.validateToken(byArray, this.secondaryTokenFactoryList, false);
            }
            catch (WSLoginFailedException wSLoginFailedException4) {
                throwable = wSLoginFailedException4.getCause();
                if (throwable instanceof TokenExpiredException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validateToken: token is expired.");
                    }
                    FFDCFilter.processException((Throwable)wSLoginFailedException4, "com.ibm.ws.security.ltpa.LTPAServerObject.validateToken", "921", this);
                    throw wSLoginFailedException4;
                }
                FFDCFilter.processException((Throwable)wSLoginFailedException4, "com.ibm.ws.security.ltpa.LTPAServerObject.validateToken", "925", this);
                wSLoginFailedException2 = wSLoginFailedException4;
            }
        }
        if (token == null) {
            Tr.debug(tc, "security.ltpa.validate.verifytoken.failed");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "LTPAServerObject: LTPATokenFactory.validateToken error due to invalid keys or token type.");
            }
            if (wSLoginFailedException2 != null) {
                throw wSLoginFailedException2;
            }
            if (wSLoginFailedException != null) {
                throw wSLoginFailedException;
            }
            throw new WSLoginFailedException("Validation of LTPA token failed due to invalid keys or token type.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken");
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token validateToken(byte[] byArray, List list, boolean bl) throws WSLoginFailedException {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken -> " + (bl ? "primary" : "secondary"));
        }
        WSLoginFailedException wSLoginFailedException = null;
        Token token = null;
        TokenFactory[] tokenFactoryArray = list.toArray(new TokenFactory[0]);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BEGIN VALIDATING TOKEN: some errors may occur, look for SUCCESS:");
        }
        try {
            Integer n = new Integer(byArray.length);
            FactoryPrediction factoryPrediction = (FactoryPrediction)tokenFactoryPredictionMap.get(n);
            if (factoryPrediction == null) {
                HashMap hashMap = tokenFactoryPredictionMap;
                synchronized (hashMap) {
                    factoryPrediction = new FactoryPrediction();
                    tokenFactoryPredictionMap.put(n, factoryPrediction);
                }
            }
            int n2 = factoryPrediction.getFactoryNumber();
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < tokenFactoryArray.length; ++j) {
                    if ((i != 0 || j != n2) && i != 1) continue;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Calling tokenFactory[" + j + "].validateTokenBytes() -> " + tokenFactoryArray[j].getClass().getName());
                        }
                        if ((token = tokenFactoryArray[j].validateTokenBytes(byArray)) == null) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "validateToken -> SUCCESS: validated using tokenFactoryArray[" + j + "]: " + tokenFactoryArray[j].getClass().getName());
                        }
                        factoryPrediction.addResult(byArray.length, j);
                        if (n2 == j) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Prediction successful:token:" + tokenFactoryArray[j].getClass().getName() + "::" + byArray.length);
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Prediction failed:token:" + tokenFactoryArray[j].getClass().getName() + "::" + byArray.length);
                        }
                        return token;
                    }
                    catch (InvalidTokenException invalidTokenException) {
                        if (j < tokenFactoryArray.length) {
                            if (wSLoginFailedException == null) {
                                wSLoginFailedException = new WSLoginFailedException(invalidTokenException.getMessage(), invalidTokenException);
                                continue;
                            }
                            wSLoginFailedException.addException(invalidTokenException);
                            continue;
                        }
                        wSLoginFailedException.addException(invalidTokenException);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred processing TokenFactory validateTokenBytes.", new Object[]{wSLoginFailedException});
                        }
                        throw wSLoginFailedException;
                    }
                    catch (TokenExpiredException tokenExpiredException) {
                        FFDCFilter.processException((Throwable)tokenExpiredException, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1017", this);
                        Tr.warning(tc, "security.ltpa.validate.tokenexpired", (Object)new Object[]{tokenExpiredException.getMessage()});
                        throw new WSLoginFailedException(tokenExpiredException.getMessage(), tokenExpiredException);
                    }
                    catch (Exception exception) {
                        if (j < tokenFactoryArray.length) {
                            if (wSLoginFailedException == null) {
                                wSLoginFailedException = new WSLoginFailedException(exception.getMessage(), exception);
                                continue;
                            }
                            wSLoginFailedException.addException(exception);
                            continue;
                        }
                        wSLoginFailedException.addException(exception);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred processing TokenFactory validateTokenBytes.", new Object[]{wSLoginFailedException});
                        }
                        throw wSLoginFailedException;
                    }
                }
            }
        }
        catch (WSLoginFailedException wSLoginFailedException2) {
            ArrayList arrayList = wSLoginFailedException2.getExceptions();
            for (int i = 0; i < arrayList.size(); ++i) {
                Throwable throwable = (Throwable)arrayList.get(i);
                FFDCFilter.processException(throwable, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1049", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Exception occurred processing TokenFactory validateTokenBytes.", new Object[]{throwable});
            }
            throw wSLoginFailedException2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateToken -> FAILED for " + (bl ? "primary." : "secondary."));
        }
        return null;
    }

    public WSCredential validate(byte[] byArray) throws WSLoginFailedException {
        Token token;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        if ((token = this.validateToken(byArray)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate (bytes)");
            }
            return this.validate(token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Problem validating token, returning null.");
        }
        throw new WSLoginFailedException("Problem validating LTPA token.");
    }

    public WSCredential validate(Token token) throws WSLoginFailedException {
        if (LTPAServerObject.getUserRegistry() == null || token == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Bootstrap mode: returning unauthenticated cred.");
            }
            try {
                WSCredential wSCredential = ctxMgr.getUnauthenticatedCredential();
                return wSCredential;
            }
            catch (WSSecurityException wSSecurityException) {
                throw new WSLoginFailedException(wSSecurityException.getMessage(), wSSecurityException);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validation successful - to create credential");
        }
        String string = null;
        try {
            String[] stringArray = token.getAttributes("u");
            string = this.getSecurityName(stringArray[0]);
            if (SecurityConfig.isRegTAM() && !RegistryUtil.checkValidUserifTAM(string, LTPAServerObject.getUserRegistry())) {
                throw new WSLoginFailedException("User is not valid in Access Manager");
            }
            WSCredential wSCredential = null;
            String string2 = SecurityConfig.getIntSvrIdIfUsed();
            if (string2 != null && ctxMgr.isInternalServerId(string)) {
                wSCredential = ctxMgr.getServerCredential();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validate: returning server cred " + wSCredential);
                }
                return wSCredential;
            }
            if (wSCredential == null) {
                wSCredential = LTPAServerObject.getUserRegistry().createCredential(string);
            }
            final WSCredential wSCredential2 = wSCredential;
            WSCredential wSCredential3 = null;
            final Token token2 = token;
            try {
                wSCredential3 = (WSCredential)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new WSCredentialImpl(wSCredential2, "oid:1.3.18.0.2.30.2", token2, true, token2.getExpiration());
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred creating new WS cred.", new Object[]{privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.security.ltpa.LTPAServerObject.createLTPAToken", "1159", this);
                Exception exception = privilegedActionException.getException();
                String string3 = exception != null ? exception.getMessage() : "Exception occurred creating new WS cred.";
                throw new WSLoginFailedException(string3, exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate");
            }
            return wSCredential3;
        }
        catch (WSLoginFailedException wSLoginFailedException) {
            FFDCFilter.processException((Throwable)wSLoginFailedException, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1170", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate: LTPA validation failed", wSLoginFailedException);
            }
            Tr.error(tc, "security.ltpa.validate.createcredential.failed", new Object[]{string, wSLoginFailedException});
            throw wSLoginFailedException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.validate", "1177", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "validate: LTPA validation failed", exception);
            }
            Tr.error(tc, "security.ltpa.validate.createcredential.failed", new Object[]{string, exception});
            throw new WSLoginFailedException(exception.getMessage(), exception);
        }
    }

    public String validateGetUser(byte[] byArray) {
        String string;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validateGetUser", byArray);
            }
            string = null;
            Token token = null;
            try {
                token = this.validateToken(byArray);
                if (token == null || !token.isValid()) {
                    Tr.error(tc, "security.ltpa.validate.tokenexpired");
                }
                String[] stringArray = token.getAttributes("u");
                string = this.getSecurityName(stringArray[0]);
            }
            catch (Exception exception) {
                if (!tc.isEntryEnabled()) break block5;
                Tr.exit(tc, "validateGetUser: LTPA token is not valid", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateGetUser", string);
        }
        return string;
    }

    public long getExpiration(byte[] byArray) throws InvalidTokenException, TokenExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExpiration", byArray);
        }
        if (byArray == null) {
            throw new InvalidTokenException();
        }
        long l = 0L;
        Token token = null;
        try {
            token = this.validateToken(byArray);
            if (token != null && token.isValid()) {
                l = token.getExpiration();
            }
        }
        catch (Exception exception) {
            throw new TokenExpiredException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExpiration", new Long(l));
        }
        return l;
    }

    private String getSecurityName(String string) throws CustomRegistryException, EntryNotFoundException, UnsupportedEntryTypeException, RemoteException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecurityName", string);
        }
        if ((string2 = SecurityConfig.getIntSvrIdIfUsed()) != null && ctxMgr.isInternalServerId(string)) {
            return string2;
        }
        String string3 = null;
        String string4 = null;
        string4 = this.getRelativeName(string);
        if (string.startsWith(supportedTypes[1])) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Calling userRegistry.getUserSecName");
            }
            string3 = LTPAServerObject.getUserRegistry().getUserSecurityName(string4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Back from  userRegistry.getUserSecName");
            }
        } else if (string.startsWith(supportedTypes[0])) {
            string3 = LTPAServerObject.getUserRegistry().getGroupSecurityName(string4);
        } else {
            UnsupportedEntryTypeException unsupportedEntryTypeException = new UnsupportedEntryTypeException("not USER or GROUP");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecurityName", unsupportedEntryTypeException);
            }
            Tr.error(tc, "security.ltpa.badtype", new Object[]{unsupportedEntryTypeException});
            throw unsupportedEntryTypeException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityName", string3);
        }
        return string3;
    }

    private String getRelativeName(String string) throws CustomRegistryException, RemoteException {
        int n = string.indexOf(realmSeparator);
        String string2 = string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelativeName", string);
        }
        this.realm = LTPAServerObject.getUserRegistry().getRealm();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "realm from userRegistry.getRealm(): " + this.realm + "\n realm length: " + this.realm.length());
            Tr.debug(tc, "realmIndex: " + n);
        }
        if (n >= 0) {
            int n2 = string.indexOf(typeSeparator);
            if (n - n2 - 1 == this.realm.length() && string.startsWith(this.realm, n2 + 1)) {
                string2 = string.substring(n + 1);
            } else {
                Tr.error(tc, "security.ltpa.realm_mismatch");
                throw new CustomRegistryException("The realm in the token: " + string.substring(n2 + 1, n) + " does not match the current realm: " + this.realm);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelativeName", string2);
        }
        return string2;
    }

    private byte[] getPrivateKey(byte[] byArray, byte[] byArray2) {
        KeyEncryptor keyEncryptor = new KeyEncryptor(byArray);
        return keyEncryptor.decrypt((byte[])byArray2.clone());
    }

    private byte[] getSharedKey(byte[] byArray, byte[] byArray2) {
        KeyEncryptor keyEncryptor = new KeyEncryptor(byArray);
        return keyEncryptor.decrypt((byte[])byArray2.clone());
    }

    private byte[] getPublicKey() throws RemoteException {
        return this.publicKey;
    }

    private byte[] getEncPrivateKey() throws RemoteException {
        return this.encryptedPrivateKey;
    }

    private byte[] getEncSharedKey() throws RemoteException {
        return this.encryptedSharedKey;
    }

    public void updateLTPAKeysFromMap(Map map) throws RemoteException {
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "updateLTPAKeysFromMap", new Object[]{map});
            }
            LTPAPublicKey lTPAPublicKey = null;
            LTPAPrivateKey lTPAPrivateKey = null;
            byte[] byArray = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Latest keys: " + map);
            }
            if (map != null) {
                TokenFactory[] tokenFactoryArray;
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    tokenFactoryArray = (TokenFactory[])iterator.next();
                    Object v = map.get(tokenFactoryArray);
                    if (v instanceof Key) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found secret key from Map.");
                        }
                        byArray = ((Key)v).getEncoded();
                        continue;
                    }
                    if (!(v instanceof KeyPair)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found key pair from Map.");
                    }
                    Key key = ((KeyPair)v).getPublicKey();
                    lTPAPublicKey = new LTPAPublicKey(key.getEncoded());
                    Key key2 = ((KeyPair)v).getPrivateKey();
                    lTPAPrivateKey = new LTPAPrivateKey(key2.getEncoded());
                }
                primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.expiration", new Long(expirationLimit));
                if (byArray != null) {
                    primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_shared_key", byArray);
                }
                if (lTPAPublicKey != null) {
                    primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_public_key", lTPAPublicKey);
                }
                if (lTPAPrivateKey != null) {
                    primaryTokenFactoryMap.put("com.ibm.wsspi.security.ltpa.ltpa_private_key", lTPAPrivateKey);
                }
                if ((tokenFactoryArray = this.primaryTokenFactoryList.toArray(new TokenFactory[0])).length > 0) {
                    for (int i = 0; i < tokenFactoryArray.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Refreshing primary tokenFactory keys for: " + tokenFactoryArray[i].getClass().getName());
                        }
                        tokenFactoryArray[i].initialize(primaryTokenFactoryMap);
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The keys passed in are null, not updating keys.");
            }
            try {
                ContextManagerFactory.getInstance().refreshServerSubject();
                LTPACrypto.rsaKeysMap.clear();
                LTPACrypto.verifyKeysMap.clear();
                LTPACrypto.cryptoKeysMap.clear();
            }
            catch (WSSecurityException wSSecurityException) {
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "Exception refreshing server Subject after key generation.", new Object[]{wSSecurityException});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateLTPAKeysFromMap");
        }
    }

    public Map generateKeysForKeySetGroup(Session session, Boolean bl) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKeysForKeySetGroup", new Object[]{session, bl});
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        Boolean bl2 = Boolean.FALSE;
        if (session == null) {
            session = new Session();
            bl2 = Boolean.TRUE;
        }
        if (ManagementScopeManager.getInstance().getProcessType().equals("DeploymentManager") || ManagementScopeManager.getInstance().getProcessType().equals("UnManagedProcess")) {
            try {
                this.ltpaKeySetGroupName = (String)SecurityConfig.getConfig().getValue("ltpakeysetgroupname");
                WSKeySetGroup wSKeySetGroup = KeySetGroupManager.getInstance().getKeySetGroup(this.ltpaKeySetGroupName);
                String string = wSKeySetGroup.getScope();
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand adminCommand = commandMgr.createCommand("generateKeyForKeySetGroup");
                adminCommand.setConfigSession(session);
                adminCommand.setParameter("keySetGroupName", this.ltpaKeySetGroupName);
                adminCommand.setParameter("keySetGroupScope", string);
                adminCommand.setParameter("keySetGroupUpdateRuntime", bl);
                adminCommand.setParameter("keySetGroupSaveConfig", Boolean.FALSE);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                if (commandResult.isSuccessful()) {
                    Map map = (Map)commandResult.getResult();
                    if (bl2 == Boolean.TRUE) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, " Saving the security.xml changes.");
                        }
                        configService.save(session, true);
                        configService.discard(session);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "generateKeysForKeySetGroup (success)");
                    }
                    return map;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "generateKeysForKeySetGroup: command task result is failure.", new Object[]{commandResult.getException()});
                }
                throw new RemoteException(commandResult.getException().getMessage());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.generateKeysForKeySetGroup", "1536", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Problem generating SSO keys.  Using old keys still.");
                }
                Tr.error(tc, "security.ltpa.importkeys", new Object[]{exception});
                throw new RemoteException("Problem generating SSO keys. Using original values. The exception is " + exception.getMessage());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Only generating keys in the DMGR or UnManaged processes, current process type: " + ManagementScopeManager.getInstance().getProcessType());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateKeysForKeySetGroup (null)");
        }
        return null;
    }

    public synchronized Map importSSOPropertiesToKeySetGroup(Properties properties, byte[] byArray, Session session, Boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importSSOProperties");
        }
        ConfigService configService = ConfigServiceFactory.getConfigService();
        if (ManagementScopeManager.getInstance().getProcessType().equals("DeploymentManager") || ManagementScopeManager.getInstance().getProcessType().equals("UnManagedProcess")) {
            Boolean bl2 = Boolean.FALSE;
            if (session == null) {
                session = new Session();
                bl2 = Boolean.TRUE;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Executing importSSOProperties");
            }
            String string = properties.getProperty(SHARED_KEY_PROPERTY);
            String string2 = properties.getProperty(PRIVATE_KEY_PROPERTY);
            String string3 = properties.getProperty(PUBLIC_KEY_PROPERTY);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Shared key: " + string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Private key: " + string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Public key: " + string3);
            }
            SecretKeySpec secretKeySpec = null;
            KeyPair keyPair = null;
            HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
            try {
                Object object;
                this.ltpaKeySetGroupName = (String)SecurityConfig.getConfig().getValue("ltpakeysetgroupname");
                WSKeySetGroup wSKeySetGroup = KeySetGroupManager.getInstance().getKeySetGroup(this.ltpaKeySetGroupName);
                WSKeySet[] wSKeySetArray = wSKeySetGroup.getAllKeySets();
                for (int i = 0; i < wSKeySetArray.length; ++i) {
                    object = wSKeySetArray[i].getName();
                    String string4 = wSKeySetArray[i].getManagementScopeName();
                    boolean bl3 = wSKeySetArray[i].getIsKeyPair();
                    WSKeyStore wSKeyStore = wSKeySetArray[i].getWSKeyStore();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating new KeyReference for KeySet: " + (String)object);
                    }
                    CommandMgr commandMgr = CommandMgr.getCommandMgr();
                    AdminCommand adminCommand = commandMgr.createCommand("createKeyReference");
                    adminCommand.setConfigSession(session);
                    adminCommand.setParameter("keySetName", object);
                    adminCommand.setParameter("keySetScope", string4);
                    adminCommand.setParameter("keyReferenceSaveConfig", Boolean.FALSE);
                    adminCommand.execute();
                    CommandResult commandResult = adminCommand.getCommandResult();
                    if (commandResult.isSuccessful()) {
                        Object object2;
                        Object object3;
                        byte[] byArray2;
                        byte[] byArray3;
                        ObjectName objectName = (ObjectName)commandResult.getResult();
                        com.ibm.websphere.models.config.ipc.ssl.KeyReference keyReference = (com.ibm.websphere.models.config.ipc.ssl.KeyReference)MOFUtil.convertToEObject((Session)session, (ObjectName)objectName);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "New KeyReference version: " + keyReference.getVersion());
                        }
                        if (bl3) {
                            byArray3 = Base64Coder.base64Decode(string2.getBytes("UTF8"));
                            byArray2 = Base64Coder.base64Decode(string3.getBytes("UTF8"));
                            object3 = new LTPAPublicKey(byArray2);
                            byte[] byArray4 = this.getPrivateKey(byArray, byArray3);
                            object2 = new LTPAPrivateKey(byArray4);
                            keyPair = new KeyPair((Key)object3, (Key)object2);
                            WSKeyPairReference wSKeyPairReference = new WSKeyPairReference(keyReference, keyPair, wSKeySetArray[i], wSKeyStore);
                            wSKeySetArray[i].addKeyReference(wSKeyPairReference);
                            int n = keyReference.getVersion();
                            String string5 = wSKeySetArray[i].getAliasPrefix();
                            hashMap.put(string5 + "_" + n, keyPair);
                            continue;
                        }
                        byArray3 = Base64Coder.base64Decode(string.getBytes("UTF8"));
                        byArray2 = this.getSharedKey(byArray, byArray3);
                        secretKeySpec = new SecretKeySpec(byArray2, 0, 24, "3DES");
                        object3 = new WSKeyReference(keyReference, secretKeySpec, wSKeySetArray[i], wSKeyStore);
                        wSKeySetArray[i].addKeyReference((KeyReference)object3);
                        int n = keyReference.getVersion();
                        object2 = wSKeySetArray[i].getAliasPrefix();
                        hashMap.put((String)object2 + "_" + n, secretKeySpec);
                        continue;
                    }
                    throw new RemoteException(commandResult.getException().getMessage());
                }
                if (bl != null && bl.booleanValue()) {
                    this.objName = this.getMBean();
                    ObjectName objectName = new ObjectName("WebSphere:type=SecurityAdmin,*");
                    object = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
                    while (object.hasNext()) {
                        try {
                            objectName = (ObjectName)object.next();
                            if (this.objName.equals(objectName)) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, " SecurityAdmin object name = " + objectName);
                            }
                            AdminServiceFactory.getAdminService().invoke(objectName, "updateRuntimeKeys", new Object[]{hashMap}, new String[]{"java.util.Map"});
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.commands.GenerateKeyForKeySetGroup.beforeStepsExecuted", "1673", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception on MBean call.", new Object[]{exception});
                            }
                            throw exception;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " SecurityAdmin object name (self) = " + this.objName);
                    }
                    AdminServiceFactory.getAdminService().invoke(this.objName, "updateRuntimeKeys", new Object[]{hashMap}, new String[]{"java.util.Map"});
                }
                if (bl2 == Boolean.TRUE) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " Saving the security.xml changes.");
                    }
                    configService.save(session, true);
                    configService.discard(session);
                }
                this.traceKeyMap(hashMap);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "importSSOProperties (success)");
                }
                return hashMap;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.importSSOPropertiesToKeySetGroup", "1698", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Problem importing SSO keys.  Using old keys still.");
                }
                Tr.error(tc, "security.ltpa.importkeys", new Object[]{exception});
                throw new Exception("Problem importing SSO keys. Using original values. The exception is " + exception.getMessage());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Only import properties in the DMGR or UnManaged processes, current process type: " + ManagementScopeManager.getInstance().getProcessType());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importSSOProperties (null)");
        }
        return null;
    }

    private ObjectName getMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBean");
        }
        if (this.objName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting MBean");
            }
            try {
                String string = AdminServiceFactory.getAdminService().getProcessName();
                this.objName = new ObjectName("WebSphere:type=SecurityAdmin,process=" + string + ",*");
                Iterator iterator = AdminServiceFactory.getAdminService().queryNames(this.objName, null).iterator();
                if (!iterator.hasNext()) {
                    Tr.error(tc, "security.ctr.nombean.error");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMBean");
                    }
                    throw new Exception("No SecurityAdmin MBean found: returning null");
                }
                this.objName = (ObjectName)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " SecurityAdmin object name = " + this.objName);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMBean");
                }
                return this.objName;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.getMBean", "1738", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception on MBean call.", new Object[]{exception});
                }
                throw exception;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning MBean");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean");
        }
        return this.objName;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void generateKeys(byte[] var1_1) throws RemoteException {
        if (LTPAServerObject.tc.isEntryEnabled()) {
            Tr.entry(LTPAServerObject.tc, "generateKeys");
        }
        this.adminPassword = var1_1;
        if (LTPAServerObject.sharedKey == null) ** GOTO lbl-1000
        if (LTPAServerObject.ltpaPubKey == null) ** GOTO lbl-1000
        if (LTPAServerObject.ltpaPrivKey != null) {
            var2_2 = new KeyEncryptor(this.adminPassword);
            var3_3 = LTPADigSignature.generateLTPAKeyPair();
            this.publicKey = var3_3.getPublic().getEncoded();
            this.privateKey = var3_3.getPrivate().getEncoded();
            LTPAServerObject.ltpaPubKey = new LTPAPublicKey(this.publicKey);
            LTPAServerObject.ltpaPrivKey = new LTPAPrivateKey(this.privateKey);
            this.encryptedPrivateKey = var2_2.encrypt((byte[])this.privateKey.clone());
            new LTPACrypto();
            LTPAServerObject.sharedKey = LTPACrypto.generate3DESKey();
            this.encryptedSharedKey = var2_2.encrypt((byte[])LTPAServerObject.sharedKey.clone());
            this.refreshTokenFactories();
        } else lbl-1000:
        // 3 sources

        {
            this.generateKeysForKeySetGroup(null, Boolean.TRUE);
        }
        if (LTPAServerObject.tc.isEntryEnabled()) {
            Tr.exit(LTPAServerObject.tc, "generateKeys");
        }
    }

    public Properties genKeys(byte[] byArray) throws Exception {
        Properties properties;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "genKeys");
            }
            KeyEncryptor keyEncryptor = new KeyEncryptor(byArray);
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            LTPAKeyPair lTPAKeyPair = LTPADigSignature.generateLTPAKeyPair();
            byArray2 = lTPAKeyPair.getPublic().getEncoded();
            byArray3 = lTPAKeyPair.getPrivate().getEncoded();
            byte[] byArray4 = keyEncryptor.encrypt((byte[])byArray3.clone());
            new LTPACrypto();
            byte[] byArray5 = LTPACrypto.generate3DESKey();
            byte[] byArray6 = keyEncryptor.encrypt((byte[])byArray5.clone());
            byte[] byArray7 = Base64Coder.base64Encode(byArray6);
            byte[] byArray8 = Base64Coder.base64Encode(byArray4);
            byte[] byArray9 = Base64Coder.base64Encode(byArray2);
            properties = new Properties();
            try {
                String string;
                properties.put(SHARED_KEY_PROPERTY, new String(byArray7, "UTF8"));
                properties.put(PRIVATE_KEY_PROPERTY, new String(byArray8, "UTF8"));
                properties.put(PUBLIC_KEY_PROPERTY, new String(byArray9, "UTF8"));
                properties.put(LTPA_VERSION_PROPERTY, CURRENT_LTPA_VERSION);
                properties.put(CREATION_DATE_PROPERTY, new Date().toString());
                String string2 = InetAddress.getLocalHost().getHostName();
                properties.put(CREATION_HOST_PROPERTY, string2);
                ORB oRB = EJSORB.getORBInstance();
                if (oRB != null && (string = oRB.getProperty("com.ibm.CORBA.principalName")) != null && string.length() > 0) {
                    properties.put(LDAP_REALM_PROPERTY, string.substring(0, string.indexOf(realmSeparator)));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, "com.ibm.ws.security.ltpa.LTPAServerObject.genKeys", "1835", this);
                Tr.error(tc, "security.ltpa.exportkeys", new Object[]{unsupportedEncodingException});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unsupported encoding: UTF8");
                }
                throw new Exception(unsupportedEncodingException.getMessage());
            }
            catch (UnknownHostException unknownHostException) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Unknown host exception");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "genKeys");
        }
        return properties;
    }

    public void checkImportSSOProperties(Properties properties, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkImportSSOProperties");
        }
        String string = properties.getProperty(SHARED_KEY_PROPERTY);
        String string2 = properties.getProperty(PRIVATE_KEY_PROPERTY);
        String string3 = properties.getProperty(PUBLIC_KEY_PROPERTY);
        try {
            byte[] byArray2 = Base64Coder.base64Decode(string.getBytes("UTF8"));
            byte[] byArray3 = Base64Coder.base64Decode(string2.getBytes("UTF8"));
            byte[] byArray4 = Base64Coder.base64Decode(string3.getBytes("UTF8"));
            LTPAPublicKey lTPAPublicKey = new LTPAPublicKey(byArray4);
            byte[] byArray5 = this.getPrivateKey(byArray, byArray3);
            LTPAPrivateKey lTPAPrivateKey = new LTPAPrivateKey(byArray5);
            byte[] byArray6 = this.getSharedKey(byArray, byArray2);
        }
        catch (NullPointerException nullPointerException) {
            FFDCFilter.processException((Throwable)nullPointerException, "com.ibm.ws.security.ltpa.LTPAServerObject.checkImportSSOProperties", "1871", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Problem importingSSO keys. Using original values. Make sure that the password is correct.");
            }
            Tr.error(tc, "security.ltpa.checkimportltpakeys", new Object[]{nullPointerException});
            throw new Exception("Problem importingSSO keys. Using original values. Make sure the password is correct.");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.checkImportSSOProperties", "1878", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Problem importingSSO keys. Using original values.");
            }
            Tr.error(tc, "security.ltpa.checkimportltpakeys", new Object[]{exception});
            throw new Exception("Problem importingSSO keys. Using original values. Check the Password. The exception is " + exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void importSSOProperties(Properties var1_1, byte[] var2_2) throws Exception {
        if (LTPAServerObject.tc.isEntryEnabled()) {
            Tr.entry(LTPAServerObject.tc, "importSSOProperties");
        }
        this.new_adminPassword = var2_2;
        var3_3 = var1_1.getProperty("com.ibm.websphere.ltpa.3DESKey");
        var4_4 = var1_1.getProperty("com.ibm.websphere.ltpa.PrivateKey");
        var5_5 = var1_1.getProperty("com.ibm.websphere.ltpa.PublicKey");
        try {
            this.new_encryptedSharedKey = Base64Coder.base64Decode(var3_3.getBytes("UTF8"));
            this.new_encryptedPrivateKey = Base64Coder.base64Decode(var4_4.getBytes("UTF8"));
            this.new_publicKey = Base64Coder.base64Decode(var5_5.getBytes("UTF8"));
            LTPAServerObject.new_ltpaPubKey = new LTPAPublicKey(this.new_publicKey);
            this.new_privateKey = this.getPrivateKey(var2_2, this.new_encryptedPrivateKey);
            LTPAServerObject.new_ltpaPrivKey = new LTPAPrivateKey(this.new_privateKey);
            this.new_sharedKey = this.getSharedKey(var2_2, this.new_encryptedSharedKey);
        }
        catch (Exception var6_6) {
            FFDCFilter.processException((Throwable)var6_6, "com.ibm.ws.security.ltpa.LTPAServerObject.importSSOProperties", "1916", this);
            if (LTPAServerObject.tc.isDebugEnabled()) {
                Tr.debug(LTPAServerObject.tc, "Problem importingSSO keys. Using original values.");
            }
            Tr.error(LTPAServerObject.tc, "security.ltpa.importkeys", new Object[]{var6_6});
            throw new Exception("Problem importingSSO keys. Using original values. The exception is " + var6_6.getMessage());
        }
        if (LTPAServerObject.sharedKey == null) ** GOTO lbl-1000
        if (LTPAServerObject.ltpaPubKey == null) ** GOTO lbl-1000
        if (LTPAServerObject.ltpaPrivKey != null) {
            this.adminPassword = this.new_adminPassword;
            this.encryptedSharedKey = this.new_encryptedSharedKey;
            this.encryptedPrivateKey = this.new_encryptedPrivateKey;
            this.publicKey = this.new_publicKey;
            this.privateKey = this.new_privateKey;
            LTPAServerObject.ltpaPubKey = LTPAServerObject.new_ltpaPubKey;
            LTPAServerObject.ltpaPrivKey = LTPAServerObject.new_ltpaPrivKey;
            LTPAServerObject.sharedKey = this.new_sharedKey;
            this.refreshTokenFactories();
        } else lbl-1000:
        // 3 sources

        {
            this.importSSOPropertiesToKeySetGroup(var1_1, var2_2, null, Boolean.TRUE);
        }
        if (LTPAServerObject.tc.isEntryEnabled()) {
            Tr.exit(LTPAServerObject.tc, "importSSOProperties");
        }
    }

    public Properties exportSSOProperties(byte[] byArray) throws Exception {
        Serializable serializable;
        block18: {
            Object object;
            Object object2;
            Object object3;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "exportSSOProperties");
            }
            KeyEncryptor keyEncryptor = null;
            keyEncryptor = byArray != null ? new KeyEncryptor(byArray) : new KeyEncryptor(this.adminPassword);
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            if (this.encryptedSharedKey != null && this.encryptedPrivateKey != null && this.publicKey != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exporting the old-style keys.");
                }
                byArray2 = Base64Coder.base64Encode(this.encryptedSharedKey);
                byArray3 = Base64Coder.base64Encode(this.encryptedPrivateKey);
                byArray4 = Base64Coder.base64Encode(this.publicKey);
            } else if (this.generationKeys == null) {
                this.initializeKeySetGroupKeys();
            } else {
                this.generationKeys = KeySetGroupManager.getInstance().getKeySetGroup(this.ltpaKeySetGroupName).getLatestKeys();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Latest keys: " + this.generationKeys);
                }
            }
            if (this.generationKeys != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exporting the latest keys from the KeySetGroup.");
                }
                serializable = null;
                object3 = null;
                object2 = null;
                object = this.generationKeys.keySet().iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    Object v = this.generationKeys.get(string);
                    if (v instanceof Key) {
                        object2 = ((Key)v).getEncoded();
                        byArray2 = Base64Coder.base64Encode(keyEncryptor.encrypt((byte[])object2.clone()));
                        continue;
                    }
                    if (!(v instanceof KeyPair)) continue;
                    Key key = ((KeyPair)v).getPublicKey();
                    serializable = new LTPAPublicKey(key.getEncoded());
                    Key key2 = ((KeyPair)v).getPrivateKey();
                    object3 = new LTPAPrivateKey(key2.getEncoded());
                    byte[] byArray5 = ((LTPAPublicKey)serializable).getEncoded();
                    byte[] byArray6 = ((LTPAPrivateKey)object3).getEncoded();
                    byte[] byArray7 = keyEncryptor.encrypt((byte[])byArray6.clone());
                    byArray3 = Base64Coder.base64Encode(byArray7);
                    byArray4 = Base64Coder.base64Encode(byArray5);
                }
            } else {
                Exception exception = new Exception("Keys do not exist. Make sure the LTPA configuration is setup");
                Tr.error(tc, "security.ltpa.importkeys", new Object[]{exception});
                throw exception;
            }
            serializable = new Properties();
            try {
                ((Properties)serializable).put(SHARED_KEY_PROPERTY, new String(byArray2, "UTF8"));
                ((Properties)serializable).put(PRIVATE_KEY_PROPERTY, new String(byArray3, "UTF8"));
                ((Properties)serializable).put(PUBLIC_KEY_PROPERTY, new String(byArray4, "UTF8"));
                ((Properties)serializable).put(LTPA_VERSION_PROPERTY, CURRENT_LTPA_VERSION);
                ((Properties)serializable).put(CREATION_DATE_PROPERTY, new Date().toString());
                object3 = InetAddress.getLocalHost().getHostName();
                ((Properties)serializable).put(CREATION_HOST_PROPERTY, object3);
                object2 = EJSORB.getORBInstance();
                if (object2 != null && (object = object2.getProperty("com.ibm.CORBA.principalName")) != null && ((String)object).length() > 0) {
                    ((Properties)serializable).put(LDAP_REALM_PROPERTY, ((String)object).substring(0, ((String)object).indexOf(realmSeparator)));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, "com.ibm.ws.security.ltpa.LTPAServerObject.exportSSOProperties", "2058", this);
                Tr.error(tc, "security.ltpa.exportkeys", new Object[]{unsupportedEncodingException});
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unsupported encoding: UTF8");
                }
                throw new Exception(unsupportedEncodingException.getMessage());
            }
            catch (UnknownHostException unknownHostException) {
                if (!tc.isDebugEnabled()) break block18;
                Tr.debug(tc, "Unknown host exception");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportSSOProperties");
        }
        return serializable;
    }

    public byte[] issueLoginToken(BasicAuthData basicAuthData) throws RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "issueLoginToken");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "issueLoginToken");
        }
        throw new RemoteException("issueLoginToken not implemented");
    }

    private static byte[] toBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug(tc, "to UTF8 bytes =" + unsupportedEncodingException.toString());
        }
        return byArray;
    }

    static UserRegistryImpl getUserRegistry() {
        if (userRegistry == null) {
            userRegistry = (UserRegistryImpl)SecurityServerImpl.getRegistryImpl(ctxMgr.getDefaultRealm());
        }
        return userRegistry;
    }

    static boolean useFIPS() {
        return _useFIPS;
    }

    static boolean forceSoftwareJCEProviderForLTPA() {
        return _forceSoftwareJCEProviderForLTPA;
    }

    static String defaultJCEProvider() {
        return _defaultJCEProvider;
    }

    public synchronized Map importLTPAKeysToKeySetGroup(String string, String string2, String string3, byte[] byArray, Session session, com.ibm.websphere.models.config.security.Security security2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importLTPAKeysToKeySetGroup");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "privateKeyString: " + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "publicKeyString: " + string2);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sharedKeyString: " + string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "password: " + byArray);
        }
        Boolean bl = Boolean.FALSE;
        if (session == null) {
            session = new Session();
            bl = Boolean.TRUE;
        }
        SecretKeySpec secretKeySpec = null;
        KeyPair keyPair = null;
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        try {
            WSKeySet[] wSKeySetArray;
            Object object;
            Iterator iterator;
            EList eList = security2.getKeyStores();
            if (eList != null) {
                iterator = eList.iterator();
                while (iterator.hasNext()) {
                    object = (KeyStore)iterator.next();
                    wSKeySetArray = object.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key store Name:" + (String)wSKeySetArray);
                    }
                    if (!wSKeySetArray.endsWith("LTPAKeys")) continue;
                    String string4 = KeyStoreManager.getInstance().expand(object.getLocation());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key store location:" + string4);
                    }
                    object.setLocation(string4);
                }
            }
            iterator = security2.getAuthMechanisms().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof LTPA) || (wSKeySetArray = (LTPA)object) == null) continue;
                KeyStoreManager.getInstance().loadKeyStores(security2);
                KeySetManager.getInstance().initializeKeySets(security2, true);
                KeySetGroupManager.getInstance().initializeKeySetGroups(security2, true);
                this.ltpaKeySetGroupName = ((LTPA)security2.getActiveAuthMechanism()).getKeySetGroup().getName();
                break;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ltpaKeySetGroupName:" + this.ltpaKeySetGroupName);
            }
            if ((object = KeySetGroupManager.getInstance().getKeySetGroup(this.ltpaKeySetGroupName)) != null) {
                ((WSKeySetGroup)object).getLatestKeys();
            }
            wSKeySetArray = ((WSKeySetGroup)object).getAllKeySets();
            for (int i = 0; i < wSKeySetArray.length; ++i) {
                String string5 = wSKeySetArray[i].getName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keySetName:" + string5);
                }
                String string6 = wSKeySetArray[i].getManagementScopeName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keySetScope:" + string6);
                }
                boolean bl2 = wSKeySetArray[i].getIsKeyPair();
                WSKeyStore wSKeyStore = wSKeySetArray[i].getWSKeyStore();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating new KeyReference for KeySet: " + string5);
                }
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                AdminCommand adminCommand = commandMgr.createCommand("createKeyReference");
                adminCommand.setConfigSession(session);
                adminCommand.setParameter("keySetName", string5);
                adminCommand.setParameter("keySetScope", string6);
                adminCommand.setParameter("keyReferenceSaveConfig", bl);
                adminCommand.execute();
                CommandResult commandResult = adminCommand.getCommandResult();
                if (commandResult.isSuccessful()) {
                    Object object2;
                    Object object3;
                    byte[] byArray2;
                    byte[] byArray3;
                    ObjectName objectName = (ObjectName)commandResult.getResult();
                    com.ibm.websphere.models.config.ipc.ssl.KeyReference keyReference = (com.ibm.websphere.models.config.ipc.ssl.KeyReference)MOFUtil.convertToEObject((Session)session, (ObjectName)objectName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New KeyReference version: " + keyReference.getVersion());
                    }
                    if (bl2) {
                        byArray3 = Base64Coder.base64Decode(string.getBytes("UTF8"));
                        byArray2 = Base64Coder.base64Decode(string2.getBytes("UTF8"));
                        object3 = new LTPAPublicKey(byArray2);
                        byte[] byArray4 = this.getPrivateKey(byArray, byArray3);
                        object2 = new LTPAPrivateKey(byArray4);
                        keyPair = new KeyPair((Key)object3, (Key)object2);
                        WSKeyPairReference wSKeyPairReference = new WSKeyPairReference(keyReference, keyPair, wSKeySetArray[i], wSKeyStore);
                        wSKeySetArray[i].addKeyReference(wSKeyPairReference);
                        int n = keyReference.getVersion();
                        String string7 = wSKeySetArray[i].getAliasPrefix();
                        hashMap.put(string7 + "_" + n, keyPair);
                        continue;
                    }
                    byArray3 = Base64Coder.base64Decode(string3.getBytes("UTF8"));
                    byArray2 = this.getSharedKey(byArray, byArray3);
                    secretKeySpec = new SecretKeySpec(byArray2, 0, 24, "3DES");
                    object3 = new WSKeyReference(keyReference, secretKeySpec, wSKeySetArray[i], wSKeyStore);
                    wSKeySetArray[i].addKeyReference((KeyReference)object3);
                    int n = keyReference.getVersion();
                    object2 = wSKeySetArray[i].getAliasPrefix();
                    hashMap.put((String)object2 + "_" + n, secretKeySpec);
                    continue;
                }
                throw new RemoteException(commandResult.getException().getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importLTPAKeysToKeySetGroup (success)");
            }
            return hashMap;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.ltpa.LTPAServerObject.importLTPAKeysToKeySetGroup", "2271", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Problem importing previous version keys. ");
            }
            Tr.error(tc, "security.ltpa.importLTPAKeysToKeySetGroup", new Object[]{exception});
            throw new Exception("Problem importing previous version keys. The exception is " + exception.getMessage());
        }
    }

    private void traceKeyMap(Map map) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "traceKeyMap using LTPA password \"WebAS\" to produce encrypted key strings.");
            }
            try {
                if (map != null) {
                    Object object;
                    Object object2;
                    String string;
                    KeyEncryptor keyEncryptor = new KeyEncryptor("WebAS".getBytes("UTF8"));
                    LTPAPublicKey lTPAPublicKey = null;
                    LTPAPrivateKey lTPAPrivateKey = null;
                    byte[] byArray = null;
                    byte[] byArray2 = null;
                    byte[] byArray3 = null;
                    byte[] byArray4 = null;
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        string = (String)iterator.next();
                        object2 = map.get(string);
                        if (object2 instanceof Key) {
                            byArray = ((Key)object2).getEncoded();
                            byArray2 = Base64Coder.base64Encode(keyEncryptor.encrypt((byte[])byArray.clone()));
                            continue;
                        }
                        if (!(object2 instanceof KeyPair)) continue;
                        object = ((KeyPair)object2).getPublicKey();
                        lTPAPublicKey = new LTPAPublicKey(object.getEncoded());
                        Key key = ((KeyPair)object2).getPrivateKey();
                        lTPAPrivateKey = new LTPAPrivateKey(key.getEncoded());
                        byte[] byArray5 = lTPAPublicKey.getEncoded();
                        byte[] byArray6 = lTPAPrivateKey.getEncoded();
                        byte[] byArray7 = keyEncryptor.encrypt((byte[])byArray6.clone());
                        byArray3 = Base64Coder.base64Encode(byArray7);
                        byArray4 = Base64Coder.base64Encode(byArray5);
                    }
                    string = new String(byArray2, "UTF8");
                    object2 = new String(byArray3, "UTF8");
                    object = new String(byArray4, "UTF8");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Shared key: " + string);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Public key: " + (String)object);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Private key: " + object2);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Keys do not exist. Make sure the LTPA configuration is setup");
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Could not trace keys, received exception.", new Object[]{exception});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "traceKeyMap");
        }
    }

    private void traceValidationKeys(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "traceValidationKeys");
        }
        if (map != null) {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Map map2 = (Map)iterator.next();
                if (map2 == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Validation keyMap: " + map2);
                }
                this.traceKeyMap(map2);
            }
        }
    }

    static {
        CURRENT_LTPA_VERSION = "1.0";
        ltpaServer = null;
        _useFIPS = false;
        _forceSoftwareJCEProviderForLTPA = false;
        _defaultJCEProvider = "IBMJCE";
        primaryTokenFactoryMap = new HashMap();
        secondaryTokenFactoryMap = new HashMap();
        ctxMgr = ContextManagerFactory.getInstance();
        ACCESS_LTPA_SERVER_OBJECT = new WebSphereRuntimePermission("accessLTPAServerObject");
        MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
        tokenFactoryPredictionMap = new HashMap();
    }

    final class FactoryPrediction {
        int length = 0;
        int factoryNumber = 0;
        long[] statistics;

        public FactoryPrediction() {
            this.statistics = new long[LTPAServerObject.this.primaryTokenFactoryList.size()];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void addResult(int n, int n2) {
            int n3;
            long l;
            if (n == this.length && n2 == this.factoryNumber) {
                return;
            }
            int n4 = n2;
            this.statistics[n4] = this.statistics[n4] + 1L;
            if (this.statistics[n2] > 1000L) {
                long[] lArray = this.statistics;
                // MONITORENTER : this.statistics
                l = 1L;
                for (n3 = 1; n3 < this.statistics.length; ++n3) {
                    if (this.statistics[n3] <= 0L || this.statistics[n3] >= l) continue;
                    l = this.statistics[n3];
                }
                --l;
                n3 = 0;
                while (n3 < this.statistics.length) {
                    int n5 = n3++;
                    this.statistics[n5] = this.statistics[n5] - l;
                }
                // MONITOREXIT : lArray
            }
            int n6 = 0;
            l = this.statistics[0];
            n3 = 1;
            while (true) {
                if (n3 >= this.statistics.length) {
                    this.factoryNumber = n6;
                    return;
                }
                if (this.statistics[n3] > l) {
                    n6 = n3;
                    l = this.statistics[n3];
                }
                ++n3;
            }
        }

        public int getFactoryNumber() {
            return this.factoryNumber;
        }
    }
}

