/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class LTPACrypto {
    private static TraceComponent tc;
    private static final String CRYPTO_ALGORITHM = "RSA";
    private static final String ENCRYPT_ALGORITHM = "DESede";
    private static final String CIPHER = "DESede/ECB/PKCS5Padding";
    private static IvParameterSpec ivs8;
    private static IvParameterSpec ivs16;
    private static SecureRandom random;
    private static double[] ETB;
    private static int slot;
    private static int channels;
    private static int[] samples;
    private static int[] ones;
    private static int[] block;
    private static byte[] seed;
    private static int ri;
    private static boolean seedInitialized;
    static int trMix;
    private static final byte[] Pmd2;
    private static final int[] PC;
    private static final int[] SP0;
    private static final int[] SP1;
    private static final ConcurrentHashMap bigIntegerMap;
    private static final ConcurrentHashMap bigIntegerInverseMap;
    protected static final ConcurrentHashMap rsaKeysMap;
    protected static final ConcurrentHashMap cryptoKeysMap;
    protected static final ConcurrentHashMap verifyKeysMap;
    static final Comparator cachingVerifyKeyComparator;
    static final Comparator cachingKeyComparator;
    static final int MAX_CACHE = 2000;
    static String[][] rsaKeyMaterial;
    static String[][] dsaKeyMaterial;
    static byte[][][] rsaKeys;
    static byte[][][] dsaKeys;

    LTPACrypto() {
    }

    static final boolean cmp(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        while (--n3 >= 0) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    static final int msbf(byte[] byArray, int n, int n2) {
        int n3 = 0;
        do {
            n3 |= (byArray[n++] & 0xFF) << --n2 * 8;
        } while (n2 > 0);
        return n3;
    }

    static final int msbf2(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    static final void msbf(int n, byte[] byArray, int n2, int n3) {
        do {
            byArray[n2++] = (byte)(n >>> --n3 * 8);
        } while (n3 > 0);
    }

    static final void msbf4(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    static final void msbf2(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 8);
        byArray[n2 + 1] = (byte)n;
    }

    static final int lsbf(byte[] byArray, int n, int n2) {
        int n3 = 0;
        do {
            n3 |= (byArray[n + --n2] & 0xFF) << n2 * 8;
        } while (n2 > 0);
        return n3;
    }

    static final int lsbf4(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | byArray[n + 3] << 24;
    }

    static final void lsbf4(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >>> 8);
        byArray[n2 + 2] = (byte)(n >>> 16);
        byArray[n2 + 3] = (byte)(n >>> 24);
    }

    static void lsbf2(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[n2 + 1] = (byte)(n >>> 8);
    }

    static final void trng(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = 0;
        while (n2-- > 0) {
            while (n3 < 8) {
                int n4 = 0;
                do {
                    long l2 = System.currentTimeMillis();
                    while (System.currentTimeMillis() == l2) {
                        ++n4;
                    }
                } while (n4 == 0);
                int n5 = samples[slot] ^ n4;
                LTPACrypto.samples[LTPACrypto.slot] = n4;
                int n6 = 0;
                int n7 = 1;
                do {
                    if ((n5 & n7) != 0) {
                        int n8 = n6;
                        ones[n8] = ones[n8] + ((n4 & n7) != 0 ? 1 : -1);
                        channels ^= n7;
                    }
                    int n9 = n6;
                    block[n9] = block[n9] - 1;
                    if (block[n9] == 0) {
                        l = l << 1 | (long)((channels & n7) != 0 ? 1 : 0);
                        ++n3;
                    }
                    if (block[n6] <= 0) {
                        int n10;
                        for (n10 = 0; n10 < 16 && !(Math.abs(0.5 - (double)ones[n6] / 56.0) <= ETB[n10]); ++n10) {
                        }
                        LTPACrypto.block[n6] = n10 == 16 ? -1 : n10 + 1;
                    }
                    n7 <<= 1;
                } while (++n6 < 16);
                slot = (slot + 1) % 56;
            }
            byArray[n++] = (byte)(l >>> (n3 -= 8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void random(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        if (!seedInitialized) {
            LTPACrypto.trng(seed, 0, 32);
            LTPACrypto.md5(null, seed, 0, 32, seed, 0);
            rsaKeys = new byte[4][][];
            int n5 = 0;
            n4 = 0;
            while (n5 < rsaKeyMaterial.length) {
                LTPACrypto.rsaKeys[n4] = new byte[8][];
                LTPACrypto.rsaKeys[n4][2] = new BigInteger(rsaKeyMaterial[n5][2], 36).toByteArray();
                LTPACrypto.rsaKeys[n4][3] = new BigInteger(rsaKeyMaterial[n5][0], 36).toByteArray();
                LTPACrypto.rsaKeys[n4][4] = new BigInteger(rsaKeyMaterial[n5][1], 36).toByteArray();
                LTPACrypto.setRSAKey(rsaKeys[n4]);
                LTPACrypto.rsaKeys[n4 + 1] = new byte[][]{rsaKeys[n4][0], rsaKeys[n4][2]};
                ++n5;
                n4 += 2;
            }
            dsaKeys = new byte[4][4][];
            n5 = 0;
            n4 = 0;
            while (n5 < dsaKeyMaterial.length) {
                for (n3 = 0; n3 < 3; ++n3) {
                    byte[] byArray2 = new BigInteger(dsaKeyMaterial[n5][n3], 36).toByteArray();
                    LTPACrypto.dsaKeys[n4 + 1][n3] = byArray2;
                    LTPACrypto.dsaKeys[n4][n3] = byArray2;
                }
                LTPACrypto.dsaKeys[n4][3] = new BigInteger(dsaKeyMaterial[n5][3], 36).toByteArray();
                LTPACrypto.dsaKeys[n4 + 1][3] = new BigInteger(dsaKeyMaterial[n5][4], 36).toByteArray();
                ++n5;
                n4 += 2;
            }
            seedInitialized = true;
        }
        byte[] byArray3 = seed;
        synchronized (seed) {
            for (n4 = 0; n4 < n2; ++n4) {
                n3 = ++ri % 8;
                if (ri % trMix == 0) {
                    byte by = seed[n3];
                    LTPACrypto.trng(seed, n3, 1);
                    int n6 = n3;
                    seed[n6] = (byte)(seed[n6] ^ by);
                }
                if (n3 == 0) {
                    LTPACrypto.md5(null, seed, 0, 32, seed, 0);
                }
                byArray[n++] = seed[n3];
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    static final void sha(int[] nArray, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 1732584193;
        int n5 = -271733879;
        int n6 = -1732584194;
        int n7 = 271733878;
        int n8 = -1009589776;
        int[] nArray2 = new int[80];
        int n9 = n2 / 4;
        boolean bl = false;
        boolean bl2 = false;
        do {
            int n10;
            int n11;
            for (n11 = 0; n11 < 16 && n9 > 0; ++n11) {
                nArray2[n11] = byArray[n + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | byArray[n] << 24;
                --n9;
                n += 4;
            }
            if (n11 < 16) {
                if (!bl2) {
                    n10 = n2 % 4;
                    int n12 = nArray2[n11++] = n10 != 0 ? LTPACrypto.msbf(byArray, n, n10) << (4 - n10) * 8 | 1 << 31 - n10 * 8 : Integer.MIN_VALUE;
                    if (n11 == 15) {
                        nArray2[15] = 0;
                    }
                    bl2 = true;
                }
                if (n11 <= 14) {
                    while (n11 < 14) {
                        nArray2[n11++] = 0;
                    }
                    if (nArray != null) {
                        n2 += nArray[5];
                    }
                    nArray2[14] = n2 >>> 29;
                    nArray2[15] = n2 << 3;
                    bl = true;
                }
                n11 = 16;
            }
            do {
                n10 = nArray2[n11 - 3] ^ nArray2[n11 - 8] ^ nArray2[n11 - 14] ^ nArray2[n11 - 16];
                nArray2[n11] = n10 << 1 | n10 >>> 31;
            } while (++n11 < 80);
            int n13 = n4;
            int n14 = n5;
            int n15 = n6;
            int n16 = n7;
            int n17 = n8;
            n11 = 0;
            do {
                n10 = (n4 << 5 | n4 >>> 27) + (n5 & n6 | ~n5 & n7) + n8 + nArray2[n11] + 1518500249;
                n8 = n7;
                n7 = n6;
                n6 = n5 << 30 | n5 >>> 2;
                n5 = n4;
                n4 = n10;
            } while (++n11 < 20);
            do {
                n10 = (n4 << 5 | n4 >>> 27) + (n5 ^ n6 ^ n7) + n8 + nArray2[n11] + 1859775393;
                n8 = n7;
                n7 = n6;
                n6 = n5 << 30 | n5 >>> 2;
                n5 = n4;
                n4 = n10;
            } while (++n11 < 40);
            do {
                n10 = (n4 << 5 | n4 >>> 27) + (n5 & n6 | (n5 | n6) & n7) + n8 + nArray2[n11] + -1894007588;
                n8 = n7;
                n7 = n6;
                n6 = n5 << 30 | n5 >>> 2;
                n5 = n4;
                n4 = n10;
            } while (++n11 < 60);
            do {
                n10 = (n4 << 5 | n4 >>> 27) + (n5 ^ n6 ^ n7) + n8 + nArray2[n11] + -899497514;
                n8 = n7;
                n7 = n6;
                n6 = n5 << 30 | n5 >>> 2;
                n5 = n4;
                n4 = n10;
            } while (++n11 < 80);
            n4 += n13;
            n5 += n14;
            n6 += n15;
            n7 += n16;
            n8 += n17;
        } while (!bl);
        LTPACrypto.msbf4(n4, byArray2, n3);
        LTPACrypto.msbf4(n5, byArray2, n3 + 4);
        LTPACrypto.msbf4(n6, byArray2, n3 + 8);
        LTPACrypto.msbf4(n7, byArray2, n3 + 12);
        LTPACrypto.msbf4(n8, byArray2, n3 + 16);
    }

    private static final int FF(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n += (n2 & n3 | ~n2 & n4) + n5 + n8) << n6 | n >>> n7) + n2;
    }

    private static final int GG(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n += (n2 & n4 | n3 & ~n4) + n5 + n8) << n6 | n >>> n7) + n2;
    }

    private static final int HH(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n += (n2 ^ n3 ^ n4) + n5 + n8) << n6 | n >>> n7) + n2;
    }

    private static final int II(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return ((n += (n3 ^ (n2 | ~n4)) + n5 + n8) << n6 | n >>> n7) + n2;
    }

    static final void md5(int[] nArray, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = 1732584193;
        int n5 = -271733879;
        int n6 = -1732584194;
        int n7 = 271733878;
        int n8 = n2 / 4;
        int[] nArray2 = new int[16];
        boolean bl = false;
        boolean bl2 = false;
        do {
            int n9;
            int n10 = 0;
            while (n10 < 16 && n8 > 0) {
                nArray2[n10++] = LTPACrypto.lsbf4(byArray, n);
                --n8;
                n += 4;
            }
            if (n10 < 16) {
                if (!bl2) {
                    n9 = n2 % 4;
                    int n11 = nArray2[n10++] = n9 != 0 ? LTPACrypto.lsbf(byArray, n, n9) | 128 << n9 * 8 : 128;
                    if (n10 == 15) {
                        nArray2[15] = 0;
                    }
                    bl2 = true;
                }
                if (n10 <= 14) {
                    while (n10 < 14) {
                        nArray2[n10++] = 0;
                    }
                    if (nArray != null) {
                        n2 += nArray[5];
                    }
                    nArray2[14] = n2 << 3;
                    nArray2[15] = n2 >>> 29;
                    bl = true;
                }
            }
            n9 = n4;
            int n12 = nArray2[0];
            n4 = LTPACrypto.FF(n9, n5, n6, n7, n12, 7, 25, -680876936);
            int n13 = n7;
            int n14 = nArray2[1];
            n7 = LTPACrypto.FF(n13, n4, n5, n6, n14, 12, 20, -389564586);
            int n15 = n6;
            int n16 = nArray2[2];
            n6 = LTPACrypto.FF(n15, n7, n4, n5, n16, 17, 15, 606105819);
            int n17 = n5;
            int n18 = nArray2[3];
            n5 = LTPACrypto.FF(n17, n6, n7, n4, n18, 22, 10, -1044525330);
            int n19 = nArray2[4];
            n4 = LTPACrypto.FF(n4, n5, n6, n7, n19, 7, 25, -176418897);
            int n20 = nArray2[5];
            n7 = LTPACrypto.FF(n7, n4, n5, n6, n20, 12, 20, 1200080426);
            int n21 = nArray2[6];
            n6 = LTPACrypto.FF(n6, n7, n4, n5, n21, 17, 15, -1473231341);
            int n22 = nArray2[7];
            n5 = LTPACrypto.FF(n5, n6, n7, n4, n22, 22, 10, -45705983);
            int n23 = nArray2[8];
            n4 = LTPACrypto.FF(n4, n5, n6, n7, n23, 7, 25, 1770035416);
            int n24 = nArray2[9];
            n7 = LTPACrypto.FF(n7, n4, n5, n6, n24, 12, 20, -1958414417);
            int n25 = nArray2[10];
            n6 = LTPACrypto.FF(n6, n7, n4, n5, n25, 17, 15, -42063);
            int n26 = nArray2[11];
            n5 = LTPACrypto.FF(n5, n6, n7, n4, n26, 22, 10, -1990404162);
            int n27 = nArray2[12];
            n4 = LTPACrypto.FF(n4, n5, n6, n7, n27, 7, 25, 1804603682);
            int n28 = nArray2[13];
            n7 = LTPACrypto.FF(n7, n4, n5, n6, n28, 12, 20, -40341101);
            int n29 = nArray2[14];
            n6 = LTPACrypto.FF(n6, n7, n4, n5, n29, 17, 15, -1502002290);
            int n30 = nArray2[15];
            n5 = LTPACrypto.FF(n5, n6, n7, n4, n30, 22, 10, 1236535329);
            n4 = LTPACrypto.GG(n4, n5, n6, n7, n14, 5, 27, -165796510);
            n7 = LTPACrypto.GG(n7, n4, n5, n6, n21, 9, 23, -1069501632);
            n6 = LTPACrypto.GG(n6, n7, n4, n5, n26, 14, 18, 643717713);
            n5 = LTPACrypto.GG(n5, n6, n7, n4, n12, 20, 12, -373897302);
            n4 = LTPACrypto.GG(n4, n5, n6, n7, n20, 5, 27, -701558691);
            n7 = LTPACrypto.GG(n7, n4, n5, n6, n25, 9, 23, 38016083);
            n6 = LTPACrypto.GG(n6, n7, n4, n5, n30, 14, 18, -660478335);
            n5 = LTPACrypto.GG(n5, n6, n7, n4, n19, 20, 12, -405537848);
            n4 = LTPACrypto.GG(n4, n5, n6, n7, n24, 5, 27, 568446438);
            n7 = LTPACrypto.GG(n7, n4, n5, n6, n29, 9, 23, -1019803690);
            n6 = LTPACrypto.GG(n6, n7, n4, n5, n18, 14, 18, -187363961);
            n5 = LTPACrypto.GG(n5, n6, n7, n4, n23, 20, 12, 1163531501);
            n4 = LTPACrypto.GG(n4, n5, n6, n7, n28, 5, 27, -1444681467);
            n7 = LTPACrypto.GG(n7, n4, n5, n6, n16, 9, 23, -51403784);
            n6 = LTPACrypto.GG(n6, n7, n4, n5, n22, 14, 18, 1735328473);
            n5 = LTPACrypto.GG(n5, n6, n7, n4, n27, 20, 12, -1926607734);
            n4 = LTPACrypto.HH(n4, n5, n6, n7, n20, 4, 28, -378558);
            n7 = LTPACrypto.HH(n7, n4, n5, n6, n23, 11, 21, -2022574463);
            n6 = LTPACrypto.HH(n6, n7, n4, n5, n26, 16, 16, 1839030562);
            n5 = LTPACrypto.HH(n5, n6, n7, n4, n29, 23, 9, -35309556);
            n4 = LTPACrypto.HH(n4, n5, n6, n7, n14, 4, 28, -1530992060);
            n7 = LTPACrypto.HH(n7, n4, n5, n6, n19, 11, 21, 1272893353);
            n6 = LTPACrypto.HH(n6, n7, n4, n5, n22, 16, 16, -155497632);
            n5 = LTPACrypto.HH(n5, n6, n7, n4, n25, 23, 9, -1094730640);
            n4 = LTPACrypto.HH(n4, n5, n6, n7, n28, 4, 28, 681279174);
            n7 = LTPACrypto.HH(n7, n4, n5, n6, n12, 11, 21, -358537222);
            n6 = LTPACrypto.HH(n6, n7, n4, n5, n18, 16, 16, -722521979);
            n5 = LTPACrypto.HH(n5, n6, n7, n4, n21, 23, 9, 76029189);
            n4 = LTPACrypto.HH(n4, n5, n6, n7, n24, 4, 28, -640364487);
            n7 = LTPACrypto.HH(n7, n4, n5, n6, n27, 11, 21, -421815835);
            n6 = LTPACrypto.HH(n6, n7, n4, n5, n30, 16, 16, 530742520);
            n5 = LTPACrypto.HH(n5, n6, n7, n4, n16, 23, 9, -995338651);
            n4 = LTPACrypto.II(n4, n5, n6, n7, n12, 6, 26, -198630844);
            n7 = LTPACrypto.II(n7, n4, n5, n6, n22, 10, 22, 1126891415);
            n6 = LTPACrypto.II(n6, n7, n4, n5, n29, 15, 17, -1416354905);
            n5 = LTPACrypto.II(n5, n6, n7, n4, n20, 21, 11, -57434055);
            n4 = LTPACrypto.II(n4, n5, n6, n7, n27, 6, 26, 1700485571);
            n7 = LTPACrypto.II(n7, n4, n5, n6, n18, 10, 22, -1894986606);
            n6 = LTPACrypto.II(n6, n7, n4, n5, n25, 15, 17, -1051523);
            n5 = LTPACrypto.II(n5, n6, n7, n4, n14, 21, 11, -2054922799);
            n4 = LTPACrypto.II(n4, n5, n6, n7, n23, 6, 26, 1873313359);
            n7 = LTPACrypto.II(n7, n4, n5, n6, n30, 10, 22, -30611744);
            n6 = LTPACrypto.II(n6, n7, n4, n5, n21, 15, 17, -1560198380);
            n5 = LTPACrypto.II(n5, n6, n7, n4, n28, 21, 11, 1309151649);
            n4 = LTPACrypto.II(n4, n5, n6, n7, n19, 6, 26, -145523070);
            n7 = LTPACrypto.II(n7, n4, n5, n6, n26, 10, 22, -1120210379);
            n6 = LTPACrypto.II(n6, n7, n4, n5, n16, 15, 17, 718787259);
            n5 = LTPACrypto.II(n5, n6, n7, n4, n24, 21, 11, -343485551) + n17;
            n4 += n9;
            n6 += n15;
            n7 += n13;
        } while (!bl);
        LTPACrypto.lsbf4(n4, byArray2, n3);
        LTPACrypto.lsbf4(n5, byArray2, n3 + 4);
        LTPACrypto.lsbf4(n6, byArray2, n3 + 8);
        LTPACrypto.lsbf4(n7, byArray2, n3 + 12);
    }

    static final void md2(byte[][] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) {
        byte[] byArray4 = Pmd2;
        byte by = 0;
        byte[] byArray5 = new byte[16];
        byte[] byArray6 = new byte[48];
        do {
            byte by2 = byArray5[15];
            int n4 = 0;
            do {
                if (n2 > 0) {
                    by = byArray2[n++];
                    --n2;
                } else if (n2 == 0) {
                    by = (byte)(16 - n4);
                    --n2;
                } else if (n2 == -2) {
                    by = byArray5[n4];
                }
                byte by3 = by;
                byArray6[n4 + 16] = by3;
                byArray6[n4 + 32] = (byte)(byArray6[n4] ^ by3);
                int n5 = n4++;
                byte by4 = (byte)(byArray5[n5] ^ byArray4[(by ^ by2) & 0xFF]);
                byArray5[n5] = by4;
                by2 = by4;
            } while (n4 < 16);
            if (n2 <= 0) {
                --n2;
            }
            by2 = 0;
            n4 = 0;
            do {
                int n6 = 0;
                do {
                    int n7 = n6++;
                    byte by5 = (byte)(byArray6[n7] ^ byArray4[by2 & 0xFF]);
                    byArray6[n7] = by5;
                    by2 = by5;
                } while (n6 < 48);
                by2 = (byte)(by2 + n4);
            } while (++n4 < 18);
        } while (n2 > -3);
        System.arraycopy(byArray6, 0, byArray3, n3, 16);
    }

    static final byte[] rc4key(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[258];
        int n3 = 0;
        int n4 = 0;
        do {
            byArray2[n3] = (byte)n3;
        } while (++n3 < 256);
        n3 = 0;
        do {
            n4 = n4 + byArray2[n3] + byArray[(n3 + n) % n2] & 0xFF;
            byte by = byArray2[n3];
            byArray2[n3] = byArray2[n4];
            byArray2[n4] = by;
        } while (++n3 < 256);
        return byArray2;
    }

    static final void rc4(byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) {
        if ((n2 += n) == n) {
            return;
        }
        int n4 = byArray[256] & 0xFF;
        int n5 = byArray[257] & 0xFF;
        if (n == n3) {
            do {
                n4 = n4 + 1 & 0xFF;
                byte by = byArray[n4];
                n5 = n5 + by & 0xFF;
                byte by2 = byArray[n5];
                byArray[n5] = by;
                byArray[n4] = by2;
                byArray3[n] = (byte)(byArray2[n] ^ byArray[byArray[n5] + byArray[n4] & 0xFF]);
            } while (++n < n2);
        } else {
            do {
                n4 = n4 + 1 & 0xFF;
                byte by = byArray[n4];
                n5 = n5 + by & 0xFF;
                byte by3 = byArray[n5];
                int n6 = n3++;
                byArray[n5] = by;
                byArray[n4] = by3;
                byArray3[n6] = (byte)(byArray2[n] ^ byArray[byArray[n5] + byArray[n4] & 0xFF]);
            } while (++n < n2);
        }
        byArray[256] = (byte)n4;
        byArray[257] = (byte)n5;
    }

    static final int[] desKey(boolean bl, byte[] byArray, int n, int n2) {
        int[] nArray = PC;
        int[] nArray2 = new int[n2 * 4];
        int n3 = 0;
        boolean bl2 = bl;
        do {
            int n4 = LTPACrypto.lsbf4(byArray, n + n3);
            int n5 = LTPACrypto.lsbf4(byArray, n + n3 + 4);
            int n6 = (n5 >>> 4 ^ n4) & 0xF0F0F0F;
            n4 ^= n6;
            n5 ^= n6 << 4;
            n6 = (n4 << 18 ^ n4) & 0xCCCC0000;
            n4 ^= n6 ^ n6 >>> 18;
            n6 = (n5 << 18 ^ n5) & 0xCCCC0000;
            n5 ^= n6 ^ n6 >>> 18;
            n6 = (n5 >>> 1 ^ n4) & 0x55555555;
            n4 ^= n6;
            n5 ^= n6 << 1;
            n6 = (n4 >>> 8 ^ n5) & 0xFF00FF;
            n5 ^= n6;
            n4 ^= n6 << 8;
            n6 = (n5 >>> 1 ^ n4) & 0x55555555;
            n5 ^= n6 << 1;
            n5 = n5 << 16 & 0xFF0000 | n5 & 0xFF00 | n5 >> 16 & 0xFF | (n4 ^= n6) >> 4 & 0xF000000;
            n4 &= 0xFFFFFFF;
            int n7 = 0;
            do {
                int n8 = (32508 >> n7 & 1) == 1 ? 2 : 1;
                n4 = (n4 >>> n8 | n4 << 28 - n8) & 0xFFFFFFF;
                int n9 = nArray[n4 & 0x3F] | nArray[0x40 | n4 >> 6 & 3 | n4 >> 7 & 0x3C] | nArray[0x80 | n4 >> 13 & 0xF | n4 >> 14 & 0x30] | nArray[0xC0 | n4 >> 20 & 1 | n4 >> 21 & 6 | n4 >> 22 & 0x38];
                n5 = (n5 >>> n8 | n5 << 28 - n8) & 0xFFFFFFF;
                n6 = nArray[0x100 | n5 & 0x3F] | nArray[0x140 | n5 >> 7 & 3 | n5 >> 8 & 0x3C] | nArray[0x180 | n5 >> 15 & 0x3F] | nArray[0x1C0 | n5 >> 21 & 0xF | n5 >> 22 & 0x30];
                int n10 = (bl ? n3 : n2 - n3 - 8) * 4 + (bl2 ? n7 : 15 - n7) * 2;
                nArray2[n10] = n6 << 16 | n9 & 0xFFFF;
                n9 = n9 >>> 16 | n6 & 0xFFFF0000;
                nArray2[n10 + 1] = n9 << 4 | n9 >>> 28;
            } while (++n7 < 16);
            bl2 ^= true;
        } while ((n3 += 8) < n2);
        return nArray2;
    }

    static final void des(boolean bl, int[] nArray, byte[] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3) {
        int[] nArray2 = SP0;
        int[] nArray3 = SP1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = nArray.length;
        if (byArray != null) {
            n4 = LTPACrypto.lsbf4(byArray, 0);
            n5 = LTPACrypto.lsbf4(byArray, 4);
        }
        n2 += n;
        while (n < n2) {
            int n9 = LTPACrypto.lsbf4(byArray2, n);
            int n10 = LTPACrypto.lsbf4(byArray2, n + 4);
            n += 8;
            if (byArray != null) {
                if (bl) {
                    n9 ^= n4;
                    n10 ^= n5;
                } else {
                    n6 = n9;
                    n7 = n10;
                }
            }
            int n11 = (n10 >>> 4 ^ n9) & 0xF0F0F0F;
            n9 ^= n11;
            n10 ^= n11 << 4;
            n11 = (n9 >>> 16 ^ n10) & 0xFFFF;
            n10 ^= n11;
            n9 ^= n11 << 16;
            n11 = (n10 >>> 2 ^ n9) & 0x33333333;
            n9 ^= n11;
            n10 ^= n11 << 2;
            n11 = (n9 >>> 8 ^ n10) & 0xFF00FF;
            n10 ^= n11;
            n9 ^= n11 << 8;
            n11 = (n10 >>> 1 ^ n9) & 0x55555555;
            int n12 = (n10 ^= n11 << 1) << 1 | n10 >>> 31;
            n10 = (n9 ^= n11) << 1 | n9 >>> 31;
            int n13 = 32;
            while (true) {
                n9 = n12;
                int n14 = n13 - 32;
                do {
                    n12 = n10 ^ nArray[n14 + 1];
                    n11 = n12 >>> 4 | n12 << 28 | 0xC040C040;
                    n12 = n10 ^ nArray[n14] | 0x80008000;
                    n9 ^= nArray2[n11 & 0x7F] | nArray2[n11 >>> 8 & 0xFF] | nArray3[n11 >>> 16 & 0x7F] | nArray3[n11 >>> 24] | nArray2[n12 & 0x3F] | nArray2[n12 >>> 8 & 0xBF] | nArray3[n12 >>> 16 & 0x3F] | nArray3[n12 >>> 24 & 0xBF];
                    n12 = n9 ^ nArray[n14 + 3];
                    n11 = n12 >>> 4 | n12 << 28 | 0xC040C040;
                    n12 = n9 ^ nArray[n14 + 2] | 0x80008000;
                    n10 ^= nArray2[n11 & 0x7F] | nArray2[n11 >>> 8 & 0xFF] | nArray3[n11 >>> 16 & 0x7F] | nArray3[n11 >>> 24] | nArray2[n12 & 0x3F] | nArray2[n12 >>> 8 & 0xBF] | nArray3[n12 >>> 16 & 0x3F] | nArray3[n12 >>> 24 & 0xBF];
                } while ((n14 += 4) < n13);
                if ((n13 += 32) > n8) break;
                n12 = n10;
                n10 = n9;
            }
            n9 = n9 >>> 1 | n9 << 31;
            n10 = n10 >>> 1 | n10 << 31;
            n11 = (n10 >>> 1 ^ n9) & 0x55555555;
            n9 ^= n11;
            n10 ^= n11 << 1;
            n11 = (n9 >>> 8 ^ n10) & 0xFF00FF;
            n10 ^= n11;
            n9 ^= n11 << 8;
            n11 = (n10 >>> 2 ^ n9) & 0x33333333;
            n9 ^= n11;
            n10 ^= n11 << 2;
            n11 = (n9 >>> 16 ^ n10) & 0xFFFF;
            n10 ^= n11;
            n9 ^= n11 << 16;
            n11 = (n10 >>> 4 ^ n9) & 0xF0F0F0F;
            n9 ^= n11;
            n10 ^= n11 << 4;
            if (byArray != null) {
                if (bl) {
                    n4 = n9;
                    n5 = n10;
                } else {
                    n9 ^= n4;
                    n10 ^= n5;
                    n4 = n6;
                    n5 = n7;
                }
            }
            if (byArray3 == null) continue;
            LTPACrypto.lsbf4(n9, byArray3, n3);
            LTPACrypto.lsbf4(n10, byArray3, n3 + 4);
            n3 += 8;
        }
        if (byArray != null) {
            LTPACrypto.lsbf4(n4, byArray, 0);
            LTPACrypto.lsbf4(n5, byArray, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final byte[] rsa(boolean bl, int n, byte[][] byArray, byte[] byArray2, int n2, int n3) {
        BigInteger bigInteger;
        Serializable serializable;
        byte[] byArray3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object;
        CachingKey cachingKey = new CachingKey(byArray, byArray2, n2, n3, bl);
        CachingKey cachingKey2 = (CachingKey)rsaKeysMap.get(cachingKey);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "size:" + rsaKeysMap.size());
        }
        if (cachingKey2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rsa.caching successful:" + cachingKey2.hashcode);
            }
            ++cachingKey2.successfulUses;
            cachingKey2.reused = true;
            return cachingKey2.result;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "rsa.caching failed:" + cachingKey.hashcode);
        }
        if (rsaKeysMap.size() > 2000) {
            object = rsaKeysMap;
            synchronized (object) {
                block43: {
                    if (rsaKeysMap.size() > 2000) {
                        try {
                            CachingKey[] cachingKeyArray = rsaKeysMap.keySet().toArray(new CachingKey[rsaKeysMap.size()]);
                            Arrays.sort(cachingKeyArray, cachingKeyComparator);
                            if (cachingKeyComparator.compare(cachingKeyArray[0], cachingKeyArray[cachingKeyArray.length - 1]) < 0) {
                                n7 = rsaKeysMap.size() / 5;
                                for (n6 = 0; n6 < n7; ++n6) {
                                    rsaKeysMap.remove(cachingKeyArray[n6]);
                                    n7 = rsaKeysMap.size() / 5;
                                    --cachingKeyArray[n6 + 1 * n7].successfulUses;
                                    --cachingKeyArray[n6 + 2 * n7].successfulUses;
                                    --cachingKeyArray[n6 + 3 * n7].successfulUses;
                                    --cachingKeyArray[n6 + 4 * n7].successfulUses;
                                }
                            } else {
                                n7 = rsaKeysMap.size() / 5;
                                n6 = 0;
                                for (n5 = 0; n5 < n7; ++n5) {
                                    rsaKeysMap.remove(cachingKeyArray[cachingKeyArray.length - 1 - n5]);
                                    n7 = rsaKeysMap.size() / 5;
                                    n6 = cachingKeyArray.length - 1 - n5;
                                    --cachingKeyArray[n6 - 1 * n7].successfulUses;
                                    --cachingKeyArray[n6 - 2 * n7].successfulUses;
                                    --cachingKeyArray[n6 - 3 * n7].successfulUses;
                                    --cachingKeyArray[n6 - 4 * n7].successfulUses;
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block43;
                            Tr.debug(tc, "Exception clearing rsaKeysMap cache.", new Object[]{exception});
                        }
                    }
                }
            }
        }
        object = null;
        int n8 = byArray.length;
        BigInteger[] bigIntegerArray = new BigInteger[n8];
        if (n8 == 8) {
            n4 = 3;
            n7 = n8;
            if (n == 3) {
                bigIntegerArray[0] = new BigInteger(byArray[0]);
            }
        } else {
            n4 = 0;
            n7 = 2;
        }
        do {
            bigIntegerArray[n4] = new BigInteger(byArray[n4]);
        } while (++n4 < n7);
        n5 = n4 == 2 ? bigIntegerArray[0].bitLength() : bigIntegerArray[3].bitLength() + bigIntegerArray[4].bitLength();
        n6 = (n5 + 7) / 8;
        if (n != 3 || !bl && n == 3) {
            byArray3 = new byte[n6 + 1];
            System.arraycopy(byArray2, n2, byArray3, n6 + 1 - n3, n3);
            if (bl && n != 0) {
                n7 = n6 - n3 - 3;
                serializable = null;
                byArray3[2] = (byte)n;
                if (byArray3[2] == 2) {
                    serializable = new Random(System.currentTimeMillis() ^ (long)byArray2.hashCode() ^ (long)n7);
                }
                int n9 = -1;
                n4 = 3;
                while (n7-- > 0) {
                    if (n == 2) {
                        byte by;
                        do {
                            by = (byte)((Random)serializable).nextInt();
                            n9 = by;
                        } while (by == 0);
                    }
                    byArray3[n4++] = n9;
                }
            }
            bigInteger = new BigInteger(byArray3);
        } else {
            byArray3 = LTPACrypto.padISO9796(byArray2, n2, n3, n5);
            if (byArray3 == null) {
                return null;
            }
            bigInteger = new BigInteger(1, byArray3);
        }
        if (n8 > 3) {
            serializable = bigInteger.remainder(bigIntegerArray[3]).modPow(bigIntegerArray[5], bigIntegerArray[3]);
            BigInteger bigInteger2 = bigInteger.remainder(bigIntegerArray[4]).modPow(bigIntegerArray[6], bigIntegerArray[4]);
            bigInteger = ((BigInteger)serializable).add(bigIntegerArray[3]).subtract(bigInteger2).multiply(bigIntegerArray[7]).remainder(bigIntegerArray[3]).multiply(bigIntegerArray[4]).add(bigInteger2);
        } else {
            bigInteger = bigInteger.modPow(bigIntegerArray[1], bigIntegerArray[0]);
        }
        if (n == 3 && (!bl && !bigInteger.remainder(BigInteger.valueOf(16L)).equals(BigInteger.valueOf(6L)) || bl && bigInteger.multiply(BigInteger.valueOf(2L)).compareTo(bigIntegerArray[0]) == 1)) {
            bigInteger = bigIntegerArray[0].subtract(bigInteger);
        }
        byArray3 = bigInteger.toByteArray();
        n8 = 0;
        if (bl || n == 3) {
            n7 = n6;
            n4 = byArray3.length - n7;
            if (n4 == 0) {
                return byArray3;
            }
            if (n4 < 0) {
                n8 = -n4;
                n4 = 0;
            }
        } else if (n == 0) {
            n4 = byArray3[0] == 0 && byArray3.length > 1 ? 1 : 0;
            n7 = byArray3.length - n4;
        } else if (byArray3[0] == n) {
            n4 = 1;
            while (n4 < byArray3.length && byArray3[n4++] != 0) {
            }
            n7 = byArray3.length - n4;
            if (n7 == 0) {
                return null;
            }
        } else {
            return null;
        }
        object = new byte[n7];
        System.arraycopy(byArray3, n4, object, n8, n7 - n8);
        serializable = rsaKeysMap;
        synchronized (serializable) {
            rsaKeysMap.put(cachingKey, cachingKey);
            cachingKey.result = (byte[])object;
            cachingKey.successfulUses = 0L;
        }
        return object;
    }

    static final byte[] signISO9796(byte[][] byArray, byte[] byArray2, int n, int n2) {
        return LTPACrypto.signISO9796(byArray, byArray2, n, n2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final byte[] signISO9796(byte[][] byArray, byte[] byArray2, int n, int n2, boolean bl) {
        CachingKey[] cachingKeyArray;
        Object object;
        CachingKey cachingKey;
        CachingKey cachingKey2;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "crypto.map.size=" + cryptoKeysMap.size());
        }
        if ((cachingKey2 = (CachingKey)cryptoKeysMap.get(cachingKey = new CachingKey(byArray, byArray2, n, n2, bl))) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "crypto.caching successful:" + cachingKey2.hashcode);
            }
            ++cachingKey2.successfulUses;
            cachingKey2.reused = true;
            return cachingKey2.result;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "crypto.caching failed:" + cachingKey.hashcode);
        }
        if (cryptoKeysMap.size() > 2000) {
            object = cryptoKeysMap;
            synchronized (object) {
                block26: {
                    if (cryptoKeysMap.size() > 2000) {
                        try {
                            int n3;
                            int n4;
                            cachingKeyArray = cryptoKeysMap.keySet().toArray(new CachingKey[cryptoKeysMap.size()]);
                            Arrays.sort(cachingKeyArray, cachingKeyComparator);
                            if (cachingKeyComparator.compare(cachingKeyArray[0], cachingKeyArray[cachingKeyArray.length - 1]) < 0) {
                                n4 = cryptoKeysMap.size() / 5;
                                for (n3 = 0; n3 < n4; ++n3) {
                                    cryptoKeysMap.remove(cachingKeyArray[n3]);
                                    n4 = cryptoKeysMap.size() / 5;
                                    --cachingKeyArray[n3 + 1 * n4].successfulUses;
                                    --cachingKeyArray[n3 + 2 * n4].successfulUses;
                                    --cachingKeyArray[n3 + 3 * n4].successfulUses;
                                    --cachingKeyArray[n3 + 4 * n4].successfulUses;
                                }
                            } else {
                                n4 = cryptoKeysMap.size() / 5;
                                n3 = 0;
                                for (int i = 0; i < n4; ++i) {
                                    cryptoKeysMap.remove(cachingKeyArray[cachingKeyArray.length - 1 - i]);
                                    n4 = cryptoKeysMap.size() / 5;
                                    n3 = cachingKeyArray.length - 1 - i;
                                    --cachingKeyArray[n3 - 1 * n4].successfulUses;
                                    --cachingKeyArray[n3 - 2 * n4].successfulUses;
                                    --cachingKeyArray[n3 - 3 * n4].successfulUses;
                                    --cachingKeyArray[n3 - 4 * n4].successfulUses;
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block26;
                            Tr.debug(tc, "Exception clearing cryptoKeysMap cache.", new Object[]{exception});
                        }
                    }
                }
            }
        }
        object = null;
        if (LTPAServerObject.useFIPS() || bl) {
            try {
                cachingKeyArray = new BigInteger(byArray[0]);
                BigInteger bigInteger = new BigInteger(byArray[2]);
                BigInteger bigInteger2 = new BigInteger(byArray[3]);
                BigInteger bigInteger3 = new BigInteger(byArray[4]);
                BigInteger bigInteger4 = bigInteger.modInverse(bigInteger2.subtract(BigInteger.ONE).multiply(bigInteger3.subtract(BigInteger.ONE)));
                KeyFactory keyFactory = null;
                keyFactory = LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA() ? KeyFactory.getInstance(CRYPTO_ALGORITHM, LTPAServerObject.defaultJCEProvider()) : KeyFactory.getInstance(CRYPTO_ALGORITHM);
                RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec((BigInteger)cachingKeyArray, bigInteger4);
                PrivateKey privateKey = keyFactory.generatePrivate(rSAPrivateKeySpec);
                Signature signature = null;
                signature = LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA() ? Signature.getInstance("SHA1withRSA", LTPAServerObject.defaultJCEProvider()) : Signature.getInstance("SHA1withRSA");
                signature.initSign(privateKey);
                signature.update(byArray2, n, n2);
                object = signature.sign();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchAlgorithmException});
                FFDCFilter.processException(noSuchAlgorithmException, "com.ibm.ws.security.ltpa.LTPACrypto", "1520");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchProviderException});
                FFDCFilter.processException(noSuchProviderException, "com.ibm.ws.security.ltpa.LTPACrypto", "1526");
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                Tr.debug(tc, "Error: KeySpec invalid");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{invalidKeySpecException});
                FFDCFilter.processException(invalidKeySpecException, "com.ibm.ws.security.ltpa.LTPACrypto", "1532");
            }
            catch (InvalidKeyException invalidKeyException) {
                Tr.debug(tc, "Error: Key invalid");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{invalidKeyException});
                FFDCFilter.processException(invalidKeyException, "com.ibm.ws.security.ltpa.LTPACrypto", "1538");
            }
            catch (SignatureException signatureException) {
                Tr.debug(tc, "Error: Signature operation failed");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{signatureException});
                FFDCFilter.processException(signatureException, "com.ibm.ws.security.ltpa.LTPACrypto", "1544");
            }
        } else {
            object = LTPACrypto.rsa(true, 3, byArray, byArray2, n, n2);
        }
        cachingKeyArray = cryptoKeysMap;
        synchronized (cachingKeyArray) {
            cryptoKeysMap.put(cachingKey, cachingKey);
            cachingKey.result = (byte[])object;
            cachingKey.successfulUses = 0L;
        }
        return object;
    }

    static final boolean verifyISO9796(byte[][] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3, int n4) {
        return LTPACrypto.verifyISO9796(byArray, byArray2, n, n2, byArray3, n3, n4, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean verifyISO9796(byte[][] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3, int n4, boolean bl) {
        Object object;
        CachingVerifyKey cachingVerifyKey = new CachingVerifyKey(byArray, byArray2, n, n2, byArray3, n3, n4, bl);
        CachingVerifyKey cachingVerifyKey2 = (CachingVerifyKey)verifyKeysMap.get(cachingVerifyKey);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "v.size:" + verifyKeysMap.size());
        }
        if (cachingVerifyKey2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "verify.caching successful:" + cachingVerifyKey2.hashcode);
            }
            ++cachingVerifyKey2.successfulUses;
            cachingVerifyKey2.reused = true;
            return cachingVerifyKey2.result;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "verify.caching failed:" + cachingVerifyKey.hashcode);
        }
        if (verifyKeysMap.size() > 2000) {
            ConcurrentHashMap concurrentHashMap = verifyKeysMap;
            synchronized (concurrentHashMap) {
                block26: {
                    if (verifyKeysMap.size() > 2000) {
                        try {
                            int n5;
                            int n6;
                            object = verifyKeysMap.keySet().toArray(new CachingVerifyKey[verifyKeysMap.size()]);
                            Arrays.sort(object, cachingVerifyKeyComparator);
                            if (cachingVerifyKeyComparator.compare(object[0], object[((CachingVerifyKey[])object).length - 1]) < 0) {
                                n6 = verifyKeysMap.size() / 5;
                                for (n5 = 0; n5 < n6; ++n5) {
                                    verifyKeysMap.remove(object[n5]);
                                    n6 = verifyKeysMap.size() / 5;
                                    --object[n5 + 1 * n6].successfulUses;
                                    --object[n5 + 2 * n6].successfulUses;
                                    --object[n5 + 3 * n6].successfulUses;
                                    --object[n5 + 4 * n6].successfulUses;
                                }
                            } else {
                                n6 = verifyKeysMap.size() / 5;
                                n5 = 0;
                                for (int i = 0; i < n6; ++i) {
                                    verifyKeysMap.remove(object[((CachingVerifyKey[])object).length - 1 - i]);
                                    n6 = verifyKeysMap.size() / 5;
                                    n5 = ((CachingVerifyKey[])object).length - 1 - i;
                                    --object[n5 - 1 * n6].successfulUses;
                                    --object[n5 - 2 * n6].successfulUses;
                                    --object[n5 - 3 * n6].successfulUses;
                                    --object[n5 - 4 * n6].successfulUses;
                                }
                            }
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block26;
                            Tr.debug(tc, "Exception clearing verifyKeysMap cache.", new Object[]{exception});
                        }
                    }
                }
            }
        }
        boolean bl2 = false;
        if (LTPAServerObject.useFIPS() || bl) {
            try {
                object = new BigInteger(byArray[0]);
                BigInteger bigInteger = new BigInteger(byArray[1]);
                KeyFactory keyFactory = null;
                keyFactory = LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA() ? KeyFactory.getInstance(CRYPTO_ALGORITHM, LTPAServerObject.defaultJCEProvider()) : KeyFactory.getInstance(CRYPTO_ALGORITHM, "IBMJCE");
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec((BigInteger)object, bigInteger);
                PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
                Signature signature = null;
                signature = LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA() ? Signature.getInstance("SHA1withRSA", LTPAServerObject.defaultJCEProvider()) : Signature.getInstance("SHA1withRSA");
                signature.initVerify(publicKey);
                signature.update(byArray2, n, n2);
                bl2 = signature.verify(byArray3);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchAlgorithmException});
                FFDCFilter.processException(noSuchAlgorithmException, "com.ibm.ws.security.ltpa.LTPACrypto", "1951");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchProviderException});
                FFDCFilter.processException(noSuchProviderException, "com.ibm.ws.security.ltpa.LTPACrypto", "1957");
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                Tr.debug(tc, "Error: KeySpec invalid");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{invalidKeySpecException});
                FFDCFilter.processException(invalidKeySpecException, "com.ibm.ws.security.ltpa.LTPACrypto", "1963");
            }
            catch (InvalidKeyException invalidKeyException) {
                Tr.debug(tc, "Error: Key invalid");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{invalidKeyException});
                FFDCFilter.processException(invalidKeyException, "com.ibm.ws.security.ltpa.LTPACrypto", "1969");
            }
            catch (SignatureException signatureException) {
                Tr.debug(tc, "Error: Signature operation failed");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{signatureException});
                FFDCFilter.processException(signatureException, "com.ibm.ws.security.ltpa.LTPACrypto", "1975");
            }
        } else {
            byArray3 = LTPACrypto.rsa(false, 3, byArray, byArray3, n3, n4);
            bl2 = (byArray2 = LTPACrypto.padISO9796(byArray2, n, n2, new BigInteger(byArray[0]).bitLength())).length == byArray3.length && LTPACrypto.cmp(byArray2, 0, byArray3, 0, byArray3.length);
        }
        object = verifyKeysMap;
        synchronized (object) {
            verifyKeysMap.put(cachingVerifyKey, cachingVerifyKey);
            cachingVerifyKey.result = bl2;
            cachingVerifyKey.successfulUses = 0L;
        }
        return bl2;
    }

    static final byte[] padISO9796(byte[] byArray, int n, int n2, int n3) {
        return LTPACrypto.padISO9796(byArray, n, n2, n3, false);
    }

    static final byte[] padISO9796(byte[] byArray, int n, int n2, int n3, boolean bl) {
        byte[] byArray2 = null;
        if (!LTPAServerObject.useFIPS() && !bl) {
            int n4;
            if (n2 * 16 > --n3 + 3) {
                return null;
            }
            byArray2 = new byte[(n3 + 7) / 8];
            for (int i = 0; i < byArray2.length / 2; ++i) {
                byArray2[byArray2.length - 1 - 2 * i] = byArray[n + n2 - 1 - i % n2];
            }
            if ((byArray2.length & 1) != 0) {
                byArray2[0] = byArray[n + n2 - 1 - byArray2.length / 2 % n2];
            }
            long l = 2064737499334935870L;
            for (n4 = 0; n4 < byArray2.length / 2; ++n4) {
                int n5 = byArray2.length - 1 - 2 * n4;
                byArray2[n5 - 1] = (byte)((l >> (byArray2[n5] >>> 2 & 0x3C) & 0xFL) << 4 | l >> ((byArray2[n5] & 0xF) << 2) & 0xFL);
            }
            int n6 = byArray2.length - 2 * n2;
            byArray2[n6] = (byte)(byArray2[n6] ^ 1);
            n4 = n3 % 8;
            byArray2[0] = (byte)(byArray2[0] & (byte)((1 << n4) - 1));
            byArray2[0] = (byte)(byArray2[0] | 1 << (n4 - 1 + 8) % 8);
            byArray2[byArray2.length - 1] = (byte)(byArray2[byArray2.length - 1] << 4 | 6);
        }
        return byArray2;
    }

    static final void setRSAKey(byte[][] byArray) {
        int n;
        BigInteger[] bigIntegerArray = new BigInteger[8];
        for (n = 0; n < 8; ++n) {
            if (byArray[n] == null) continue;
            bigIntegerArray[n] = new BigInteger(1, byArray[n]);
        }
        if (bigIntegerArray[3].compareTo(bigIntegerArray[4]) < 0) {
            BigInteger bigInteger = bigIntegerArray[3];
            bigIntegerArray[3] = bigIntegerArray[4];
            bigIntegerArray[4] = bigInteger;
            bigInteger = bigIntegerArray[5];
            bigIntegerArray[5] = bigIntegerArray[6];
            bigIntegerArray[6] = bigInteger;
            bigIntegerArray[7] = null;
        }
        if (bigIntegerArray[7] == null) {
            bigIntegerArray[7] = bigIntegerArray[4].modInverse(bigIntegerArray[3]);
        }
        if (bigIntegerArray[0] == null) {
            bigIntegerArray[0] = bigIntegerArray[3].multiply(bigIntegerArray[4]);
        }
        if (bigIntegerArray[1] == null) {
            bigIntegerArray[1] = bigIntegerArray[2].modInverse(bigIntegerArray[3].subtract(BigInteger.valueOf(1L)).multiply(bigIntegerArray[4].subtract(BigInteger.valueOf(1L))));
        }
        if (bigIntegerArray[5] == null) {
            bigIntegerArray[5] = bigIntegerArray[1].remainder(bigIntegerArray[3].subtract(BigInteger.valueOf(1L)));
        }
        if (bigIntegerArray[6] == null) {
            bigIntegerArray[6] = bigIntegerArray[1].remainder(bigIntegerArray[4].subtract(BigInteger.valueOf(1L)));
        }
        for (n = 0; n < 8; ++n) {
            byArray[n] = bigIntegerArray[n].toByteArray();
        }
    }

    static final byte[][] rsaKey(int n, boolean bl, boolean bl2) {
        return LTPACrypto.rsaKey(n, bl, bl2, false);
    }

    static final byte[][] rsaKey(int n, boolean bl, boolean bl2, boolean bl3) {
        byte[][] byArrayArray = new byte[bl ? 8 : 3][];
        if (LTPAServerObject.useFIPS() || bl3) {
            BigInteger bigInteger = BigInteger.valueOf(bl2 ? 65537L : 3L);
            KeyPair keyPair = null;
            try {
                RSAKeyGenParameterSpec rSAKeyGenParameterSpec = new RSAKeyGenParameterSpec(n * 8, bigInteger);
                KeyPairGenerator keyPairGenerator = null;
                SecureRandom secureRandom = null;
                if (LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA()) {
                    keyPairGenerator = KeyPairGenerator.getInstance(CRYPTO_ALGORITHM, LTPAServerObject.defaultJCEProvider());
                    secureRandom = SecureRandom.getInstance("IBMSecureRandom", LTPAServerObject.defaultJCEProvider());
                } else {
                    keyPairGenerator = KeyPairGenerator.getInstance(CRYPTO_ALGORITHM, "IBMJCE");
                    secureRandom = SecureRandom.getInstance("IBMSecureRandom");
                }
                keyPairGenerator.initialize(n * 8, secureRandom);
                keyPair = keyPairGenerator.generateKeyPair();
                RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
                byte[] byArray = rSAPublicKey.getEncoded();
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)keyPair.getPrivate();
                byte[] byArray2 = rSAPrivateCrtKey.getEncoded();
                BigInteger bigInteger2 = rSAPublicKey.getPublicExponent();
                BigInteger bigInteger3 = rSAPublicKey.getModulus();
                BigInteger bigInteger4 = rSAPrivateCrtKey.getPrivateExponent();
                byArrayArray[0] = bigInteger3.toByteArray();
                byArrayArray[1] = bl ? null : bigInteger4.toByteArray();
                byArrayArray[2] = bigInteger2.toByteArray();
                if (bl) {
                    BigInteger bigInteger5 = rSAPrivateCrtKey.getPrimeP();
                    BigInteger bigInteger6 = rSAPrivateCrtKey.getPrimeQ();
                    BigInteger bigInteger7 = rSAPrivateCrtKey.getPrimeExponentP();
                    BigInteger bigInteger8 = rSAPrivateCrtKey.getPrimeExponentQ();
                    BigInteger bigInteger9 = rSAPrivateCrtKey.getCrtCoefficient();
                    byArrayArray[3] = bigInteger5.toByteArray();
                    byArrayArray[4] = bigInteger6.toByteArray();
                    byArrayArray[5] = bigInteger7.toByteArray();
                    byArrayArray[6] = bigInteger8.toByteArray();
                    byArrayArray[7] = bigInteger9.toByteArray();
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchAlgorithmException});
                FFDCFilter.processException(noSuchAlgorithmException, "com.ibm.ws.security.ltpa.LTPACrypto", "2156");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchProviderException});
                FFDCFilter.processException(noSuchProviderException, "com.ibm.ws.security.ltpa.LTPACrypto", "2162");
            }
        } else {
            BigInteger bigInteger;
            BigInteger bigInteger10;
            BigInteger bigInteger11;
            BigInteger bigInteger12 = BigInteger.valueOf(bl2 ? 65537L : 3L);
            BigInteger bigInteger13 = BigInteger.valueOf(1L);
            BigInteger bigInteger14 = BigInteger.valueOf(2L);
            byte[] byArray = new byte[(n /= 2) + 1];
            BigInteger bigInteger15 = null;
            while (true) {
                bigInteger11 = null;
                while (true) {
                    if (bigInteger11 == null) {
                        LTPACrypto.random(byArray, 1, n);
                        byArray[1] = (byte)(byArray[1] | 0xC0);
                        int n2 = n;
                        byArray[n2] = (byte)(byArray[n2] | 1);
                        bigInteger11 = new BigInteger(byArray);
                    } else if ((bigInteger11 = bigInteger11.add(bigInteger14)).bitLength() > n * 8) {
                        bigInteger11 = null;
                        continue;
                    }
                    if (bigInteger11.isProbablePrime(32) && bigInteger12.gcd(bigInteger11.subtract(bigInteger13)).equals(bigInteger13)) break;
                }
                if (bigInteger15 == null) {
                    bigInteger15 = bigInteger11;
                    continue;
                }
                bigInteger10 = bigInteger15.multiply(bigInteger11);
                if (bigInteger10.bitLength() == n * 2 * 8) {
                    bigInteger = bigInteger12.modInverse(bigInteger15.subtract(bigInteger13).multiply(bigInteger11.subtract(bigInteger13)));
                    if (bigInteger15.modPow(bigInteger12, bigInteger10).modPow(bigInteger, bigInteger10).equals(bigInteger15)) break;
                }
                bigInteger15 = null;
            }
            byArrayArray[0] = bigInteger10.toByteArray();
            byArrayArray[1] = bl ? null : bigInteger.toByteArray();
            byArrayArray[2] = bigInteger12.toByteArray();
            if (bl) {
                if (bigInteger15.compareTo(bigInteger11) < 0) {
                    bigInteger12 = bigInteger15;
                    bigInteger15 = bigInteger11;
                    bigInteger11 = bigInteger12;
                }
                byArrayArray[3] = bigInteger15.toByteArray();
                byArrayArray[4] = bigInteger11.toByteArray();
                byArrayArray[5] = bigInteger.remainder(bigInteger15.subtract(bigInteger13)).toByteArray();
                byArrayArray[6] = bigInteger.remainder(bigInteger11.subtract(bigInteger13)).toByteArray();
                byArrayArray[7] = bigInteger11.modInverse(bigInteger15).toByteArray();
            }
        }
        return byArrayArray;
    }

    static final boolean dsa(int n, byte[][] byArray, byte[] byArray2, int n2, int n3, byte[] byArray3, int n4) {
        int n5 = 0;
        BigInteger[] bigIntegerArray = new BigInteger[6];
        do {
            bigIntegerArray[n5] = new BigInteger(byArray[n5]);
        } while (++n5 < 4);
        if (bigIntegerArray[1].bitLength() != 160) {
            return false;
        }
        byte[] byArray4 = new byte[21];
        if (n == 2) {
            LTPACrypto.sha(null, byArray2, n2, n3, byArray4, 1);
        } else if (n3 == 20) {
            System.arraycopy(byArray2, n2, byArray4, 1, 20);
        } else {
            return false;
        }
        BigInteger bigInteger = new BigInteger(byArray4);
        if (n == 0) {
            byArray4 = new byte[20];
            LTPACrypto.random(byArray4, 0, 20);
            byArray4[0] = (byte)(byArray4[0] & 0x7F);
            BigInteger bigInteger2 = new BigInteger(byArray4);
            bigIntegerArray[4] = bigIntegerArray[2].modPow(bigInteger2, bigIntegerArray[0]).remainder(bigIntegerArray[1]);
            bigIntegerArray[5] = bigInteger2.modInverse(bigIntegerArray[1]).multiply(bigIntegerArray[3].multiply(bigIntegerArray[4]).add(bigInteger)).remainder(bigIntegerArray[1]);
            n5 = 0;
            do {
                byArray3[n4 + n5] = 0;
            } while (++n5 < 40);
            n5 = 0;
            do {
                int n6;
                int n7 = (n6 = (byArray4 = bigIntegerArray[n5 + 4].toByteArray()).length) > 20 ? 1 : 0;
                System.arraycopy(byArray4, n7, byArray3, n4 + 20 * n5 + (20 - (n6 -= n7)), n6);
            } while (++n5 < 2);
            return true;
        }
        n5 = 0;
        do {
            byte by;
            if (n == 1) {
                System.arraycopy(byArray3, n4 + n5 * 20, byArray4, 1, 20);
            } else if (byArray3[n4] == 2 && (by = byArray3[n4 + 1]) > 0 && by <= 21) {
                byArray4 = new byte[by];
                System.arraycopy(byArray3, n4 + 2, byArray4, 0, by);
                n4 += by + 2;
            } else {
                return false;
            }
            bigIntegerArray[n5 + 4] = new BigInteger(byArray4);
        } while (++n5 < 2);
        BigInteger bigInteger3 = bigIntegerArray[5].modInverse(bigIntegerArray[1]);
        BigInteger bigInteger4 = bigInteger.multiply(bigInteger3).remainder(bigIntegerArray[1]);
        BigInteger bigInteger5 = bigIntegerArray[4].multiply(bigInteger3).remainder(bigIntegerArray[1]);
        BigInteger bigInteger6 = bigIntegerArray[2].modPow(bigInteger4, bigIntegerArray[0]).multiply(bigIntegerArray[3].modPow(bigInteger5, bigIntegerArray[0])).remainder(bigIntegerArray[0]).remainder(bigIntegerArray[1]);
        return bigInteger6.equals(bigIntegerArray[4]);
    }

    static final byte getBits(String string, int n, int n2) {
        int n3 = n / 7;
        byte by = (byte)string.charAt(n3);
        int n4 = n % 7;
        by = (byte)(by & 127 >>> n4);
        if ((n4 = n2 - (7 - n4)) > 0) {
            return (byte)(by << n4 | (byte)string.charAt(n3 + 1) >>> 7 - n4);
        }
        if (n4 < 0) {
            return (byte)(by >>> -n4);
        }
        return by;
    }

    static final void printBytes(String string, byte[] byArray, int n, int n2) {
        System.out.println(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append("0123456789ABCDEF".charAt(byArray[n] >> 4 & 0xF));
            stringBuffer.append("0123456789ABCDEF".charAt(byArray[n] & 0xF));
            stringBuffer.append(" ");
            if (++n3 % 16 == 0 || n3 == n2) {
                System.out.println(stringBuffer.toString());
                stringBuffer.setLength(0);
            }
            ++n;
        }
    }

    static final void printInfo(String string, int n, long l, long l2, long l3, long l4) {
        System.out.print((string + "....................").substring(0, 20));
        for (int i = 0; i < 2; ++i) {
            long l5;
            long l6 = i == 0 ? l : l3;
            long l7 = l5 = i == 0 ? l2 : l4;
            if (l6 == -1L) {
                System.out.print("      ");
                continue;
            }
            String string2 = "     " + (long)(n * 1000) / (l5 - l6);
            System.out.print(string2.substring(string2.length() - 6));
        }
        System.out.println();
    }

    static final boolean verifyBuf(byte[] byArray, int n, String string) {
        for (int i = 0; i < 1024 * n; ++i) {
            if (byArray[i] == (byte)(i % 128)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string + " failed!");
            }
            return true;
        }
        return false;
    }

    static final boolean testRSAKeys(byte[] byArray, byte[][] byArray2, byte[][] byArray3) {
        int n;
        int n2 = byArray3[0].length;
        if (byArray3[0][0] == 0) {
            --n2;
        }
        long l = System.currentTimeMillis();
        byte[] byArray4 = LTPACrypto.rsa(true, 0, byArray3, byArray, 1, n2);
        long l2 = System.currentTimeMillis();
        byArray4 = LTPACrypto.rsa(false, 0, byArray2, byArray4, 0, byArray4.length);
        long l3 = System.currentTimeMillis();
        String string = "RSA/" + (byArray2.length == 8 ? "CRT/" : "") + n2 * 8 + (byArray3[1].length == 1 && byArray3[1][0] == 3 ? "/3" : "/F4") + " ...................";
        string = string.substring(0, 20);
        for (n = 0; n < 2; ++n) {
            String string2 = "     " + (n == 0 ? l3 - l2 : l2 - l);
            string = string + string2.substring(string2.length() - 5);
        }
        for (n = 0; n < byArray4.length; ++n) {
            if (byArray4[n] == (byte)((n + 1) % 128)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RSA failed!");
            }
            return true;
        }
        return false;
    }

    static final boolean testDSAKeys(byte[] byArray, byte[][] byArray2, byte[][] byArray3) {
        int n = byArray2[0].length;
        if (byArray2[0][0] == 0) {
            --n;
        }
        long l = System.currentTimeMillis();
        byte[] byArray4 = new byte[40];
        LTPACrypto.dsa(0, byArray2, byArray, 0, 20, byArray4, 0);
        long l2 = System.currentTimeMillis();
        boolean bl = LTPACrypto.dsa(1, byArray3, byArray, 0, 20, byArray4, 0);
        long l3 = System.currentTimeMillis();
        String string = ("DSA/" + n * 8 + " ...................").substring(0, 20);
        for (int i = 0; i < 2; ++i) {
            String string2 = "     " + (i == 0 ? l2 - l : l3 - l2);
            string = string + string2.substring(string2.length() - 5);
        }
        if (!bl && tc.isDebugEnabled()) {
            Tr.debug(tc, "DSA failed!");
        }
        return !bl;
    }

    static final byte[] generateSecretKey(int n) {
        new SecureRandom();
        return SecureRandom.getSeed(n);
    }

    static final byte[] generate3DESKey() {
        return LTPACrypto.generate3DESKey(false);
    }

    static final byte[] generate3DESKey(boolean bl) {
        byte[] byArray = null;
        if (LTPAServerObject.useFIPS() || bl) {
            try {
                SecureRandom secureRandom = null;
                KeyGenerator keyGenerator = null;
                if (LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA()) {
                    secureRandom = SecureRandom.getInstance("IBMSecureRandom", LTPAServerObject.defaultJCEProvider());
                    keyGenerator = KeyGenerator.getInstance(ENCRYPT_ALGORITHM, LTPAServerObject.defaultJCEProvider());
                } else {
                    secureRandom = SecureRandom.getInstance("IBMSecureRandom");
                    keyGenerator = KeyGenerator.getInstance(ENCRYPT_ALGORITHM);
                }
                keyGenerator.init(secureRandom);
                SecretKey secretKey = keyGenerator.generateKey();
                byArray = secretKey.getEncoded();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchAlgorithmException});
                FFDCFilter.processException(noSuchAlgorithmException, "com.ibm.ws.security.ltpa.LTPACrypto", "2561");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchProviderException});
                FFDCFilter.processException(noSuchProviderException, "com.ibm.ws.security.ltpa.LTPACrypto", "2567");
            }
        } else {
            int n = 24;
            byArray = new byte[n];
            LTPACrypto.random(byArray, 0, n);
        }
        return byArray;
    }

    static final byte[] encrypt(byte[] byArray, byte[] byArray2) {
        return LTPACrypto.encrypt(byArray, byArray2, CIPHER, false);
    }

    static final byte[] encrypt(byte[] byArray, byte[] byArray2, String string, boolean bl) {
        long l = 0L;
        if (tc.isDebugEnabled()) {
            l = System.currentTimeMillis();
            Tr.debug(tc, "Cipher used to encrypt: " + string);
            Tr.debug(tc, "Data size: " + byArray.length);
            Tr.debug(tc, "Key size: " + byArray2.length);
        }
        byte[] byArray3 = null;
        if (LTPAServerObject.useFIPS() || bl) {
            try {
                Object object;
                if (null == byArray) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Array was null");
                    }
                    return null;
                }
                SecretKey secretKey = null;
                if (string.indexOf("AES") != -1) {
                    secretKey = new SecretKeySpec(byArray2, 0, 16, "AES");
                } else {
                    object = new DESedeKeySpec(byArray2);
                    SecretKeyFactory secretKeyFactory = null;
                    secretKeyFactory = LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA() ? SecretKeyFactory.getInstance(ENCRYPT_ALGORITHM, LTPAServerObject.defaultJCEProvider()) : SecretKeyFactory.getInstance(ENCRYPT_ALGORITHM);
                    secretKey = secretKeyFactory.generateSecret((KeySpec)object);
                }
                object = null;
                object = LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA() ? Cipher.getInstance(string, LTPAServerObject.defaultJCEProvider()) : Cipher.getInstance(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The Provider Cipher used to encrypt: " + ((Cipher)object).getProvider());
                    Tr.debug(tc, "The Algoritm Cipher used to encrypt: " + ((Cipher)object).getAlgorithm());
                }
                if (string.indexOf("ECB") == -1) {
                    if (string.indexOf("AES") != -1) {
                        if (ivs16 == null) {
                            LTPACrypto.setIVS16(byArray2);
                        }
                        ((Cipher)object).init(1, (Key)secretKey, ivs16);
                    } else {
                        if (ivs8 == null) {
                            LTPACrypto.setIVS8(byArray2);
                        }
                        ((Cipher)object).init(1, (Key)secretKey, ivs8);
                    }
                } else {
                    ((Cipher)object).init(1, secretKey);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "encrypt() Cipher.doFinal()\n   data: " + new String(byArray));
                }
                byArray3 = ((Cipher)object).doFinal(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchAlgorithmException});
                FFDCFilter.processException(noSuchAlgorithmException, "com.ibm.ws.security.ltpa.LTPACrypto", "2672");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchProviderException});
                FFDCFilter.processException(noSuchProviderException, "com.ibm.ws.security.ltpa.LTPACrypto", "2678");
            }
            catch (InvalidKeyException invalidKeyException) {
                Tr.debug(tc, "Error: Key invalid");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{invalidKeyException});
                FFDCFilter.processException(invalidKeyException, "com.ibm.ws.security.ltpa.LTPACrypto", "2684");
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{invalidKeySpecException});
                FFDCFilter.processException(invalidKeySpecException, "com.ibm.ws.security.ltpa.LTPACrypto", "2689");
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchPaddingException});
                FFDCFilter.processException(noSuchPaddingException, "com.ibm.ws.security.ltpa.LTPACrypto", "2694");
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                FFDCFilter.processException(illegalBlockSizeException, "com.ibm.ws.security.ltpa.LTPACrypto", "2699");
            }
            catch (BadPaddingException badPaddingException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{badPaddingException});
                FFDCFilter.processException(badPaddingException, "com.ibm.ws.security.ltpa.LTPACrypto", "2704");
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{invalidAlgorithmParameterException});
                FFDCFilter.processException(invalidAlgorithmParameterException, "com.ibm.ws.security.ltpa.LTPACrypto", "2709");
            }
        } else {
            int n = byArray2.length;
            int[] nArray = LTPACrypto.desKey(true, byArray2, 0, n);
            byArray3 = LTPACrypto.padPKCS5(byArray);
            if (null == byArray3) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Array was null");
                }
                return null;
            }
            LTPACrypto.des(true, nArray, null, byArray3, 0, byArray3.length, byArray3, 0);
        }
        if (tc.isDebugEnabled()) {
            long l2 = System.currentTimeMillis();
            Tr.debug(tc, "Total encryption time: " + (l2 - l));
        }
        return byArray3;
    }

    static final byte[] decrypt(byte[] byArray, byte[] byArray2) {
        return LTPACrypto.decrypt(byArray, byArray2, CIPHER, false);
    }

    static final byte[] decrypt(byte[] byArray, byte[] byArray2, String string, boolean bl) {
        long l = 0L;
        if (tc.isDebugEnabled()) {
            l = System.currentTimeMillis();
            Tr.debug(tc, "Cipher used to decrypt: " + string);
            Tr.debug(tc, "key size: " + byArray2.length);
        }
        byte[] byArray3 = null;
        if (LTPAServerObject.useFIPS() || bl) {
            try {
                Object object;
                if (null == byArray) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Array was null");
                    }
                    return null;
                }
                SecretKey secretKey = null;
                if (string.indexOf("AES") != -1) {
                    secretKey = new SecretKeySpec(byArray2, 0, 16, "AES");
                } else {
                    object = new DESedeKeySpec(byArray2);
                    SecretKeyFactory secretKeyFactory = null;
                    secretKeyFactory = LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA() ? SecretKeyFactory.getInstance(ENCRYPT_ALGORITHM, LTPAServerObject.defaultJCEProvider()) : SecretKeyFactory.getInstance(ENCRYPT_ALGORITHM);
                    secretKey = secretKeyFactory.generateSecret((KeySpec)object);
                }
                object = null;
                object = LTPAServerObject.useFIPS() || LTPAServerObject.forceSoftwareJCEProviderForLTPA() ? Cipher.getInstance(string, LTPAServerObject.defaultJCEProvider()) : Cipher.getInstance(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The Provider Cipher used to decrypt: " + ((Cipher)object).getProvider());
                    Tr.debug(tc, "The Algoritm Cipher used to decrypt: " + ((Cipher)object).getAlgorithm());
                }
                if (string.indexOf("ECB") == -1) {
                    if (string.indexOf("AES") != -1) {
                        if (ivs16 == null) {
                            LTPACrypto.setIVS16(byArray2);
                        }
                        ((Cipher)object).init(2, (Key)secretKey, ivs16);
                    } else {
                        if (ivs8 == null) {
                            LTPACrypto.setIVS8(byArray2);
                        }
                        ((Cipher)object).init(2, (Key)secretKey, ivs8);
                    }
                } else {
                    ((Cipher)object).init(2, secretKey);
                }
                byArray3 = ((Cipher)object).doFinal(byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "decrypt() Cipher.doFinal()\n   tmpMesg: " + new String(byArray3));
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchAlgorithmException});
                FFDCFilter.processException(noSuchAlgorithmException, "com.ibm.ws.security.ltpa.LTPACrypto", "2825");
            }
            catch (NoSuchProviderException noSuchProviderException) {
                Tr.debug(tc, "Error: Provider " + LTPAServerObject.defaultJCEProvider() + " not found");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchProviderException});
                FFDCFilter.processException(noSuchProviderException, "com.ibm.ws.security.ltpa.LTPACrypto", "2831");
            }
            catch (InvalidKeyException invalidKeyException) {
                Tr.debug(tc, "Error: Key invalid");
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{invalidKeyException});
                FFDCFilter.processException(invalidKeyException, "com.ibm.ws.security.ltpa.LTPACrypto", "2837");
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{invalidKeySpecException});
                FFDCFilter.processException(invalidKeySpecException, "com.ibm.ws.security.ltpa.LTPACrypto", "2842");
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{noSuchPaddingException});
                FFDCFilter.processException(noSuchPaddingException, "com.ibm.ws.security.ltpa.LTPACrypto", "2847");
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                FFDCFilter.processException(illegalBlockSizeException, "com.ibm.ws.security.ltpa.LTPACrypto", "2852");
            }
            catch (BadPaddingException badPaddingException) {
                Tr.debug(tc, "BadPaddingException validating token, normal when token generated from other factory.", new Object[]{badPaddingException.getMessage()});
                FFDCFilter.processException(badPaddingException, "com.ibm.ws.security.ltpa.LTPACrypto", "2857");
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                Tr.error(tc, "security.ltpa.noalgorithm", new Object[]{invalidAlgorithmParameterException});
                FFDCFilter.processException(invalidAlgorithmParameterException, "com.ibm.ws.security.ltpa.LTPACrypto", "2862");
            }
        } else {
            int n = byArray2.length;
            int[] nArray = LTPACrypto.desKey(false, byArray2, 0, n);
            LTPACrypto.des(false, nArray, null, byArray, 0, byArray.length, byArray, 0);
            byArray3 = LTPACrypto.unpadPKCS5(byArray);
            if (null == byArray3) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Array was not properly paded");
                }
                return null;
            }
        }
        if (tc.isDebugEnabled()) {
            long l2 = System.currentTimeMillis();
            Tr.debug(tc, "Total decryption time: " + (l2 - l));
        }
        return byArray3;
    }

    private static final byte[] unpadPKCS5(byte[] byArray) {
        if (null == byArray) {
            return null;
        }
        if (0 == byArray.length) {
            return null;
        }
        int n = byArray.length;
        byte by = byArray[n - 1];
        if (by > 8 || by < 1) {
            return null;
        }
        for (int i = n - by; i < n; ++i) {
            if (byArray[i] == by) continue;
            return null;
        }
        byte[] byArray2 = new byte[n - by];
        System.arraycopy(byArray, 0, byArray2, 0, n - by);
        return byArray2;
    }

    private static final byte[] padPKCS5(byte[] byArray) {
        if (null == byArray) {
            return null;
        }
        int n = byArray.length;
        int n2 = 8 - n % 8;
        byte[] byArray2 = new byte[n + n2];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        for (int i = n; i < byArray2.length; ++i) {
            byArray2[i] = (byte)n2;
        }
        return byArray2;
    }

    public static String toHexString(byte[] byArray) {
        String string = null;
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = Integer.toHexString(byArray[i]);
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            string = string + string2;
        }
        return string;
    }

    public static synchronized IvParameterSpec getIVS8() {
        return ivs8;
    }

    public static synchronized IvParameterSpec getIVS16() {
        return ivs16;
    }

    public static synchronized void setIVS8(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIVS8");
        }
        if (ivs8 == null) {
            try {
                byte[] byArray2 = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    byArray2[i] = byArray[i];
                }
                ivs8 = new IvParameterSpec(byArray2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setIVS8: ivs8 successfully set");
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setIVS8 unxepected exception setting initialization vector", new Object[]{exception});
                }
                FFDCFilter.processException(exception, "com.ibm.ws.security.ltpa.LTPAToken2Factory.initialize", "2997");
            }
        }
    }

    public static synchronized void setIVS16(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIVS16");
        }
        if (ivs16 == null) {
            try {
                byte[] byArray2 = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    byArray2[i] = byArray[i];
                }
                ivs16 = new IvParameterSpec(byArray2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setIVS16: ivs16 successfully set");
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "setIVS16 unxepected exception setting initialization vector", new Object[]{exception});
                }
                FFDCFilter.processException(exception, "com.ibm.ws.security.ltpa.LTPAToken2Factory.initialize", "3026");
            }
        }
    }

    static {
        int n;
        tc = Tr.register(LTPACrypto.class, null, "com.ibm.ejs.resources.security");
        ivs8 = null;
        ivs16 = null;
        random = null;
        ETB = new double[16];
        LTPACrypto.ETB[0] = 0.001;
        double d = 0.001;
        double d2 = Math.log(2.0 * d);
        int n2 = 1;
        do {
            LTPACrypto.ETB[n2++] = Math.exp(d2 / (double)n2) / 2.0;
        } while (n2 < ETB.length);
        samples = new int[56];
        ones = new int[16];
        block = new int[16];
        seed = new byte[32];
        seedInitialized = false;
        trMix = 128;
        Pmd2 = new byte[256];
        int n3 = 0;
        do {
            LTPACrypto.Pmd2[n3] = LTPACrypto.getBits("\u0014KH<M\u000b0|\u0000O&e%\u0007Yp\u0003\u0004l*8\u0017g@c\\qIDLWY^\u0013\u0010,Pz6W\u001e?:N\u0000YNB7F\u0011!?\u0014%>'1\u001amT{<IP>~Xul_n=*-\u0007LD+2\u0003OrL\u0010B\u0012\u000b\u0011\u0017d\u0018\u0003};\u001a-$\u0006\"9T}Lso~y8\u000f~\u0019\u0018,i\n-W#W/$E*bZUF'n\u0007\r\u0014ZH}[\u001d_F_\n8t\u0002<(YkA2d8ad\b2o\u001ees\u000b5\u0000\u0010m@%VkV\u000bOX8F0Z&D\u0003x\u001eU#hd=jF^:aW\u001f\u001cuk\u000bj\u0013\u000b\n0k:\n(B\u0002:=~7hA@S*&VpoH605?Q\u0013B{\u0004\u0003\u0017[\n)q\bJb|6\u001f![ieu?cX\u0000:9y;vps\u00191Pr)Nw\u0017cVu%BF\u0014\"Bi\u000fvGc-\\f\u001a3OD01 ", n3 * 8, 8);
        } while (++n3 < 256);
        PC = new int[512];
        int n4 = 0;
        int n5 = 0;
        n2 = 0;
        do {
            byte by = LTPACrypto.getBits("\bu\u00011)Y\u001b\u0001(\"N\u0000$`\f\u0002-T@ \u001c\u0003\r\u00118@\u0013U\u0006 6\u000e\u0001$ \u0019@!\u001b\u0001\nI4H\tX\u0002K", n2 * 6, 6);
            n3 = by;
            if (by == 32) continue;
            n = 0;
            do {
                if ((1 << n4 & n) == 0) continue;
                int n6 = n5 + n;
                PC[n6] = PC[n6] | 1 << n3;
            } while (++n < 64);
            if ((n4 = (n4 + 1) % 6) != 0) continue;
            n5 += 64;
        } while (++n2 < 56);
        SP0 = new int[256];
        SP1 = new int[256];
        String string = "@\rs\u0014TY%\u001eK\u000b\"\tRYI95%2YW}\u0003\u0012\u0004A0\u0000\bI$(\u0000Q\u0014\u0002\u0002J\u0004D\u0012 (\u0000@Y\u0010!\u0016\u00020\u0001 \u0011-iC\u0007RX6(o\u007fA$\f\u0000`I\u0011\u0001P\u0005\u0000$4\u0006  \n\n\b(\f\u0000R\f\u0010A\u0004\u0011\u0010a@\u0004XSU\u0016.pe\u0007a@)\u0016K\u001as\u0016=&$Q\u0004V\rJ\u001bj\"gO\u0004\u0005\u0014l\u000emF[#(3\u0010)rEG\rpKc\u000e \u0000&J(mM\u0013\u00146Zd\u0000\u0004F\u001a-\u001d\u001cy&\u001cV\u0010\u000e8aqSI1%r`\u0015M9\u0014S4RFlh";
        int[] nArray = SP0;
        while (true) {
            n5 = 0;
            int n7 = 63;
            int n8 = 0;
            int n9 = 0;
            long l = 0L;
            n2 = 3;
            do {
                n = 0;
                do {
                    if (l == 0L) {
                        n9 = LTPACrypto.getBits(string, n5, 8) & 0xFF;
                        if (n9 == 0) {
                            n5 += 8;
                            n += 64;
                            continue;
                        }
                        n5 += 8;
                        if (n9 == 255) {
                            n8 = 2;
                            continue;
                        }
                        l = 0L;
                        int n10 = 0;
                        do {
                            l <<= 8;
                            l |= (long)(LTPACrypto.getBits(string, n5, 8) & 0xFF);
                            n5 += 8;
                        } while (++n10 < 8);
                    }
                    if ((l & 1L << n7) != 0L) {
                        int n11 = n;
                        nArray[n11] = nArray[n11] | n9 << n2 * 8;
                    }
                    ++n;
                    if (--n7 >= 0) continue;
                    n7 = 63;
                    l = 0L;
                    if (n8 <= 0) continue;
                    --n8;
                    n -= 64;
                } while (n < 256);
            } while (--n2 >= 0);
            if (nArray != SP0) break;
            nArray = SP1;
            string = "\u0001'%dK''$N\u0018d\t\u0012yGa4i\u0013GH\u0000\u0011K#G\u0016#'&fL\u0000\u0002\u000b\u0016\u001d\u000f\f\u001c\u001f9C\u0014\u0001c-\u0016RXpV\u001cxAG\u0014Z+)\fkRe\u007fP\t\u0018!\u000008\u0000B( \t\u0010\u0010\u0018#\u0010 ,\u0011A\u0002\u0012\t!\u0004\u0018\u0003 )\u0004\u0004\u0005]\u0014T^rFi-\u0002\bpYcltX\u0002k<\u0001R<lIK\u0016L9F\b\r\u001b\u0006_\u0013\u0018S\u001a.D\u0019,+\u00165\u0014\u0016fL\u007f|\u0001D\u0004\u0002H@BIB\b\u0001\n\u0002\u0004)!\u0004\f\u00004`!\u0006\fA\u0011\u0010`\u0012B\u0002\u0005\u0016<l\u0018N\u001ai5\u0014";
        }
        bigIntegerMap = new ConcurrentHashMap();
        bigIntegerInverseMap = new ConcurrentHashMap();
        rsaKeysMap = new ConcurrentHashMap();
        cryptoKeysMap = new ConcurrentHashMap();
        verifyKeysMap = new ConcurrentHashMap();
        cachingVerifyKeyComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                CachingVerifyKey cachingVerifyKey = (CachingVerifyKey)object;
                CachingVerifyKey cachingVerifyKey2 = (CachingVerifyKey)object2;
                if (cachingVerifyKey.successfulUses < cachingVerifyKey2.successfulUses) {
                    return -1;
                }
                if (cachingVerifyKey.successfulUses == cachingVerifyKey2.successfulUses) {
                    return 0;
                }
                return 1;
            }
        };
        cachingKeyComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                CachingKey cachingKey = (CachingKey)object;
                CachingKey cachingKey2 = (CachingKey)object2;
                if (!cachingKey.reused) {
                    if (cachingKey2.reused) {
                        return -1;
                    }
                } else if (!cachingKey2.reused) {
                    return 1;
                }
                if (cachingKey.successfulUses < cachingKey2.successfulUses) {
                    return -1;
                }
                if (cachingKey.successfulUses == cachingKey2.successfulUses) {
                    return 0;
                }
                return 1;
            }
        };
        rsaKeyMaterial = new String[][]{{"4svq2jqtxo3zn2njenso9vwyg2bynvo08ekktj4d7sqwk9s3oz", "4se994le3trmoep5f74ytxfupr2o0oi9dem4nzailb4k4g5e7j", "1ekh"}, {"uk5febz1u9c5x7knn185refnb02syox36xqwae0lm30z9j9p03hyu175dyxbiczds3k1n6jiwqdeyetwgsy1qrvje8a7o40cmb5", "ujsuw3e4k53dtzgbsm3tjpytf5h25i71r8cs8ijbigo607ceo5zy5toem0kp4oeb77tt86h7gkix5fjdq13sa7puya61b2ep82n", "3"}};
        dsaKeyMaterial = new String[][]{{"otj4bi3e6pxy54h5tkjwpuzycvm3ta6jg9f6lj52mvygb9l72y1tkrs0ppuldns6kem6vzw3fbwhinhdhpqjvn284fc0dsaz39h", "jpdh5mk2p667os7al4gmvbdfmar3bsv", "cdybrmm4x665tomdaiedafq3d2wiajhlkbeql7iui72eeayleaa3ppn7lhfdbrh508kum7havwgb7otsnme3pc8r7kipf55hvio", "lpb2xrb2yivmklm6i6pyzvagsu9qhdz", "6d3ng23juhszoxet3kkzw2ei7y3hxo67c9oqvuf5d1dpev7qzwhzy11tcaikknfxtr62zyk96d9vvhli6zw2b2sxbrnlc3xkuzy"}, {"10uj5jh4khn7t93eh41c1d7sfptfuqiycpiimudbj62leu8fwnnt3k5cdkzynrvbhlflm3qe6sfwsjs3bbvjm8j8ctzaljlothjtbujclhafng31uzf4zmj11qjni0z9ou77rap19wl7ps7v52fbuoycrgu6xohwoobiwfanlkh4t18wtw3kf1nsdxz7mwpu9ddu4cz", "s6zmy3zi8dumvm43ofheresn52f9trj", "z4asx4yhsha3vd0d0uhhnahzmtj1qg572k3frvtq46x9lrawlm4x70oc99d4qsplci9e8qjtaqt3sqf719tfojrwjnonkqbxm9op3ck61fcxx2q6l4vg1rizk9kn74pi9859nqqctvn9174smwqzosvdrnd89eykgocc09ph343gpen9lgo0h6dk32a35gut5wb6w1", "f8xedoxwqju60mngerxyt5jv7rl8wbg", "egc8c7ptmx0hr5i4x2bzgeumx8kcmc9jokca88r8e4k1ih802bnz9flr08topo1v7kodqg9yab3xpf2j0lv9zmg8jhh38okgjfeou1fb7xn6blo4t1m8fb64p849eaqa66f1c0ar7m1uwdwc9k57vr58frxezjd1w4sc4zp8s6wn89lmbzem0brt6phtukhg2qfgrn"}};
    }

    static class CachingVerifyKey {
        boolean reused = false;
        long successfulUses;
        byte[][] key;
        byte[] data;
        int off;
        int len;
        byte[] sig;
        int sigOff;
        int sigLen;
        boolean useJCE;
        int hashcode;
        boolean result;

        public CachingVerifyKey(byte[][] byArray, byte[] byArray2, int n, int n2, byte[] byArray3, int n3, int n4, boolean bl) {
            this.key = byArray;
            this.data = byArray2;
            this.off = n;
            this.len = n2;
            this.sig = byArray3;
            this.sigOff = n3;
            this.sigLen = n4;
            this.useJCE = bl;
            this.successfulUses = 0L;
            this.reused = false;
            this.hashcode = 0;
            if (byArray != null && byArray.length > 0 && byArray[0] != null && byArray[0].length > 0) {
                this.hashcode += byArray[0][0];
            }
            if (byArray2 != null) {
                int n5;
                for (n5 = 0; n5 < byArray2.length && n5 < 10; ++n5) {
                    this.hashcode += byArray2[n5];
                }
                for (n5 = byArray2.length - 1; n5 >= 0 && n5 > byArray2.length - 10; --n5) {
                    this.hashcode += byArray2[n5];
                }
            }
            this.hashcode += n;
            if (n != 0) {
                this.hashcode *= n;
            }
            if (bl) {
                this.hashcode *= 2;
            }
        }

        public boolean equals(Object object) {
            int n;
            if (!(object instanceof CachingVerifyKey)) {
                return false;
            }
            CachingVerifyKey cachingVerifyKey = (CachingVerifyKey)object;
            if (this.hashcode != cachingVerifyKey.hashcode) {
                return false;
            }
            if (this.len != cachingVerifyKey.len) {
                return false;
            }
            if (this.key != null) {
                if (cachingVerifyKey.key == null) {
                    return false;
                }
                if (this.key.length != cachingVerifyKey.key.length) {
                    return false;
                }
                for (n = 0; n < this.key.length; ++n) {
                    if (this.key[n] != null) {
                        if (cachingVerifyKey.key[n] == null) {
                            return false;
                        }
                        if (this.key[n].length != cachingVerifyKey.key[n].length) {
                            return false;
                        }
                        for (int i = 0; i < this.key[n].length; ++i) {
                            if (this.key[n][i] == cachingVerifyKey.key[n][i]) continue;
                            return false;
                        }
                        continue;
                    }
                    if (cachingVerifyKey.key[n] == null) continue;
                    return false;
                }
            } else if (cachingVerifyKey.key != null) {
                return false;
            }
            if (this.data != null) {
                if (cachingVerifyKey.data == null) {
                    return false;
                }
                if (this.data.length != cachingVerifyKey.data.length) {
                    return false;
                }
                for (n = 0; n < this.data.length; ++n) {
                    if (this.data[n] == cachingVerifyKey.data[n]) continue;
                    return false;
                }
            } else if (cachingVerifyKey.data != null) {
                return false;
            }
            if (this.sig != null) {
                if (cachingVerifyKey.sig == null) {
                    return false;
                }
                if (this.sig.length != cachingVerifyKey.sig.length) {
                    return false;
                }
                for (n = 0; n < this.sig.length; ++n) {
                    if (this.sig[n] == cachingVerifyKey.sig[n]) continue;
                    return false;
                }
            } else if (cachingVerifyKey.sig != null) {
                return false;
            }
            if (this.off != cachingVerifyKey.off) {
                return false;
            }
            if (this.useJCE != cachingVerifyKey.useJCE) {
                return false;
            }
            if (this.sigOff != cachingVerifyKey.sigOff) {
                return false;
            }
            return this.sigLen == cachingVerifyKey.sigLen;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    static class CachingKey {
        boolean reused = false;
        long successfulUses;
        byte[][] key;
        byte[] data;
        int off;
        int len;
        boolean useJCE;
        int hashcode;
        byte[] result;

        public CachingKey(byte[][] byArray, byte[] byArray2, int n, int n2, boolean bl) {
            this.key = byArray;
            this.data = byArray2;
            this.off = n;
            this.len = n2;
            this.useJCE = bl;
            this.successfulUses = 0L;
            this.reused = false;
            this.hashcode = 0;
            if (byArray != null && byArray.length > 0 && byArray[0] != null && byArray[0].length > 0) {
                this.hashcode += byArray[0][0];
            }
            if (byArray2 != null) {
                for (int i = 0; i < byArray2.length; ++i) {
                    this.hashcode += byArray2[i];
                }
            }
            this.hashcode += n + n2;
            if (n != 0) {
                this.hashcode *= n;
            }
            if (bl) {
                this.hashcode *= 2;
            }
        }

        public boolean equals(Object object) {
            int n;
            if (!(object instanceof CachingKey)) {
                return false;
            }
            CachingKey cachingKey = (CachingKey)object;
            if (this.hashcode != cachingKey.hashcode) {
                return false;
            }
            if (this.len != cachingKey.len) {
                return false;
            }
            if (this.key != null) {
                if (cachingKey.key == null) {
                    return false;
                }
                if (this.key.length != cachingKey.key.length) {
                    return false;
                }
                for (n = 0; n < this.key.length; ++n) {
                    if (this.key[n] != null) {
                        if (cachingKey.key[n] == null) {
                            return false;
                        }
                        if (this.key[n].length != cachingKey.key[n].length) {
                            return false;
                        }
                        for (int i = 0; i < this.key[n].length; ++i) {
                            if (this.key[n][i] == cachingKey.key[n][i]) continue;
                            return false;
                        }
                        continue;
                    }
                    if (cachingKey.key[n] == null) continue;
                    return false;
                }
            } else if (cachingKey.key != null) {
                return false;
            }
            if (this.data != null) {
                if (cachingKey.data == null) {
                    return false;
                }
                if (this.data.length != cachingKey.data.length) {
                    return false;
                }
                for (n = 0; n < this.data.length; ++n) {
                    if (this.data[n] == cachingKey.data[n]) continue;
                    return false;
                }
            } else if (cachingKey.data != null) {
                return false;
            }
            if (this.off != cachingKey.off) {
                return false;
            }
            return this.useJCE == cachingKey.useJCE;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

