/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ltpa;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.InvalidTokenException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.TokenExpiredException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAPrivateKey;
import com.ibm.ws.security.ltpa.LTPAPublicKey;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.ltpa.LTPATokenizer;
import com.ibm.ws.security.ltpa.UserData;
import com.ibm.ws.security.util.StringUtil;
import com.ibm.wsspi.security.ltpa.Token;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;

public class AuthzPropToken
implements Token,
Serializable {
    private static final TraceComponent tc = Tr.register(AuthzPropToken.class, null, "com.ibm.ejs.resources.security");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yy.MM.dd kk:mm:ss:SSS z");
    private UserData userData;
    private long expiration;
    private static final char DELIM = '|';
    private int defaultExpirationMins = 10;
    private byte[] tokenData = null;
    private byte[] sharedKey = null;
    private LTPAPrivateKey privateKey = null;
    private LTPAPublicKey publicKey = null;
    private short version = 1;

    public AuthzPropToken(byte[] byArray, byte[] byArray2, LTPAPrivateKey lTPAPrivateKey, LTPAPublicKey lTPAPublicKey) throws InvalidTokenException, TokenExpiredException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthzPropToken from byte[]");
        }
        this.expiration = 0L;
        this.tokenData = byArray;
        this.decode();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogInfo().toString());
        }
        if (!this.isValid() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Expired AuthzPropToken constructed", new Exception());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthzPropToken from byte[]");
        }
    }

    public AuthzPropToken(String string, long l, byte[] byArray, LTPAPrivateKey lTPAPrivateKey, LTPAPublicKey lTPAPublicKey) throws TokenCreationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthzPropToken from accessID");
        }
        this.expiration = System.currentTimeMillis() + l * 60L * 1000L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expiration set to: " + new Date(this.expiration));
        }
        this.tokenData = null;
        this.userData = new UserData(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthzPropToken from accessID");
        }
    }

    protected AuthzPropToken(long l, byte[] byArray, LTPAPrivateKey lTPAPrivateKey, LTPAPublicKey lTPAPublicKey, UserData userData) throws TokenCreationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthzPropToken from userData");
        }
        long l2 = System.currentTimeMillis();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Refreshing expiration of token.");
        }
        Long l3 = (Long)SecurityConfig.getConfig().getValue("security.ltpa.expirydate");
        this.expiration = l2 + l3 * 60L * 1000L;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expiration set to: " + new Date(this.expiration));
        }
        this.tokenData = null;
        this.userData = userData;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AuthzPropToken from userData");
        }
    }

    protected void encode() {
        String string = this.userData.toString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.expiration).append('|').append(string);
        String string2 = stringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "tokenString before encode: " + string2);
        }
        this.tokenData = AuthzPropToken.toBytes(string2);
    }

    protected void decode() throws InvalidTokenException {
        block8: {
            String string = AuthzPropToken.toStrings(this.tokenData);
            int n = string.length();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Before parsing, length: " + n, ", string: " + string);
            }
            int n2 = -1;
            int n3 = 0;
            try {
                for (int i = 0; i < n - 1; ++i) {
                    char c = string.charAt(i);
                    if (i > 0 && string.charAt(i - 1) == '\\' || c != '|' || n2 != -1) continue;
                    n2 = i + 1;
                    break;
                }
                if (n2 != -1) {
                    String string2 = string.substring(n3, n2 - 1);
                    this.expiration = Long.parseLong(string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Expiration set to: " + new Date(this.expiration));
                    }
                    Map map = LTPATokenizer.parseUserData(string.substring(n2, n));
                    this.userData = new UserData(map);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "userData after decode: " + this.userData.toString());
                    }
                    break block8;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UserData delimiter not found.");
                }
                throw new InvalidTokenException("UserData delimiter not found.");
            }
            catch (Exception exception) {
                throw new InvalidTokenException(exception.getMessage(), exception);
            }
        }
    }

    public boolean isValid() throws InvalidTokenException, TokenExpiredException {
        Date date = new Date();
        Date date2 = new Date(this.expiration);
        boolean bl = date.before(date2);
        if (!bl) {
            StringBuffer stringBuffer = this.getLogInfo();
            stringBuffer.insert(0, "token expired ");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, stringBuffer.toString());
            }
            throw new TokenExpiredException("Token expiration Date: " + date2 + ", current Date: " + date);
        }
        return bl;
    }

    private static String toStrings(byte[] byArray) {
        String string = null;
        try {
            string = new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug(tc, "to UTF8 Strings =" + unsupportedEncodingException.toString());
        }
        return string;
    }

    private static byte[] toBytes(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Tr.debug(tc, "to UTF8 bytes =" + unsupportedEncodingException.toString());
        }
        return byArray;
    }

    public byte[] getBytes() throws InvalidTokenException, TokenExpiredException {
        if (this.tokenData != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returning existing encoded bytes from token object.");
            }
            return this.tokenData;
        }
        this.encode();
        if (!this.isValid() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Expired or invalid LTPA token constructed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogInfo().toString());
        }
        return this.tokenData;
    }

    public long getExpiration() {
        return this.expiration;
    }

    UserData getUserData() {
        return this.userData;
    }

    public String[] addAttribute(String string, String string2) {
        this.tokenData = null;
        return this.userData.addAttribute(string, string2);
    }

    public String[] getAttributes(String string) {
        return this.userData.getAttributes(string);
    }

    public Enumeration getAttributeNames() {
        return this.userData.getAttributeNames();
    }

    public String toString() {
        return StringUtil.toString(this.tokenData);
    }

    public short getVersion() {
        return this.version;
    }

    private StringBuffer getLogInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = this.getAttributes(string);
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(stringArray);
            stringBuffer.append(", ");
        }
        stringBuffer.append("Expiration time: ");
        stringBuffer.append(dateFormat.format(new Date(this.expiration)));
        return stringBuffer;
    }

    public Object clone() {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expiration passed into cloned token: " + this.expiration);
            }
            UserData userData = (UserData)this.userData.clone();
            if (LTPAServerObject.primaryTokenFactoryMap != null && LTPAServerObject.primaryTokenFactoryMap.size() > 0) {
                byte[] byArray = (byte[])LTPAServerObject.primaryTokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_shared_key");
                LTPAPublicKey lTPAPublicKey = (LTPAPublicKey)LTPAServerObject.primaryTokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_public_key");
                LTPAPrivateKey lTPAPrivateKey = (LTPAPrivateKey)LTPAServerObject.primaryTokenFactoryMap.get("com.ibm.wsspi.security.ltpa.ltpa_private_key");
                if (byArray != null && lTPAPrivateKey != null && lTPAPublicKey != null) {
                    this.sharedKey = byArray;
                    this.privateKey = lTPAPrivateKey;
                    this.publicKey = lTPAPublicKey;
                }
            }
            if (LTPAServerObject.sharedKey != null && LTPAServerObject.ltpaPrivKey != null && LTPAServerObject.ltpaPubKey != null) {
                this.sharedKey = LTPAServerObject.sharedKey;
                this.privateKey = LTPAServerObject.ltpaPrivKey;
                this.publicKey = LTPAServerObject.ltpaPubKey;
            }
            return new AuthzPropToken(this.expiration, this.sharedKey, this.privateKey, this.publicKey, userData);
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.security.ltpa.AuthzPropToken.clone", "321");
            return null;
        }
    }
}

