/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.ejb;

import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CollaboratorCookie;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;

public class SecurityBeanCookie
implements CollaboratorCookie {
    private static TraceComponent tc = Tr.register(SecurityBeanCookie.class, null, "com.ibm.ejs.resources.security");
    protected EJBJar ejbJar;
    protected EList roleRefList;
    protected String beanName;
    protected String appName;
    protected String moduleName;
    protected EList runAsSettings;

    public SecurityBeanCookie(String string, String string2, String string3) {
        this.beanName = string;
        this.appName = string2;
        this.moduleName = string3;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(" beanName=[").append(this.getBeanName()).append("], appName=[").append(this.getAppName()).append("], moduleName=[").append(this.getModuleName()).append("] ");
        return stringBuffer.toString();
    }

    public EJBJar getEjbJar() {
        return this.ejbJar;
    }

    public void setEjbJar(EJBJar eJBJar) {
        this.ejbJar = eJBJar;
    }

    public EList getRoleRefList() {
        return this.roleRefList;
    }

    public void setRoleRefList(String string, EJBJar eJBJar) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRoleRefList()  beanName= " + string);
        }
        if (eJBJar == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "setRoleRefList : EJB Jar is null");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setRoleRefList");
            }
            return;
        }
        EList eList = eJBJar.getEnterpriseBeans();
        if (eList != null) {
            EnterpriseBean[] enterpriseBeanArray = eList.toArray(new EnterpriseBean[0]);
            for (int i = 0; i < enterpriseBeanArray.length; ++i) {
                if (!enterpriseBeanArray[i].getName().equals(string)) continue;
                this.roleRefList = enterpriseBeanArray[i].getSecurityRoleRefs();
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, " role-ref to role-link list for " + enterpriseBeanArray[i].getName());
                SecurityRoleRef[] securityRoleRefArray = this.roleRefList.toArray(new SecurityRoleRef[0]);
                for (int j = 0; j < securityRoleRefArray.length; ++j) {
                    Tr.debug(tc, "role-ref = " + securityRoleRefArray[j].getName() + " role-link = " + securityRoleRefArray[j].getLink());
                }
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRoleRefList");
        }
    }

    public EList getRunAsSettings() {
        return this.runAsSettings;
    }

    public void setRunAsSettings(EnterpriseBeanExtension enterpriseBeanExtension) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRunAsSettings");
        }
        if (enterpriseBeanExtension != null) {
            this.runAsSettings = enterpriseBeanExtension.getRunAsSettings();
        }
        if (this.runAsSettings != null) {
            int n = this.runAsSettings.size();
            for (int i = 0; i < n; ++i) {
                SecurityIdentity securityIdentity = (SecurityIdentity)this.runAsSettings.get(i);
                EList eList = securityIdentity.getMethodElements();
                if (eList == null || eList.size() == 0) continue;
                MethodElement[] methodElementArray = eList.toArray(new MethodElement[0]);
                for (int j = 0; j < methodElementArray.length; ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "method name " + methodElementArray[j].getName());
                    }
                    if (methodElementArray[j].getEnterpriseBean() == null) continue;
                    String string = methodElementArray[j].getEnterpriseBean().getName();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "bean name " + string);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRunAsSettings");
        }
    }
}

