/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2;

import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

public class TrustedIDEvaluatorImpl
implements TrustedIDEvaluator {
    private VaultImpl vault = null;
    private ContextManager contextManager = null;
    private static final TraceComponent tc = Tr.register(TrustedIDEvaluatorImpl.class, "Security", "com.ibm.ejs.resources.security");

    public TrustedIDEvaluatorImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.vault = VaultImpl.getInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean isTrusted(String string, String string2) {
        String string3 = "TrustedIDEvaluatorImpl.isTrusted(user, pwd)";
        String string4 = null;
        TrustedIDEvaluatorImpl trustedIDEvaluatorImpl = this;
        SecurityConfiguration securityConfiguration = trustedIDEvaluatorImpl.vault.getSecurityConfiguration();
        String string5 = securityConfiguration.getCSIv2TrustedPrincipalList();
        String string6 = securityConfiguration.getCSIv2AlternateIdentityAssertionPerformTrustedId();
        String string7 = securityConfiguration.getCSIv2AlternateIdentityAssertionPerformTrustedPassword();
        String string8 = securityConfiguration.getloginUserid();
        String string9 = securityConfiguration.getloginPassword();
        if (string8 != null && !string8.equals("") && string != null && string.equalsIgnoreCase(string8) && string9 != null && !string9.equals("") && string2 != null && string2.equalsIgnoreCase(string9)) {
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "The server ID/password is from this cell, returning true.";
                SecurityLogger.debugMessage(string3, string4);
            }
            return true;
        }
        if (string6 != null && string.equalsIgnoreCase(string6) && string7 != null && string2 != null && string2.equalsIgnoreCase(string7)) {
            if (SecurityLogger.debugTraceEnabled) {
                string4 = "The alternate ID/password is from this cell, returning true.";
                SecurityLogger.debugMessage(string3, string4);
            }
            return true;
        }
        if (string8 != null && !string8.equals("") && (string9 == null || string9.equals(""))) {
            if (string != null && string.equalsIgnoreCase(string8)) {
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "The server ID is from this cell, returning true.";
                    SecurityLogger.debugMessage(string3, string4);
                }
                return true;
            }
            try {
                Subject subject = this.contextManager.getServerSubject();
                WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                if (wSCredential != null) {
                    String string10 = wSCredential.getAccessId();
                    String string11 = wSCredential.getUniqueSecurityName();
                    String string12 = wSCredential.getSecurityName();
                    if (string10 != null && string.equalsIgnoreCase(string10) || string11 != null && string.equalsIgnoreCase(string11) || string12 != null && string.equalsIgnoreCase(string12)) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string4 = "The server access ID, secuirty name, or unique server ID is from this cell, returning true.";
                            SecurityLogger.debugMessage(string3, string4);
                        }
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                if (SecurityLogger.debugTraceEnabled) {
                    string4 = "Exception getting access ID from server credential.";
                    SecurityLogger.debugMessage(string3, string4);
                }
                SecurityLogger.logException(string3, exception, 0, 0);
                return false;
            }
        }
        return this.isTrusted(string);
    }

    public boolean isTrusted(String string) {
        String string2 = "TrustedIDEvaluatorImpl.isTrusted(user)";
        String string3 = null;
        if (this.getContextManager().isInternalServerId(string)) {
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "The serverID " + string + " is an internal server identity.";
                SecurityLogger.debugMessage(string2, string3);
            }
            return true;
        }
        TrustedIDEvaluatorImpl trustedIDEvaluatorImpl = this;
        SecurityConfiguration securityConfiguration = trustedIDEvaluatorImpl.vault.getSecurityConfiguration();
        String string4 = securityConfiguration.getCSIv2TrustedPrincipalList();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "|");
        while (stringTokenizer.hasMoreTokens()) {
            if (!TrustedIDEvaluatorImpl.clean(stringTokenizer.nextToken()).equalsIgnoreCase(string)) continue;
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "The serverID " + string + " has been found in the trusted list.";
                SecurityLogger.debugMessage(string2, string3);
            }
            return true;
        }
        stringTokenizer = new StringTokenizer(string4, ",");
        while (stringTokenizer.hasMoreTokens()) {
            if (!TrustedIDEvaluatorImpl.clean(stringTokenizer.nextToken()).equalsIgnoreCase(string)) continue;
            if (SecurityLogger.debugTraceEnabled) {
                string3 = "The serverID " + string + " has been found in the trusted list.";
                SecurityLogger.debugMessage(string2, string3);
            }
            return true;
        }
        return false;
    }

    public boolean isTrusted(X509Certificate[] x509CertificateArray) {
        String string = "TrustedIDEvaluatorImpl.isTrusted(cert)";
        String string2 = null;
        boolean bl = false;
        if (x509CertificateArray != null && x509CertificateArray[0] != null) {
            String string3 = x509CertificateArray[0].getIssuerDN().getName();
            bl = this.isTrusted(string3);
        } else {
            string2 = "cert chain or the first cert is null";
            SecurityLogger.debugMessage(string, string2);
        }
        return bl;
    }

    private ContextManager getContextManager() {
        if (this.contextManager == null) {
            this.contextManager = ContextManagerFactory.getInstance();
        }
        return this.contextManager;
    }

    public static String clean(String string) {
        String string2 = null;
        if (string != null && ((string2 = string.trim()).startsWith("\"") && string2.endsWith("\"") || string2.startsWith("'") && string2.endsWith("'"))) {
            string2 = string2.substring(1, string2.length() - 1).trim();
        }
        return string2;
    }
}

