/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.application.AppDeploymentUtil;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.models.config.security.AuthorizationConfig;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.crypto.config.KeySetGroupManager;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.ORB;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.security.audit.AuditServiceImpl;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.core.AppContextManagerFactory;
import com.ibm.ws.security.core.AppContextManagerImpl;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.JaasWCCMHelper;
import com.ibm.ws.security.core.SASConfig;
import com.ibm.ws.security.core.SecurityAdmin;
import com.ibm.ws.security.core.SecurityCollaborator;
import com.ibm.ws.security.core.SecurityComponentImpl;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.core.SecurityConfigException;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.ws.security.core.SecurityDM;
import com.ibm.ws.security.core.SecurityManager;
import com.ibm.ws.security.core.WSAccessManager;
import com.ibm.ws.security.internals.ContextManagerInternals;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.security.policy.NullDynamicPolicy;
import com.ibm.ws.security.policy.WSDynamicPolicy;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedConfiguratorFactory;
import com.ibm.ws.security.server.SecurityServer;
import com.ibm.ws.security.server.SecurityServerFactory;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.security.service.SecurityServiceEvent;
import com.ibm.ws.security.service.SecurityServiceListener;
import com.ibm.ws.security.util.Constants;
import com.ibm.ws.security.util.JaccUtil;
import com.ibm.ws.security.util.SecurityMerge;
import com.ibm.ws.security.web.TrustAssociationManager;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.provider.AbstractJSSEProvider;
import com.ibm.wsspi.security.audit.AuditService;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import com.ibm.wsspi.security.authorization.InitializeJACCProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.security.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class distSecurityComponentImpl
extends ComponentImpl
implements SecurityService,
ConfigChangeListener {
    private static final TraceComponent tc = Tr.register(distSecurityComponentImpl.class, "Security", "com.ibm.ejs.resources.security");
    private static final String LOGIN_CONFIG_CLASS = "com.ibm.ws.security.auth.login.Configuration";
    private Repository repository = null;
    private EndPointMgr endPointMgr = null;
    private boolean globalSecurityEnabled = true;
    private boolean serverSecurityEnabled = true;
    private String processType = null;
    private SecurityServer secServer = null;
    private ArrayList listeners = new ArrayList(32);
    private static RoleBasedConfigurator configurator = null;
    private InitializeJACCProvider initializeJACCProvider = null;
    private static AuditService _auditService = null;
    private Properties secProps = null;
    private boolean expandedVariables = false;
    SecurityComponentImpl Proxy = null;
    private static final String START_EVENT = "start";
    private static final String STOP_EVENT = "stop";
    private ObjectName objName = null;

    distSecurityComponentImpl(SecurityComponentImpl securityComponentImpl) {
        this.Proxy = securityComponentImpl;
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", object);
        }
        Security security2 = null;
        try {
            security2 = this.initializeWCCMConfig();
            this.initializeAudit();
            this.initializeJava2Sec(security2);
            this.initializeJAAS(security2);
            this.initializeSecurityConfig(security2);
            this.initializeSSOTAI();
            Tr.info(tc, "security.init.startcomplete");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.distSecurityComponentImpl.initialize", "245", this);
            Tr.audit(tc, "security.init.svcstartfail");
            if (exception instanceof ConfigurationError) {
                throw (ConfigurationError)exception;
            }
            if (exception instanceof ConfigurationWarning) {
                throw (ConfigurationWarning)exception;
            }
            throw new ConfigurationError(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, START_EVENT);
            }
            try {
                if (this.globalSecurityEnabled) {
                    this.registerListenerWithAdminService();
                }
                if (this.processType.equals("NodeAgent")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Security server is being started");
                    }
                    this.initialize();
                    this.fireStartedEvent();
                    Tr.info(tc, "security.init.svcstartcomplete");
                    Tr.info(tc, "security.init.secstatus", new Object[]{new Boolean(this.globalSecurityEnabled)});
                }
                try {
                    EJBContainer eJBContainer = (EJBContainer)this.Proxy.GetService(EJBContainer.class);
                    if (eJBContainer == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "attempt to get EJBContainer failed");
                        }
                        break block12;
                    }
                    AppContextManagerImpl appContextManagerImpl = (AppContextManagerImpl)AppContextManagerFactory.getInstance();
                    appContextManagerImpl.initialize(eJBContainer);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.distSecurityComponentImpl.start", "310", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "attempt to initialize AppContextManager failed", exception);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityComponentImpl.start", "317", this);
                Tr.error(tc, "security.init.error", new Object[]{exception});
                Tr.audit(tc, "security.init.svcstartfail");
                throw new RuntimeError(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, START_EVENT);
        }
    }

    public void startSecurity() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startSecurity");
        }
        this.initialize();
        this.fireStartedEvent();
        Tr.info(tc, "security.init.svcstartcomplete");
        Tr.info(tc, "security.init.secstatus", new Object[]{new Boolean(this.globalSecurityEnabled)});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startSecurity");
        }
    }

    public void initialize() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        try {
            SecurityContext.setIsServerProcess();
            ConfigRoot configRoot = this.repository.getConfigRoot();
            if (this.globalSecurityEnabled) {
                try {
                    this.secServer = SecurityServerFactory.create();
                    this.initializeCache();
                    SecurityContext.enable(_auditService);
                    this.initializeServerSubject();
                    String string = (String)SecurityConfig.getConfig().getValue("security.unexpandedServerId");
                    if (string != null) {
                        this.getCellHostNames(configRoot);
                    }
                    SecurityContext.initialize();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityComponentImpl.initialize", "394", this);
                    Tr.error(tc, "security.init.secidautherror", new Object[]{exception});
                    throw exception;
                }
            }
            configurator = RoleBasedConfiguratorFactory.getConfigurator(this.globalSecurityEnabled);
            if (this.globalSecurityEnabled) {
                this.configureRoleBasedAuthz(configRoot, "admin-authz");
                this.configureRoleBasedAuthz(configRoot, "naming-authz");
                SecurityCollaborator.initialize();
            }
            this.initializeSecurityMBeans();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityComponentImpl.initialize", "418", this);
            if (this.globalSecurityEnabled) {
                Tr.error(tc, "security.init.error", new Object[]{exception});
                throw exception;
            }
            Tr.warning(tc, "security.init.error", (Object)new Object[]{exception});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListenerWithAdminService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerListenerWithAdminService");
        }
        Admin admin = null;
        try {
            admin = (Admin)this.Proxy.GetService(Admin.class);
            if (admin != null) {
                admin.addConfigChangeListener((ConfigChangeListener)this);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.ServerSecurityComponentImpl.registerListenerWithAdminService", "452", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attempt to register ConfigChangeListener failed", exception);
            }
        }
        finally {
            if (admin != null) {
                this.Proxy.ReleaseService(admin);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerListenerWithAdminService");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, STOP_EVENT);
        }
        if (this.initializeJACCProvider != null) {
            this.initializeJACCProvider.cleanup();
        }
        this.fireStoppedEvent();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, STOP_EVENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Security initializeWCCMConfig() throws Exception {
        Security security2;
        block39: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initializeSecurityWCCMConfig");
            }
            security2 = null;
            try {
                Object object;
                Resource resource;
                EtoolsCopyUtility etoolsCopyUtility;
                block41: {
                    this.Proxy.AddService(SecurityService.class);
                    this.repository = (Repository)this.Proxy.GetService(Repository.class);
                    ConfigRoot configRoot = this.repository.getConfigRoot();
                    SecurityDM securityDM = new SecurityDM();
                    securityDM.registerWithFFDCService();
                    Resource resource2 = null;
                    String string = "security.xml";
                    try {
                        resource2 = configRoot.getResource(0, string);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityComponentImpl.initialize", "508", this);
                        Tr.error(tc, "security.loadresource.error", new Object[]{string, exception});
                        throw exception;
                    }
                    Security security3 = (Security)resource2.getContents().get(0);
                    etoolsCopyUtility = new EtoolsCopyUtility();
                    security2 = (Security)etoolsCopyUtility.copy(security3);
                    if (security2 == null) {
                        Tr.error(tc, "security.init.nullsecobject");
                        throw new SecurityConfigException("Cannot get the Security object. security.xml might be corrupt or missing");
                    }
                    SecurityConfig.getConfig().setValue("cell.security.enabled", new Boolean(security2.isEnabled()));
                    SecurityConfig.getConfig().setValue("server.security.enabled", new Boolean(security2.isAppEnabled()));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isEnabled = " + security2.isEnabled() + " isAppEnabled = " + security2.isAppEnabled());
                    }
                    this.secProps = SecurityConfig.getProperties(security2.getProperties());
                    this.globalSecurityEnabled = security2.isEnabled();
                    this.serverSecurityEnabled = security2.isAppEnabled();
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    this.processType = adminService.getProcessType();
                    if (this.processType == null || this.processType.length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cannot determine process type");
                        }
                        Tr.error(tc, "security.init.nullprocesstype");
                        throw new SecurityConfigException("Cannot determine the process type.");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Process type: " + this.processType);
                    }
                    SecurityConfig.getConfig().setValue("com.ibm.ws.security.processType", this.processType);
                    WSAccessManager.adminapps = AppDeploymentUtil.listSystemApps(this.repository);
                    if (this.processType.equals("NodeAgent")) {
                        Object object2;
                        Object object3;
                        Resource resource3;
                        block38: {
                            resource3 = null;
                            try {
                                resource3 = configRoot.getResource(4, string);
                            }
                            catch (Exception exception) {
                                if (!tc.isDebugEnabled()) break block38;
                                Tr.debug(tc, "Security.xml for node agent process is missing. Will use cell's security.xml");
                            }
                        }
                        if (resource3 != null) {
                            SecurityConfig.getConfig().setValue("server.security.enabled", new Boolean(security2.isAppEnabled()));
                            object3 = (Security)resource3.getContents().get(0);
                            object2 = (Security)etoolsCopyUtility.copy((EObject)object3);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Non-managed process: Start merging the node agent's and cell's configuration");
                            }
                            if ((security2 = SecurityMerge.merge(security2, (Security)object2)) == null) {
                                Tr.error(tc, "security.init.nullsecobject");
                                throw new SecurityConfigException("Cannot get the Security object after security merge. security.xml might be corrupt or missing");
                            }
                            this.secProps = SecurityConfig.getProperties(security2.getProperties());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Non-managed process: End of merging the node agent's and cell's configuration");
                            }
                        }
                        object3 = this.secProps.getProperty("WAS_UseRemoteRegistry");
                        object2 = SecurityConfig.getProperties(security2.getActiveUserRegistry().getProperties());
                        String string2 = ((Properties)object2).getProperty("com.ibm.websphere.registry.UseDataSource");
                        if ("cell".equalsIgnoreCase((String)object3) || "true".equalsIgnoreCase(string2)) {
                            SecurityConfig.getConfig().setValue("WAS_UseRemoteRegistry", "cell");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Setting remote registry to: cell");
                            }
                        }
                        break block39;
                    }
                    if (this.processType.equals("DeploymentManager")) {
                        Resource resource4;
                        block40: {
                            resource4 = null;
                            try {
                                resource4 = configRoot.getResource(4, string);
                            }
                            catch (Exception exception) {
                                if (!tc.isDebugEnabled()) break block40;
                                Tr.debug(tc, "Security.xml for deployment manager is missing. Will use cell's security.xml");
                            }
                        }
                        if (resource4 != null) {
                            SecurityConfig.getConfig().setValue("server.security.enabled", new Boolean(security2.isAppEnabled()));
                            Security security4 = (Security)resource4.getContents().get(0);
                            Security security5 = (Security)etoolsCopyUtility.copy(security4);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Non-managed process: Start merging the deployment manager's and cell's configuration");
                            }
                            if ((security2 = SecurityMerge.merge(security2, security5)) == null) {
                                Tr.error(tc, "security.init.nullsecobject");
                                throw new SecurityConfigException("Cannot get the Security object after security merge. security.xml might be corrupt or missing");
                            }
                            this.secProps = SecurityConfig.getProperties(security2.getProperties());
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Non-managed process: End of merging the deployment manager's and cell's configuration");
                            }
                        }
                        break block39;
                    }
                    if (!this.processType.equals("ManagedProcess")) break block39;
                    resource = null;
                    try {
                        resource = configRoot.getResource(4, string);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block41;
                        Tr.debug(tc, "Security.xml for server is missing. Will use cell's security.xml");
                    }
                }
                if (resource != null) {
                    SecurityConfig.getConfig().setValue("server.security.enabled", new Boolean(security2.isAppEnabled()));
                    object = (Security)resource.getContents().get(0);
                    Security security6 = (Security)etoolsCopyUtility.copy((EObject)object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Managed process: Start merging the server's and cell's configuration");
                    }
                    if ((security2 = SecurityMerge.merge(security2, security6)) == null) {
                        Tr.error(tc, "security.init.nullsecobject");
                        throw new SecurityConfigException("Cannot get the Security object after security merge. security.xml might be corrupt or missing");
                    }
                    this.secProps = SecurityConfig.getProperties(security2.getProperties());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Managed process: End of merging the server's and cell's configuration");
                    }
                }
                if ((object = this.secProps.getProperty("WAS_UseRemoteRegistry")) != null && (((String)object).equalsIgnoreCase("node") || ((String)object).equalsIgnoreCase("cell"))) {
                    SecurityConfig.getConfig().setValue("WAS_UseRemoteRegistry", object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting remote registry to: " + (String)object);
                    }
                }
            }
            finally {
                if (this.repository != null) {
                    this.Proxy.ReleaseService(this.repository);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security config: " + SecurityConfig.getConfig());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSecurityWCCMConfig");
        }
        return security2;
    }

    private void initializeAudit() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeAudit");
        }
        try {
            AuditServiceImpl.initAuditService(this.secProps);
            _auditService = AuditServiceImpl.getAuditService();
        }
        catch (Exception exception) {
            Tr.error(tc, "security.init.error", new Object[]{exception});
            throw new ConfigurationError("Failed to initialize AuditService", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeAudit");
        }
    }

    private void initializeSSOTAI() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSSOTAI");
        }
        if (this.globalSecurityEnabled) {
            Object object;
            TrustAssociationManager.create();
            SecurityConfig securityConfig = SecurityConfig.getConfig();
            String string = (String)securityConfig.getValue("security.activeAuthMechanism");
            if (!(!string.equalsIgnoreCase("LTPA") && !string.equalsIgnoreCase("ICSF") || (object = (Boolean)securityConfig.getValue("security.ltpa.sso.enabled")) != null && ((Boolean)object).booleanValue())) {
                Tr.warning(tc, "security.init.ltpawithoutsso");
            }
            if (((String)(object = (String)securityConfig.getValue("security.enablePluggableAuthentication"))).equalsIgnoreCase("true") || ((String)object).equalsIgnoreCase("yes")) {
                String string2 = "Failed to initialize WSCallbackHandlerFactory";
                try {
                    TrustAssociationManager.create();
                    String string3 = (String)securityConfig.getValue("security.callbackHandlerFactoryClass");
                    Class<?> clazz = Class.forName(string3);
                    Method method2 = clazz.getMethod("getInstance", String.class);
                    WSCallbackHandlerFactory wSCallbackHandlerFactory = (WSCallbackHandlerFactory)method2.invoke(null, string3);
                }
                catch (Exception exception) {
                    Tr.error(tc, "security.init.error", new Object[]{exception});
                    throw new ConfigurationError(string2, exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSSOTAI");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeSecurityConfig(Security security2) throws Exception {
        String string;
        CharSequence charSequence;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dist initializeSecurityConfig");
        }
        Properties properties = new Properties();
        ORB oRB = (ORB)this.Proxy.GetService(ORB.class);
        try {
            if (oRB != null) {
                properties = oRB.getOrbProps();
            }
        }
        finally {
            if (oRB != null) {
                this.Proxy.ReleaseService(oRB);
            }
        }
        this.insertVariables(properties);
        SecurityConfig.getConfig().setValues(security2, this.secProps);
        Server server = (Server)this.Proxy.GetService(Server.class);
        try {
            string2 = server.getCellName() + ":" + server.getNodeName() + ":" + server.getName();
            SecurityConfig.getConfig().setValue("process.serverName", string2);
            if (!SecurityConfig.isUseRegistryServerId()) {
                charSequence = new StringBuffer("server");
                charSequence.append(":").append(server.getCellName()).append("_").append(server.getNodeName()).append("_").append(server.getName());
                string = charSequence.toString();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting internalServerID to = " + string);
                }
                SecurityConfig.getConfig().setValue("com.ibm.ws.security.internalServerId", string);
            }
            SecurityConfig.getConfig().setValue("shortservername", server.getName());
            SecurityConfig.getConfig().setValue("server.short.name", server.getShortName());
            SecurityConfig.getConfig().setValue("nodename", server.getNodeName());
            SecurityConfig.getConfig().setValue("node.short.name", server.getShortNodeName());
            SecurityConfig.getConfig().setValue("cellname", server.getCellName());
            SecurityConfig.getConfig().setValue("cell.short.name", server.getShortCellName());
        }
        finally {
            if (server != null) {
                this.Proxy.ReleaseService(server);
            }
        }
        if (this.globalSecurityEnabled && properties != null) {
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            String string10;
            String string11;
            string2 = (String)this.secProps.get("com.ibm.CORBA.keyFileName");
            if (string2 != null) {
                properties.put("com.ibm.CORBA.keyFileName", string2);
            }
            if ((charSequence = (String)this.secProps.get("com.ibm.ssl.keyStoreClientAlias")) != null) {
                properties.put("com.ibm.ssl.keyStoreClientAlias", charSequence);
            }
            if ((string = (String)this.secProps.get("com.ibm.ssl.keyStoreServerAlias")) != null) {
                properties.put("com.ibm.ssl.keyStoreServerAlias", string);
            }
            if ((string11 = (String)this.secProps.get("com.ibm.ssl.sas.outbound.keyStoreClientAlias")) != null) {
                properties.put("com.ibm.ssl.sas.outbound.keyStoreClientAlias", string11);
            }
            if ((string10 = (String)this.secProps.get("com.ibm.ssl.sas.outbound.keyStoreServerAlias")) != null) {
                properties.put("com.ibm.ssl.sas.outbound.keyStoreServerAlias", string10);
            }
            if ((string9 = (String)this.secProps.get("com.ibm.ssl.sas.inbound.keyStoreClientAlias")) != null) {
                properties.put("com.ibm.ssl.sas.inbound.keyStoreClientAlias", string9);
            }
            if ((string8 = (String)this.secProps.get("com.ibm.ssl.sas.inbound.keyStoreServerAlias")) != null) {
                properties.put("com.ibm.ssl.sas.inbound.keyStoreServerAlias", string8);
            }
            if ((string7 = (String)this.secProps.get("com.ibm.ssl.csi.outbound.keyStoreClientAlias")) != null) {
                properties.put("com.ibm.ssl.csi.outbound.keyStoreClientAlias", string7);
            }
            if ((string6 = (String)this.secProps.get("com.ibm.ssl.csi.outbound.keyStoreServerAlias")) != null) {
                properties.put("com.ibm.ssl.csi.outbound.keyStoreServerAlias", string6);
            }
            if ((string5 = (String)this.secProps.get("com.ibm.ssl.csi.inbound.keyStoreClientAlias")) != null) {
                properties.put("com.ibm.ssl.csi.inbound.keyStoreClientAlias", string5);
            }
            if ((string4 = (String)this.secProps.get("com.ibm.ssl.csi.inbound.keyStoreServerAlias")) != null) {
                properties.put("com.ibm.ssl.csi.inbound.keyStoreServerAlias", string4);
            }
            if ((string3 = (String)this.secProps.get("com.ibm.ssl.tokenSlot")) != null) {
                properties.put("com.ibm.ssl.tokenSlot", string3);
            }
            String string12 = (String)this.secProps.get("com.ibm.security.useFIPS");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "use_fips_flag = " + string12);
            }
            if (string12 != null) {
                properties.put("com.ibm.security.useFIPS", string12);
            } else {
                properties.put("com.ibm.security.useFIPS", "false");
            }
            String string13 = (String)this.secProps.get("security.enablePluggableAuthentication");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "enable_pluggable_auth_falg = " + string13);
            }
            if (string13 != null) {
                properties.put("security.enablePluggableAuthentication", string13);
            } else {
                properties.put("security.enablePluggableAuthentication", "false");
            }
            String string14 = (String)this.secProps.get("com.ibm.websphere.security.suppressExceptionStack");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "suppress_exception_stack = " + string14);
            }
            if (string14 != null) {
                properties.put("com.ibm.websphere.security.suppressExceptionStack", string14);
            } else {
                properties.put("com.ibm.websphere.security.suppressExceptionStack", "false");
            }
        }
        this.endPointMgr = (EndPointMgr)this.Proxy.GetService(EndPointMgr.class);
        try {
            string2 = null;
            SASConfig.updateORBConfig(security2, properties, this.endPointMgr, (com.ibm.websphere.models.config.process.Server)((Object)string2));
        }
        finally {
            if (this.endPointMgr != null) {
                this.Proxy.ReleaseService(this.endPointMgr);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dist initializeSecurityConfig");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initializeJAAS(Security var1_1) throws Exception {
        if (distSecurityComponentImpl.tc.isEntryEnabled()) {
            Tr.entry(distSecurityComponentImpl.tc, "initializeJAAS");
        }
        try {
            Configuration.setConfiguration((Configuration)new com.ibm.ws.security.auth.login.Configuration());
        }
        catch (Exception var2_2) {
            FFDCFilter.processException((Throwable)var2_2, "com.ibm.ws.security.core.SecurityComponentImpl.initialize", "951", this);
            Tr.error(distSecurityComponentImpl.tc, "security.init.wccmjaas.setcfgerror", new Object[]{"com.ibm.ws.security.auth.login.Configuration", var2_2});
            throw new ConfigurationError("Unable to set com.ibm.ws.security.auth.login.Configuration as the JAAS Login Configuration class.", var2_2);
        }
        var2_3 = com.ibm.ws.security.auth.login.Configuration.getConfiguration();
        var3_4 = var2_3.getClass().getName();
        if (distSecurityComponentImpl.tc.isDebugEnabled()) {
            Tr.debug(distSecurityComponentImpl.tc, "The Login Configuration class is: " + var3_4);
        }
        if (var2_3 instanceof com.ibm.ws.security.auth.login.Configuration) {
            try {
                var4_5 = (com.ibm.ws.security.auth.login.Configuration)var2_3;
                var5_7 = var1_1.getSystemLoginConfig();
                var6_8 = JaasWCCMHelper.convertToConfiguration(var5_7, true);
                var5_7 = var1_1.getApplicationLoginConfig();
                var7_9 = JaasWCCMHelper.convertToConfiguration(var5_7, false);
                var6_8.putAll(var7_9);
                var4_5.updateWCCMConfig(var6_8);
                Tr.info(distSecurityComponentImpl.tc, "security.init.wccmjaas.init");
                if (!distSecurityComponentImpl.tc.isDebugEnabled()) ** GOTO lbl36
                var8_10 = var4_5.toString();
                Tr.debug(distSecurityComponentImpl.tc, "The dynamic JAAS login configuration is:\n\t" + var8_10);
            }
            catch (Exception var4_6) {
                FFDCFilter.processException((Throwable)var4_6, "com.ibm.ws.security.core.SecurityComponentImpl.initialize", "986", this);
                Tr.error(distSecurityComponentImpl.tc, "security.init.wccmjaas.error", new Object[]{var4_6});
                throw var4_6;
            }
        } else {
            if (this.globalSecurityEnabled) {
                Tr.error(distSecurityComponentImpl.tc, "security.init.wccmjaas.wrongclasserror", new Object[]{var3_4, "com.ibm.ws.security.auth.login.Configuration"});
                throw new RuntimeException("JAAS Login provider class com.ibm.ws.security.auth.login.Configuration is not configured as login provider class");
            }
            Tr.warning(distSecurityComponentImpl.tc, "security.init.wccmjaas.wrongclasswarning", (Object)new Object[]{var3_4, "com.ibm.ws.security.auth.login.Configuration"});
        }
lbl36:
        // 3 sources

        if (distSecurityComponentImpl.tc.isEntryEnabled()) {
            Tr.entry(distSecurityComponentImpl.tc, "initializeJAAS");
        }
    }

    private void initializeJaccProxy(DynamicPolicy dynamicPolicy, Security security2) throws Exception {
        DynamicPolicyFactory.setInstance(dynamicPolicy);
        String string = System.getProperty("javax.security.jacc.policy.provider");
        boolean bl = false;
        AuthorizationConfig authorizationConfig = null;
        if (security2 != null) {
            try {
                authorizationConfig = security2.getAuthConfig();
                if (authorizationConfig != null) {
                    bl = authorizationConfig.isUseJACCProvider();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProxy", "1035", this);
                Tr.error(tc, "security.jacc.config.error", new Object[]{exception});
                throw new ConfigurationError("Failed to get useJACCProvider information", exception);
            }
        }
        if (string == null && !bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using default authorization");
            }
            return;
        }
        this.expandVariables();
        if (authorizationConfig != null) {
            SecurityConfig.setAuthorizationValues(authorizationConfig);
        }
        if (string == null && authorizationConfig != null && (string = SecurityConfig.getPolicyClassName()) != null) {
            System.setProperty("javax.security.jacc.policy.provider", string);
        }
        if (string == null) {
            throw new ConfigurationError("The JACC provider's policy class name is null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The JACC provider's policy implementation class name is: " + string);
        }
        SecurityConfig.setJACCEnabled();
        if (SecurityConfig.supportsDynamicModuleUpdates()) {
            JaccUtil.setAppDynamicUpdates();
        }
        if (string.equals("com.ibm.ws.security.policy.JaccPolicyProxy")) {
            SecurityConfig.setDefaultJaccProvider();
        }
        String string2 = SecurityConfig.getInitializeJACCProviderClassName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "jaccInit Class Name: ", string2);
        }
        if (string2 != null && string2.length() != 0) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                this.initializeJACCProvider = (InitializeJACCProvider)Class.forName(string2, true, classLoader).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Tr.error(tc, "security.jacc.initialize.error", new Object[]{string2, classNotFoundException});
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", "1100", this);
                throw new ConfigurationError(classNotFoundException.getMessage(), classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Tr.error(tc, "security.jacc.initialize.error", new Object[]{string2, illegalAccessException});
                FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", "1107", this);
                throw new ConfigurationError(illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                Tr.error(tc, "security.jacc.initialize.error", new Object[]{string2, instantiationException});
                FFDCFilter.processException((Throwable)instantiationException, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", "1114", this);
                throw new ConfigurationError(instantiationException.getMessage(), instantiationException);
            }
            int n = -1;
            try {
                n = this.initializeJACCProvider.initialize(SecurityConfig.getJACCProviderCustomProperties());
            }
            catch (Exception exception) {
                Tr.error(tc, "security.jacc.initialize.error", new Object[]{string2, exception});
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", "1126", this);
                throw new ConfigurationError(exception.getMessage(), exception);
            }
            if (n != 0) {
                String string3 = "The initialize method of " + string2 + " did not return success code 0.  The error code returned was: " + n;
                String string4 = Constants.nls.getFormattedMessage("security.jacc.initialize.error", new Object[]{string2, new Integer(n)}, string3);
                throw new ConfigurationError(string4);
            }
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Policy.setPolicy((Policy)Class.forName(string, true, classLoader).newInstance());
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (Throwable throwable) {
            Tr.error(tc, "security.jacc.init.error", new Object[]{string, throwable});
            FFDCFilter.processException(throwable, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJaccProvider", "1150", this);
            throw new ConfigurationError(throwable.getMessage(), throwable);
        }
        Tr.audit(tc, "security.jacc.initialized", new Object[]{string, SecurityConfig.getPolicyConfigurationFactoryClassName(), SecurityConfig.getRoleConfigurationFactoryClassName(), string2});
        SecurityConfig.setNullProtectionDomain();
        SecurityConfig.setNullCodeSource();
    }

    private void initializeJava2Sec(Security security2) throws SecurityConfigException, ConfigurationError {
        if (security2 != null) {
            Boolean bl = null;
            try {
                bl = new Boolean(security2.isEnforceJava2Security());
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJava2Sec", "1181", this);
                Tr.error(tc, "security.j2sec.init.error", new Object[]{exception});
                throw new ConfigurationError("Failed to get EnforceJava2Security.", exception);
            }
            try {
                boolean bl2 = bl;
                if (!bl2) {
                    NullDynamicPolicy nullDynamicPolicy = new NullDynamicPolicy(Policy.getPolicy());
                    Policy.setPolicy(nullDynamicPolicy);
                    this.initializeJaccProxy(nullDynamicPolicy, security2);
                    String string = System.getProperty("java.security.manager");
                    if (string != null && string.length() > 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Custom SecurityManager is loaded :" + string);
                        }
                    } else {
                        System.setSecurityManager(null);
                    }
                    Tr.info(tc, "security.manager.disabled");
                } else {
                    WSDynamicPolicy wSDynamicPolicy = new WSDynamicPolicy(Policy.getPolicy(), this.repository);
                    Policy.setPolicy(wSDynamicPolicy);
                    this.initializeJaccProxy(wSDynamicPolicy, security2);
                    String string = (String)this.secProps.get("java.security.debug");
                    Server server = (Server)this.Proxy.GetService(Server.class);
                    ExtClassLoader extClassLoader = (ExtClassLoader)server.getRuntimeClassLoader();
                    this.Proxy.ReleaseService(server);
                    boolean bl3 = new Boolean(security2.isEnableJava2SecRuntimeFiltering());
                    SecurityManager securityManager = new SecurityManager(string, extClassLoader, wSDynamicPolicy.getRuntimeFilteredPermission(), bl3);
                    System.setSecurityManager(securityManager);
                    Tr.info(tc, "security.jsecman.installed");
                    Boolean bl4 = Boolean.TRUE;
                    bl4 = new Boolean(security2.isIssuePermissionWarning());
                    wSDynamicPolicy.initApplicationTemplate(bl4);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityComponentImpl.initializeJava2Sec", "1237", this);
                Tr.error(tc, "security.j2sec.init.error", new Object[]{exception});
                throw new ConfigurationError("Error during Java 2 Security and Dynamic Policy initialization", exception);
            }
        }
    }

    void configureRoleBasedAuthz(ConfigRoot configRoot, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configureRoleBasedAuthz", new Object[]{configRoot, string});
        }
        String string2 = string + ".xml";
        try {
            Resource resource = configRoot.getResource(0, string2);
            this.getConfigurator().loadApplication(string, resource);
        }
        catch (Exception exception) {
            Tr.error(tc, "security.loadresource.error", new Object[]{string2, exception});
            throw exception;
        }
        if (string.equals("admin-authz")) {
            try {
                this.getConfigurator().loadSecurityPolicy(string, "/com/ibm/ws/security/server/xml/SecurityServer.xml", "domain");
            }
            catch (Exception exception) {
                Tr.error(tc, "security.load.secConfig", new Object[]{exception});
                throw exception;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configureRoleBasedAuthz");
        }
    }

    void initializeSecurityMBeans() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSecurityMBeans");
        }
        try {
            SecurityAdmin securityAdmin = new SecurityAdmin();
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            DefaultRuntimeCollaborator defaultRuntimeCollaborator = new DefaultRuntimeCollaborator(securityAdmin, "SecurityAdmin");
            mBeanFactory.activateMBean("SecurityAdmin", defaultRuntimeCollaborator, mBeanFactory.getConfigId("SecurityAdmin"), "com/ibm/ws/management/descriptor/xml/SecurityAdmin.xml");
        }
        catch (Exception exception) {
            Tr.error(tc, "security.init.mbeanerror", new Object[]{"SecurityAdmin", exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSecurityMBeans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SecurityServiceListener securityServiceListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addListener", securityServiceListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(securityServiceListener)) {
                this.listeners.add(securityServiceListener);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SecurityServiceListener securityServiceListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeListener", securityServiceListener);
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(securityServiceListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configChanged", configRepositoryEvent);
        }
        try {
            Object object;
            int n;
            TreeSet treeSet = (TreeSet)SecurityConfig.getConfig().getValue("security.serverNameList");
            String string = (String)SecurityConfig.getConfig().getValue("security.unexpandedServerId");
            String string2 = "cells/" + (String)SecurityConfig.getConfig().getValue("cellname") + "/security.xml";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security.xml: " + string2);
            }
            ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
            if (treeSet != null && string != null) {
                for (n = 0; n < configChangeNotifierArray.length; ++n) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Document changed: " + configChangeNotifierArray[n].getUri());
                    }
                    if (configChangeNotifierArray[n].getChangeType() != 0 && configChangeNotifierArray[n].getChangeType() != 1 || !configChangeNotifierArray[n].getUri().endsWith("serverindex.xml")) continue;
                    object = configChangeNotifierArray[n].getUri();
                    int n2 = ((String)object).lastIndexOf(47);
                    int n3 = -1;
                    if (n2 > 0) {
                        n3 = ((String)object).lastIndexOf(47, n2 - 1);
                    }
                    if (n2 <= 0 || n3 <= 0) continue;
                    String string3 = ((String)object).substring(n3 + 1, n2);
                    if (tc.isDebugEnabled()) {
                        if (configChangeNotifierArray[n].getChangeType() == 0) {
                            Tr.debug(tc, "Node added: " + string3);
                        } else {
                            Tr.debug(tc, "Node removed: " + string3);
                        }
                    }
                    if (this.repository == null) {
                        this.repository = (Repository)this.Proxy.GetService(class$com$ibm$ws$runtime$service$Repository == null ? distSecurityComponentImpl.class$("com.ibm.ws.runtime.service.Repository") : class$com$ibm$ws$runtime$service$Repository);
                    }
                    ConfigRoot configRoot = this.repository.getConfigRoot();
                    String[] stringArray = configRoot.list(3, null);
                    String string4 = configRoot.getValue(3);
                    for (int i = 0; i < stringArray.length; ++i) {
                        boolean bl;
                        configRoot.setValue(3, stringArray[i]);
                        if (!stringArray[i].equals(string3)) continue;
                        Resource resource = configRoot.getResource(3, "serverindex.xml");
                        EList eList = resource.getContents();
                        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
                        String string5 = serverIndex.getHostName().toLowerCase();
                        String string6 = SecurityConfig.expandHost(string, string5);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Expanded serverID: " + string6);
                        }
                        if (string6 == null) continue;
                        if (configChangeNotifierArray[n].getChangeType() == 0) {
                            bl = treeSet.add(string6);
                            if (!tc.isDebugEnabled()) continue;
                            if (bl) {
                                Tr.debug(tc, "Server ID " + string6 + " was added to the multi-serverID list.");
                                continue;
                            }
                            Tr.debug(tc, "Server ID " + string6 + " was already in the multi-serverID list.");
                            continue;
                        }
                        if (configChangeNotifierArray[n].getChangeType() != 1) continue;
                        bl = treeSet.remove(string6);
                        if (!tc.isDebugEnabled()) continue;
                        if (bl) {
                            Tr.debug(tc, "Server ID " + string6 + " was removed to the multi-serverID list.");
                            continue;
                        }
                        Tr.debug(tc, "Server ID " + string6 + " was not present in the multi-serverID list.");
                    }
                    configRoot.setValue(3, string4);
                }
            }
            for (n = 0; n < configChangeNotifierArray.length; ++n) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Document changed: " + configChangeNotifierArray[n].getUri());
                }
                if (!configChangeNotifierArray[n].getUri().equalsIgnoreCase(string2)) continue;
                try {
                    object = this.loadSecurityCellXMLFromConfig();
                    if (!object.isDynamicallyUpdateSSLConfig()) continue;
                    if (ManagementScopeManager.getInstance().getProcessType().equals("DeploymentManager")) {
                        this.temporarilyDisableCertificateAuthenticationAcrossCell(90000L);
                    }
                    SSLConfigManager.getInstance().initializeServerSSL((Security)object, true);
                    KeySetGroupManager.getInstance().initializeKeySetGroups((Security)object, true);
                    AbstractJSSEProvider.clearSSLContextCache();
                    LTPAServerObject lTPAServerObject = LTPAServerObject.getLTPAServer();
                    lTPAServerObject.refreshTokenFactories();
                    AuthCache.getInstance().removeAllEntries();
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.distSecurityComponentImpl.configChanged", "1497", this);
                    Tr.debug(tc, "Exception re-loading the SSL config.", new Object[]{exception.getMessage()});
                    throw exception;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityComponentImpl.configChanged", "1506", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught: " + exception.getMessage());
            }
        }
        finally {
            if (this.repository != null) {
                this.Proxy.ReleaseService(this.repository);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configChanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Security loadSecurityCellXMLFromConfig() throws ConfigurationWarning, ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSecurityXMLFromConfig");
        }
        Repository repository2 = null;
        Security security2 = null;
        try {
            repository2 = (Repository)this.getService(Repository.class);
            ConfigRoot configRoot = repository2.getConfigRoot();
            Resource resource = null;
            String string = "security.xml";
            try {
                resource = configRoot.getResource(0, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLComponentImpl.initialize", "1539", this);
                Tr.debug(tc, "Exception loading the Cell security.xml.", new Object[]{string, exception});
                throw new ConfigurationError(exception);
            }
            Security security3 = (Security)resource.getContents().get(0);
            EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
            security2 = (Security)etoolsCopyUtility.copy(security3);
            if (security2 == null) {
                Tr.error(tc, "ssl.init.nullsecobject.CWPKI0009E");
                throw new ConfigurationError("Cannot get WCCM Security object.  security.xml might be corrupt or missing.");
            }
        }
        finally {
            if (repository2 != null) {
                this.releaseService(repository2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSecurityXMLFromConfig");
        }
        return security2;
    }

    public void temporarilyDisableCertificateAuthenticationAcrossCell(long l) throws Exception {
        this.objName = this.getMBean();
        ObjectName objectName = new ObjectName("WebSphere:type=SSLAdmin,*");
        Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName, null).iterator();
        while (iterator.hasNext()) {
            try {
                objectName = (ObjectName)iterator.next();
                if (this.objName.equals(objectName)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " SSLAdmin object name = " + objectName);
                }
                AdminServiceFactory.getAdminService().invoke(objectName, "temporarilyDisableCertificateAuthentication", new Object[]{new Long(l)}, new String[]{"java.lang.Long"});
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLConfigChangeListener.temporaryDisableCertificateAuthentication", "129", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception on MBean call.", new Object[]{exception});
                }
                throw exception;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, " SSLAdmin object name (self) = " + this.objName);
        }
        AdminServiceFactory.getAdminService().invoke(this.objName, "temporarilyDisableCertificateAuthentication", new Object[]{new Long(l)}, new String[]{"java.lang.Long"});
    }

    private ObjectName getMBean() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBean");
        }
        if (this.objName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting MBean");
            }
            try {
                String string = AdminServiceFactory.getAdminService().getProcessName();
                this.objName = new ObjectName("WebSphere:type=SSLAdmin,process=" + string + ",*");
                Iterator iterator = AdminServiceFactory.getAdminService().queryNames(this.objName, null).iterator();
                if (!iterator.hasNext()) {
                    Tr.error(tc, "security.ctr.nombean.error");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getMBean");
                    }
                    throw new Exception("No SSLAdmin MBean found: returning null");
                }
                this.objName = (ObjectName)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " SSLAdmin object name = " + this.objName);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getMBean");
                }
                return this.objName;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.ssl.core.SSLConfigChangeListener.getMBean", "162", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception on MBean call.", new Object[]{exception});
                }
                throw exception;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning MBean");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBean");
        }
        return this.objName;
    }

    private void getCellHostNames(ConfigRoot configRoot) throws Exception {
        TreeSet<String> treeSet;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCellHostNames");
            }
            treeSet = new TreeSet<String>();
            try {
                Object object;
                Object object2;
                int n;
                String string;
                String[] stringArray;
                WSCredential wSCredential = ContextManagerFactory.getInstance().getServerCredential();
                if (wSCredential != null) {
                    stringArray = wSCredential.getAccessId().toLowerCase();
                    string = (String)SecurityConfig.getConfig().getValue("process.hostName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server accessID: " + (String)stringArray + ", hostname: " + string);
                    }
                    if (string != null) {
                        n = string.length();
                        int n2 = stringArray.indexOf(string);
                        if (n2 != -1) {
                            object2 = new StringBuffer((String)stringArray);
                            ((StringBuffer)object2).replace(n2, n2 + n, "${HOST}");
                            object = ((StringBuffer)object2).toString();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Unexpanded accessID is: " + (String)object);
                            }
                            SecurityConfig.getConfig().setValue("security.unexpandedServerId", object);
                        }
                    }
                }
                stringArray = configRoot.list(3, null);
                string = configRoot.getValue(3);
                for (n = 0; n < stringArray.length; ++n) {
                    boolean bl;
                    String string2;
                    configRoot.setValue(3, stringArray[n]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node name: " + stringArray[n]);
                    }
                    Resource resource = configRoot.getResource(3, "serverindex.xml");
                    object2 = resource.getContents();
                    object = (ServerIndex)resource.getContents().get(0);
                    String string3 = object.getHostName().toLowerCase();
                    String string4 = (String)SecurityConfig.getConfig().getValue("security.unexpandedServerId");
                    if (string4 == null || (string2 = SecurityConfig.expandHost(string4, string3)) == null || !(bl = treeSet.add(string2))) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server ID " + string2 + " was added to the multi-serverID list.");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Server ID " + string2 + " was already in the multi-serverID list.");
                }
                configRoot.setValue(3, string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.distSecurityComponentImpl.getCellHostNames", "1700", this);
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Exception occurred getting Cell hostnames.", new Object[]{exception});
            }
        }
        SecurityConfig.getConfig().setValue("security.serverNameList", treeSet);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCellHostNames");
        }
    }

    private void fireStartedEvent() {
        this.fireEvent(START_EVENT);
    }

    private void fireStoppedEvent() {
        this.fireEvent(STOP_EVENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fireEvent,  event is :" + string);
        }
        List list = null;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            list = (List)this.listeners.clone();
        }
        if (list != null) {
            int n = list.size();
            SecurityServiceEvent securityServiceEvent = string.equals(START_EVENT) ? new SecurityServiceEvent(1) : new SecurityServiceEvent(2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "list size = " + n, "event = " + string);
            }
            for (int i = 0; i < n; ++i) {
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("Invoking stateChanged(), Listener.hashCode() = ");
                    stringBuffer.append(list.get(i).hashCode());
                    stringBuffer.append("Listener.toString()");
                    stringBuffer.append(list.get(i).toString());
                    Tr.debug(tc, stringBuffer.toString());
                }
                try {
                    ((SecurityServiceListener)list.get(i)).stateChanged(securityServiceEvent);
                    continue;
                }
                catch (Exception exception) {
                    Tr.error(tc, "security.init.error", new Object[]{exception});
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityComponentImpl.fireEvent", "1765", this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fireEvent, : event is " + string);
        }
    }

    public RoleBasedConfigurator getConfigurator() throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigurator");
        }
        if (configurator == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RoleBasedConfigurator not initialized");
            }
            throw new RoleBasedAppException("RoleBasedConfigurator not initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigurator");
        }
        return configurator;
    }

    public Properties getSecureSocketLayer(String string) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecureSocketLayer", string);
        }
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Alias is null or empty string.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecureSocketLayer");
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("com.ibm.ssl.direction", "inbound");
            return JSSEHelper.getInstance().getProperties(string, hashMap, null);
        }
        catch (SSLException sSLException) {
            FFDCFilter.processException((Throwable)sSLException, "com.ibm.ws.security.core.distSecurityComponentImpl.getSecureSocketLayer", "1806", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting SSL properties.", new Object[]{sSLException});
            }
            return null;
        }
    }

    public boolean isSecurityEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSecurityEnabled");
        }
        try {
            return this.globalSecurityEnabled;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.core.SecurityComponentImpl.isSecurityEnabled", "1827", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", throwable);
            }
            return true;
        }
    }

    public boolean isServerSecurityEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServerSecurityEnabled");
        }
        try {
            return this.serverSecurityEnabled;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws.security.core.SecurityComponentImpl.isServerSecurityEnabled", "1847", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", throwable);
            }
            return true;
        }
    }

    public String getRealm() {
        return (String)SecurityConfig.getConfig().getValue("security.activeUserRegistry.realm");
    }

    public WSSecurityContext getWSSecurityContext() {
        WSSecurityContext wSSecurityContext;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getWSSecurityContext");
            }
            wSSecurityContext = null;
            if (this.globalSecurityEnabled) {
                try {
                    String string = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism.OID");
                    WSSecurityContextFactory wSSecurityContextFactory = WSSecurityContextFactory.getInstance();
                    wSSecurityContext = wSSecurityContextFactory.createContext(string);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityComponentImpl.getWSSecurityContext", "1890", this);
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Exception getting WSSecurityContext", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSecurityContext", wSSecurityContext);
        }
        return wSSecurityContext;
    }

    private void expandVariables() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandVariables");
        }
        VariableMap variableMap = (VariableMap)this.Proxy.GetService(VariableMap.class);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        try {
            string = variableMap.expand("${WAS_INSTALL_ROOT}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_INSTALL_ROOT}");
            }
            string = System.getProperty("was.install.root");
        }
        try {
            string2 = variableMap.expand("${USER_INSTALL_ROOT}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${USER_INSTALL_ROOT}");
            }
            string2 = System.getProperty("user.install.root", System.getProperty("was.install.root"));
        }
        try {
            string3 = variableMap.expand("${WAS_TEMP_DIR}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_TEMP_DIR}");
            }
            string3 = string + File.separator + "tmp";
        }
        try {
            string5 = variableMap.expand("${WAS_PROPS_DIR}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_PROPS_DIR}");
            }
            string5 = string + File.separator + "properties";
        }
        try {
            string6 = variableMap.expand("${APP_INSTALL_ROOT}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${APP_INSTALL_ROOT}");
            }
            string6 = string + File.separator + "installedApps";
        }
        try {
            string4 = variableMap.expand("${WAS_ETC_DIR}");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cannot expand ${WAS_ETC_DIR}");
            }
            string4 = string + File.separator + "etc";
        }
        SecurityConfig.getConfig().setValue("${WAS_INSTALL_ROOT}", string);
        SecurityConfig.getConfig().setValue("${USER_INSTALL_ROOT}", string2);
        SecurityConfig.getConfig().setValue("${WAS_TEMP_DIR}", string3);
        SecurityConfig.getConfig().setValue("${WAS_PROPS_DIR}", string5);
        SecurityConfig.getConfig().setValue("${WAS_ETC_DIR}", string4);
        SecurityConfig.getConfig().setValue("${APP_INSTALL_ROOT}", string6);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "${WAS_INSTALL_ROOT}  = " + string);
            Tr.debug(tc, "${USER_INSTALL_ROOT} = " + string2);
            Tr.debug(tc, "${WAS_TEMP_DIR}      = " + string3);
            Tr.debug(tc, "${WAS_PROPS_DIR}     = " + string5);
            Tr.debug(tc, "${WAS_ETC_DIR}       = " + string4);
            Tr.debug(tc, "${APP_INSTALL_ROOT}  = " + string6);
        }
        this.expandedVariables = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandVariables");
        }
    }

    private void insertVariables(Properties properties) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "inserting variables into orbProps");
        }
        if (!this.expandedVariables) {
            this.expandVariables();
        }
        if (properties != null) {
            properties.put("${WAS_INSTALL_ROOT}", SecurityConfig.getConfig().getValue("${WAS_INSTALL_ROOT}"));
            properties.put("${USER_INSTALL_ROOT}", SecurityConfig.getConfig().getValue("${USER_INSTALL_ROOT}"));
            properties.put("${WAS_TEMP_DIR}", SecurityConfig.getConfig().getValue("${WAS_TEMP_DIR}"));
            properties.put("${WAS_PROPS_DIR}", SecurityConfig.getConfig().getValue("${WAS_PROPS_DIR}"));
            properties.put("${WAS_ETC_DIR}", SecurityConfig.getConfig().getValue("${WAS_ETC_DIR}"));
            properties.put("${APP_INSTALL_ROOT}", SecurityConfig.getConfig().getValue("${APP_INSTALL_ROOT}"));
            properties.put("com.ibm.ws.security.processType", SecurityConfig.getConfig().getValue("com.ibm.ws.security.processType"));
        }
    }

    private void initializeCache() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeCache");
        }
        Long l = (Long)SecurityConfig.getConfig().getValue("security.CacheTimeout");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "security cache timeout", l);
        }
        Cache.setDefaultTimeout(l * 1000L);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeCache");
        }
    }

    Subject initializeServerSubject() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeServerSubject");
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        Subject subject = ((ContextManagerInternals)contextManager).getServerSubjectInternal();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeServerSubject", subject);
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProviderList() {
        BufferedReader bufferedReader = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkProviderList");
        }
        String string3 = System.getProperty("java.home");
        string2 = string3 + File.separator + "lib" + File.separator + "security" + File.separator + "java.security";
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().startsWith("#") || string.trim().length() <= 0 || !string.trim().startsWith("security.provider")) continue;
                if (string.indexOf("com.ibm.crypto.fips.provider.IBMJCEFIPS") != -1) {
                    bl = true;
                }
                if (string.indexOf("com.ibm.crypto.provider.IBMJCE") == -1) continue;
                if (bl) {
                } else {
                    Tr.warning(tc, "security.checkProviderList.warning");
                    if (tc.isEntryEnabled()) {
                        Tr.debug(tc, "In FIPS mode, IBMJCEFIPS provider is not found before the IBMJCE provider in the java.security file.");
                    }
                }
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "FileNotFoundException caught for " + string2);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught: " + exception.getMessage());
            }
        }
        finally {
            block26: {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block26;
                    Tr.debug(tc, "Exception caught: " + exception.getMessage());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkProviderList");
        }
    }

    private com.ibm.websphere.models.config.process.Server getServerObjectIfNecessary(Properties properties) {
        String string = properties.getProperty("com.ibm.CORBA.TransportMode");
        if (string == null || string.equalsIgnoreCase("Pluggable")) {
            return null;
        }
        this.repository = (Repository)this.Proxy.GetService(Repository.class);
        Resource resource = null;
        String string2 = "server.xml";
        try {
            resource = this.repository.getConfigRoot().getResource(4, string2);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.distSecurityComponentImpl.getServerObject", "2140", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to load resource from process :  ", string2);
            }
            return null;
        }
        com.ibm.websphere.models.config.process.Server server = (com.ibm.websphere.models.config.process.Server)resource.getContents().get(0);
        EtoolsCopyUtility etoolsCopyUtility = new EtoolsCopyUtility();
        server = (com.ibm.websphere.models.config.process.Server)etoolsCopyUtility.copy(server);
        return server;
    }
}

