/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.websphere.cache.DistributedMap;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ConfigServiceProxy;
import com.ibm.websphere.management.dynamicproxy.InvocationHandler;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.security.auth.AuthCache;
import com.ibm.ws.security.auth.DistributedMapFactory;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.j2c.WSDefaultPrincipalMapping;
import com.ibm.ws.security.authorize.AppInstallNotify;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SSLConfigValidation;
import com.ibm.ws.security.core.SecurityAdminHelper;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.UserRegistryImpl;
import com.ibm.ws.security.registry.ldap.LdapRegistryImpl;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.util.AuthData;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.security.util.InvalidPasswordDecodingException;
import com.ibm.ws.security.util.PasswordUtil;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.ssl.JSSEProviderFactory;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfig;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.wsspi.security.ltpa.Token;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class SecurityAdmin
implements InvocationHandler {
    private static final String LOGIN_CONFIG_CLASS = "com.ibm.ws.security.auth.login.Configuration";
    private static List cachedDefaultCiphers = null;
    private static final WebSphereRuntimePermission GET_SSO_TOKEN_PERM = new WebSphereRuntimePermission("getSingleSignonToken");
    private static final String[] CIPHER_SUITES_LIST = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_RSA_FIPS_WITH_DES_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_RC4_128_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};
    private static final String[] FIPS_CIPHER_SUITES_LIST = new String[]{"SSL_RSA_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA"};
    private static final TraceComponent tc = Tr.register(SecurityAdmin.class, null, "com.ibm.ejs.resources.security");
    private LTPAServerObject _ltpaServer = null;
    private UserRegistry _registry = null;
    private boolean initialized = false;
    static /* synthetic */ Class class$com$ibm$wsspi$security$token$SingleSignonToken;

    public SecurityAdmin() throws Exception {
        this.initialize();
    }

    public synchronized void initialize() throws Exception {
        Boolean bl;
        if (this.initialized) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize ");
        }
        if ((bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled")).booleanValue()) {
            ContextManager contextManager;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is enabled, therefore initializing references to user registry and ltpa server.");
            }
            if ((contextManager = ContextManagerFactory.getInstance()) != null) {
                try {
                    this._registry = contextManager.getRegistry(contextManager.getDefaultRealm());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.initialize", "172", this);
                    Tr.error(tc, "security.sambean.urerr", new Object[]{exception});
                    throw exception;
                }
            } else {
                Tr.error(tc, "security.sambean.nullsecserver");
                throw new Exception("Unable to get ContextManager");
            }
            try {
                this._ltpaServer = LTPAServerObject.getLTPAServer();
            }
            catch (LTPAConfigException lTPAConfigException) {
                FFDCFilter.processException((Throwable)lTPAConfigException, "com.ibm.ws.security.core.SecurityAdmin.initialize", "191", this);
                Tr.debug(tc, "Error initializing LTPA server object.");
            }
            if (tc.isDebugEnabled()) {
                if (this._ltpaServer == null) {
                    Tr.debug(tc, "ltpa server not initialized.");
                } else {
                    Tr.debug(tc, "ltpa server initialized.");
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security is not enabled, therefore not initializing references to user registry and ltpa server.");
        }
        this.initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void purgeUserFromAuthCache(String string, String string2) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "purgeUserFromAuthCache");
            }
            AuthCache authCache = AuthCache.getInstance();
            try {
                authCache.removeEntry(string, string2);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.purgeUserFromCache", "227", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception purging user" + string2 + " from cache.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "purgeUserFromAuthCache");
        }
    }

    public void clearAuthCache() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "clearAuthCache");
            }
            AuthCache authCache = AuthCache.getInstance();
            try {
                authCache.removeAllEntries();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.purgeUserFromCache", "249", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception clearing auth cache.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearAuthCache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLdapBindInfo(String object, String string) {
        block68: {
            block67: {
                Object object2;
                ConfigService configService;
                block66: {
                    if (!WSSecurityHelper.isGlobalSecurityEnabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Global security is not enabled.");
                        }
                        return;
                    }
                    configService = null;
                    try {
                        object2 = AdminServiceFactory.getAdminService().getDeploymentManagerAdminClient();
                        configService = new ConfigServiceProxy((AdminClient)object2);
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block66;
                        Tr.debug(tc, "Unable to get ConfigService from deployment manager");
                    }
                }
                if (configService == null) {
                    configService = ConfigServiceFactory.getConfigService();
                }
                if (configService == null) {
                    try {
                        object2 = new Properties();
                        ((Properties)object2).setProperty("location", "local");
                        configService = ConfigServiceFactory.createConfigService(true, (Properties)object2);
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unable to create ConfigService. ", exception);
                        }
                        return;
                    }
                }
                if (configService == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is no configservice available.");
                    }
                    Tr.audit(tc, "security.registry.ldap.update.audit");
                    return;
                }
                object2 = null;
                try {
                    Object object3;
                    Object object4;
                    Object object5;
                    String string2;
                    object2 = new Session();
                    ObjectName objectName = ConfigServiceHelper.createObjectName(null, "Security");
                    ObjectName objectName2 = null;
                    ObjectName objectName3 = configService.resolve((Session)object2, "Cell=")[0];
                    if (objectName3 != null) {
                        objectName2 = configService.queryConfigObjects((Session)object2, objectName3, objectName, null)[0];
                    }
                    if (objectName2 == null) {
                        objectName2 = configService.queryConfigObjects((Session)object2, null, objectName, null)[0];
                    }
                    ObjectName objectName4 = (ObjectName)configService.getAttribute((Session)object2, objectName2, "activeUserRegistry");
                    boolean bl = false;
                    try {
                        string2 = ConfigServiceHelper.getConfigDataType(objectName4);
                        if (string2 != null && string2.equalsIgnoreCase("LDAPUserRegistry")) {
                            bl = true;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    string2 = null;
                    try {
                        string2 = (String)configService.getAttribute((Session)object2, objectName4, "serverId");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The active registry is not LDAP, no update is performed.");
                        }
                        return;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "This is LDAP user registry.");
                    }
                    ArrayList arrayList = (ArrayList)configService.getAttribute((Session)object2, objectName4, "hosts");
                    String string3 = "";
                    String string4 = "ldap://";
                    if (arrayList != null) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            object5 = (AttributeList)arrayList.get(i);
                            String string5 = (String)ConfigServiceHelper.getAttributeValue((AttributeList)object5, "host");
                            object4 = (Integer)ConfigServiceHelper.getAttributeValue((AttributeList)object5, "port");
                            object3 = new StringBuffer();
                            if (string5.startsWith(string4)) {
                                string5 = string5.substring(string4.length());
                            }
                            if (SecurityConfig.isIPv6Addr(string5)) {
                                string5 = SecurityConfig.formatIPv6Addr(string5);
                            }
                            ((StringBuffer)object3).append(string4).append(string5);
                            if (object4 != null && (Integer)object4 > 0) {
                                ((StringBuffer)object3).append(":" + (Integer)object4);
                            }
                            if (object3 == null || ((StringBuffer)object3).length() <= 0) continue;
                            if (string3 == "") {
                                string3 = ((StringBuffer)object3).toString();
                                continue;
                            }
                            if (string3.indexOf(((StringBuffer)object3).toString()) != -1) continue;
                            string3 = string3 + " " + ((StringBuffer)object3).toString();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "LDAP hosts are " + string3);
                        }
                    }
                    String string6 = (String)configService.getAttribute((Session)object2, objectName4, "bindPassword");
                    object5 = (String)configService.getAttribute((Session)object2, objectName4, "bindDN");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "New bind DN is " + (String)object5);
                    }
                    boolean bl2 = true;
                    if (string == null || object == null || string.length() == 0 || ((String)object).length() == 0) {
                        object = object5;
                        string = string6;
                        bl2 = false;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Bind info input  is incompleted, use bind info from security.xml.");
                        }
                    }
                    object4 = SecurityServerImpl.getRegistryImpl(ContextManagerFactory.getInstance().getDefaultRealm());
                    if (string != null && object != null && string.length() != 0 && ((String)object).length() != 0) {
                        try {
                            object = object3 = object4.checkPassword((String)object, string);
                        }
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Bind info is incorrect with Bind DN of " + (String)object);
                            }
                            Tr.audit(tc, "security.registry.ldap.update.audit");
                            try {
                                configService.discard((Session)object2);
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    object = null;
                    string = null;
                    LdapRegistryImpl.refreshRegistry((String)object, string, string3);
                    try {
                        if (string2 == null || string2 == "") {
                            string2 = "123";
                        }
                        object4.getUsers(string2, 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ((string6 == null && string == null || string6.equals(string)) && (object5 == null && object == null || ((String)object5).equals(object))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Bind info is not changed in security.xml since last update.");
                        }
                        bl2 = false;
                    }
                    if (bl2) {
                        object3 = new AttributeList();
                        ((AttributeList)object3).add(new Attribute("bindDN", object));
                        ((AttributeList)object3).add(new Attribute("bindPassword", string));
                        configService.setAttributes((Session)object2, objectName4, (AttributeList)object3);
                        configService.save((Session)object2, false);
                        try {
                            configService.discard((Session)object2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String string7 = AdminServiceFactory.getAdminService().getProcessType();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Process Type is " + string7);
                        }
                        if (string7.equals("DeploymentManager")) {
                            // empty if block
                        }
                        ObjectName objectName5 = new ObjectName("WebSphere:type=NodeSync,*");
                        Iterator iterator = AdminServiceFactory.getAdminService().queryNames(objectName5, null).iterator();
                        while (iterator.hasNext()) {
                            ObjectName objectName6 = (ObjectName)iterator.next();
                            AdminServiceFactory.getAdminService().invoke(objectName6, "sync", new Object[0], new String[0]);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "security.xml Sync completed.");
                        }
                        break block67;
                    }
                    try {
                        configService.discard((Session)object2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                catch (Exception exception) {
                    break block68;
                }
                finally {
                    try {
                        configService.discard((Session)object2);
                    }
                    catch (Exception exception) {}
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAuthDataCfg(HashMap hashMap) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAuthDataCfg ", new Object[]{hashMap});
        }
        if (hashMap != null) {
            WSDefaultPrincipalMapping.refreshAuthData(hashMap);
        } else {
            WorkSpace workSpace = null;
            try {
                Object object;
                Object object2;
                Object object3;
                String string = "" + System.currentTimeMillis();
                workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(string);
                RepositoryContextType repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("cells");
                URI uRI = URI.createURI("security.xml");
                Collection collection = workSpace.findContext(repositoryContextType);
                Security security2 = null;
                Iterator iterator = collection.iterator();
                if (iterator.hasNext()) {
                    object3 = (RepositoryContext)iterator.next();
                    object2 = object3.getResourceSet().createResource(uRI);
                    object = new HashMap();
                    object2.load((Map)object);
                    security2 = (Security)object2.getContents().get(0);
                }
                if (security2 != null) {
                    object3 = new HashMap();
                    object2 = security2.getAuthDataEntries().iterator();
                    while (object2.hasNext()) {
                        object = (JAASAuthData)object2.next();
                        if (object == null) continue;
                        ((HashMap)object3).put(object.getAlias(), new AuthData(object.getUserId(), object.getPassword()));
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "AuthData - add " + object.getAlias());
                    }
                    WSDefaultPrincipalMapping.refreshAuthData((HashMap)object3);
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception refreshing J2C AuthData.");
                }
            }
            finally {
                block21: {
                    if (workSpace != null) {
                        try {
                            String string = workSpace.getUserName();
                            WorkSpaceManagerFactory.getManager().removeWorkSpace(string);
                        }
                        catch (WorkSpaceException workSpaceException) {
                            if (!tc.isDebugEnabled()) break block21;
                            Tr.debug(tc, "Exception removing WorkSpace.");
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAuthDataCfg ");
        }
    }

    public void updateJAASCfg(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateJAASCfg ");
        }
        Configuration configuration = com.ibm.ws.security.auth.login.Configuration.getConfiguration();
        String string2 = configuration.getClass().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The Login Configuration class is: " + string2);
        }
        if (configuration instanceof com.ibm.ws.security.auth.login.Configuration) {
            try {
                com.ibm.ws.security.auth.login.Configuration configuration2 = (com.ibm.ws.security.auth.login.Configuration)configuration;
                configuration2.updateWCCMAppConfig(string);
                configuration2.refresh();
                if (tc.isDebugEnabled()) {
                    String string3 = configuration2.toString();
                    Tr.debug(tc, "The dynamic JAAS login configuration is:\n" + string3);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.updateJAASCfg", "608", this);
                Tr.error(tc, "security.init.wccmjaas.error", new Object[]{exception});
            }
        } else {
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
            if (bl != null && bl.booleanValue()) {
                Tr.error(tc, "security.init.wccmjaas.wrongclasserror", new Object[]{string2, LOGIN_CONFIG_CLASS});
                throw new RuntimeException("JAAS Login provider class com.ibm.ws.security.auth.login.Configuration is not configured as login provider class");
            }
            Tr.warning(tc, "security.init.wccmjaas.wrongclasswarning", (Object)new Object[]{string2, LOGIN_CONFIG_CLASS});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateJAASCfg ");
        }
    }

    public String getJAASCfg() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJAASCfg ");
        }
        String string = null;
        Configuration configuration = com.ibm.ws.security.auth.login.Configuration.getConfiguration();
        String string2 = configuration.getClass().getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The Login Configuration class is: " + string2);
        }
        if (configuration instanceof com.ibm.ws.security.auth.login.Configuration) {
            try {
                com.ibm.ws.security.auth.login.Configuration configuration2 = (com.ibm.ws.security.auth.login.Configuration)configuration;
                string = configuration2.toString();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.getJAASCfg", "660", this);
                Tr.error(tc, "security.init.wccmjaas.error", new Object[]{exception});
            }
        } else {
            Boolean bl = (Boolean)SecurityConfig.getConfig().getValue("security.enabled");
            if (bl != null && bl.booleanValue()) {
                Tr.error(tc, "security.init.wccmjaas.wrongclasserror", new Object[]{string2, LOGIN_CONFIG_CLASS});
                throw new RuntimeException("JAAS Login provider class com.ibm.ws.security.auth.login.Configuration is not configured as login provider class");
            }
            Tr.warning(tc, "security.init.wccmjaas.wrongclasswarning", (Object)new Object[]{string2, LOGIN_CONFIG_CLASS});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJAASCfg ");
        }
        return string;
    }

    public Result getUsers(String string, Integer n, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers ", string + " " + n);
        }
        int n2 = n;
        Result result = null;
        UserRegistry userRegistry = this.getRegistry(properties);
        if (userRegistry != null) {
            try {
                SecurityConfig.getConfig();
                result = userRegistry.getUsers(SecurityConfig.variableMapExpand(string), n2);
            }
            catch (CustomRegistryException customRegistryException) {
                FFDCFilter.processException((Throwable)customRegistryException, "com.ibm.ws.security.core.SecurityAdmin.getUsers", "710", this);
                Tr.error(tc, "security.sambean.getusrerr", new Object[]{string, new Integer(n2), customRegistryException});
                throw customRegistryException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.getUsers", "716", this);
                Tr.error(tc, "security.sambean.getusrerr", new Object[]{string, new Integer(n2), exception});
                throw exception;
            }
        } else {
            Tr.error(tc, "security.sa.no.registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers ");
        }
        return result;
    }

    public Result getGroups(String string, Integer n, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups ", string + " " + n);
        }
        int n2 = n;
        Result result = null;
        UserRegistry userRegistry = this.getRegistry(properties);
        if (userRegistry != null) {
            try {
                result = userRegistry.getGroups(string, n2);
            }
            catch (CustomRegistryException customRegistryException) {
                FFDCFilter.processException((Throwable)customRegistryException, "com.ibm.ws.security.core.SecurityAdmin.getGroups", "748", this);
                Tr.error(tc, "security.sambean.getgrperr", new Object[]{string, new Integer(n2), customRegistryException});
                throw customRegistryException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.getGroups", "754", this);
                Tr.error(tc, "security.sambean.getgrperr", new Object[]{string, new Integer(n2), exception});
                throw exception;
            }
        } else {
            Tr.error(tc, "security.sa.no.registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups ");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Boolean checkRunAsUser(List list, List list2, String string, Properties properties) throws Exception {
        Boolean bl;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkRunAsUser", string);
        }
        if (SecurityConfig.isJACCEnabled()) {
            if (!tc.isDebugEnabled()) return Boolean.TRUE;
            Tr.debug(tc, "No runAsRole to role checking when JACC is enabled");
            return Boolean.TRUE;
        }
        boolean bl2 = false;
        UserRegistry userRegistry = null;
        if (string == null || string.trim().length() <= 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RunAs username is null");
            }
            bl2 = true;
        } else if (list.contains(string)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user " + string + " is in the user list");
            }
            bl2 = true;
        } else {
            userRegistry = this.getRegistry(properties);
            Result result = null;
            object = null;
            if (userRegistry != null) {
                result = userRegistry.getUsers(string, 1);
                if (result != null) {
                    object = (String)result.getList().get(0);
                }
                if (list != null && object != null && ((String)object).length() > 0 && list.contains(object)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "user " + string + " is in the list");
                    }
                    bl2 = true;
                }
            } else {
                Tr.error(tc, "security.sa.no.registry");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cannot determine if user " + string + " is in the list since registry is null. Returing false");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkRunAsUser");
                }
            }
        }
        if (!bl2 && userRegistry != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "user " + string + " is not in the user list. Checking in the group list");
            }
            boolean bl3 = false;
            object = (Boolean)SecurityConfig.getConfig().getValue("security.registry.IgnoreCase");
            if (object != null && ((Boolean)object).booleanValue()) {
                bl3 = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ignoreCase is set");
                }
            }
            List list3 = userRegistry.getGroupsForUser(string);
            if (list2 != null && list3 != null) {
                block0: for (int i = 0; i < list2.size() && !bl2; ++i) {
                    if (bl3) {
                    } else {
                        if (!list3.contains(list2.get(i))) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "user " + string + " is in the group list");
                        }
                        bl2 = true;
                        continue;
                    }
                    for (int j = 0; j < list3.size(); ++j) {
                        String string2;
                        String string3 = (String)list3.get(j);
                        if (!string3.equalsIgnoreCase(string2 = (String)list2.get(i))) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "user " + string + " is in the group list");
                        }
                        bl2 = true;
                        continue block0;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkRunAsUser", bl2 ? Boolean.TRUE : Boolean.FALSE);
        }
        if (bl2) {
            bl = Boolean.TRUE;
            return bl;
        }
        bl = Boolean.FALSE;
        return bl;
    }

    public String getAccessIds(boolean bl, String string, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAccessIds", string);
        }
        String string2 = null;
        UserRegistry userRegistry = this.getRegistry(properties);
        if (userRegistry != null) {
            string2 = bl ? userRegistry.getUniqueUserId(string) : userRegistry.getUniqueGroupId(string);
        } else {
            Tr.error(tc, "security.sa.no.registry");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "registry is null. Returing null accessId");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessIds");
        }
        return string2;
    }

    public String getRealm(Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm ");
        }
        UserRegistry userRegistry = this.getRegistry(properties);
        String string = null;
        if (userRegistry != null) {
            try {
                string = userRegistry.getRealm();
            }
            catch (CustomRegistryException customRegistryException) {
                FFDCFilter.processException((Throwable)customRegistryException, "com.ibm.ws.security.core.SecurityAdmin.getRealm", "913", this);
                Tr.error(tc, "security.sa.get.realm", new Object[]{customRegistryException});
                throw customRegistryException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.getRealm", "919", this);
                Tr.error(tc, "security.sa.get.realm", new Object[]{exception});
                throw exception;
            }
        } else {
            Tr.error(tc, "security.sa.no.registry");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm ", string);
        }
        return string;
    }

    public void generateKeys(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKeys");
        }
        LTPAServerObject lTPAServerObject = this.getLtpaServer();
        this.generateKeysForKeySetGroup(null, Boolean.TRUE);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateKeys");
        }
    }

    public void updateRuntimeKeys(Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRuntimeKeys ");
        }
        try {
            LTPAServerObject lTPAServerObject = this.getLtpaServer();
            lTPAServerObject.updateLTPAKeysFromMap(map);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateRuntimeKeys ");
            }
            return;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.updateRuntimeKeys", "965", this);
            Tr.error(tc, "security.ErrorCreatingLTPAKeys", new Object[]{exception});
            throw exception;
        }
    }

    public Map generateKeysForKeySetGroup(Session session, Boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateKeysForKeySetGroup");
        }
        try {
            LTPAServerObject lTPAServerObject = this.getLtpaServer();
            Map map = lTPAServerObject.generateKeysForKeySetGroup(session, bl);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "generateKeysForKeySetGroup");
            }
            return map;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.generateKeysForKeySetGroup", "987", this);
            Tr.error(tc, "security.ErrorCreatingLTPAKeys", new Object[]{exception});
            throw exception;
        }
    }

    public Properties genKeys(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "genKeys ");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "genKeys ");
        }
        Map map = this.generateKeysForKeySetGroup(null, Boolean.FALSE);
        return null;
    }

    public void exportKeys(String string, Properties properties) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportKeys filename:" + string);
        }
        LTPAServerObject lTPAServerObject = this.getLtpaServer(properties);
        String string2 = properties.getProperty("ltpa_password");
        Properties properties2 = null;
        try {
            if (lTPAServerObject != null) {
                properties2 = lTPAServerObject.exportSSOProperties(string2.getBytes("UTF8"));
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.exportKeys", "1021", this);
            Tr.error(tc, "security.sambean.expltpakeys", new Object[]{exception});
            throw exception;
        }
        try {
            this.setProps(properties2, string);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.core.SecurityAdmin.exportKeys", "1033", this);
            Tr.error(tc, "security.sa.set.props", new Object[]{string, iOException});
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportKeys ");
        }
    }

    public void importKeys(String string, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importKeys " + string);
        }
        Properties properties = new Properties();
        try {
            properties = this.getProps(string);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.security.core.SecurityAdmin.importKeys", "1054", this);
            Tr.error(tc, "security.sa.set.props", new Object[]{string, iOException});
            throw iOException;
        }
        try {
            LTPAServerObject lTPAServerObject = this.getLtpaServer(properties);
            lTPAServerObject.importSSOProperties(properties, byArray);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.importKeys", "1067", this);
            Tr.error(tc, "security.sambean.impltpakeys", new Object[]{properties, exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importKeys ");
        }
    }

    public void getApplicationRoles(String string) {
    }

    public void getEjbModuleRoles(String string, String string2) {
    }

    public void getWebModuleRoles(String string, String string2) {
    }

    public Map importSSOPropertiesToKeySetGroup(Properties properties, byte[] byArray, Session session, Boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importSSOPropertiesToKeySetGroup");
        }
        try {
            LTPAServerObject lTPAServerObject = this.getLtpaServer();
            if (null != lTPAServerObject) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "importSSOPropertiesToKeySetGroup");
                }
                return lTPAServerObject.importSSOPropertiesToKeySetGroup(properties, byArray, session, bl);
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "security.sambean.impltpakeys", new Object[]{properties, exception});
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.importLTPAKeys", "1115", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importSSOPropertiesToKeySetGroup", exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importSSOPropertiesToKeySetGroup (null)");
        }
        return null;
    }

    public void importLTPAKeys(Properties properties, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "importLTPAKeys");
        }
        try {
            LTPAServerObject lTPAServerObject = this.getLtpaServer(properties);
            if (null != lTPAServerObject) {
                lTPAServerObject.importSSOProperties(properties, byArray);
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "security.sambean.impltpakeys", new Object[]{properties, exception});
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.importLTPAKeys", "1139", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "importLTPAKeys", exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importLTPAKeys");
        }
    }

    public void checkImportLTPAKeys(Properties properties, byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkImportLTPAKeys");
        }
        try {
            LTPAServerObject lTPAServerObject = this.getLtpaServer(properties);
            if (null != lTPAServerObject) {
                lTPAServerObject.checkImportSSOProperties(properties, byArray);
            }
        }
        catch (Exception exception) {
            Tr.error(tc, "security.sambean.impltpakeys", new Object[]{properties, exception});
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.checkImportLTPAKeys", "1160", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkImportLTPAKeys", exception);
            }
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkImportLTPAKeys");
        }
    }

    public Properties exportLTPAKeys(byte[] byArray) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportLTPAKeys (with pw)");
        }
        try {
            Properties properties = null;
            LTPAServerObject lTPAServerObject = this.getLtpaServer();
            if (lTPAServerObject != null) {
                properties = lTPAServerObject.exportSSOProperties(byArray);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ltpaServer is null! not good.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "exportLTPAKeys: " + (properties != null ? properties.toString() : "null props"));
            }
            return properties;
        }
        catch (Exception exception) {
            Tr.error(tc, "security.sambean.expltpakeys", new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.exportLTPAKeys", "1189", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "exportLTPAKeys", exception);
            }
            throw exception;
        }
    }

    public Properties exportLTPAKeys() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportLTPAKeys");
        }
        try {
            Properties properties = null;
            LTPAServerObject lTPAServerObject = this.getLtpaServer();
            if (lTPAServerObject != null) {
                properties = lTPAServerObject.exportSSOProperties(ManagementScopeManager.getInstance().getCellName().getBytes("UTF8"));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ltpaServer is null! not good.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "exportLTPAKeys: " + (properties != null ? properties.toString() : "null props"));
            }
            return properties;
        }
        catch (Exception exception) {
            Tr.error(tc, "security.sambean.expltpakeys", new Object[]{exception});
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.exportLTPAKeys", "1218", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "exportLTPAKeys", exception);
            }
            throw exception;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Boolean checkPassword(String var1_1, String var2_2, Properties var3_3) throws Exception {
        if (SecurityAdmin.tc.isEntryEnabled()) {
            Tr.entry(SecurityAdmin.tc, "checkPassword");
        }
        var4_4 = false;
        var5_5 = this.getRegistry(var3_3);
        SecurityConfig.getConfig();
        var1_1 = SecurityConfig.variableMapExpand(var1_1);
        SecurityConfig.getConfig();
        var2_2 = SecurityConfig.variableMapExpand(var2_2);
        try {
            var2_2 = PasswordUtil.decode(var2_2);
        }
        catch (InvalidPasswordDecodingException var6_6) {
            // empty catch block
        }
        if (var5_5 != null) {
            try {
                var6_7 = (String)SecurityConfig.getConfig().getValue("security.activeAuthMechanism.OID");
                if (ContextManagerFactory.getInstance().isCellSecurityEnabled() && var6_7 != null && "oid:1.2.840.113554.1.2.2".endsWith(var6_7)) {
                    var7_11 = (String)SecurityConfig.getConfig().getValue("com.ibm.websphere.security.krb.kerberos_realm");
                    if (var7_11 != null && !var7_11.equals("") && var1_1.indexOf(64) == -1) {
                        var1_1 = var1_1 + "@" + var7_11;
                    }
                    if ((var8_13 = ContextManagerFactory.getInstance().login(ContextManagerFactory.getInstance().getDefaultRealm(), var1_1, var2_2)) == null) ** GOTO lbl46
                    if (SecurityAdmin.tc.isDebugEnabled()) {
                        Tr.debug(SecurityAdmin.tc, "password is ok");
                    }
                    var4_4 = true;
                }
                var7_12 = var5_5.checkPassword(var1_1, var2_2);
                var4_4 = true;
            }
            catch (PasswordCheckFailedException var6_8) {
                FFDCFilter.processException((Throwable)var6_8, "com.ibm.ws.security.core.SecurityAdmin.checkPassword", "1272", this);
                Tr.error(SecurityAdmin.tc, "security.sa.chk.password", new Object[]{var1_1, var6_8});
                throw var6_8;
            }
            catch (CustomRegistryException var6_9) {
                FFDCFilter.processException((Throwable)var6_9, "com.ibm.ws.security.core.SecurityAdmin.checkPassword", "1278", this);
                Tr.error(SecurityAdmin.tc, "security.sa.chk.password.custom", new Object[]{var1_1, var6_9});
                throw var6_9;
            }
            catch (Exception var6_10) {
                FFDCFilter.processException((Throwable)var6_10, "com.ibm.ws.security.core.SecurityAdmin.checkPassword", "1284", this);
                Tr.error(SecurityAdmin.tc, "security.sa.chk.password.custom", new Object[]{var1_1, var6_10});
                throw var6_10;
            }
        } else {
            if (SecurityAdmin.tc.isDebugEnabled()) {
                Tr.debug(SecurityAdmin.tc, "registry is null: checkPassword failed");
            }
            Tr.error(SecurityAdmin.tc, "security.sa.no.registry");
        }
lbl46:
        // 4 sources

        if (SecurityAdmin.tc.isEntryEnabled()) {
            Tr.exit(SecurityAdmin.tc, "checkPassword", var4_4 != false ? Boolean.TRUE : Boolean.FALSE);
        }
        return var4_4 != false ? Boolean.TRUE : Boolean.FALSE;
    }

    public Integer checkTokenLibFile(String string, String string2, String string3, String string4, String string5, String string6) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTokenLibFile");
        }
        int n = SSLConfigValidation.checkTokenLibFile(string, string2, string3, string4, string5, string6);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTokenLibFile", "status=" + n);
        }
        return new Integer(n);
    }

    public Integer checkKeyFile(String string, String string2, String string3, String string4, String string5) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkKeyFile");
        }
        int n = SSLConfigValidation.checkKeyFile(string, string2, string3, string4, string5);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkKeyFile", "status=" + n);
        }
        return new Integer(n);
    }

    public Integer checkTrustFile(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTrustFile");
        }
        int n = SSLConfigValidation.checkTrustFile(string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTrustFile", "status=" + n);
        }
        return new Integer(n);
    }

    public TokenHolder getOpaqueToken(ByteArray byteArray) {
        TokenHolder tokenHolder;
        byte[] byArray;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getOpaqueToken");
            }
            byArray = null;
            tokenHolder = null;
            if (AdminHelper.getPlatformHelper().isZOS()) {
                block14: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Extract stoken of input ssoToken's originating servant.");
                    }
                    Token token = null;
                    try {
                        token = ContextManagerFactory.getInstance().getWSCredTokenMapper().validateLTPAToken(byteArray.getArray());
                        String[] stringArray = token.getAttributes("com.ibm.websphere.zOS.ServantIdentifier");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "retrieved servantID" + stringArray[0]);
                        }
                        tokenHolder = SecurityAdminHelper.getOpaqueToken(byteArray, stringArray[0]);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getOpaqueToken returns token." + tokenHolder);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.getOpaqueToken", "1412", this);
                        if (!tc.isEntryEnabled()) break block14;
                        Tr.exit(tc, "Exception occurred extracting stoken of input ssoToken's originating servant.", new Object[]{exception});
                    }
                }
                return tokenHolder;
            }
            try {
                DistributedMap distributedMap = DistributedMapFactory.getMap("WSSecureMap");
                if (distributedMap != null) {
                    byArray = (byte[])distributedMap.get((Object)byteArray);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.getOpaqueToken", "1428", this);
                if (!tc.isEntryEnabled()) break block15;
                Tr.exit(tc, "Exception occurred getting opaque token from distributed map.", new Object[]{exception});
            }
        }
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken returns null.");
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getOpaqueToken returns opaque token.");
            }
            tokenHolder = new TokenHolder(byArray, "WS_OPAQUE", 1);
        }
        return tokenHolder;
    }

    public TokenHolder getInitialContextToken(ByteArray byteArray, String string) {
        TokenHolder tokenHolder;
        byte[] byArray;
        block31: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInitialContextToken, targetServer: " + string);
            }
            byArray = null;
            GSSCredential gSSCredential = null;
            tokenHolder = null;
            GSSContext gSSContext = null;
            GSSManager gSSManager = GSSManager.getInstance();
            try {
                DistributedMap distributedMap = DistributedMapFactory.getMap("WSSecureMapNotShared");
                if (distributedMap != null) {
                    gSSCredential = (GSSCredential)distributedMap.get((Object)byteArray);
                } else {
                    Tr.error(tc, "dm is null");
                }
                if (gSSCredential != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "gssCred is not null ");
                    }
                    String string2 = "host@" + string;
                    Oid oid = null;
                    if (oid == null) {
                        try {
                            oid = new Oid("1.2.840.113554.1.2.2");
                        }
                        catch (GSSException gSSException) {
                            Object[] objectArray = new Object[]{Oid.class, "Oid(\"1.2.840.113554.1.2.2\")", gSSException};
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception getting OID: " + gSSException.getMessage());
                            }
                            throw gSSException;
                        }
                    }
                    GSSName gSSName = null;
                    try {
                        gSSName = gSSManager.createName(string2, GSSName.NT_HOSTBASED_SERVICE, oid);
                    }
                    catch (GSSException gSSException) {
                        Object[] objectArray = new Object[]{gSSManager, "createName()", gSSException};
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception calling createName: " + gSSException.getMessage());
                        }
                        throw gSSException;
                    }
                    Tr.debug(tc, "ServerName" + gSSName);
                    try {
                        gSSContext = gSSManager.createContext(gSSName, oid, gSSCredential, 0);
                    }
                    catch (GSSException gSSException) {
                        Object[] objectArray = new Object[]{gSSManager, "createContext()", gSSException};
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception calling createContext: " + gSSException.getMessage());
                        }
                        throw gSSException;
                    }
                    try {
                        gSSContext.requestCredDeleg(true);
                    }
                    catch (GSSException gSSException) {
                        Object[] objectArray = new Object[]{gSSContext, "requestCredDeleg(true)", gSSException};
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception calling requestCredDeleg: " + gSSException.getMessage());
                        }
                        throw gSSException;
                    }
                    byte[] byArray2 = null;
                    int n = 0;
                    try {
                        byArray = gSSContext.initSecContext(byArray2, 0, n);
                        Tr.debug(tc, "Token = " + byArray.length + byArray);
                    }
                    catch (GSSException gSSException) {
                        Object[] objectArray = new Object[]{gSSContext, "initSecContext()", gSSException};
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception calling initSecContext: " + gSSException.getMessage());
                        }
                        throw gSSException;
                    }
                    if (gSSContext.isEstablished()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "initSecContext: clientContext established successfully.");
                        }
                    } else {
                        Object[] objectArray = new Object[]{gSSContext, string2};
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "initSecContext: clientContext not established.");
                        }
                    }
                    break block31;
                }
                Tr.error(tc, "gssCred was null");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.getOpaqueToken", "1584", this);
                if (!tc.isEntryEnabled()) break block31;
                Tr.exit(tc, "Exception occurred getting opaque token from distributed map.", new Object[]{exception});
            }
        }
        if (byArray == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInitialContextToken returns null.");
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInitialContextToken returns opaque token.");
            }
            tokenHolder = new TokenHolder(byArray, "INIT_CONTEXT_TOKEN", 1);
        }
        return tokenHolder;
    }

    public TokenHolder[] getSingleSignonTokens() {
        Serializable serializable;
        TokenHolder tokenHolder;
        SingleSignonToken[] singleSignonTokenArray;
        block13: {
            Serializable serializable2;
            SecurityManager securityManager;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSingleSignonTokens");
            }
            if ((securityManager = System.getSecurityManager()) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting: " + GET_SSO_TOKEN_PERM);
                }
                securityManager.checkPermission(GET_SSO_TOKEN_PERM);
            }
            singleSignonTokenArray = null;
            tokenHolder = null;
            try {
                serializable = ContextManagerFactory.getInstance().getCallerSubject();
                serializable2 = SubjectHelper.getWSCredentialFromSubject((Subject)serializable);
                if (serializable != null && serializable2 != null && !serializable2.isUnauthenticated() && !serializable2.isBasicAuth()) {
                    singleSignonTokenArray = (SingleSignonToken[])com.ibm.ws.security.util.AccessController.doPrivileged(new PrivilegedExceptionAction((Subject)serializable){
                        private final /* synthetic */ Subject val$subject;
                        {
                            this.val$subject = subject;
                        }

                        public Object run() throws Exception {
                            HashSet hashSet = new HashSet();
                            Set set = this.val$subject.getPrivateCredentials(class$com$ibm$wsspi$security$token$SingleSignonToken == null ? (class$com$ibm$wsspi$security$token$SingleSignonToken = SecurityAdmin.class$("com.ibm.wsspi.security.token.SingleSignonToken")) : class$com$ibm$wsspi$security$token$SingleSignonToken);
                            Set set2 = this.val$subject.getPublicCredentials(class$com$ibm$wsspi$security$token$SingleSignonToken == null ? (class$com$ibm$wsspi$security$token$SingleSignonToken = SecurityAdmin.class$("com.ibm.wsspi.security.token.SingleSignonToken")) : class$com$ibm$wsspi$security$token$SingleSignonToken);
                            if (set != null) {
                                hashSet.addAll(set);
                            }
                            if (set2 != null) {
                                hashSet.addAll(set2);
                            }
                            return hashSet.toArray(new SingleSignonToken[0]);
                        }
                    });
                    tokenHolder = new TokenHolder(serializable2.getCredentialToken(), "LtpaToken", -1);
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                serializable2 = privilegedActionException.getException();
                FFDCFilter.processException((Throwable)serializable2, "com.ibm.ws.security.core.SecurityAdmin.getSingleSignonTokens", "1653", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected exception getting token list", serializable2);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.getSingleSignonTokens", "1658", this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Unexpected exception getting token list", exception);
            }
        }
        serializable = new HashSet();
        for (int i = 0; singleSignonTokenArray != null && i < singleSignonTokenArray.length; ++i) {
            try {
                serializable.add(new TokenHolder(singleSignonTokenArray[i].getBytes(), singleSignonTokenArray[i].getName(), singleSignonTokenArray[i].getVersion()));
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.getSingleSignonTokens", "1674", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Unexpected exception building TokenHolder list", exception);
            }
        }
        if ((SecurityConfig.getConfig().getValue("com.ibm.ws.security.ssoInteropModeEnabled").equals("true") || SecurityConfig.getConfig().getValue("com.ibm.ws.security.webInboundPropagationEnabled").equals("false") || serializable.size() == 0) && tokenHolder != null) {
            serializable.add(tokenHolder);
        }
        TokenHolder[] tokenHolderArray = serializable.toArray(new TokenHolder[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSingleSignonTokens", tokenHolderArray);
        }
        return tokenHolderArray;
    }

    private UserRegistry getRegistry(Properties properties) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (tc.isEntryEnabled()) {
            object4 = SecurityConfig.maskPasswords(properties);
            Tr.entry(tc, "getRegistry " + object4);
        }
        object4 = this._registry;
        if (properties == null && object4 != null) {
            return object4;
        }
        if (properties == null && object4 == null) {
            Object object5;
            object3 = (Properties)SecurityConfig.getConfig().getValue("security.activeUserRegistry.props");
            properties = SecurityConfig.expandProps((Properties)object3);
            object2 = (Properties)SecurityConfig.getConfig().getValue("security.registry.ldap.props");
            if (object2 != null) {
                Properties properties2;
                object5 = ((Properties)object2).keys();
                while (object5.hasMoreElements()) {
                    object = (String)object5.nextElement();
                    properties.put(object, ((Properties)object2).get(object));
                }
                object = (Boolean)SecurityConfig.getConfig().getValue("security.registry.ldap.SSLEnabled");
                properties.put("sslEnabled", object);
                if (((Boolean)object).booleanValue() && (properties2 = (Properties)SecurityConfig.getConfig().getValue("security.registry.ldap.SSLConfig")) != null) {
                    properties.put("sslConfig", properties2);
                }
                properties.put("CustUserRegImplClass", "com.ibm.ws.security.registry.ldap.LdapRegistryImpl");
            } else {
                object5 = (Properties)SecurityConfig.getConfig().getValue("CustomerUserRegistryProps");
                if (object5 != null && (object = (String)((Properties)object5).get("CustUserRegImplClass")) != null) {
                    properties.put("CustUserRegImplClass", object);
                }
            }
        }
        try {
            Properties properties3 = null;
            if (properties != null) {
                properties3 = new Properties();
                object3 = properties.keys();
                while (object3.hasMoreElements()) {
                    object2 = (String)object3.nextElement();
                    properties3.put(object2, properties.get(object2));
                }
            }
            if (properties3 != null && (object3 = (Boolean)properties3.get("sslEnabled")) != null && ((Boolean)object3).booleanValue()) {
                block20: {
                    object2 = null;
                    try {
                        object2 = (Properties)properties3.get("sslConfig");
                    }
                    catch (ClassCastException classCastException) {
                        object = (SecureSocketLayer)properties3.get("sslConfig");
                        if (object == null) break block20;
                        object2 = this.createPropertiesFromSecureSocketLayer((SecureSocketLayer)object);
                    }
                }
                if (object2 != null) {
                    properties3.put("sslConfig", object2);
                }
            }
            object3 = new UserRegistryImpl();
            object2 = SecurityConfig.expandProps(properties3);
            ((UserRegistryImpl)object3).initialize((Properties)object2);
            object4 = object3;
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.security.core.SecurityAdmin.getRegistry", "1813", this);
            Tr.error(tc, "security.registry.createerror", new Object[]{remoteException});
            throw remoteException;
        }
        catch (CustomRegistryException customRegistryException) {
            FFDCFilter.processException((Throwable)customRegistryException, "com.ibm.ws.security.core.SecurityAdmin.getRegistry", "1819", this);
            Tr.error(tc, "security.registry.createerror", new Object[]{customRegistryException});
            throw customRegistryException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.getRegistry", "1825", this);
            Tr.error(tc, "security.registry.createerror", new Object[]{exception});
            throw exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegistry ");
        }
        if (this._registry == null) {
            this._registry = object4;
        }
        return object4;
    }

    private Properties createPropertiesFromSecureSocketLayer(SecureSocketLayer secureSocketLayer) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Converting SSL config to properties.");
        }
        try {
            SSLConfig sSLConfig = SSLConfigManager.getInstance().parseSecureSocketLayer(null, null, secureSocketLayer, true);
            return sSLConfig;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.security.core.SecurityAdmin.createPropertiesFromSecureSocketLayer", "1849", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception converting the properties.", new Object[]{exception});
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProps(String string) throws IOException {
        URL uRL;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getProps ");
            }
            String string2 = string;
            uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.security.core.SecurityAdmin.getProps", "1872", this);
                Tr.error(tc, "security.sa.set.props", new Object[]{string2, malformedURLException});
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Malformed url", string2);
            }
        }
        Properties properties = new Properties();
        InputStream inputStream = uRL.openStream();
        try {
            properties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProps ");
        }
        return properties;
    }

    private void setProps(Properties properties, String string) throws IOException {
        URL uRL;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setProps ");
            }
            String string2 = string;
            uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, "com.ibm.ws.security.core.SecurityAdmin.setProps", "1905", this);
                Tr.error(tc, "security.sa.set.props", new Object[]{string2, malformedURLException});
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Malformed url", string2);
            }
        }
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(uRL.getFile());
        properties.save(fileOutputStream, "SSOProperties");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProps ");
        }
    }

    private LTPAServerObject getLtpaServer(Properties properties) throws Exception {
        return this.getLtpaServer();
    }

    private LTPAServerObject getLtpaServer() throws Exception {
        if (this._ltpaServer == null) {
            this._ltpaServer = new LTPAServerObject();
            if (this._ltpaServer == null) {
                Tr.error(tc, "security.sambean.noltpaserver");
                throw new Exception("Error creating LTPAServerObject.");
            }
        }
        return this._ltpaServer;
    }

    public void preInvoke(String string, Object[] objectArray, String[] stringArray, StateObject stateObject, int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preInvoke()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preInvoke");
        }
    }

    public void postInvoke(String string, Object[] objectArray, String[] stringArray, StateObject stateObject, int n, Throwable throwable, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke");
        }
        if (string.equals("purgeUserFromAuthCache")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "purgeUserFromAuthCache()");
            }
            this.purgeUserFromAuthCache((String)objectArray[0], (String)objectArray[1]);
        } else if (string.equals("clearAuthCache")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clearAuthCache()");
            }
            this.clearAuthCache();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propagatePolicyToJACCProvider(String string) throws Exception {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "propagatePolicyToJACCProvider");
        }
        WorkSpace workSpace = null;
        Archive archive = null;
        Resource resource = null;
        try {
            string2 = "" + System.currentTimeMillis();
            workSpace = WorkSpaceManagerFactory.getManager().getWorkSpace(string2);
            RepositoryContextType repositoryContextType = RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("deployments");
            Collection collection = workSpace.findContext(repositoryContextType);
            Iterator iterator = collection.iterator();
            URI uRI = URI.createURI("deployment.xml");
            while (iterator.hasNext()) {
                Object object;
                RepositoryContext repositoryContext = (RepositoryContext)iterator.next();
                String string3 = repositoryContext.getName();
                boolean bl = false;
                if (string != null) {
                    object = new StringTokenizer(string, ":");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        if (!string3.equals(((StringTokenizer)object).nextToken())) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "appName to be propagated is: " + string3);
                        }
                        bl = true;
                    }
                }
                if (string != null && !bl) continue;
                object = repositoryContext.getPath();
                repositoryContext.extract(false);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "appName is: " + string3 + ", dirName is " + (String)object);
                }
                try {
                    CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
                    ArchiveOptions archiveOptions = new ArchiveOptions();
                    archiveOptions.setUseJavaReflection(false);
                    archiveOptions.setIsReadOnly(true);
                    resource = repositoryContext.getResourceSet().createResource(uRI);
                    HashMap hashMap = new HashMap();
                    resource.load(hashMap);
                    Deployment deployment = (Deployment)resource.getContents().get(0);
                    ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                    String string4 = applicationDeployment.getAppContextIDForSecurity();
                    archive = commonarchiveFactory.openEARFile(archiveOptions, (String)object);
                    AppInstallNotify.getInstance().appInstall((EARFile)archive, string3, string4, false);
                }
                finally {
                    if (archive != null) {
                        archive.close();
                    }
                    if (resource == null) continue;
                    resource.unload();
                    resource = null;
                }
            }
        }
        finally {
            if (workSpace != null) {
                string2 = workSpace.getUserName();
                WorkSpaceManagerFactory.getManager().removeWorkSpace(string2);
            }
        }
    }

    public static List getSecureSocketLayerCipherList(Boolean bl) {
        SSLContext sSLContext = null;
        String string = "CipherList";
        SecurityConfiguration securityConfiguration = null;
        Object var4_4 = null;
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = JSSEProviderFactory.isFipsEnabled();
        if (bl2 == bl) {
            String string2;
            if (cachedDefaultCiphers != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getSecureSocketLayerCipherList returning cached Ciphers: " + cachedDefaultCiphers);
                }
                return cachedDefaultCiphers;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSecureSocketLayerCipherList cachedDefaultCiphers is null, proceed to determine the provider.");
            }
            if ((securityConfiguration = VaultImpl.getSecurityConfiguration()) != null && securityConfiguration.processIsServer() && (string2 = securityConfiguration.getCSIInboundSSLConfigAlias()) != null) {
                block12: {
                    try {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("com.ibm.ssl.direction", "inbound");
                        hashMap.put("com.ibm.ssl.endPointName", "IIOP");
                        sSLContext = JSSEHelper.getInstance().getSSLContext(string2, hashMap, null);
                    }
                    catch (SSLException sSLException) {
                        if (!tc.isDebugEnabled()) break block12;
                        Tr.debug(tc, "Error getting sslConfig for alias " + string2, new Object[]{sSLException});
                    }
                }
                if (sSLContext != null) {
                    stringArray = sSLContext.getServerSocketFactory().getDefaultCipherSuites();
                }
            }
        }
        if (stringArray == null) {
            stringArray = bl != false ? FIPS_CIPHER_SUITES_LIST : CIPHER_SUITES_LIST;
        }
        arrayList = new ArrayList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("SSL_RSA_WITH_NULL_MD5") || stringArray[i].equals("SSL_RSA_WITH_NULL_SHA") || stringArray[i].equals("SSL_DH_anon_WITH_AES_128_CBC_SHA") || stringArray[i].equals("SSL_DH_anon_WITH_RC4_128_MD5") || stringArray[i].equals("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA") || stringArray[i].equals("SSL_DH_anon_WITH_DES_CBC_SHA") || stringArray[i].equals("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5") || stringArray[i].equals("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA") || stringArray.equals("SSL_DH_anon_WITH_AES_256_CBC_SHA")) continue;
            arrayList.add(stringArray[i]);
        }
        if (arrayList != null && bl == bl2) {
            cachedDefaultCiphers = arrayList;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecureSocketLayerCipherList = " + arrayList);
        }
        return arrayList;
    }

    protected static InputStream openKeyStore(String string) throws MalformedURLException, IOException {
        try {
            OpenKeyStoreAction openKeyStoreAction = new OpenKeyStoreAction(string);
            return (InputStream)AccessController.doPrivileged(openKeyStoreAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception opening keystore.", new Object[]{exception});
            }
            if (exception instanceof MalformedURLException) {
                throw (MalformedURLException)exception;
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.getMessage());
        }
    }

    static class OpenKeyStoreAction
    implements PrivilegedExceptionAction {
        private String file = null;

        public OpenKeyStoreAction(String string) {
            this.file = string;
        }

        public Object run() throws MalformedURLException, IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "OpenKeyStoreAction.run");
            }
            InputStream inputStream = null;
            URL uRL = null;
            File file = new File(this.file);
            if (file.exists() && file.length() == 0L) {
                throw new IOException("Keystore file exists, but is empty: " + this.file);
            }
            uRL = !file.exists() ? new URL(this.file) : new URL("file:" + file.getCanonicalPath());
            inputStream = uRL.openStream();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "OpenKeyStoreAction.run");
            }
            return inputStream;
        }
    }
}

