/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.core;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordDecodingException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.SASPropFile;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class CSIClientProperties {
    private static final TraceComponent tc = Tr.register(CSIClientProperties.class);
    private static final String CONFIG_URL_PROPERTY_NAME = "com.ibm.CORBA.ConfigURL";
    private static final String[] CLIENT_AUTHN_TYPE_KEYS = new String[]{"com.ibm.CSI.performClientAuthenticationtype", "com.ibm.CSI.performClientAuthenticationType", "com.ibm.CORBA.authenticationTarget"};
    private static final String[] LOGIN_USERID_KEYS = new String[]{"com.ibm.CSI.Rem.Userid", "com.ibm.CORBA.loginUserid"};
    private static final String[] LOGIN_PASSWORD_KEYS = new String[]{"com.ibm.CSI.Rem.Password", "com.ibm.CORBA.loginPassword"};
    private static final String[] SSL_KEYRING_KEYS = new String[]{"com.ibm.CSI.performSSL.Keyring"};
    private static final int TRANSPORT_AUTHN_REQUIRED_MASK = 1;
    private static final int TRANSPORT_AUTHN_SUPPORTED_MASK = 2;
    private static final int SSL_REQUIRED_MASK = 4;
    private static final int SSL_SUPPORTED_MASK = 8;
    private static final int CLIENT_AUTHN_REQUIRED_MASK = 16;
    private static final int CLIENT_AUTHN_SUPPORTED_MASK = 32;
    private static final int CONFIDENTIALITY_REQUIRED_MASK = 64;
    private static final int CONFIDENTIALITY_SUPPORTED_MASK = 128;

    private CSIClientProperties() {
    }

    public static String[] getCSIProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCSIProperties");
        }
        Properties properties = CSIClientProperties.getCSIClientProps();
        int n = 0;
        String[] stringArray = new String[5];
        String string = CSIClientProperties.getProperty("com.ibm.CSI.performTransportAssocSSLTLSRequired", properties, "false");
        String string2 = CSIClientProperties.getProperty("com.ibm.CSI.performTransportAssocSSLTLSSupported", properties, "true");
        if (Boolean.valueOf(string) == Boolean.TRUE) {
            n |= 0xC;
        }
        if (Boolean.valueOf(string2) == Boolean.TRUE) {
            n |= 8;
        }
        String string3 = CSIClientProperties.getProperty("com.ibm.CSI.performTLClientAuthenticationRequired", properties, "false");
        String string4 = CSIClientProperties.getProperty("com.ibm.CSI.performTLClientAuthenticationSupported", properties, "true");
        if (Boolean.valueOf(string3) == Boolean.TRUE) {
            n |= 3;
        }
        if (Boolean.valueOf(string4) == Boolean.TRUE) {
            n |= 2;
        }
        String string5 = CSIClientProperties.getProperty("com.ibm.CSI.performMessageConfidentialityRequired", properties, "true");
        String string6 = CSIClientProperties.getProperty("com.ibm.CSI.performMessageConfidentialitySupported", properties, "true");
        if (Boolean.valueOf(string5) == Boolean.TRUE) {
            n |= 0xC0;
        }
        if (Boolean.valueOf(string6) == Boolean.TRUE) {
            n |= 0x80;
        }
        String string7 = CSIClientProperties.getProperty("com.ibm.CSI.performClientAuthenticationRequired", properties, "false");
        String string8 = CSIClientProperties.getProperty("com.ibm.CSI.performClientAuthenticationSupported", properties, "true");
        if (Boolean.valueOf(string7) == Boolean.TRUE) {
            n |= 0x30;
        }
        if (Boolean.valueOf(string8) == Boolean.TRUE) {
            n |= 0x20;
        }
        stringArray[0] = Integer.toString(n);
        stringArray[1] = CSIClientProperties.getProperty(CLIENT_AUTHN_TYPE_KEYS, properties, "BasicAuth");
        stringArray[3] = CSIClientProperties.getLoginUserID();
        stringArray[4] = CSIClientProperties.getLoginPassword();
        stringArray[2] = CSIClientProperties.getProperty(SSL_KEYRING_KEYS, properties, "");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCSIProperties", new Object[]{stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4] != null ? "xxxxx" : null});
        }
        return stringArray;
    }

    public static Properties getCSIClientProps() {
        Properties properties;
        block10: {
            block9: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "getCSIClientProps");
                }
                String string = System.getProperty(CONFIG_URL_PROPERTY_NAME);
                properties = new Properties();
                if (string != null) {
                    try {
                        InputStream inputStream = new URL(string).openStream();
                        properties.load(inputStream);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "read properties", properties);
                        }
                    }
                    catch (IOException iOException) {
                        if (!tc.isEventEnabled()) break block9;
                        Tr.event(tc, "Unable to load properties", iOException);
                    }
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "decoding property file passwords");
                }
                SASPropFile.decodePropPasswords(properties);
            }
            catch (InvalidPasswordDecodingException invalidPasswordDecodingException) {
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "Unable to decode passwords", (Object)invalidPasswordDecodingException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCSIClientProps", properties);
        }
        return properties;
    }

    public static String getLoginUserID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoginUserID");
        }
        Properties properties = CSIClientProperties.getCSIClientProps();
        String string = CSIClientProperties.getProperty(LOGIN_USERID_KEYS, properties, "");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoginUserID", string == null ? null : string);
        }
        return string;
    }

    public static String getLoginPassword() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoginPassword");
        }
        Properties properties = CSIClientProperties.getCSIClientProps();
        String string = CSIClientProperties.getProperty(LOGIN_PASSWORD_KEYS, properties, "");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoginPassword", string == null ? null : "****");
        }
        return string;
    }

    private static String getProperty(String[] stringArray, Properties properties, String string) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProperty", new Object[]{stringArray, properties, string});
        }
        String string2 = null;
        for (n = 0; n < stringArray.length && string2 == null; ++n) {
            string2 = System.getProperty(stringArray[n]);
        }
        for (n = 0; n < stringArray.length && string2 == null; ++n) {
            string2 = properties.getProperty(stringArray[n]);
        }
        if (string2 == null || string2.equals("")) {
            string2 = string;
        }
        if (tc.isEntryEnabled()) {
            n = 0;
            if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
                if (stringArray[0].indexOf("word") != -1) {
                    n = 1;
                } else if (stringArray[0].indexOf("Pass") != -1) {
                    n = 1;
                } else if (stringArray[0].indexOf("pass") != -1) {
                    n = 1;
                } else if (stringArray[0].indexOf("pw") != -1) {
                    n = 1;
                } else if (stringArray[0].indexOf("PW") != -1) {
                    n = 1;
                }
            }
            Tr.exit(tc, "getProperty", n == 0 ? string2 : "****");
        }
        return string2;
    }

    private static String getProperty(String string, Properties properties, String string2) {
        return CSIClientProperties.getProperty(new String[]{string}, properties, string2);
    }
}

