/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.KeyFileFormatKind;
import com.ibm.websphere.models.config.ipc.ssl.KeyManager;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.websphere.models.config.ipc.ssl.KeySetGroup;
import com.ibm.websphere.models.config.ipc.ssl.ManagementScope;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.ipc.ssl.SslFactory;
import com.ibm.websphere.models.config.ipc.ssl.SslPackage;
import com.ibm.websphere.models.config.ipc.ssl.TrustManager;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.jaaslogin.JAASLoginModule;
import com.ibm.websphere.models.config.orb.securityprotocol.CommonSecureInterop;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPSecurityProtocol;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPTransport;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportLayer;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.DynamicSSLConfigSelection;
import com.ibm.websphere.models.config.security.LocalOSUserRegistry;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.SSLConfigGroup;
import com.ibm.websphere.models.config.security.SSLType;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.SecurityPackage;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ssl.config.CertificateManager;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.config.ManagementScopeData;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.ssl.config.SSLConfigManager;
import com.ibm.ws.ssl.model.CertReqInfo;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class MergeSecurityConfig {
    private static TraceComponent tc = Tr.register(MergeSecurityConfig.class, null, "com.ibm.ejs.resources.security");
    private static ManagementScope cellScope = null;
    private static String DIST = "windows";
    private static String ZOS1 = "os390";
    private static String ZOS2 = "os400";
    private static String DefaultSSLSettings = "DefaultSSLSettings";
    private static String DefaultCellSSL = "CellDefaultSSLSettings";
    private static String DefaultNodeSSL = "NodeDefaultSSLSettings";
    private static String DefaultKeyStore = "DefaultKeyStore";
    private static String DefaultTrustStore = "DefaultTrustStore";
    private static String DefaultNodeLTPA = "NodeLTPA";
    private static String DefaultCellScope = "cell";
    private static String DefaultNodeScope = "node";
    private static String DefaultConfigCellsPath = "/config/cells/";
    private static String DefaultCellsPath = "/cells/";
    private static String DefaultNodesPath = "/nodes/";
    private static String DefaultEtcPath = "/etc";
    private static String DefaultP12KeyStore = "key.p12";
    private static String DefaultP12TrustStore = "trust.p12";
    private static String DefaultHostnameVariable = "${hostname}";

    public static Security merge(String string, String string2, Security security2, Security security3, String string3, String string4) throws Exception {
        return MergeSecurityConfig.merge(string, string2, security2, security3, string3, string4, DIST, DIST);
    }

    public static Security merge(String string, String string2, Security security2, Security security3, String string3, String string4, String string5, String string6) throws Exception {
        return MergeSecurityConfig.merge(string, string2, security2, security3, string3, string4, DIST, DIST, false, null);
    }

    public static Security merge(String string, String string2, Security security2, Security security3, String string3, String string4, String string5, String string6, boolean bl, String string7) throws Exception {
        CharSequence charSequence;
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        int n2;
        Object object11;
        Object object12;
        Iterator iterator;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge", new Object[]{string, string2, string3, string4, string5, string6, Boolean.toString(bl), string7});
        }
        if (security2 == null) {
            throw new Exception("Null cell level security object provided");
        }
        if (security3 == null) {
            throw new Exception("Null server level security object provided");
        }
        if (string3 == null) {
            throw new Exception("Null nodeName provided");
        }
        if (security2.isEnabled() && bl) {
            boolean bl2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding a older version node. Check for validSecurityConfig. ");
            }
            if (bl2 = MergeSecurityConfig.checkIfInternalServerIdUsed(security2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "InternalServerId is set in the dmgr config. Cannot add an older version node unless the serverID/passwd option is used. ");
                }
                throw new Exception("InternalServerId is used in the current dmgr config. Cannot add an older node. Modify the dmgr security config to use the serverID/passwd before adding an older version node");
            }
            if (!string5.equals(ZOS1) || !(security2.getActiveUserRegistry() instanceof LocalOSUserRegistry)) {
                boolean bl3 = MergeSecurityConfig.checkIfNullServerPasswordUsed(security2);
                if (bl3) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The server password is null or missing in the dmgr config. Cannot add an older version node unless the server password is entered. ");
                    }
                    throw new Exception("The server password is null or missing in the current dmgr config. Cannot add an older node. Modify the dmgr security config to use the server password before adding an older version node");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The dmgr security config check passed.");
                }
            }
        }
        string3 = "_" + string3 + "_";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Node name is " + string3);
        }
        if (security3.getApplicationLoginConfig() != null && security3.getApplicationLoginConfig().getEntries().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting JAAS configuration.");
            }
            EList eList = security2.getApplicationLoginConfig().getEntries();
            ArrayList<String> arrayList = null;
            if (eList != null && eList.size() > 0) {
                arrayList = new ArrayList<String>(eList.size());
                iterator = eList.iterator();
                while (iterator.hasNext()) {
                    object12 = (JAASConfigurationEntry)iterator.next();
                    arrayList.add(object12.getAlias());
                }
            }
            iterator = security3.getApplicationLoginConfig().getEntries();
            object12 = iterator.iterator();
            object11 = new ArrayList(iterator.size());
            while (object12.hasNext()) {
                JAASConfigurationEntry jAASConfigurationEntry = (JAASConfigurationEntry)object12.next();
                if (arrayList == null || !arrayList.contains(jAASConfigurationEntry.getAlias())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding JAAS alias: " + jAASConfigurationEntry.getAlias() + " to cell.");
                    }
                    object11.add(jAASConfigurationEntry);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding JAAS alias: " + jAASConfigurationEntry.getAlias() + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{jAASConfigurationEntry.getAlias()});
            }
            for (n2 = 0; n2 < object11.size(); ++n2) {
                object10 = (JAASConfigurationEntry)object11.get(n2);
                object9 = object10.eResource();
                object8 = null;
                if (object9 instanceof XMIResource) {
                    object8 = ((XMIResource)object9).getID((EObject)object10);
                }
                StringBuffer stringBuffer = null;
                if (object8 != null) {
                    int n3 = ((String)object8).indexOf(95);
                    StringBuffer stringBuffer2 = new StringBuffer((String)object8);
                    if (n3 != -1) {
                        stringBuffer = stringBuffer2.replace(n3, n3 + 1, string3);
                        ((XMIResource)object9).setID((EObject)object10, stringBuffer.toString());
                    } else {
                        stringBuffer = stringBuffer2.append(string3);
                        ((XMIResource)object9).setID((EObject)object10, stringBuffer.toString());
                    }
                }
                object7 = object10.getLoginModules();
                for (int i = 0; i < object7.size(); ++i) {
                    object6 = (JAASLoginModule)object7.get(i);
                    object5 = object6.getOptions();
                    object9 = object6.eResource();
                    if (object9 instanceof XMIResource) {
                        object8 = ((XMIResource)object9).getID((EObject)object6);
                    }
                    if (object8 != null) {
                        int n4 = ((String)object8).indexOf(95);
                        object4 = new StringBuffer((String)object8);
                        stringBuffer = null;
                        if (n4 != -1) {
                            stringBuffer = ((StringBuffer)object4).replace(n4, n4 + 1, string3);
                            ((XMIResource)object9).setID((EObject)object6, stringBuffer.toString());
                        } else {
                            stringBuffer = ((StringBuffer)object4).append(string3);
                            ((XMIResource)object9).setID((EObject)object6, stringBuffer.toString());
                        }
                    }
                    if (object5 == null) continue;
                    Iterator iterator2 = object5.iterator();
                    while (iterator2.hasNext()) {
                        object4 = (Property)iterator2.next();
                        object9 = object4.eResource();
                        object8 = null;
                        if (object9 instanceof XMIResource) {
                            object8 = ((XMIResource)object9).getID((EObject)object4);
                        }
                        if (object8 == null) continue;
                        object3 = new StringBuffer((String)object8);
                        int n5 = ((String)object8).indexOf(95);
                        if (n5 != -1) {
                            stringBuffer = ((StringBuffer)object3).replace(n5, n5 + 1, string3);
                            ((XMIResource)object9).setID((EObject)object4, stringBuffer.toString());
                            continue;
                        }
                        stringBuffer = ((StringBuffer)object3).append(string3);
                        ((XMIResource)object9).setID((EObject)object4, stringBuffer.toString());
                    }
                }
                security2.getApplicationLoginConfig().getEntries().add(object11.get(n2));
            }
        }
        if (security3.getAuthDataEntries() != null && security3.getAuthDataEntries().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting J2C configuration.");
            }
            EList eList = security2.getAuthDataEntries();
            ArrayList<String> arrayList = null;
            if (eList != null && eList.size() > 0) {
                arrayList = new ArrayList<String>(eList.size());
                iterator = eList.iterator();
                while (iterator.hasNext()) {
                    object12 = (JAASAuthData)iterator.next();
                    arrayList.add(object12.getAlias());
                }
            }
            iterator = security3.getAuthDataEntries();
            object12 = new ArrayList(iterator.size());
            object11 = iterator.iterator();
            while (object11.hasNext()) {
                JAASAuthData jAASAuthData = (JAASAuthData)object11.next();
                if (arrayList == null || !arrayList.contains(jAASAuthData.getAlias())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding J2C alias: " + jAASAuthData.getAlias() + " to cell.");
                    }
                    object12.add(jAASAuthData);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding J2C alias: " + jAASAuthData.getAlias() + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{jAASAuthData.getAlias()});
            }
            for (n2 = 0; n2 < object12.size(); ++n2) {
                object10 = (JAASAuthData)object12.get(n2);
                object9 = object10.eResource();
                object8 = null;
                if (object9 instanceof XMIResource) {
                    object8 = ((XMIResource)object9).getID((EObject)object10);
                }
                if (object8 != null) {
                    int n6 = ((String)object8).indexOf(95);
                    object7 = new StringBuffer((String)object8);
                    StringBuffer stringBuffer = null;
                    if (n6 != -1) {
                        stringBuffer = ((StringBuffer)object7).replace(n6, n6 + 1, string3);
                        ((XMIResource)object9).setID((EObject)object10, stringBuffer.toString());
                    } else {
                        stringBuffer = ((StringBuffer)object7).append(string3);
                        ((XMIResource)object9).setID((EObject)object10, stringBuffer.toString());
                    }
                }
                security2.getAuthDataEntries().add(object12.get(n2));
            }
        }
        if (security3.getManagementScopes() != null && security3.getManagementScopes().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting getManagementScopes configuration.");
            }
            EList eList = security2.getManagementScopes();
            ArrayList<String> arrayList = null;
            if (eList != null && eList.size() > 0) {
                arrayList = new ArrayList<String>(eList.size());
                iterator = eList.iterator();
                while (iterator.hasNext()) {
                    object12 = (ManagementScope)iterator.next();
                    if (object12 == null) continue;
                    object11 = object12.eResource();
                    String string8 = null;
                    if (object11 instanceof XMIResource) {
                        string8 = ((XMIResource)object11).getID((EObject)object12);
                    }
                    if (string8 == null) continue;
                    arrayList.add(object12.getScopeName());
                }
            }
            iterator = security3.getManagementScopes();
            object12 = iterator.iterator();
            object11 = new ArrayList(iterator.size());
            while (object12.hasNext()) {
                ManagementScope managementScope = (ManagementScope)object12.next();
                object10 = managementScope.eResource();
                object9 = null;
                if (object10 instanceof XMIResource) {
                    object9 = ((XMIResource)object10).getID(managementScope);
                }
                if (cellScope == null) {
                    cellScope = (ManagementScope)eList.get(0);
                }
                managementScope = MergeSecurityConfig.fixUpCell(managementScope, cellScope);
                if (arrayList == null || object9 != null && !arrayList.contains(managementScope.getScopeName())) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding ManagementScope alias: " + managementScope.getScopeName() + " to cell.");
                    }
                    object11.add(managementScope);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding ManagementScope alias: " + managementScope.getScopeName() + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{managementScope.getScopeName()});
            }
            for (n2 = 0; n2 < object11.size(); ++n2) {
                object10 = (ManagementScope)object11.get(n2);
                if (object10 == null) continue;
                security2.getManagementScopes().add(object10);
            }
        }
        String string9 = KeyStoreManager.getInstance().expand("${CONFIG_ROOT}");
        Object object13 = null;
        iterator = security2.getKeyStores();
        for (n = 0; n < iterator.size(); ++n) {
            object11 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)iterator.get(n);
            String string10 = object11.getManagementScope().getScopeType();
            if (string10 == null || !string10.equals(DefaultCellScope) || !object11.getName().endsWith(DefaultTrustStore)) continue;
            object13 = object11;
        }
        n = 0;
        object11 = null;
        Object object14 = null;
        if (security3.getRepertoire() != null && security3.getRepertoire().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting SSL configuration.");
            }
            object10 = security2.getRepertoire();
            object9 = null;
            if (object10 != null && object10.size() > 0) {
                object9 = new ArrayList(object10.size());
                object8 = object10.iterator();
                while (object8.hasNext()) {
                    Notifier notifier;
                    SSLConfig sSLConfig = (SSLConfig)object8.next();
                    object7 = sSLConfig.getAlias();
                    if (object7 != null && ((String)object7).equals(DefaultCellSSL)) {
                        notifier = sSLConfig.getSetting().getKeyStore();
                        object6 = sSLConfig.getSetting().getTrustStore();
                        if (notifier != null && object6 != null) {
                            if (notifier.getLocation() != null && notifier.isFileBased() && !notifier.isReadOnly() && notifier.getType() != null && !notifier.getType().equals("JCERACFKS") && !notifier.getType().equals("PKCS12")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting migration keystore to: " + notifier.getName());
                                }
                                object11 = notifier;
                                n = 1;
                            }
                            if (object6.getLocation() != null && object6.isFileBased() && !notifier.isReadOnly() && object6.getType() != null && !object6.getType().equals("JCERACFKS") && !object6.getType().equals("PKCS12")) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Setting migration truststore to: " + object6.getName());
                                }
                                object14 = object6;
                                n = 1;
                            }
                        }
                    }
                    notifier = sSLConfig.eResource();
                    object6 = null;
                    if (notifier instanceof XMIResource) {
                        object6 = ((XMIResource)notifier).getID(sSLConfig);
                    }
                    if (object6 == null) continue;
                    object5 = sSLConfig.getManagementScope() != null ? sSLConfig.getManagementScope().getScopeName() : object6;
                    object9.add(MergeSecurityConfig.getCellAliasKey(sSLConfig.getAlias(), object5));
                }
            }
            object8 = security3.getRepertoire();
            Iterator iterator3 = object8.iterator();
            object7 = new ArrayList(object8.size());
            while (iterator3.hasNext()) {
                Object object15;
                SSLConfig sSLConfig = (SSLConfig)iterator3.next();
                object6 = sSLConfig.getAlias();
                if (n != 0 && object6 != null && ((String)object6).equals(DefaultNodeSSL)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting alias " + object6 + " keystores to the cell keystores due to migration.");
                    }
                    sSLConfig.getSetting().setKeyStore((com.ibm.websphere.models.config.ipc.ssl.KeyStore)object11);
                    sSLConfig.getSetting().setTrustStore((com.ibm.websphere.models.config.ipc.ssl.KeyStore)object14);
                }
                if (sSLConfig.getType() == null || sSLConfig.getType().getName().equals("JSSE")) {
                    object5 = sSLConfig.getSetting().getKeyStore();
                    object15 = sSLConfig.getSetting().getTrustStore();
                    if (object5 != null && object15 != null) {
                        try {
                            object4 = MergeSecurityConfig.checkIfKeyStoreExistsAndCreateIfNot(object5, string9, string2, string4);
                            if (object4 != null) {
                                MergeSecurityConfig.checkIfTrustStoreExistsAndCreateIfNot((com.ibm.websphere.models.config.ipc.ssl.KeyStore)object15, string9, string2, (Certificate)object4);
                            }
                        }
                        catch (SSLException sSLException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception creating keystore or truststore.", new Object[]{sSLException});
                            }
                            Tr.error(tc, "security.merge.node.keystore.creation.failed", new Object[]{string3, sSLException.getMessage()});
                            throw sSLException;
                        }
                    }
                }
                if (object13 != null && object13.isFileBased() && !object13.isReadOnly()) {
                    sSLConfig = MergeSecurityConfig.replaceDefaultNodeTrustStoreWithCellTrustStore(sSLConfig, (com.ibm.websphere.models.config.ipc.ssl.KeyStore)object13);
                }
                sSLConfig = MergeSecurityConfig.replaceDummyKeyStoreWithCellKeyStoreIfNecessary(sSLConfig, security2.getKeyStores());
                object5 = sSLConfig.eResource();
                object15 = null;
                if (object5 instanceof XMIResource) {
                    object15 = ((XMIResource)object5).getID(sSLConfig);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server refID: " + (String)object15);
                }
                object4 = object15;
                if (sSLConfig.getManagementScope() != null) {
                    object3 = MergeSecurityConfig.fixUpCell(sSLConfig.getManagementScope(), cellScope);
                    object4 = object3.getScopeName();
                }
                if (object9 == null || !object9.contains(MergeSecurityConfig.getCellAliasKey(sSLConfig.getAlias(), (String)object4))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding SSL alias: " + MergeSecurityConfig.getCellAliasKey(sSLConfig.getAlias(), (String)object4) + " to cell.");
                    }
                    object7.add(sSLConfig);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding SSL alias: " + MergeSecurityConfig.getCellAliasKey(sSLConfig.getAlias(), (String)object4) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{sSLConfig.getAlias()});
            }
            for (int i = 0; i < object7.size(); ++i) {
                int n7;
                object6 = (SSLConfig)object7.get(i);
                object5 = object6.getSetting();
                CryptoHardwareToken cryptoHardwareToken = object5.getCryptoHardware();
                object4 = object5.getProperties();
                object3 = null;
                Resource resource = object6.eResource();
                object2 = null;
                if (resource instanceof XMIResource) {
                    object2 = ((XMIResource)resource).getID((EObject)object6);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Fixing refID: " + (String)object2);
                }
                if (object2 != null) {
                    n7 = ((String)object2).indexOf(95);
                    object = new StringBuffer((String)object2);
                    if (n7 != -1) {
                        object3 = ((StringBuffer)object).replace(n7, n7 + 1, string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fixed up refID: " + ((StringBuffer)object3).toString());
                        }
                        ((XMIResource)resource).setID((EObject)object6, ((StringBuffer)object3).toString());
                    } else {
                        object3 = ((StringBuffer)object).append(string3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Fixed up refID: " + ((StringBuffer)object3).toString());
                        }
                        ((XMIResource)resource).setID((EObject)object6, ((StringBuffer)object3).toString());
                    }
                }
                if (object5 != null) {
                    resource = object5.eResource();
                    object2 = null;
                    if (resource instanceof XMIResource) {
                        object2 = ((XMIResource)resource).getID((EObject)object5);
                    }
                    if (object2 != null) {
                        n7 = ((String)object2).indexOf(95);
                        object = new StringBuffer((String)object2);
                        if (n7 != -1) {
                            object3 = ((StringBuffer)object).replace(n7, n7 + 1, string3);
                            ((XMIResource)resource).setID((EObject)object5, ((StringBuffer)object3).toString());
                        } else {
                            object3 = ((StringBuffer)object).append(string3);
                            ((XMIResource)resource).setID((EObject)object5, ((StringBuffer)object3).toString());
                        }
                    }
                }
                if (cryptoHardwareToken != null) {
                    resource = cryptoHardwareToken.eResource();
                    object2 = null;
                    if (resource instanceof XMIResource) {
                        object2 = ((XMIResource)resource).getID(cryptoHardwareToken);
                    }
                    if (object2 != null) {
                        n7 = ((String)object2).indexOf(95);
                        object = new StringBuffer((String)object2);
                        if (n7 != -1) {
                            object3 = ((StringBuffer)object).replace(n7, n7 + 1, string3);
                            ((XMIResource)resource).setID(cryptoHardwareToken, ((StringBuffer)object3).toString());
                        } else {
                            object3 = ((StringBuffer)object).append(string3);
                            ((XMIResource)resource).setID(cryptoHardwareToken, ((StringBuffer)object3).toString());
                        }
                    }
                }
                if (object4 != null) {
                    Iterator iterator4 = object4.iterator();
                    while (iterator4.hasNext()) {
                        object = (Property)iterator4.next();
                        resource = object.eResource();
                        object2 = null;
                        if (resource instanceof XMIResource) {
                            object2 = ((XMIResource)resource).getID((EObject)object);
                        }
                        if (object2 == null) continue;
                        charSequence = new StringBuffer((String)object2);
                        int n8 = ((String)object2).indexOf(95);
                        if (n8 != -1) {
                            object3 = charSequence.replace(n8, n8 + 1, string3);
                            ((XMIResource)resource).setID((EObject)object, ((StringBuffer)object3).toString());
                            continue;
                        }
                        object3 = charSequence.append(string3);
                        ((XMIResource)resource).setID((EObject)object, ((StringBuffer)object3).toString());
                    }
                }
                security2.getRepertoire().add(object7.get(i));
            }
        }
        boolean bl4 = false;
        boolean bl5 = false;
        if (security3.getKeyStores() != null && security3.getKeyStores().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting KeyStore configuration.");
            }
            object8 = new ArrayList();
            EList eList = security2.getKeyStores();
            object7 = null;
            if (eList != null && eList.size() > 0) {
                object7 = new ArrayList(eList.size());
                Iterator iterator5 = eList.iterator();
                while (iterator5.hasNext()) {
                    object6 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)iterator5.next();
                    if (object6 == null) continue;
                    object5 = object6.eResource();
                    String string11 = null;
                    if (object5 instanceof XMIResource) {
                        string11 = ((XMIResource)object5).getID((EObject)object6);
                    }
                    if (string11 == null) continue;
                    object4 = object6.getManagementScope() != null ? object6.getManagementScope().getScopeName() : string11;
                    object7.add(MergeSecurityConfig.getCellAliasKey(object6.getName(), (String)object4));
                }
            }
            EList eList2 = security3.getKeyStores();
            object6 = eList2.iterator();
            object5 = new ArrayList(eList2.size());
            while (object6.hasNext()) {
                com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)object6.next();
                if (keyStore.getLocation().indexOf(DefaultConfigCellsPath) != -1 || keyStore.getLocation().indexOf(DefaultCellsPath) != -1) {
                    keyStore.setLocation(MergeSecurityConfig.fixUpKeyStoreCell(keyStore.getLocation()));
                }
                object4 = keyStore.eResource();
                object3 = null;
                if (object4 instanceof XMIResource) {
                    object3 = ((XMIResource)object4).getID(keyStore);
                }
                Object object16 = object3;
                if (keyStore.getManagementScope() != null) {
                    object2 = MergeSecurityConfig.fixUpCell(keyStore.getManagementScope(), cellScope);
                    object16 = object2.getScopeName();
                }
                if (object7 == null || object3 != null && !object7.contains(MergeSecurityConfig.getCellAliasKey(keyStore.getName(), (String)object16))) {
                    if (keyStore.getName().startsWith(DefaultNodeLTPA)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding KeyStore alias: " + MergeSecurityConfig.getCellAliasKey(keyStore.getName(), (String)object16) + " to cell.");
                    }
                    object5.add(keyStore);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding KeyStore alias: " + MergeSecurityConfig.getCellAliasKey(keyStore.getName(), (String)object16) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{keyStore.getName()});
            }
            for (int i = 0; i < object5.size(); ++i) {
                object4 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)object5.get(i);
                if (object4 == null) continue;
                security2.getKeyStores().add(object4);
            }
            EList eList3 = security2.getKeyStores();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total number of keystores = " + eList3.size());
            }
            for (int i = 0; i < eList3.size(); ++i) {
                com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore;
                int n9;
                String string12;
                object3 = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)eList3.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Looking at keystore " + object3.getName() + " (" + object3.getManagementScope().getScopeName() + ").");
                }
                if ((string12 = object3.getManagementScope().getScopeType()) != null && string12.equals(DefaultCellScope) && object3.getName().endsWith(DefaultKeyStore) && object3.isFileBased()) {
                    for (n9 = 0; n9 < eList3.size(); ++n9) {
                        keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)eList3.get(n9);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking at keystore " + keyStore.getName() + " (" + keyStore.getManagementScope().getScopeName() + ").");
                        }
                        if ((object = keyStore.getManagementScope().getScopeType()) == null || ((String)object).equals(DefaultCellScope) || !keyStore.getName().endsWith(DefaultTrustStore) || !keyStore.isFileBased()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exchanging signers from keystore " + object3.getName() + " in scope " + object3.getManagementScope().getScopeName() + " with truststore " + keyStore.getName() + " in scope " + keyStore.getManagementScope().getScopeName());
                        }
                        charSequence = MergeSecurityConfig.whichLocationKeyStoreExists(keyStore.getLocation(), string9, string2);
                        KeyStoreManager.getInstance().exchangeSigners(string9, (com.ibm.websphere.models.config.ipc.ssl.KeyStore)object3, (String)charSequence, keyStore);
                        bl4 = true;
                    }
                }
                if (string12 != null && !string12.equals(DefaultCellScope) && object3.getName().endsWith(DefaultKeyStore) && object3.isFileBased()) {
                    for (n9 = 0; n9 < eList3.size(); ++n9) {
                        keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)eList3.get(n9);
                        object = keyStore.getManagementScope().getScopeType();
                        if (object == null || !((String)object).equals(DefaultCellScope) || !keyStore.getName().endsWith(DefaultTrustStore) || !keyStore.isFileBased()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exchanging signers from keystore " + object3.getName() + " in scope " + object3.getManagementScope().getScopeName() + " with truststore " + keyStore.getName() + " in scope " + keyStore.getManagementScope().getScopeName());
                        }
                        charSequence = MergeSecurityConfig.whichLocationKeyStoreExists(object3.getLocation(), string9, string2);
                        KeyStoreManager.getInstance().exchangeSigners((String)charSequence, (com.ibm.websphere.models.config.ipc.ssl.KeyStore)object3, string9, keyStore);
                        bl5 = true;
                    }
                }
                if (!object3.getName().equals("CMSKeyStore") || !object3.isFileBased()) continue;
                for (n9 = 0; n9 < eList3.size(); ++n9) {
                    keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)eList3.get(n9);
                    if (!keyStore.getName().endsWith(DefaultKeyStore) || !keyStore.isFileBased() || object3.getManagementScope().getScopeName().equals(keyStore.getManagementScope().getScopeName())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exchanging signers from keystore " + keyStore.getName() + " with keystore " + object3.getName());
                    }
                    object = MergeSecurityConfig.whichLocationKeyStoreExists(object3.getLocation(), string9, string2);
                    charSequence = MergeSecurityConfig.whichLocationKeyStoreExists(keyStore.getLocation(), string9, string2);
                    KeyStoreManager.getInstance().exchangeSigners((String)charSequence, keyStore, (String)object, (com.ibm.websphere.models.config.ipc.ssl.KeyStore)object3);
                }
            }
        }
        if (!bl4) {
            Tr.info(tc, "security.merge.cell.signer.not.exchanged", new Object[]{string3});
        }
        if (!bl5) {
            Tr.info(tc, "security.merge.node.signer.not.exchanged", new Object[]{string3});
        }
        if (security3.getKeySets() != null && security3.getKeySets().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting KeySet configuration.");
            }
            object8 = security2.getKeySets();
            ArrayList<String> arrayList = null;
            if (object8 != null && object8.size() > 0) {
                arrayList = new ArrayList<String>(object8.size());
                object7 = object8.iterator();
                while (object7.hasNext()) {
                    KeySet keySet = (KeySet)object7.next();
                    if (keySet == null) continue;
                    object6 = keySet.eResource();
                    object5 = null;
                    if (object6 instanceof XMIResource) {
                        object5 = ((XMIResource)object6).getID(keySet);
                    }
                    if (object5 == null) continue;
                    Object object17 = keySet.getManagementScope() != null ? keySet.getManagementScope().getScopeName() : object5;
                    arrayList.add(MergeSecurityConfig.getCellAliasKey(keySet.getName(), (String)object17));
                }
            }
            object7 = security3.getKeySets();
            Iterator iterator6 = object7.iterator();
            object6 = new ArrayList(object7.size());
            while (iterator6.hasNext()) {
                object5 = (KeySet)iterator6.next();
                Resource resource = object5.eResource();
                String string13 = null;
                if (resource instanceof XMIResource) {
                    string13 = ((XMIResource)resource).getID((EObject)object5);
                }
                object3 = string13;
                if (object5.getManagementScope() != null) {
                    ManagementScope managementScope = MergeSecurityConfig.fixUpCell(object5.getManagementScope(), cellScope);
                    object3 = managementScope.getScopeName();
                }
                if (arrayList == null || string13 != null && !arrayList.contains(MergeSecurityConfig.getCellAliasKey(object5.getName(), (String)object3))) {
                    if (object5.getName().startsWith(DefaultNodeLTPA)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding KeySet alias: " + MergeSecurityConfig.getCellAliasKey(object5.getName(), (String)object3) + " to cell.");
                    }
                    object6.add(object5);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding KeySet alias: " + MergeSecurityConfig.getCellAliasKey(object5.getName(), (String)object3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{object5.getName()});
            }
            for (int i = 0; i < object6.size(); ++i) {
                KeySet keySet = (KeySet)object6.get(i);
                if (keySet == null) continue;
                security2.getKeySets().add(keySet);
            }
        }
        if (security3.getKeySetGroups() != null && security3.getKeySetGroups().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting KeySetGroup configuration.");
            }
            object8 = security2.getKeySetGroups();
            ArrayList<String> arrayList = null;
            if (object8 != null && object8.size() > 0) {
                arrayList = new ArrayList<String>(object8.size());
                object7 = object8.iterator();
                while (object7.hasNext()) {
                    String string14;
                    KeySetGroup keySetGroup = (KeySetGroup)object7.next();
                    if (keySetGroup == null) continue;
                    object6 = keySetGroup.eResource();
                    String string15 = null;
                    if (object6 instanceof XMIResource) {
                        string15 = ((XMIResource)object6).getID(keySetGroup);
                    }
                    String string16 = string14 = keySetGroup.getManagementScope() != null ? keySetGroup.getManagementScope().getScopeName() : string15;
                    if (string15 == null) continue;
                    arrayList.add(MergeSecurityConfig.getCellAliasKey(keySetGroup.getName(), string14));
                }
            }
            object7 = security3.getKeySetGroups();
            Iterator iterator7 = object7.iterator();
            object6 = new ArrayList(object7.size());
            while (iterator7.hasNext()) {
                KeySetGroup keySetGroup = (KeySetGroup)iterator7.next();
                Resource resource = keySetGroup.eResource();
                String string17 = null;
                if (resource instanceof XMIResource) {
                    string17 = ((XMIResource)resource).getID(keySetGroup);
                }
                object3 = string17;
                if (keySetGroup.getManagementScope() != null) {
                    ManagementScope managementScope = MergeSecurityConfig.fixUpCell(keySetGroup.getManagementScope(), cellScope);
                    object3 = managementScope.getScopeName();
                }
                if (arrayList == null || string17 != null && !arrayList.contains(MergeSecurityConfig.getCellAliasKey(keySetGroup.getName(), (String)object3))) {
                    if (keySetGroup.getName().startsWith(DefaultNodeLTPA)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding KeySetGroup alias: " + MergeSecurityConfig.getCellAliasKey(keySetGroup.getName(), (String)object3) + " to cell.");
                    }
                    object6.add(keySetGroup);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding KeySetGroup alias: " + MergeSecurityConfig.getCellAliasKey(keySetGroup.getName(), (String)object3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{keySetGroup.getName()});
            }
            for (int i = 0; i < object6.size(); ++i) {
                KeySetGroup keySetGroup = (KeySetGroup)object6.get(i);
                if (keySetGroup == null) continue;
                security2.getKeySetGroups().add(keySetGroup);
            }
        }
        if (security3.getDynamicSSLConfigSelections() != null && security3.getDynamicSSLConfigSelections().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting DynamicSSLConfigSelection configuration.");
            }
            object8 = security2.getDynamicSSLConfigSelections();
            ArrayList<String> arrayList = null;
            if (object8 != null && object8.size() > 0) {
                arrayList = new ArrayList<String>(object8.size());
                object7 = object8.iterator();
                while (object7.hasNext()) {
                    DynamicSSLConfigSelection dynamicSSLConfigSelection = (DynamicSSLConfigSelection)object7.next();
                    if (dynamicSSLConfigSelection == null) continue;
                    object6 = dynamicSSLConfigSelection.eResource();
                    String string18 = null;
                    if (object6 instanceof XMIResource) {
                        string18 = ((XMIResource)object6).getID(dynamicSSLConfigSelection);
                    }
                    if (string18 == null) continue;
                    String string19 = dynamicSSLConfigSelection.getManagementScope() != null ? dynamicSSLConfigSelection.getManagementScope().getScopeName() : string18;
                    arrayList.add(MergeSecurityConfig.getCellAliasKey(dynamicSSLConfigSelection.getName(), string19));
                }
            }
            object7 = security3.getDynamicSSLConfigSelections();
            Iterator iterator8 = object7.iterator();
            object6 = new ArrayList(object7.size());
            while (iterator8.hasNext()) {
                DynamicSSLConfigSelection dynamicSSLConfigSelection = (DynamicSSLConfigSelection)iterator8.next();
                Resource resource = dynamicSSLConfigSelection.eResource();
                String string20 = null;
                if (resource instanceof XMIResource) {
                    string20 = ((XMIResource)resource).getID(dynamicSSLConfigSelection);
                }
                object3 = string20;
                if (dynamicSSLConfigSelection.getManagementScope() != null) {
                    ManagementScope managementScope = MergeSecurityConfig.fixUpCell(dynamicSSLConfigSelection.getManagementScope(), cellScope);
                    object3 = managementScope.getScopeName();
                }
                if (arrayList == null || string20 != null && !arrayList.contains(MergeSecurityConfig.getCellAliasKey(dynamicSSLConfigSelection.getName(), (String)object3))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding DynamicSSLConfigSelection alias: " + MergeSecurityConfig.getCellAliasKey(dynamicSSLConfigSelection.getName(), (String)object3) + " to cell.");
                    }
                    object6.add(dynamicSSLConfigSelection);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding DynamicSSLConfigSelection alias: " + MergeSecurityConfig.getCellAliasKey(dynamicSSLConfigSelection.getName(), (String)object3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{dynamicSSLConfigSelection.getName()});
            }
            for (int i = 0; i < object6.size(); ++i) {
                DynamicSSLConfigSelection dynamicSSLConfigSelection = (DynamicSSLConfigSelection)object6.get(i);
                if (dynamicSSLConfigSelection == null) continue;
                security2.getDynamicSSLConfigSelections().add(dynamicSSLConfigSelection);
            }
        }
        if (security3.getKeyManagers() != null && security3.getKeyManagers().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting KeyManager configuration.");
            }
            object8 = security2.getKeyManagers();
            ArrayList<String> arrayList = null;
            if (object8 != null && object8.size() > 0) {
                arrayList = new ArrayList<String>(object8.size());
                object7 = object8.iterator();
                while (object7.hasNext()) {
                    KeyManager keyManager = (KeyManager)object7.next();
                    if (keyManager == null) continue;
                    object6 = keyManager.eResource();
                    String string21 = null;
                    if (object6 instanceof XMIResource) {
                        string21 = ((XMIResource)object6).getID(keyManager);
                    }
                    if (string21 == null) continue;
                    String string22 = keyManager.getManagementScope() != null ? keyManager.getManagementScope().getScopeName() : string21;
                    arrayList.add(MergeSecurityConfig.getCellAliasKey(keyManager.getName(), string22));
                }
            }
            object7 = security3.getKeyManagers();
            Iterator iterator9 = object7.iterator();
            object6 = new ArrayList(object7.size());
            while (iterator9.hasNext()) {
                KeyManager keyManager = (KeyManager)iterator9.next();
                Resource resource = keyManager.eResource();
                String string23 = null;
                if (resource instanceof XMIResource) {
                    string23 = ((XMIResource)resource).getID(keyManager);
                }
                object3 = string23;
                if (keyManager.getManagementScope() != null) {
                    ManagementScope managementScope = MergeSecurityConfig.fixUpCell(keyManager.getManagementScope(), cellScope);
                    object3 = managementScope.getScopeName();
                }
                if (arrayList == null || string23 != null && !arrayList.contains(MergeSecurityConfig.getCellAliasKey(keyManager.getName(), (String)object3))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding KeyManager alias: " + MergeSecurityConfig.getCellAliasKey(keyManager.getName(), (String)object3) + " to cell.");
                    }
                    object6.add(keyManager);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding KeyManager alias: " + MergeSecurityConfig.getCellAliasKey(keyManager.getName(), (String)object3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{keyManager.getName()});
            }
            for (int i = 0; i < object6.size(); ++i) {
                KeyManager keyManager = (KeyManager)object6.get(i);
                if (keyManager == null) continue;
                security2.getKeyManagers().add(keyManager);
            }
        }
        if (security3.getTrustManagers() != null && security3.getTrustManagers().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting TrustManager configuration.");
            }
            object8 = security2.getTrustManagers();
            ArrayList<String> arrayList = null;
            if (object8 != null && object8.size() > 0) {
                arrayList = new ArrayList<String>(object8.size());
                object7 = object8.iterator();
                while (object7.hasNext()) {
                    TrustManager trustManager = (TrustManager)object7.next();
                    if (trustManager == null) continue;
                    object6 = trustManager.eResource();
                    String string24 = null;
                    if (object6 instanceof XMIResource) {
                        string24 = ((XMIResource)object6).getID(trustManager);
                    }
                    if (string24 == null) continue;
                    String string25 = trustManager.getManagementScope() != null ? trustManager.getManagementScope().getScopeName() : string24;
                    arrayList.add(MergeSecurityConfig.getCellAliasKey(trustManager.getName(), string25));
                }
            }
            object7 = security3.getTrustManagers();
            Iterator iterator10 = object7.iterator();
            object6 = new ArrayList(object7.size());
            while (iterator10.hasNext()) {
                TrustManager trustManager = (TrustManager)iterator10.next();
                Resource resource = trustManager.eResource();
                String string26 = null;
                if (resource instanceof XMIResource) {
                    string26 = ((XMIResource)resource).getID(trustManager);
                }
                object3 = string26;
                if (trustManager.getManagementScope() != null) {
                    ManagementScope managementScope = MergeSecurityConfig.fixUpCell(trustManager.getManagementScope(), cellScope);
                    object3 = managementScope.getScopeName();
                }
                if (arrayList == null || string26 != null && !arrayList.contains(MergeSecurityConfig.getCellAliasKey(trustManager.getName(), (String)object3))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding TrustManager alias: " + MergeSecurityConfig.getCellAliasKey(trustManager.getName(), (String)object3) + " to cell.");
                    }
                    object6.add(trustManager);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding TrustManager alias: " + MergeSecurityConfig.getCellAliasKey(trustManager.getName(), (String)object3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{trustManager.getName()});
            }
            for (int i = 0; i < object6.size(); ++i) {
                TrustManager trustManager = (TrustManager)object6.get(i);
                if (trustManager == null) continue;
                security2.getTrustManagers().add(trustManager);
            }
        }
        if (security3.getSslConfigGroups() != null && security3.getSslConfigGroups().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting SSLConfigGroups configuration.");
            }
            object8 = security2.getSslConfigGroups();
            ArrayList<String> arrayList = null;
            if (object8 != null && object8.size() > 0) {
                arrayList = new ArrayList<String>(object8.size());
                object7 = object8.iterator();
                while (object7.hasNext()) {
                    SSLConfigGroup sSLConfigGroup = (SSLConfigGroup)object7.next();
                    if (sSLConfigGroup == null) continue;
                    object6 = sSLConfigGroup.eResource();
                    String string27 = null;
                    if (object6 instanceof XMIResource) {
                        string27 = ((XMIResource)object6).getID(sSLConfigGroup);
                    }
                    if (string27 == null) continue;
                    String string28 = sSLConfigGroup.getManagementScope() != null ? sSLConfigGroup.getManagementScope().getScopeName() : string27;
                    arrayList.add(MergeSecurityConfig.getCellAliasKey(sSLConfigGroup.getName() + ":" + sSLConfigGroup.getDirection(), string28));
                }
            }
            object7 = security3.getSslConfigGroups();
            Iterator iterator11 = object7.iterator();
            object6 = new ArrayList(object7.size());
            while (iterator11.hasNext()) {
                SSLConfigGroup sSLConfigGroup = (SSLConfigGroup)iterator11.next();
                Resource resource = sSLConfigGroup.eResource();
                String string29 = null;
                if (resource instanceof XMIResource) {
                    string29 = ((XMIResource)resource).getID(sSLConfigGroup);
                }
                object3 = string29;
                if (sSLConfigGroup.getManagementScope() != null) {
                    ManagementScope managementScope = MergeSecurityConfig.fixUpCell(sSLConfigGroup.getManagementScope(), cellScope);
                    object3 = managementScope.getScopeName();
                }
                if (arrayList == null || string29 != null && !arrayList.contains(MergeSecurityConfig.getCellAliasKey(sSLConfigGroup.getName() + ":" + sSLConfigGroup.getDirection(), (String)object3))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding SSLConfigGroup alias: " + MergeSecurityConfig.getCellAliasKey(sSLConfigGroup.getName() + ":" + sSLConfigGroup.getDirection(), (String)object3) + " to cell.");
                    }
                    object6.add(sSLConfigGroup);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Adding SSLConfigGroup alias: " + MergeSecurityConfig.getCellAliasKey(sSLConfigGroup.getName() + ":" + sSLConfigGroup.getDirection(), (String)object3) + " to cell.");
                }
                Tr.info(tc, "security.merge.notadded", new Object[]{sSLConfigGroup.getName()});
            }
            for (int i = 0; i < object6.size(); ++i) {
                SSLConfigGroup sSLConfigGroup = (SSLConfigGroup)object6.get(i);
                if (sSLConfigGroup == null) continue;
                security2.getSslConfigGroups().add(sSLConfigGroup);
            }
        }
        if (string5.equals(ZOS1) || string5.equals(ZOS2) || string6.equals(ZOS1) || string6.equals(ZOS2)) {
            if (!MergeSecurityConfig.iiopPropExists(security2)) {
                object8 = null;
                String string30 = null;
                object7 = null;
                object7 = string5.equals(ZOS1) || string5.equals(ZOS2) ? security2 : security3;
                object8 = MergeSecurityConfig.getIIOPClaimSSLAlias(object7);
                string30 = MergeSecurityConfig.getIIOPPerformSSLAlias((Security)object7);
                if (string5.equals(ZOS1) || string6.equals(ZOS1)) {
                    MergeSecurityConfig.createZOSProperties(security2, (String)object8, string30);
                }
            }
            if (string5.equals(ZOS1)) {
                String string31;
                MergeSecurityConfig.mergeIBMProtocolToCell(security2, security3);
                object8 = MergeSecurityConfig.getIIOPClaimSSLAlias(security2);
                if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, (String)object8)) {
                    String string32 = MergeSecurityConfig.getIIOPClaimSSLAlias(security3);
                    MergeSecurityConfig.setIIOPClaimSSLAlias(security2, string32);
                }
                if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, string31 = MergeSecurityConfig.getIIOPPerformSSLAlias(security2))) {
                    object7 = MergeSecurityConfig.getIIOPPerformSSLAlias(security3);
                    MergeSecurityConfig.setIIOPPerformSSLAlias(security2, (String)object7);
                }
            }
        } else if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Fixed up SSL alias for previous node version");
            }
            object8 = null;
            String string33 = null;
            object7 = null;
            object8 = MergeSecurityConfig.getIIOPClaimSSLAlias(security2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI existingClaimSSLAlias = " + (String)object8);
            }
            if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, (String)object8)) {
                string33 = MergeSecurityConfig.getIIOPClaimSSLAlias(security3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CSI claimSSLAlias = " + string33);
                }
                MergeSecurityConfig.setIIOPClaimSSLAlias(security2, string33);
            }
            String string34 = MergeSecurityConfig.getIIOPPerformSSLAlias(security2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI existingPerformSSLAlias = " + string34);
            }
            if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, string34)) {
                object7 = MergeSecurityConfig.getIIOPPerformSSLAlias(security3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CSI performSSLAlias = " + (String)object7);
                }
                MergeSecurityConfig.setIIOPPerformSSLAlias(security2, (String)object7);
            }
            MergeSecurityConfig.mergeIBMProtocolToCell(security2, security3, bl);
            object8 = MergeSecurityConfig.getIIOPClaimSSLAlias(security2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IBM existingClaimSSLAlias = " + (String)object8);
            }
            if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, (String)object8)) {
                string33 = MergeSecurityConfig.getIIOPClaimSSLAlias(security3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IBM claimSSLAlias = " + string33);
                }
                MergeSecurityConfig.setIIOPClaimSSLAlias(security2, string33);
            }
            if (!MergeSecurityConfig.isJSSETypeFromCellRepertoire(security2, string34 = MergeSecurityConfig.getIIOPPerformSSLAlias(security2))) {
                object7 = MergeSecurityConfig.getIIOPPerformSSLAlias(security3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IBM performSSLAlias = " + (String)object7);
                }
                MergeSecurityConfig.setIIOPPerformSSLAlias(security2, (String)object7);
            }
        }
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "create Dmgr_node/DefaultSSLSettings if not exist for older version node");
            }
            object8 = string7 + "/" + DefaultSSLSettings;
            MergeSecurityConfig.createDmgrDefaultSSLSettings(security2, (String)object8);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "merging custom properties");
        }
        object8 = security2.getProperties();
        EList eList = security3.getProperties();
        for (int i = 0; i < eList.size(); ++i) {
            Property property = (Property)eList.get(i);
            boolean bl6 = false;
            for (int j = 0; j < object8.size(); ++j) {
                Property property2 = (Property)object8.get(j);
                if (!property2.getName().equals(property.getName())) continue;
                bl6 = true;
            }
            if (!bl6) {
                MergeSecurityConfig.modifyProp(property, string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + property.getName() + "=" + property.getValue() + "to cell");
                }
                object8.add(property);
                continue;
            }
            Tr.info(tc, "security.merge.notadded", new Object[]{property.getName()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "merge");
        }
        return security2;
    }

    private static boolean isJSSETypeFromCellRepertoire(Security security2, String string) {
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isJSSETypeFromCellRepertoire");
        }
        if ((eList = security2.getRepertoire()) != null && eList.size() > 0) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                SSLConfig sSLConfig = (SSLConfig)iterator.next();
                if (!sSLConfig.getAlias().equals(string)) continue;
                SSLType sSLType = sSLConfig.getType();
                if (sSLType.getValue() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "isJSSETypeFromCellRepertoire: true");
                    }
                    return true;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isJSSETypeFromCellRepertoire: false (type is SSSL)");
                }
                return false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isJSSETypeFromCellRepertoire: false (entry not found)");
        }
        return false;
    }

    private static void mergeIBMProtocolToCell(Security security2, Security security3) {
        MergeSecurityConfig.mergeIBMProtocolToCell(security2, security3, false);
    }

    private static void mergeIBMProtocolToCell(Security security2, Security security3, boolean bl) {
        IIOPSecurityProtocol iIOPSecurityProtocol;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mergeIBMProtocolToCell");
        }
        if ((iIOPSecurityProtocol = security2.getIBM()) != null && !bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "nothing to do, IBM protocol information already exists");
            }
            return;
        }
        IIOPSecurityProtocol iIOPSecurityProtocol2 = security3.getIBM();
        if (iIOPSecurityProtocol2 != null) {
            security2.setIBM(iIOPSecurityProtocol2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeIBMProtocolToCell");
        }
    }

    private static void modifyProp(Property property, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "modifyProp " + property + " " + string);
        }
        Resource resource = property.eResource();
        String string2 = null;
        StringBuffer stringBuffer = null;
        if (resource instanceof XMIResource) {
            string2 = ((XMIResource)resource).getID(property);
        }
        if (string2 != null) {
            StringBuffer stringBuffer2 = new StringBuffer(string2);
            int n = string2.indexOf(95);
            if (n != -1) {
                stringBuffer = stringBuffer2.replace(n, n + 1, string);
                ((XMIResource)resource).setID(property, stringBuffer.toString());
            } else {
                stringBuffer = stringBuffer2.append(string);
                ((XMIResource)resource).setID(property, stringBuffer.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "modifyProp " + property);
        }
    }

    private static void createZOSProperties(Security security2, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createZOSProperties " + string + " " + string2);
        }
        PropertiesPackage propertiesPackage = PropertiesPackage.eINSTANCE;
        PropertiesFactory propertiesFactory = propertiesPackage.getPropertiesFactory();
        Property property = propertiesFactory.createProperty();
        Property property2 = propertiesFactory.createProperty();
        property.setName("was.com.ibm.websphere.security.zos.csiv2.inbound.transport.sslconfig");
        property2.setName("was.com.ibm.websphere.security.zos.csiv2.outbound.transport.sslconfig");
        property.setValue(string);
        property2.setValue(string2);
        EList eList = security2.getProperties();
        eList.add(property);
        eList.add(property2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createZOSProperties");
        }
    }

    private static boolean iiopPropExists(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "iiopPropExists " + security2);
        }
        boolean bl = false;
        EList eList = security2.getProperties();
        for (int i = 0; i < eList.size(); ++i) {
            Property property = (Property)eList.get(i);
            if (!property.getName().equals("was.com.ibm.websphere.security.zos.csiv2.inbound.transport.sslconfig")) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "iiopPropExists " + bl);
        }
        return bl;
    }

    private static String getIIOPClaimSSLAlias(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIIOPClaimSSLAlias " + security2);
        }
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
        CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getClaims();
        EList eList = commonSecureInterop.getLayers();
        Object var4_4 = null;
        Object object = eList.iterator();
        while (object.hasNext() && !((var4_4 = object.next()) instanceof TransportLayer)) {
        }
        object = var4_4;
        IIOPTransport iIOPTransport = object.getServerAuthentication();
        String string = iIOPTransport.getSslConfig();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIIOPClaimSSLAlias " + string);
        }
        return string;
    }

    private static void setIIOPClaimSSLAlias(Security security2, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIIOPClaimSSLAlias with alias: " + string + ", into cell security.xml: " + security2);
        }
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
        CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getClaims();
        EList eList = commonSecureInterop.getLayers();
        Object var5_5 = null;
        Object object = eList.iterator();
        while (object.hasNext() && !((var5_5 = object.next()) instanceof TransportLayer)) {
        }
        object = var5_5;
        IIOPTransport iIOPTransport = object.getServerAuthentication();
        iIOPTransport.setSslConfig(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIIOPClaimSSLAlias");
        }
    }

    private static String getIIOPPerformSSLAlias(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIIOPPerformSSLAlias " + security2);
        }
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
        CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getPerforms();
        EList eList = commonSecureInterop.getLayers();
        Object var4_4 = null;
        Object object = eList.iterator();
        while (object.hasNext() && !((var4_4 = object.next()) instanceof TransportLayer)) {
        }
        object = var4_4;
        IIOPTransport iIOPTransport = object.getServerAuthentication();
        String string = iIOPTransport.getSslConfig();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIIOPPerformSSLAlias " + string);
        }
        return string;
    }

    private static ManagementScope fixUpCell(ManagementScope managementScope, ManagementScope managementScope2) {
        String string = managementScope.getScopeName();
        ManagementScopeData managementScopeData = new ManagementScopeData(string);
        string = managementScope2.getScopeName();
        ManagementScopeData managementScopeData2 = new ManagementScopeData(string);
        managementScopeData.setCellName(managementScopeData2.getCellName());
        String string2 = managementScopeData.formFullScope();
        managementScope.setScopeName(string2);
        return managementScope;
    }

    private static String fixUpKeyStoreCell(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Original keyStoreLocation: " + string);
        }
        String string2 = ManagementScopeManager.getInstance().getCellName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell name: " + string2);
        }
        int n = string.indexOf(DefaultConfigCellsPath);
        String string3 = string;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (n != -1) {
            string4 = string.substring(0, n + DefaultConfigCellsPath.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "First part: " + string4);
            }
            string5 = string.substring(n + DefaultConfigCellsPath.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The rest: " + string5);
            }
        } else {
            n = string.lastIndexOf(DefaultCellsPath);
            if (n != -1) {
                string4 = string.substring(0, n + DefaultCellsPath.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "First part: " + string4);
                }
                string5 = string.substring(n + DefaultCellsPath.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The rest: " + string5);
                }
            }
        }
        if (string4 != null && string5 != null) {
            if (string5.indexOf(DefaultNodesPath) != -1) {
                n = string5.indexOf(DefaultNodesPath);
                string6 = string5.substring(n + DefaultNodesPath.length());
                string3 = string4 + string2 + DefaultNodesPath + string6;
            } else {
                n = string5.indexOf("/");
                string6 = string5.substring(n + "/".length());
                string3 = string4 + string2 + "/" + string6;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Last part: " + string6);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Fixed up location: " + string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New keystore location: " + string3);
        }
        return string3;
    }

    private static void setIIOPPerformSSLAlias(Security security2, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIIOPPerformSSLAlias with alias: " + string + ", into cell security.xml: " + security2);
        }
        IIOPSecurityProtocol iIOPSecurityProtocol = security2.getCSI();
        CommonSecureInterop commonSecureInterop = (CommonSecureInterop)iIOPSecurityProtocol.getPerforms();
        EList eList = commonSecureInterop.getLayers();
        Object var5_5 = null;
        Object object = eList.iterator();
        while (object.hasNext() && !((var5_5 = object.next()) instanceof TransportLayer)) {
        }
        object = var5_5;
        IIOPTransport iIOPTransport = object.getServerAuthentication();
        iIOPTransport.setSslConfig(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIIOPPerformSSLAlias");
        }
    }

    private static SSLConfig replaceDefaultNodeTrustStoreWithCellTrustStore(SSLConfig sSLConfig, com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore) {
        com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceDefaultNodeTrustStoreWithCellTrustStore", new Object[]{sSLConfig.getAlias(), keyStore.getName()});
        }
        if (sSLConfig.getType() != null && sSLConfig.getType() == SSLType.SSSL_LITERAL) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary (type=SSSL)");
            }
            return sSLConfig;
        }
        SecureSocketLayer secureSocketLayer = sSLConfig.getSetting();
        if (secureSocketLayer != null && (keyStore2 = secureSocketLayer.getTrustStore()) != null && keyStore2.getName().endsWith(DefaultTrustStore)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Replacing Node TrustStore with Cell TrustStore.");
            }
            secureSocketLayer.setTrustStore(keyStore);
            sSLConfig.setSetting(secureSocketLayer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary");
        }
        return sSLConfig;
    }

    private static SSLConfig replaceDummyKeyStoreWithCellKeyStoreIfNecessary(SSLConfig sSLConfig, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary", new Object[]{sSLConfig.getAlias()});
        }
        if (sSLConfig.getType() != null && sSLConfig.getType() == SSLType.SSSL_LITERAL) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary (type=SSSL)");
            }
            return sSLConfig;
        }
        SecureSocketLayer secureSocketLayer = sSLConfig.getSetting();
        if (secureSocketLayer != null) {
            String string = secureSocketLayer.getKeyFileName();
            if (string != null && string.endsWith("DummyServerKeyFile.jks")) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)iterator.next();
                    if (keyStore == null) continue;
                    String string2 = keyStore.getName();
                    String string3 = keyStore.getManagementScope().getScopeType();
                    if (string3 != null && string3.equals(DefaultCellScope) && string2 != null && string2.endsWith(DefaultKeyStore)) {
                        secureSocketLayer.setKeyFileName(MergeSecurityConfig.fixupNodeConfigRoot(string, keyStore.getLocation()));
                        secureSocketLayer.setKeyFilePassword(keyStore.getPassword());
                        secureSocketLayer.setKeyFileFormat(KeyFileFormatKind.get(keyStore.getType()));
                    }
                    if (string3 != null && string3.equals(DefaultCellScope) && string2 != null && string2.endsWith(DefaultTrustStore)) {
                        secureSocketLayer.setTrustFileName(MergeSecurityConfig.fixupNodeConfigRoot(string, keyStore.getLocation()));
                        secureSocketLayer.setTrustFilePassword(keyStore.getPassword());
                        secureSocketLayer.setTrustFileFormat(KeyFileFormatKind.get(keyStore.getType()));
                    }
                    sSLConfig.setSetting(secureSocketLayer);
                }
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary (not a dummy keystore)");
                }
                return sSLConfig;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceDummyKeyStoreWithCellKeyStoreIfNecessary");
        }
        return sSLConfig;
    }

    private static String fixupNodeConfigRoot(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupNodeConfigRoot", new Object[]{string, string2});
        }
        String string3 = string;
        int n = string2.indexOf(DefaultConfigCellsPath);
        if (n != -1) {
            String string4 = string2.substring(n);
            int n2 = string.indexOf(DefaultEtcPath);
            if (n2 != -1) {
                String string5 = string.substring(0, n2);
                string3 = string5 + string4;
            }
        } else {
            int n3 = string2.lastIndexOf(DefaultCellsPath);
            if (n3 != -1) {
                String string6 = string2.substring(n3);
                int n4 = string.indexOf(DefaultEtcPath);
                if (n4 != -1) {
                    String string7 = string.substring(0, n4);
                    string3 = string7 + "/config" + string6;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupNodeConfigRoot -> " + string3);
        }
        return string3;
    }

    public static Certificate checkIfKeyStoreExistsAndCreateIfNot(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore, String string, String string2, String string3) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfKeyStoreExistsAndCreateIfNot");
        }
        boolean bl = keyStore.isFileBased();
        String string4 = keyStore.getLocation();
        String string5 = keyStore.getName();
        String string6 = keyStore.getManagementScope().getScopeType();
        if (string5 != null && string5.endsWith(DefaultKeyStore) && string6 != null && !string6.equals(DefaultCellScope) && bl) {
            string4 = MergeSecurityConfig.fixupLocationWithRepositoryRoot(string2, string4);
            File file = new File(string4 = MergeSecurityConfig.fixUpKeyStoreCell(string4));
            if (file.exists()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot -> (exists)");
                }
                return null;
            }
            try {
                string4 = MergeSecurityConfig.checkForLocationInRepositoryRootMakeDirectoryIfNecessary(string, keyStore.getLocation());
                String string7 = string5;
                String string8 = keyStore.getPassword();
                String string9 = keyStore.getType();
                String string10 = keyStore.getProvider();
                String string11 = keyStore.getManagementScope().getScopeName();
                Boolean bl2 = Boolean.TRUE;
                Boolean bl3 = Boolean.TRUE;
                Boolean bl4 = Boolean.FALSE;
                Boolean bl5 = Boolean.TRUE;
                KeyStoreInfo keyStoreInfo = new KeyStoreInfo(string7, string4, string8, string10, string9, bl3, null, string11, null, bl4, bl5, bl2, null, new Integer(0), Boolean.FALSE, null);
                String string12 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqAlias", "default");
                String string13 = null;
                string13 = string12 != null ? string12 : "default";
                String string14 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqKeySize", "1024");
                String string15 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqSubjectDN", "cn=${hostname},o=IBM,c=US");
                string15 = string15.indexOf(DefaultHostnameVariable) != -1 && string3 != null ? MergeSecurityConfig.expandHostNameVariable(string15, string3) : KeyStoreManager.getInstance().expand(string15);
                String string16 = SSLConfigManager.getInstance().getGlobalProperty("com.ibm.ssl.defaultCertReqDays", "365");
                int n = new Integer(string14);
                int n2 = new Integer(string16);
                CertReqInfo certReqInfo = new CertReqInfo(string13, n, string15, n2, keyStoreInfo, null);
                Certificate certificate = CertificateManager.getInstance().selfSignedCertificateCreate(certReqInfo);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot");
                }
                return certificate;
            }
            catch (Exception exception) {
                if (exception instanceof SSLException) {
                    throw (SSLException)exception;
                }
                throw new SSLException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfKeyStoreExistsAndCreateIfNot (not filebased or in config root)");
        }
        return null;
    }

    private static String expandHostNameVariable(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expandHostNameVariable", new Object[]{string, string2});
        }
        String string3 = string;
        int n = string.indexOf(DefaultHostnameVariable);
        if (n != -1) {
            String string4 = string.substring(0, n);
            String string5 = string.substring(n + DefaultHostnameVariable.length());
            if (string4 != null && !string4.equals("") && string5 != null && !string5.equals("")) {
                string3 = string4 + string2 + string5;
            } else if (string4 != null && !string4.equals("")) {
                string3 = string4 + string2;
            } else if (string5 != null && !string5.equals("")) {
                string3 = string2 + string5;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expandHostNameVariable -> " + string3);
        }
        return string3;
    }

    public static void checkIfTrustStoreExistsAndCreateIfNot(com.ibm.websphere.models.config.ipc.ssl.KeyStore keyStore, String string, String string2, Certificate certificate) throws SSLException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfTrustStoreExistsAndCreateIfNot");
        }
        boolean bl = keyStore.isFileBased();
        String string3 = keyStore.getLocation();
        String string4 = keyStore.getName();
        String string5 = keyStore.getManagementScope().getScopeType();
        if (string4 != null && string4.endsWith(DefaultTrustStore) && string5 != null && !string5.equals(DefaultCellScope) && bl) {
            string3 = MergeSecurityConfig.fixupLocationWithRepositoryRoot(string2, string3);
            File file = new File(string3 = MergeSecurityConfig.fixUpKeyStoreCell(string3));
            if (file.exists()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot -> (exists)");
                }
                return;
            }
            try {
                string3 = MergeSecurityConfig.checkForLocationInRepositoryRootMakeDirectoryIfNecessary(string, keyStore.getLocation());
                String string6 = string4;
                String string7 = keyStore.getPassword();
                String string8 = keyStore.getType();
                String string9 = keyStore.getProvider();
                String string10 = keyStore.getManagementScope().getScopeName();
                KeyStore keyStore2 = KeyStoreManager.getInstance().getKeyStore(string6, string8, string9, string3, string7, string10, true, null);
                String string11 = "default_signer";
                if (keyStore2 != null) {
                    keyStore2.setCertificateEntry(string11, certificate);
                    FileOutputStream fileOutputStream = new FileOutputStream(string3);
                    keyStore2.store(fileOutputStream, string7.toCharArray());
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot (signer set)");
                    }
                    return;
                }
            }
            catch (Exception exception) {
                if (exception instanceof SSLException) {
                    throw (SSLException)exception;
                }
                throw new SSLException(exception.getMessage(), exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfTrustStoreExistsAndCreateIfNot (not filebased or in config root)");
        }
    }

    private static String checkForLocationInRepositoryRootMakeDirectoryIfNecessary(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkForLocationInRepositoryRootMakeDirectoryIfNecessary", new Object[]{string, string2});
        }
        String string3 = MergeSecurityConfig.fixupLocationWithRepositoryRoot(string, string2);
        string3 = MergeSecurityConfig.fixUpKeyStoreCell(string3);
        String string4 = MergeSecurityConfig.stripFileFromPath(string3);
        File file = new File(string4);
        boolean bl = false;
        if (!file.exists()) {
            bl = file.mkdirs();
        }
        if (!bl && tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not create the directory to add the keyfile.  AddNode is going to fail.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForLocationInRepositoryRootMakeDirectoryIfNecessary");
        }
        return string3;
    }

    private static String stripFileFromPath(String string) {
        int n = string.lastIndexOf("/");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private static String whichLocationKeyStoreExists(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "whichLocationKeyStoreExists");
        }
        String string4 = MergeSecurityConfig.fixupLocationWithRepositoryRoot(string3, string);
        File file = new File(string4 = MergeSecurityConfig.fixUpKeyStoreCell(string4));
        if (file.exists()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "whichLocationKeyStoreExists -> " + string3);
            }
            return string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "whichLocationKeyStoreExists -> " + string2);
        }
        return string2;
    }

    private static String fixupLocationWithRepositoryRoot(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fixupLocationWithRepositoryRoot", new Object[]{string, string2});
        }
        int n = string2.lastIndexOf(DefaultCellsPath);
        String string3 = string2;
        if (n != -1) {
            String string4 = string2.substring(n);
            string3 = string + string4;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fixupLocationWithRepositoryRoot -> " + string3);
        }
        return string3;
    }

    private static String getCellAliasKey(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(":");
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCellAliasKey -> " + string3);
        }
        return string3;
    }

    private static void createDmgrDefaultSSLSettings(Security security2, String string) {
        Object object;
        Object object2;
        Notifier notifier;
        Object object3;
        Object object4;
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDmgrDefaultSSLSettings(" + string + ")");
        }
        if ((eList = security2.getRepertoire()) != null && eList.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "search" + string);
            }
            object4 = eList.iterator();
            while (object4.hasNext()) {
                object3 = (SSLConfig)object4.next();
                notifier = object3.eResource();
                object2 = null;
                if (notifier instanceof XMIResource) {
                    object2 = ((XMIResource)notifier).getID((EObject)object3);
                }
                if (object2 == null || !string.equals(object3.getAlias())) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found: " + string + "  Cell refID: " + (String)object2);
                }
                return;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "search" + DefaultCellSSL);
        }
        object4 = null;
        object3 = eList.iterator();
        while (object3.hasNext()) {
            notifier = (SSLConfig)object3.next();
            object2 = notifier.eResource();
            object = null;
            if (object2 instanceof XMIResource) {
                object = ((XMIResource)object2).getID((EObject)notifier);
            }
            if (object == null || !DefaultCellSSL.equals(notifier.getAlias())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found: " + DefaultCellSSL + "  Cell refID: " + (String)object);
            }
            object4 = notifier;
            break;
        }
        if (object4 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "add " + string);
            }
            notifier = SecurityPackage.eINSTANCE;
            object2 = notifier.getSecurityFactory();
            object = SslPackage.eINSTANCE;
            SslFactory sslFactory = object.getSslFactory();
            SSLConfig sSLConfig = object2.createSSLConfig();
            SecureSocketLayer secureSocketLayer = sslFactory.createSecureSocketLayer();
            SecureSocketLayer secureSocketLayer2 = object4.getSetting();
            sSLConfig.setAlias(string);
            sSLConfig.setManagementScope(object4.getManagementScope());
            secureSocketLayer.setClientAuthentication(secureSocketLayer2.isClientAuthentication());
            secureSocketLayer.setSecurityLevel(secureSocketLayer2.getSecurityLevel());
            secureSocketLayer.setEnableCryptoHardwareSupport(secureSocketLayer2.isEnableCryptoHardwareSupport());
            secureSocketLayer.setEnabledCiphers(secureSocketLayer2.getEnabledCiphers());
            secureSocketLayer.setJsseProvider(secureSocketLayer2.getJsseProvider());
            secureSocketLayer.setClientAuthenticationSupported(secureSocketLayer2.isClientAuthenticationSupported());
            secureSocketLayer.setSslProtocol(secureSocketLayer2.getSslProtocol());
            EList eList2 = secureSocketLayer2.getTrustManager();
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                TrustManager trustManager = (TrustManager)iterator.next();
                secureSocketLayer.getTrustManager().add(trustManager);
            }
            secureSocketLayer.setKeyManager(secureSocketLayer2.getKeyManager());
            secureSocketLayer.setKeyStore(secureSocketLayer2.getKeyStore());
            secureSocketLayer.setTrustStore(secureSocketLayer2.getTrustStore());
            sSLConfig.setSetting(secureSocketLayer);
            security2.getRepertoire().add(sSLConfig);
        }
    }

    public static Security updateCellNameAndNodeName(Security security2, String string, String string2) {
        EObject eObject;
        Iterator iterator;
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCellNameAndNodeName");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell name: " + string + "Node name: " + string2);
        }
        if (security2.getKeyStores() != null && security2.getKeyStores().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting new cell name & node name for KeyStore.");
            }
            if ((eList = security2.getKeyStores()) != null) {
                iterator = eList.iterator();
                while (iterator.hasNext()) {
                    eObject = (com.ibm.websphere.models.config.ipc.ssl.KeyStore)iterator.next();
                    if (eObject.getLocation().indexOf(DefaultConfigCellsPath) == -1 && eObject.getLocation().indexOf(DefaultCellsPath) == -1) continue;
                    eObject.setLocation(MergeSecurityConfig.fixUpKeyStore(eObject.getLocation(), string, string2));
                }
            }
        }
        if (security2.getManagementScopes() != null && security2.getManagementScopes().size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting new cell name & node name for ManagementScopes.");
            }
            if ((eList = security2.getManagementScopes()) != null) {
                iterator = eList.iterator();
                while (iterator.hasNext()) {
                    eObject = (ManagementScope)iterator.next();
                    if (eObject.getScopeName().indexOf("(cell):") == -1) continue;
                    eObject.setScopeName(MergeSecurityConfig.fixUpManagementScope(eObject.getScopeType(), string, string2));
                }
            }
        }
        MergeSecurityConfig.fixUpSslConfigGroup(string, string2, security2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCellNameAndNodeName");
        }
        return security2;
    }

    private static String fixUpKeyStore(String string, String string2, String string3) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Original keyStoreLocation: " + string);
        }
        int n = string.indexOf(DefaultConfigCellsPath);
        String string4 = string;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        if (n != -1) {
            string5 = string.substring(0, n + DefaultConfigCellsPath.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "First part: " + string5);
            }
            string6 = string.substring(n + DefaultConfigCellsPath.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The rest: " + string6);
            }
        } else {
            n = string.lastIndexOf(DefaultCellsPath);
            if (n != -1) {
                string5 = string.substring(0, n + DefaultCellsPath.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "First part: " + string5);
                }
                string6 = string.substring(n + DefaultCellsPath.length());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The rest: " + string6);
                }
            }
        }
        if (string5 != null && string6 != null) {
            if (string6.indexOf(DefaultNodesPath) != -1) {
                n = string6.indexOf(DefaultNodesPath);
                string7 = string6.substring(n + DefaultNodesPath.length());
                if (string7 != null && string7.indexOf("/") != -1) {
                    n = string7.indexOf("/");
                    string7 = string7.substring(n + "/".length());
                }
                string4 = string5 + string2 + DefaultNodesPath + string3 + "/" + string7;
            } else {
                n = string6.indexOf("/");
                string7 = string6.substring(n + "/".length());
                string4 = string5 + string2 + "/" + string7;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Last part: " + string7);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Fixed up location: " + string4);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New keystore location: " + string4);
        }
        return string4;
    }

    private static String fixUpManagementScope(String string, String string2, String string3) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scoprType: " + string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cell name: " + string2 + "Node name: " + string3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(cell):");
        stringBuffer.append(string2);
        if (string.equals(DefaultNodeScope)) {
            stringBuffer.append(":(node):");
            stringBuffer.append(string3);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New newScopeName: " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static void fixUpSslConfigGroup(String string, String string2, Security security2) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enter fixUpSslConfigGroup");
        }
        if (security2.getSslConfigGroups() != null && security2.getSslConfigGroups().size() > 0) {
            EList eList;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting new cell name & node name for sslConfigGroup.");
            }
            if ((eList = security2.getSslConfigGroups()) != null) {
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    SSLConfigGroup sSLConfigGroup = (SSLConfigGroup)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "scopeType: " + sSLConfigGroup.getManagementScope().getScopeType());
                    }
                    if (sSLConfigGroup.getManagementScope().getScopeType().equals(DefaultCellScope)) {
                        sSLConfigGroup.setName(string);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "set cell Name: " + string);
                        continue;
                    }
                    sSLConfigGroup.setName(string2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "set node Name: " + string2);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "exit fixUpSslConfigGroup");
        }
    }

    private static boolean checkIfInternalServerIdUsed(Security security2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfInternalServerIdUsed");
        }
        boolean bl = security2.getActiveUserRegistry().isUseRegistryServerId();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfInternalServerIdUsed", bl ? Boolean.FALSE : Boolean.TRUE);
        }
        return !bl;
    }

    private static boolean checkIfNullServerPasswordUsed(Security security2) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfNullServerPasswordUsed");
        }
        if ((string = security2.getActiveUserRegistry().getServerPassword()) == null || string.length() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkIfNullServerPasswordUsed", " null server passwd. return true.");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfNullServerPasswordUsed", " return false.");
        }
        return false;
    }
}

