/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.auth.module;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.core.SecurityConfig;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class MapPlatformSubject
implements LoginModule {
    private static final TraceComponent tc = Tr.register(MapPlatformSubject.class, "Security", "com.ibm.ejs.resources.security");
    private static final int MAXIMUM_NAME_LENGTH = 8;
    private static final int MAXIMUM_AUDIT_TOKEN_LENGTH = 223;
    private Subject subject = null;
    private CallbackHandler callbackHandler = null;
    private Map sharedState = null;
    private Map options = null;
    private boolean succeeded = false;
    private WSCredential credential = null;
    private PlatformCredential pc = null;
    private String principalClass = null;

    public MapPlatformSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{subject, callbackHandler, map, map2});
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public boolean login() throws LoginException {
        Boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login");
        }
        if ((bl = (Boolean)SecurityConfig.getConfig().getValue("security.use.localos.userregistry")) == null || !bl.booleanValue()) {
            if (!this.sharedState.containsKey("WSPrincipal") || !this.sharedState.containsKey("WSCredential")) {
                this.succeeded = false;
                WSLoginFailedException wSLoginFailedException = new WSLoginFailedException("A WSPrincipal or WSCredential does not exist in the shared state.");
                Tr.event(tc, "Throwing LoginException from login", wSLoginFailedException);
                throw wSLoginFailedException;
            }
            this.credential = (WSCredential)this.sharedState.get("WSCredential");
            String string = (String)this.sharedState.get("com.ibm.wsspi.security.token.zos_userid");
            String string2 = (String)this.sharedState.get("com.ibm.wsspi.security.token.zos_audit_string");
            this.pc = ContextManagerFactory.getInstance().isInternalServerCredential(this.credential) ? PlatformCredentialManager.instance().createServerCredential() : (string != null ? PlatformCredentialManager.instance().createCredential(string, string2) : PlatformCredentialManager.instance().createDefaultCredential());
        }
        this.principalClass = this.sharedState.containsKey("com.ibm.wsspi.security.token.caller_principal_class") ? (String)this.sharedState.get("com.ibm.wsspi.security.token.caller_principal_class") : "com.ibm.websphere.security.auth.WSPrincipal";
        this.succeeded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login", new Boolean(this.succeeded));
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        try {
            if (this.pc != null && this.succeeded) {
                this.credential.set("com.ibm.ws.security.zos.PlatformCredential", this.pc);
                this.credential.set("com.ibm.wsspi.security.token.caller_principal_class", this.principalClass);
            }
        }
        catch (Exception exception) {
            WSLoginFailedException wSLoginFailedException = new WSLoginFailedException(exception);
            Tr.event(tc, "Throwing LoginException from commit", wSLoginFailedException);
            throw wSLoginFailedException;
        }
        finally {
            this.cleanup();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit", Boolean.TRUE);
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort", Boolean.TRUE);
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout");
        }
        this.cleanup();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout", Boolean.TRUE);
        }
        return true;
    }

    private void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup");
        }
        this.pc = null;
        this.principalClass = null;
        this.credential = null;
        this.succeeded = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup");
        }
    }
}

