/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.security.auth.CacheEvictionListener;
import com.ibm.ws.security.auth.CacheException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class Cache
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(Cache.class, "Security", "com.ibm.ejs.resources.security");
    private static Long defaultTimeout = null;
    private Hashtable primaryTable;
    private Hashtable secondaryTable;
    private Hashtable tertiaryTable;
    private int minSize = 0;
    private int entryLimit = Integer.MAX_VALUE;
    private CacheEvictionListener evictionCallback;
    private Alarm alarm;

    public Cache(int n, long l) {
        this(n, l, Integer.MAX_VALUE, null);
    }

    public Cache(int n, long l, int n2, CacheEvictionListener cacheEvictionListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{new Integer(n), new Long(l), new Integer(n2), cacheEvictionListener});
        }
        this.primaryTable = new Hashtable(n);
        this.secondaryTable = new Hashtable(n);
        this.tertiaryTable = new Hashtable(n);
        this.minSize = n;
        this.entryLimit = n2;
        this.alarm = new Alarm(l);
        this.alarm.addAlarmListener(this);
        this.evictionCallback = cacheEvictionListener;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void remove(Object object) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", object);
        }
        Object object2 = this.evictionCallback != null ? this.get(object) : null;
        this.primaryTable.remove(object);
        this.secondaryTable.remove(object);
        this.tertiaryTable.remove(object);
        if (this.evictionCallback != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(object2);
            this.evictionCallback.evicted(arrayList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) throws CacheException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get", object);
        }
        Hashtable hashtable = this.primaryTable;
        Entry entry = (Entry)this.primaryTable.get(object);
        if (entry == null) {
            hashtable = this.secondaryTable;
            entry = (Entry)this.secondaryTable.get(object);
            if (entry == null) {
                hashtable = this.tertiaryTable;
                entry = (Entry)this.tertiaryTable.get(object);
            }
            if (entry == null) {
                hashtable = null;
            }
        }
        if (hashtable != null && hashtable != this.primaryTable) {
            this.primaryTable.put(object, entry);
            hashtable.remove(object);
        }
        if (hashtable == null) {
            Hashtable hashtable2 = this.primaryTable;
            synchronized (hashtable2) {
                entry = (Entry)this.primaryTable.get(object);
                if (entry == null) {
                    entry = new Entry();
                    this.primaryTable.put(object, entry);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get", entry.value);
        }
        return entry.value;
    }

    public void insert(Object object, Object object2) {
        Entry entry;
        Entry entry2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", new Object[]{object, object2});
        }
        if ((entry2 = this.primaryTable.put(object, entry = new Entry(object2))) != null && entry2.value != null && this.evictionCallback != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(entry2.value);
            this.evictionCallback.evicted(arrayList);
        }
        if (this.isEvictionRequired()) {
            this.evictStaleEntries();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insert");
        }
    }

    protected boolean isEvictionRequired() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEvictionRequired");
        }
        boolean bl = false;
        if (this.entryLimit != 0 && this.entryLimit != Integer.MAX_VALUE && (n = this.primaryTable.size() + this.secondaryTable.size() + this.tertiaryTable.size()) > this.entryLimit && this.tertiaryTable.size() > this.entryLimit / 10) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEvictionRequired", new Boolean(bl));
        }
        return bl;
    }

    protected void evictStaleEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "evictStaleEntries");
        }
        Hashtable hashtable = this.tertiaryTable;
        this.tertiaryTable = this.secondaryTable;
        this.secondaryTable = this.primaryTable;
        this.primaryTable = new Hashtable(this.minSize > this.secondaryTable.size() ? this.minSize : this.secondaryTable.size());
        if (this.evictionCallback != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator iterator = hashtable.values().iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                arrayList.add(entry.value);
            }
            this.evictionCallback.evicted(arrayList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "evictStaleEntries");
        }
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", object);
        }
        long l = 0L;
        if (tc.isEntryEnabled()) {
            l = System.currentTimeMillis();
        }
        this.evictStaleEntries();
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
            stringBuffer.append(" Time elapsed cleaning cache: ");
            stringBuffer.append(System.currentTimeMillis() - l);
            stringBuffer.append(" milliseconds, Primary cache size: ");
            stringBuffer.append(this.primaryTable.size());
            stringBuffer.append(", Secondary cache size: ");
            stringBuffer.append(this.secondaryTable.size());
            stringBuffer.append(", Tertiary cache size: ");
            stringBuffer.append(this.tertiaryTable.size());
            Tr.debug(tc, stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAllEntries() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearAllEntries");
        }
        Hashtable hashtable = this.primaryTable;
        synchronized (hashtable) {
            if (this.evictionCallback != null) {
                this.tertiaryTable.putAll(this.primaryTable);
                this.tertiaryTable.putAll(this.secondaryTable);
            }
            this.primaryTable.clear();
            this.secondaryTable.clear();
            this.evictStaleEntries();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearAllEntries");
        }
    }

    public static long getDefaultTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultTimeout");
        }
        long l = 0L;
        if (defaultTimeout != null) {
            l = defaultTimeout;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultTimeout", new Long(l));
        }
        return l;
    }

    public static void setDefaultTimeout(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultTimeout", new Long(l));
        }
        if (defaultTimeout == null) {
            defaultTimeout = new Long(l);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultTimeout");
        }
    }

    private static class Alarm
    implements AlarmListener {
        private Vector alarms = new Vector();
        private long timeout;

        void addAlarmListener(AlarmListener alarmListener) {
            this.alarms.addElement(alarmListener);
        }

        Alarm(long l) {
            this.timeout = l / 2L;
            this.alarm(null);
        }

        public void alarm(Object object) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                ((AlarmListener)this.alarms.elementAt(i)).alarm(object);
            }
            AlarmManager.createDeferrable(this.timeout, this);
        }

        public long getTimeout() {
            return this.timeout * 2L;
        }
    }

    public static class Entry {
        public Object value;
        public int timesAccessed;

        public Entry() {
        }

        public Entry(Object object) {
            this.value = object;
        }
    }
}

