/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.admintask;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.models.config.security.CustomUserRegistry;
import com.ibm.websphere.models.config.security.LDAPUserRegistry;
import com.ibm.websphere.models.config.security.LocalOSUserRegistry;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.models.config.security.WIMUserRegistry;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.security.profiletask.MessageFormatHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.AttributeList;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class GetCurrentWizardSettings
extends AbstractTaskCommand {
    private static String BUNDLE_NAME = "com.ibm.ejs.resources.security";
    private static ResourceBundle resBundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private static TraceComponent tc = Tr.register(GetCurrentWizardSettings.class, "GetCurrentWizardSettings", "com.ibm.ws.security.admintasks");
    final String isEnabledKey = "isEnabled";
    final String secureAppsKey = "secureApps";
    final String secureLocalResourcesKey = "secureLocalResources";
    final String userRegistryTypeKey = "userRegistryType";

    public GetCurrentWizardSettings(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
    }

    public GetCurrentWizardSettings(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    private String getMsg(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        return MessageFormatHelper.getFormattedMessage(resourceBundle, string, objectArray);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void afterStepsExecuted() {
        Properties properties = new Properties();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterStepsExecuted");
        }
        super.afterStepsExecuted();
        ObjectName objectName = null;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!taskCommandResultImpl.isSuccessful()) {
            if (tc.isDebugEnabled()) {
                Tr.exit(tc, "afterStepsExecuted");
            }
            return;
        }
        try {
            Serializable serializable;
            String string;
            Object object;
            Object object2;
            Object object3;
            String string2;
            String string3;
            Object object4;
            Object object5;
            ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Security");
            ConfigService configService = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName objectName3 = configService.resolve(session, "Cell=")[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cell = " + objectName3.toString());
            }
            if (objectName3 != null) {
                objectName = configService.queryConfigObjects(session, objectName3, objectName2, null)[0];
            }
            int n = objectName3.toString().indexOf("_Websphere_Config_Data_Display_Name");
            String string4 = objectName3.toString().substring(n);
            int n2 = string4.indexOf(",");
            string4 = string4.substring(0, n2);
            int n3 = string4.indexOf("=");
            string4 = string4.substring(n3 + 1);
            WorkSpace workSpace = WorkspaceHelper.getWorkspace((Session)session);
            RepositoryContext repositoryContext = AppUtils.findContext("cells", string4, null, null, workSpace, true);
            URI uRI = URI.createURI("security.xml");
            Resource resource = repositoryContext.getResourceSet().getResource(uRI, true);
            Security security2 = (Security)resource.getContents().get(0);
            boolean bl = security2.isEnabled();
            boolean bl2 = security2.isAppEnabled();
            boolean bl3 = security2.isEnforceJava2Security();
            UserRegistry userRegistry = security2.getActiveUserRegistry();
            ObjectName objectName4 = (ObjectName)configService.getAttribute(session, objectName, "activeUserRegistry");
            if (bl) {
                properties.setProperty("isEnabled", "true");
            } else {
                properties.setProperty("isEnabled", "false");
            }
            if (bl2) {
                properties.setProperty("secureApps", "true");
            } else {
                properties.setProperty("secureApps", "false");
            }
            if (bl2) {
                properties.setProperty("secureLocalResources", "true");
            } else {
                properties.setProperty("secureLocalResources", "false");
            }
            if (security2.getActiveUserRegistry() instanceof LocalOSUserRegistry) {
                properties.setProperty("userRegistryType", "LocalOSUserRegistry");
                object5 = (LocalOSUserRegistry)security2.getActiveUserRegistry();
                object4 = userRegistry.getServerId();
                properties.setProperty("serverUserName", (String)object4);
            }
            if (security2.getActiveUserRegistry() instanceof CustomUserRegistry) {
                object5 = userRegistry.getProperties();
                properties.setProperty("userRegistryType", "CustomUserRegistry");
                object4 = (CustomUserRegistry)security2.getActiveUserRegistry();
                string3 = object4.getCustomRegistryClassName();
                string2 = userRegistry.getServerId();
                if (string2 != null) {
                    properties.setProperty("serverUserName", string2);
                }
                properties.setProperty("customRegistryClass", string3);
                object3 = new String[object5.size()];
                object2 = new String[object5.size()];
                object = (ArrayList)configService.getAttribute(session, objectName4, "properties");
                string = new String();
                for (int i = 0; i < object5.size(); ++i) {
                    serializable = (AttributeList)((ArrayList)object).get(i);
                    Object object6 = ConfigServiceHelper.getAttributeValue((AttributeList)serializable, "name");
                    Object object7 = ConfigServiceHelper.getAttributeValue((AttributeList)serializable, "value");
                    object3[i] = (String)object6;
                    object2[i] = (String)object7;
                    string = string.concat(object6.toString() + ":" + object7.toString() + ";");
                }
                properties.setProperty("customProps", string);
            }
            if (security2.getActiveUserRegistry() instanceof WIMUserRegistry) {
                properties.setProperty("userRegistryType", "WIMUserRegistry");
                object5 = (WIMUserRegistry)security2.getActiveUserRegistry();
                object4 = userRegistry.getServerId();
                properties.setProperty("serverUserName", (String)object4);
            }
            if (security2.getActiveUserRegistry() instanceof LDAPUserRegistry) {
                properties.setProperty("userRegistryType", "LDAPUserRegistry");
                object5 = (LDAPUserRegistry)security2.getActiveUserRegistry();
                object4 = object5.getType();
                string3 = userRegistry.getRealm();
                n = string3.indexOf(":");
                string2 = string3.substring(0, n);
                object3 = string3.substring(n + 1, string3.length());
                object2 = object5.getBaseDN();
                object = object5.getBindDN();
                string = object5.getBindPassword();
                String string5 = userRegistry.getServerId();
                serializable = new Integer(((AbstractEnumerator)object4).getValue());
                properties.setProperty("ldapServerType", ((Integer)serializable).toString());
                properties.setProperty("ldapHostname", string2);
                properties.setProperty("ldapPort", (String)object3);
                properties.setProperty("ldapBaseDN", (String)object2);
                properties.setProperty("ldapBindDN", (String)object);
                properties.setProperty("ldapBindPassword", string);
                properties.setProperty("ldapServerUserName", string5);
            }
        }
        catch (Throwable throwable) {
            String string = this.getMsg(resBundle, "security.admintask.ExceptionGettingWizardSettings", null);
            taskCommandResultImpl.addWarnings(string);
            taskCommandResultImpl.setResult(null);
            taskCommandResultImpl.setException(new CommandException(string));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "resultProps = " + properties.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterStepsExecuted");
        }
    }
}

