/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.types;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.ConfigNameCache;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.types.FIPSTSHelper;
import com.ibm.ws.scripting.types.SSLConfigTSHelper;
import com.ibm.ws.scripting.types.SecurityTSHelper;
import java.util.Hashtable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class PropertyTSHelper
extends FIPSTSHelper {
    private static TraceComponent tc = Tr.register(PropertyTSHelper.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private boolean skipFIPSCheck;
    private boolean create;

    public PropertyTSHelper(AdminConfigClient adminConfigClient, AbstractShell abstractShell, Hashtable hashtable, ConfigNameCache configNameCache) {
        super(adminConfigClient, abstractShell, hashtable, configNameCache);
        this.reset();
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reset");
        }
        this.msgId = "SECURITY_NONFIPS_PROVIDER";
        this.validationType = "all";
        this.create = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reset");
        }
    }

    public AttributeList attributeListUpdate(AttributeList attributeList, ObjectName objectName, boolean bl) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributeListUpdate");
        }
        try {
            this.create = bl;
            this.validate(attributeList, objectName);
        }
        catch (AdminException adminException) {
            this._shell.setLastException(adminException);
            throw new ScriptingException(adminException.toString());
        }
        catch (ConnectorException connectorException) {
            this._shell.setLastException(connectorException);
            throw new ScriptingException(connectorException.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributeListUpdate");
        }
        return attributeList;
    }

    protected boolean validate(AttributeList attributeList, ObjectName objectName) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean bl = false;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validationType: " + this.validationType);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "messageId: " + this.msgId);
        }
        if (this.validationType.equals("all") || this.validationType.equals("com.ibm.ssl.contextProvider")) {
            bl = this.checkProviderProperty(attributeList, objectName);
        }
        if (!bl && (this.validationType.equals("all") || this.validationType.equals("sslConfig"))) {
            bl = this.checkSSLConfigProperty(attributeList, objectName);
        }
        if (!bl && (this.validationType.equals("all") || this.validationType.equals("com.ibm.security.useFIPS"))) {
            bl = this.checkFIPSProperty(attributeList, true, objectName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate - " + bl);
        }
        return bl;
    }

    private boolean checkProviderProperty(AttributeList attributeList, ObjectName objectName) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkProviderProperty");
        }
        boolean bl = false;
        Hashtable hashtable = this.getNameValuePropertyValues(attributeList, objectName, true);
        String string = (String)hashtable.get("name");
        String string2 = (String)hashtable.get("value");
        if (string.equals("com.ibm.ssl.contextProvider")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found matching contextProvider");
            }
            if (!string2.trim().equals("") && !string2.trim().equals("IBMJSSEFIPS")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not using IBMJSSEFIPS provider");
                }
                if (this.skipFIPSCheck || this.isFIPSEnabled(objectName)) {
                    if (this.validationType.equals("all")) {
                        this.msgId = "SECURITY_NONFIPS_PROVIDER";
                    }
                    bl = true;
                    String string3 = this._shell.getFormattedMessage(this.msgId, new Object[0], "SSL provider is not IBMJSSEFIPS. FIPS approved cryptographic algorithms may not be used.");
                    System.out.println(string3);
                    Tr.warning(tc, this.msgId);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkProviderProperty - " + bl);
        }
        return bl;
    }

    private boolean checkSSLConfigProperty(AttributeList attributeList, ObjectName objectName) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkSSLConfigProperty");
        }
        boolean bl = false;
        Hashtable hashtable = this.getNameValuePropertyValues(attributeList, objectName, true);
        String string = (String)hashtable.get("name");
        String string2 = (String)hashtable.get("value");
        if (string.equals("sslConfig")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found matching sslConfig");
            }
            this.msgId = "SECURITY_NONFIPS_PROVIDER";
            bl = this.matchSSLConfig(string2, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkSSLConfigProperty - " + bl);
        }
        return bl;
    }

    public boolean checkFIPSProperty(AttributeList attributeList, boolean bl, ObjectName objectName) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkFIPSProperty");
        }
        boolean bl2 = false;
        Hashtable hashtable = this.getNameValuePropertyValues(attributeList, objectName, true);
        String string = (String)hashtable.get("name");
        String string2 = (String)hashtable.get("value");
        if (string.equals("com.ibm.security.useFIPS")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found matching useFIPS property");
            }
            if (string2.equals("true")) {
                if (bl) {
                    this.msgId = "SECURITY_NONFIPS_SSL";
                    this.validationType = "com.ibm.ssl.contextProvider";
                    this.skipFIPSCheck = true;
                    bl2 = this.matchSSLConfig("lookThroughAllSSLConfig", null, objectName);
                    this.skipFIPSCheck = false;
                    if (!bl2 && objectName != null && this.getConfigPath(objectName).indexOf("/servers/") == -1) {
                        SecurityTSHelper securityTSHelper = (SecurityTSHelper)this.getTSHelper("Security");
                        securityTSHelper.setMessageId("SECURITY_NONFIPS_SSL");
                        securityTSHelper.setValidationType("com.ibm.ssl.contextProvider");
                        bl2 = securityTSHelper.checkServerSSLConfig(objectName);
                        securityTSHelper.reset();
                    }
                } else {
                    bl2 = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkFIPSProperty - " + bl2);
        }
        return bl2;
    }

    public boolean matchSSLConfig(String string, ObjectName objectName) throws ScriptingException, AdminException, ConnectorException {
        return this.matchSSLConfig(string, objectName, null);
    }

    public boolean matchSSLConfig(String string, ObjectName objectName, ObjectName objectName2) throws ScriptingException, AdminException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "matchSSLConfig", new Object[]{string, objectName});
        }
        boolean bl = false;
        ObjectName[] objectNameArray = this.getObjectNameListForType("SSLConfig", objectName);
        if (objectNameArray != null) {
            String string2 = new String();
            if (objectName2 != null) {
                string2 = this.getConfigPath(objectName2);
            } else if (objectName != null) {
                string2 = this.getConfigPath(objectName);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "matchinfConfigPath: " + string2);
            }
            SSLConfigTSHelper sSLConfigTSHelper = (SSLConfigTSHelper)this.getTSHelper("SSLConfig");
            sSLConfigTSHelper.setMessageId(this.msgId);
            sSLConfigTSHelper.setValidationType("com.ibm.ssl.contextProvider");
            for (int i = 0; i < objectNameArray.length; ++i) {
                AttributeList attributeList;
                String string3;
                block14: {
                    string3 = null;
                    if (!string2.equals("") && !string2.equals(this.getConfigPath(objectNameArray[i]))) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skipping " + objectNameArray[i]);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing " + objectNameArray[i]);
                    }
                    if ((attributeList = this.getAttributeListFromON(objectNameArray[i])) == null) continue;
                    try {
                        string3 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "alias");
                    }
                    catch (AttributeNotFoundException attributeNotFoundException) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, attributeNotFoundException.toString());
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "alias: " + string3);
                }
                if (!string.equals("lookThroughAllSSLConfig") && (string3 == null || !string3.equals(string))) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found matching SSL config");
                }
                if (bl = sSLConfigTSHelper.validate(attributeList, objectNameArray[i])) break;
            }
            sSLConfigTSHelper.reset();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "matchSSLConfig - " + bl);
        }
        return bl;
    }

    public void setSkipFIPSCheck(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSkipFIPSCheck - " + bl);
        }
        this.skipFIPSCheck = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSkipFIPSCheck");
        }
    }

    private Hashtable getNameValuePropertyValues(AttributeList attributeList, ObjectName objectName, boolean bl) throws ScriptingException, AdminException, ConnectorException {
        AttributeList attributeList2;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNameValuePropertyValues");
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string = new String();
        String string2 = new String();
        for (int i = 0; i < attributeList.size(); ++i) {
            object = ((Attribute)attributeList.get(i)).getName();
            Object object2 = ((Attribute)attributeList.get(i)).getValue();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name: " + (String)object);
            }
            if (((String)object).equals("name")) {
                string = (String)object2;
            }
            if (!((String)object).equals("value")) continue;
            string2 = (String)object2;
        }
        if (!this.create && bl && (!string.equals("") && string2.equals("") || string.equals("") && !string2.equals("")) && (attributeList2 = this.getAttributeListFromON(objectName)) != null) {
            object = this.getNameValuePropertyValues(attributeList2, objectName, false);
            if (string.equals("")) {
                string = (String)((Hashtable)object).get("name");
            }
            if (string2.equals("")) {
                string2 = (String)((Hashtable)object).get("value");
            }
        }
        hashtable.put("name", string);
        hashtable.put("value", string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNameValuePropertyValues - " + string + " " + string2);
        }
        return hashtable;
    }
}

