/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.ws.scripting.adminCommand.AdminCmdController;
import com.ibm.ws.scripting.adminCommand.AdminCmdInteractivePrompt;
import java.util.Vector;

public class AdminCmdInteractiveStepsPrompt
extends AdminCmdInteractivePrompt {
    private static TraceComponent tc = Tr.register(AdminCmdInteractiveStepsPrompt.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private TaskCommand taskCmd;
    private CommandStep selectStep = null;
    private CommandStep lastStep = null;
    private String defaultSelection;
    private String completeStepMsg = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_TASK_COMPLETE", new Object[0], "End of task");
    private boolean selectStepFound;
    private boolean hasRequiredSteps;
    private Vector selectionIndex;

    public AdminCmdInteractiveStepsPrompt(AdminCmdController adminCmdController) {
        super(adminCmdController);
    }

    protected void setAdminCommand(AdminCommand adminCommand) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAdminCommand");
        }
        this.taskCmd = (TaskCommand)adminCommand;
        this.lastStep = null;
        this.selectStepFound = false;
        this.hasRequiredSteps = false;
        this.defaultSelection = select;
        this.selectStep = this.getNextStep();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAdminCommand");
        }
    }

    protected String getTitle() {
        return this.getMetadataTitle(this.taskCmd.getCommandMetadata());
    }

    protected String getDescription() throws Throwable {
        return this.getMetadataDescription(this.taskCmd.getCommandMetadata());
    }

    protected boolean isLoopDone(String string) {
        if (string == null) {
            string = this.defaultSelection;
        }
        return string != null && !string.equalsIgnoreCase(finish) && !string.equalsIgnoreCase(cancel);
    }

    protected String getStepTitles() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStepTitles");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.hasRequiredSteps = false;
        this.selectStepFound = false;
        String[] stringArray = this.taskCmd.listCommandSteps();
        for (int i = 0; i < stringArray.length; ++i) {
            CommandStep commandStep = this.taskCmd.getCommandStep(stringArray[i]);
            if (!commandStep.isEnabled()) {
                stringBuffer.append("   (");
            } else if (this.selectStep != null && this.selectStep.getName().equals(stringArray[i])) {
                this.selectStepFound = true;
                if (commandStep.isRequired()) {
                    stringBuffer.append("-> " + "*");
                    this.hasRequiredSteps = true;
                } else {
                    stringBuffer.append("->  ");
                }
            } else if (commandStep.isRequired()) {
                stringBuffer.append("   " + "*");
                this.hasRequiredSteps = true;
            } else {
                stringBuffer.append("    ");
            }
            stringBuffer.append(i + 1);
            stringBuffer.append(". ");
            stringBuffer.append(this.getMetadataTitle(commandStep.getCommandMetadata()));
            stringBuffer.append(" (");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(")");
            if (!commandStep.isEnabled()) {
                stringBuffer.append(")");
            }
            stringBuffer.append(AdminCmdController.nl);
        }
        if (!this.taskCmd.hasNextStep() && !this.selectStepFound) {
            stringBuffer.append("->  ");
            stringBuffer.append(this.completeStepMsg);
            stringBuffer.append(AdminCmdController.nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStepTitles - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    protected String getSelectionMenu() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSelectionMenu");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.selectionIndex = new Vector();
        this.defaultSelection = select;
        if (this.selectStepFound) {
            stringBuffer.append(selectSelection);
            stringBuffer.append(AdminCmdController.nl);
            this.selectionIndex.addElement(select);
        }
        if (this.taskCmd.hasNextStep()) {
            stringBuffer.append(nextSelection);
            stringBuffer.append(AdminCmdController.nl);
            this.selectionIndex.addElement(next);
        } else if (!this.selectStepFound) {
            this.defaultSelection = previous;
        }
        if (this.taskCmd.hasPreviousStep()) {
            stringBuffer.append(previousSelection);
            stringBuffer.append(AdminCmdController.nl);
            this.selectionIndex.addElement(previous);
        }
        if (!this.hasRequiredSteps) {
            stringBuffer.append(finishSelection);
            stringBuffer.append(AdminCmdController.nl);
            this.selectionIndex.addElement(finish);
            this.defaultSelection = finish;
        }
        stringBuffer.append(cancelSelection);
        stringBuffer.append(AdminCmdController.nl);
        this.selectionIndex.addElement(cancel);
        stringBuffer.append(helpSelection);
        stringBuffer.append(AdminCmdController.nl);
        this.selectionIndex.addElement(help);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSelectionMenu - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    protected String getSelectionPrompt() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSelectionPrompt");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.selectionIndex.isEmpty()) {
            object = this.selectionIndex.elements();
            while (object.hasMoreElements()) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)object.nextElement());
            }
        }
        object = this._adminCmdController.getShell().getFormattedMessage("ADMINTASK_STEP_REPEAT_PROMPT", new Object[]{stringBuffer.toString(), this.defaultSelection}, "Select [" + stringBuffer.toString() + "] : [" + this.defaultSelection + "] ");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSelectionPrompt - " + (String)object);
        }
        return object;
    }

    protected String getDefaultSelection() {
        return this.defaultSelection;
    }

    protected boolean validateAnswer(String string) {
        if (string == null) {
            string = this.defaultSelection;
        }
        return string != null && (this.selectionIndex.contains(string.toUpperCase()) || this.selectionIndex.contains(string.toLowerCase()));
    }

    protected boolean processSelection(String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processSelection", new Object[]{string});
        }
        boolean bl = true;
        if (string == null) {
            string = this.defaultSelection;
        }
        if (string != null && string.equalsIgnoreCase(select)) {
            this._adminCmdController.processSelectStep(this.taskCmd, this.selectStep);
            this.lastStep = this.selectStep;
            this.selectStep = this.getNextStep();
        } else if (string != null && string.equalsIgnoreCase(next)) {
            this.lastStep = this.selectStep;
            this.selectStep = this.getNextStep();
        } else if (string != null && string.equalsIgnoreCase(previous)) {
            string = previous;
            this.selectStep = !this.selectStepFound ? this.lastStep : this.getPreviousStep();
        } else if (string != null && string.equalsIgnoreCase(finish)) {
            string = finish;
        } else if (string.equalsIgnoreCase(cancel)) {
            bl = false;
        } else if (string.equalsIgnoreCase(help)) {
            this._adminCmdController.processStepsHelp(this.taskCmd);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processSelection");
        }
        return bl;
    }

    private CommandStep getNextStep() throws Throwable {
        CommandStep commandStep = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextStep");
        }
        if (this.taskCmd.hasNextStep()) {
            commandStep = this.taskCmd.nextStep();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextStep - " + commandStep);
        }
        return commandStep;
    }

    private CommandStep getPreviousStep() throws Throwable {
        CommandStep commandStep = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPreviousStep");
        }
        if (this.taskCmd.hasPreviousStep()) {
            commandStep = this.taskCmd.previousStep();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPreviousStep - " + commandStep);
        }
        return commandStep;
    }
}

