/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting.adminCommand;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.adminCommand.AdminCmd;
import com.ibm.ws.scripting.adminCommand.AdminCmdClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class AdminCmdHelp
extends AdminCmd {
    private static TraceComponent tc = Tr.register(AdminCmdHelp.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private String nl = System.getProperty("line.separator");
    private AdminCmdClient _adminCmdClient;
    private int argIndex;

    public AdminCmdHelp(AdminCmdClient adminCmdClient) {
        this._adminCmdClient = adminCmdClient;
    }

    public String help(Object[] objectArray) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help", new Object[]{objectArray});
        }
        String string = "";
        if (objectArray == null || objectArray.length == 0) {
            string = this.getGeneralHelp();
        } else {
            this.argIndex = 0;
            while (this.argIndex < objectArray.length) {
                String string2 = (String)objectArray[this.argIndex];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "arg: " + string2);
                }
                string = string2.equalsIgnoreCase("-commands") ? string + this.getCommandsGeneralHelp() : (string2.equalsIgnoreCase("-commandGroups") ? string + this.getCommandGroupsGeneralHelp() : string + this.getCommandHelp(objectArray));
                string = string + this.nl + this.nl;
                ++this.argIndex;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return string.toString();
    }

    private String getGeneralHelp() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGeneralHelp");
        }
        String string = this._adminCmdClient.getShell().getFormattedMessage("WASX8001I", new Object[0], "General help for AdminTask");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGeneralHelp");
        }
        return string;
    }

    private String getCommandsGeneralHelp() throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandsGeneralHelp");
        }
        Collection collection = this._adminCmdClient.getCommandMgr().getAllCommandMetadata();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Collection: " + collection);
        }
        Object[] objectArray = this.sortCollection(collection);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(this.getCommandDescriptionHelp((CommandMetadata)objectArray[i]));
        }
        String string = this._adminCmdClient.getShell().getFormattedMessage("WASX8004I", new Object[]{stringBuffer.toString()}, "Available commands:\n" + stringBuffer.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandsGeneralHelp");
        }
        return string;
    }

    private String getCommandDescriptionHelp(CommandMetadata commandMetadata) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandDescriptionHelp", new Object[]{commandMetadata.getName()});
        }
        StringBuffer stringBuffer = new StringBuffer();
        Tr.debug(tc, "command name " + commandMetadata.getName());
        if (!commandMetadata.isPrivate()) {
            stringBuffer.append(commandMetadata.getName());
            stringBuffer.append(" - ");
            stringBuffer.append(this.getMetadataDescription(commandMetadata));
            stringBuffer.append(this.nl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandDescriptionHelp");
        }
        return stringBuffer.toString();
    }

    private Object[] sortCollection(Collection collection) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sortCollection");
        }
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = i + 1; j < objectArray.length; ++j) {
                Object object;
                if (objectArray[j] instanceof CommandMetadata && objectArray[i] instanceof CommandMetadata) {
                    if (((CommandMetadata)objectArray[j]).getName() == null || ((CommandMetadata)objectArray[i]).getName() == null || ((CommandMetadata)objectArray[j]).getName().compareTo(((CommandMetadata)objectArray[i]).getName()) >= 0) continue;
                    object = objectArray[j];
                    objectArray[j] = objectArray[i];
                    objectArray[i] = object;
                    continue;
                }
                if (!(objectArray[j] instanceof CommandGroupMetadata) || !(objectArray[i] instanceof CommandGroupMetadata) || ((CommandGroupMetadata)objectArray[j]).getName() == null || ((CommandGroupMetadata)objectArray[i]).getName() == null || ((CommandGroupMetadata)objectArray[j]).getName().compareTo(((CommandGroupMetadata)objectArray[i]).getName()) >= 0) continue;
                object = objectArray[j];
                objectArray[j] = objectArray[i];
                objectArray[i] = object;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sortCollection");
        }
        return objectArray;
    }

    private String getCommandGroupsGeneralHelp() throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandGroupsGeneralHelp");
        }
        Collection collection = this._adminCmdClient.getCommandMgr().getAllCommandGroupMetadata();
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "Collection: " + collection);
        }
        Object[] objectArray = this.sortCollection(collection);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(this.getCommandGroupDescriptionHelp((CommandGroupMetadata)objectArray[i]));
        }
        String string = this._adminCmdClient.getShell().getFormattedMessage("WASX8005I", new Object[]{stringBuffer.toString()}, "Available command groups:\n" + stringBuffer.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandGroupsGeneralHelp");
        }
        return string;
    }

    private String getCommandGroupDescriptionHelp(CommandGroupMetadata commandGroupMetadata) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandDescriptionHelp", new Object[]{commandGroupMetadata.getName()});
        }
        StringBuffer stringBuffer = new StringBuffer();
        Tr.debug(tc, "command name " + commandGroupMetadata.getName());
        stringBuffer.append(commandGroupMetadata.getName());
        stringBuffer.append(" - ");
        stringBuffer.append(this.getMetadataDescription(commandGroupMetadata));
        stringBuffer.append(this.nl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandGroupsDescriptionHelp - " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private String getCommandHelp(Object[] objectArray) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandHelp", new Object[]{objectArray});
        }
        CommandMgr commandMgr = this._adminCmdClient.getCommandMgr();
        String string = "";
        boolean bl = false;
        String string2 = (String)objectArray[this.argIndex];
        if (commandMgr.listCommandGroups().contains(string2)) {
            string = this.getCommandGroupDetailHelp(string2);
        } else if (commandMgr.listCommands().contains(string2)) {
            if (objectArray.length == this.argIndex + 1) {
                string = this.getCommandDetailHelp(string2);
            } else {
                CommandMetadata commandMetadata = null;
                try {
                    commandMetadata = this._adminCmdClient.getCommandMgr().getCommandMetadata(string2);
                }
                catch (CommandNotFoundException commandNotFoundException) {
                    this._adminCmdClient.getShell().setLastException(commandNotFoundException);
                    throw new ScriptingException(this._adminCmdClient.getShell().getFormattedMessage("WASX8003E", new Object[]{string2}, "Invalid help command argument: " + string2));
                }
                if (commandMetadata instanceof TaskCommandMetadata && this.isStepInTask((TaskCommandMetadata)commandMetadata, (String)objectArray[this.argIndex + 1])) {
                    string = this.getCommandDetailStep((TaskCommandMetadata)commandMetadata, (String)objectArray[this.argIndex + 1]);
                    ++this.argIndex;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Advancing argument index to skip step");
                    }
                } else {
                    string = this.getCommandDetailHelp(string2);
                }
            }
        } else {
            this._adminCmdClient.getShell().setAndThrowScriptingException("WASX8003E", "Invalid help command argument: " + string2, new Object[]{string2});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandHelp");
        }
        return string;
    }

    private String getCommandGroupDetailHelp(String string) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandGroupDetailHelp", new Object[]{string});
        }
        StringBuffer stringBuffer = new StringBuffer();
        CommandGroupMetadata commandGroupMetadata = null;
        try {
            commandGroupMetadata = this._adminCmdClient.getCommandMgr().getCommandGroupMetadata(string);
        }
        catch (CommandNotFoundException commandNotFoundException) {
            this._adminCmdClient.getShell().setAndThrowScriptingException("WASX8002E", "Invalid command name: " + string, new Object[]{string});
        }
        String string2 = this.getMetadataDescription(commandGroupMetadata);
        Collection collection = this._adminCmdClient.getCommandMgr().listCommands(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Collection: " + collection);
        }
        Object[] objectArray = this.sortCollection(collection);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            String string3 = (String)objectArray[i];
            try {
                CommandMetadata commandMetadata = this._adminCmdClient.getCommandMgr().getCommandMetadata(string3);
                stringBuffer.append(this.getCommandDescriptionHelp(commandMetadata));
                continue;
            }
            catch (ScriptingException scriptingException) {
                if (scriptingException.toString().indexOf("WASX8002E") >= 0) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Ignore invalid command: " + string3);
                    continue;
                }
                throw scriptingException;
            }
        }
        String string4 = this._adminCmdClient.getShell().getFormattedMessage("WASX8007I", new Object[]{string, string2, stringBuffer.toString()}, "Group command: " + string + "\n" + stringBuffer.toString());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandGroupDetailHelp");
        }
        return string4;
    }

    public String getCommandDetailHelp(String string) throws ScriptingException, CommandException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandDetailHelp", new Object[]{string});
        }
        CommandMetadata commandMetadata = null;
        String string2 = "";
        try {
            commandMetadata = this._adminCmdClient.getCommandMgr().getCommandMetadata(string);
        }
        catch (CommandNotFoundException commandNotFoundException) {
            this._adminCmdClient.getShell().setAndThrowScriptingException("WASX8002E", "Invalid command name: " + string, new Object[]{string});
        }
        String string3 = this.getMetadataDescription(commandMetadata);
        String string4 = commandMetadata.getTargetObjectDescription();
        int n = this.getTargetObjectRequired(commandMetadata);
        if (n == 1) {
            string2 = "*";
        }
        if (n == 2) {
            string4 = "  " + this._adminCmdClient.getShell().getFormattedMessage("ADMINTASK_NONE", new Object[0], "None");
        }
        String string5 = this.getCommandParameters(commandMetadata);
        String string6 = commandMetadata instanceof TaskCommandMetadata ? this.getTaskCommandMetaSteps((TaskCommandMetadata)commandMetadata) : "  " + this._adminCmdClient.getShell().getFormattedMessage("ADMINTASK_NONE", new Object[0], "None");
        String string7 = this._adminCmdClient.getShell().getFormattedMessage("WASX8006I", new Object[]{string, string3, string2, string4, string5, string6}, "Command: " + string + "\nDescription: " + string3 + "\nTarget object: " + string4 + "\nArguments: " + string5 + "\nSteps: " + string6);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandDetailHelp");
        }
        return string7;
    }

    private boolean isStepInTask(TaskCommandMetadata taskCommandMetadata, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isStepInTask", new Object[]{string});
        }
        boolean bl = false;
        EList eList = taskCommandMetadata.getSteps();
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                if (!((CommandStepMetadata)iterator.next()).getName().equals(string)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isStepInTask - " + bl);
        }
        return bl;
    }

    private String getCommandParameters(CommandMetadata commandMetadata) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandParameters");
        }
        EList eList = commandMetadata.getParameters();
        StringBuffer stringBuffer = new StringBuffer();
        if (eList.isEmpty()) {
            stringBuffer.append("  ");
            stringBuffer.append(this._adminCmdClient.getShell().getFormattedMessage("ADMINTASK_NONE", new Object[0], "None"));
            stringBuffer.append(this.nl);
        } else {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ParameterMetadata parameterMetadata = (ParameterMetadata)iterator.next();
                stringBuffer.append("  ");
                if (parameterMetadata.isRequired()) {
                    stringBuffer.append("*");
                }
                stringBuffer.append(parameterMetadata.getName());
                stringBuffer.append(" - ");
                stringBuffer.append(this.getMetadataDescription(parameterMetadata));
                stringBuffer.append(this.nl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandParameters");
        }
        return stringBuffer.toString();
    }

    private String getTaskCommandMetaSteps(TaskCommandMetadata taskCommandMetadata) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTaskCommandMetaSteps");
        }
        StringBuffer stringBuffer = new StringBuffer();
        EList eList = taskCommandMetadata.getSteps();
        if (eList == null) {
            stringBuffer.append(this._adminCmdClient.getShell().getFormattedMessage("ADMINTASK_NONE", new Object[0], "None"));
        } else {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                CommandStepMetadata commandStepMetadata = (CommandStepMetadata)iterator.next();
                stringBuffer.append("   ");
                stringBuffer.append(commandStepMetadata.getName());
                stringBuffer.append(" - ");
                stringBuffer.append(this.getMetadataDescription(commandStepMetadata));
                stringBuffer.append(this.nl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTaskCommandMetaSteps");
        }
        return stringBuffer.toString();
    }

    private String getCommandDetailStep(TaskCommandMetadata taskCommandMetadata, String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandDetailStep", new Object[]{taskCommandMetadata.getName(), string});
        }
        String string2 = null;
        EList eList = taskCommandMetadata.getSteps();
        CommandStepMetadata commandStepMetadata = null;
        if (eList != null) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                CommandStepMetadata commandStepMetadata2 = (CommandStepMetadata)iterator.next();
                if (!commandStepMetadata2.getName().equals(string)) continue;
                commandStepMetadata = commandStepMetadata2;
                break;
            }
        }
        if (commandStepMetadata != null) {
            string2 = this.getCommandDetailStep(commandStepMetadata, string);
        } else {
            this._adminCmdClient.getShell().setAndThrowScriptingException("WASX8003E", "Invalid help command argument: " + string, new Object[]{string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandDetailStep");
        }
        return string2;
    }

    public String getCommandDetailStep(CommandStepMetadata commandStepMetadata, String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandDetailStep");
        }
        String string2 = this.getMetadataDescription(commandStepMetadata);
        String string3 = commandStepMetadata.isTable() ? this._adminCmdClient.getShell().getFormattedMessage("ADMINTASK_COLLECTION_YES", new Object[0], "Yes") : this._adminCmdClient.getShell().getFormattedMessage("ADMINTASK_COLLECTION_NO", new Object[0], "No");
        String string4 = this.getCommandParameters(commandStepMetadata);
        String string5 = this._adminCmdClient.getShell().getFormattedMessage("WASX8013I", new Object[]{string, string2, string3, string4}, "Help for " + string + ":\n\nDescription: " + string2 + "\n\nCollection: " + string3 + "\n\nArguments:\n" + string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandDetailStep");
        }
        return string5;
    }
}

