/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.scripting.AdminAppClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class FileTools {
    private static TraceComponent tc = Tr.register(AdminAppClient.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");

    public static boolean compareFileNames(File file, File file2) {
        return file.getName().equalsIgnoreCase(file2.getName());
    }

    public static void copyDirectory(File file, File file2) throws FileNotFoundException, IOException {
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyDirectory");
        }
        if (file2.isDirectory() && (stringArray = file2.list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(file2, stringArray[i]);
                if (file3.isFile()) {
                    FileTools.copyFile(new File(file, stringArray[i]), file3);
                    continue;
                }
                File file4 = new File(file, stringArray[i]);
                if (!file4.exists()) {
                    file4.mkdir();
                }
                FileTools.copyDirectory(file4, file3);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyDirectory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws FileNotFoundException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile");
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file2);
            int n = (int)file2.length();
            boolean bl = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "File length is " + n);
            }
            while (n > 210000000) {
                n /= 2;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "size is reduced to " + n);
            }
            while (!bl) {
                fileOutputStream = new FileOutputStream(file, false);
                if (n == 0) {
                    bl = true;
                    continue;
                }
                try {
                    byte[] byArray = new byte[n];
                    int n2 = fileInputStream.read(byArray);
                    while (n2 != -1) {
                        fileOutputStream.write(byArray, 0, n2);
                        n2 = fileInputStream.read(byArray);
                    }
                    bl = true;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    n /= 2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "size is reduced to " + n);
                    }
                    fileOutputStream.close();
                }
            }
            fileOutputStream.flush();
            fileOutputStream.close();
            fileInputStream.close();
        }
        finally {
            block25: {
                block24: {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block24;
                            Tr.debug(tc, "ignoring exception on input close.");
                        }
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block25;
                        Tr.debug(tc, "ignoring exception on output close.");
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static void removeDirectory(File file) {
        String[] stringArray;
        if (file.isDirectory() && (stringArray = file.list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (file2.isFile()) {
                    file2.delete();
                    continue;
                }
                FileTools.removeDirectory(file2);
            }
        }
        file.delete();
    }

    public static void scanDirectory(File file, String string, ArrayList arrayList) {
        String[] stringArray;
        if (file.isDirectory() && (stringArray = file.list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (!file2.isDirectory()) continue;
                if (file2.getName().equalsIgnoreCase(string)) {
                    arrayList.add(file2.getAbsolutePath());
                }
                FileTools.scanDirectory(file2, string, arrayList);
            }
        }
    }

    public static void scanFiles(File file, ArrayList arrayList) {
        String[] stringArray;
        if (file.isDirectory() && (stringArray = file.list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (file2.isFile()) {
                    arrayList.add(file2.getAbsolutePath());
                    continue;
                }
                FileTools.scanFiles(file2, arrayList);
            }
        }
    }
}

