/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.TestConnectionCommand;
import java.util.Set;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DataSourceCfgHelperProxy {
    private static TraceComponent tc = Tr.register(TestConnectionCommand.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private AbstractShell _shell = null;
    private AdminClient _client = null;
    private AdminControlClient _control = null;
    private String _node = null;
    private String _configId = null;
    private ObjectName dataSourceCfgHelperON = null;
    public static String[] SIGNATURE_String = null;
    public static final String DATASOURCECFGHELPER_ON = "WebSphere:type=DataSourceCfgHelper";
    private static DataSourceCfgHelperProxy _self = null;

    public static DataSourceCfgHelperProxy getInstance() {
        return _self;
    }

    public DataSourceCfgHelperProxy(AbstractShell abstractShell, AdminClient adminClient, AdminControlClient adminControlClient, String string) throws ConnectorException, ScriptingException {
        this._client = adminClient;
        this._configId = string;
        this._shell = abstractShell;
        this._control = adminControlClient;
        this._node = null;
        SIGNATURE_String = new String[1];
        DataSourceCfgHelperProxy.SIGNATURE_String[0] = "java.lang.String";
        this.init();
        _self = this;
    }

    public boolean isRunning() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRunning");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRunning");
        }
        return this.dataSourceCfgHelperON != null;
    }

    private void init() throws ScriptingException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        ObjectName objectName = null;
        try {
            int n;
            String string = "nodeagent";
            if (this._configId != null) {
                int n2;
                int n3 = this._configId.indexOf("/nodes/");
                if (n3 >= 0) {
                    n2 = this._configId.indexOf("/", n3 + 7);
                    if (n2 < 0) {
                        n2 = this._configId.indexOf(124, n3 + 7);
                    }
                    if (n2 < 0) {
                        this._shell.setAndThrowScriptingException("WASX7306E", "Cannot test: node unknown", new Object[]{this._configId});
                    }
                    this._node = this._configId.substring(n3 + 7, n2);
                } else {
                    this._node = this._control.getNode();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node is " + this._node);
                }
                if ((n2 = this._configId.indexOf("/servers/")) >= 0) {
                    n = this._configId.indexOf(124, n2 + 9);
                    if (n < 0) {
                        this._shell.setAndThrowScriptingException("WASX7306E", "Cannot test: node unknown", new Object[]{this._configId});
                    }
                    string = this._configId.substring(n2 + 9, n);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "server is " + string);
                    }
                }
            }
            Set set = null;
            while (set == null && string != null) {
                if (string.equals("llllocal")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "using current process " + this._control.getProcessName());
                    }
                    objectName = new ObjectName("WebSphere:type=DataSourceCfgHelper,node=" + this._control.getNode() + ",process=" + this._control.getProcessName() + ",*");
                } else {
                    objectName = new ObjectName("WebSphere:type=DataSourceCfgHelper,node=" + this._node + ",process=" + string + ",*");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "objectname is " + objectName);
                }
                set = this._client.queryNames(objectName, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "helpers are " + set);
                }
                if (set != null && !set.isEmpty()) {
                    Object[] objectArray = set.toArray();
                    for (n = 0; n < objectArray.length; ++n) {
                        this.dataSourceCfgHelperON = (ObjectName)objectArray[n];
                    }
                    continue;
                }
                if (this._node == null || string.equals("llllocal")) {
                    string = null;
                    continue;
                }
                if (string.equals("nodeagent")) {
                    string = "llllocal";
                    set = null;
                    continue;
                }
                string = "nodeagent";
                set = null;
            }
            if (this.dataSourceCfgHelperON != null && this.dataSourceCfgHelperON.getKeyProperty("version").equals("5.0")) {
                this._shell.setAndThrowScriptingException("WASX7387E", "TestConnection not supported when connection to 5.0 server", new Object[0]);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new ScriptingException(malformedObjectNameException.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init - " + this.dataSourceCfgHelperON);
        }
    }

    public Integer testConnection(String string) throws AdminException, ConnectorException {
        Integer n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testConnection");
        }
        try {
            Object[] objectArray = new Object[]{string};
            n = (Integer)this._client.invoke(this.dataSourceCfgHelperON, "testConnection", objectArray, SIGNATURE_String);
        }
        catch (JMException jMException) {
            throw new AdminException(jMException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "testConnection");
        }
        return n;
    }
}

