/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorAuthenticationException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.websphere.management.exception.InvalidAdminClientTypeException;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ReconnectSupport;
import com.ibm.ws.scripting.ScriptingException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public abstract class CommonScriptingObject
implements ReconnectSupport,
NotificationListener {
    private static TraceComponent tc = Tr.register(CommonScriptingObject.class, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    protected AbstractShell _shell = null;
    protected static AdminClient _client = null;
    protected LanguageUtilities _langutils = null;
    protected static final String DOMAIN = "WebSphere";
    protected static final String nl = System.getProperty("line.separator");
    protected static ResourceBundle _bundle = null;
    protected static ObjectName connectedServer = null;
    protected static String processType = "unknown";
    protected static Properties connectionProperties = null;
    private Boolean cellMgr = null;

    public abstract String help(String var1) throws ScriptingException;

    public CommonScriptingObject(AbstractShell abstractShell, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "CommonScriptingObject ctor");
        }
        this._shell = abstractShell;
        this._shell.registerForReconnect(this);
        _bundle = this._shell.getBundle();
        this._langutils = this._shell.getLangUtils();
        if (properties != null) {
            this.connectToAdminService(properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "CommonScriptingObject ctor");
        }
    }

    private void connectToAdminService(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "connectToAdminService");
        }
        try {
            this._shell.setLastException(null);
            _client = AdminClientFactory.createAdminClient(properties);
            connectedServer = _client.getServerMBean();
            processType = (String)_client.getAttribute(connectedServer, "processType");
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Connected to MBean: " + connectedServer);
            }
        }
        catch (InvalidAdminClientTypeException invalidAdminClientTypeException) {
            this._shell.logAndIssueMessage(new Object[]{properties.getProperty("type"), properties.getProperty("host"), invalidAdminClientTypeException}, "INVALID_CONN_TYPE", "Error creating \"" + properties.getProperty("type") + "\" connection to server \"" + properties.getProperty("host") + "\"; exception information: " + invalidAdminClientTypeException, invalidAdminClientTypeException);
            _client = null;
            connectedServer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectToAdminService -- null");
            }
            return;
        }
        catch (ConnectorAuthenticationException connectorAuthenticationException) {
            _client = null;
            connectedServer = null;
            this.authenticationFailure(properties, connectorAuthenticationException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectToAdminService -- null");
            }
            return;
        }
        catch (ConnectorNotAvailableException connectorNotAvailableException) {
            if (properties != null) {
                this._shell.logAndIssueMessage(new Object[]{properties.getProperty("type"), connectorNotAvailableException}, "CONNECTOR_NOT_AVAIL", "Error creating \"" + properties.getProperty("type") + "\" connection to server: server may not be running; exception information: " + connectorNotAvailableException, connectorNotAvailableException);
            }
            _client = null;
            connectedServer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectToAdminService -- null");
            }
            return;
        }
        catch (ConnectorException connectorException) {
            Throwable throwable = connectorException.getCause();
            if (throwable == null) {
                throwable = connectorException;
            } else if (throwable instanceof InvocationTargetException && (throwable = ((InvocationTargetException)throwable).getTargetException()) instanceof ConnectorAuthenticationException) {
                this.authenticationFailure(properties, throwable);
                _client = null;
                connectedServer = null;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "connectToAdminService -- null");
                }
                return;
            }
            if (properties != null) {
                this._shell.logAndIssueMessage(new Object[]{properties.getProperty("type"), properties.getProperty("host"), throwable}, "INVALID_CONN_TYPE", "Error creating \"" + properties.getProperty("type") + "\" connection to server \"" + properties.getProperty("host") + "\"; exception information: " + throwable, connectorException);
            } else {
                this._shell.logException(connectorException);
            }
            _client = null;
            connectedServer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectToAdminService -- null");
            }
            return;
        }
        catch (JMException jMException) {
            this._shell.logAndIssueMessage(new Object[]{jMException}, "WASX7210W", "Cannot determine type of server; exception information: " + jMException, jMException);
            _client = null;
            connectedServer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectToAdminService -- null");
            }
            return;
        }
        catch (JMRuntimeException jMRuntimeException) {
            this.authenticationFailure(properties, jMRuntimeException);
            _client = null;
            connectedServer = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "connectToAdminService -- null");
            }
            return;
        }
        connectionProperties = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connectToAdminService");
        }
    }

    private void authenticationFailure(Properties properties, Throwable throwable) {
        String string = properties.getProperty("host");
        String string2 = properties.getProperty("type");
        if (throwable instanceof Exception) {
            this._shell.logAndIssueMessage(new Object[]{string2, string, throwable.getMessage()}, "WASX7246E", "Cannot establish \"" + string2 + "\" connection to host \"" + string + "\" because of an authentication failure.  Please ensure that user and password are correct.", (Exception)throwable);
        } else {
            this._shell.issueMessage(new Object[]{string2, string, throwable.getMessage()}, "WASX7246E", "Cannot establish \"" + string2 + "\" connection to host \"" + string + "\" because of an authentication failure.  Please ensure that user and password are correct.");
        }
    }

    protected boolean isCellManager() throws MalformedObjectNameException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCellManager");
        }
        boolean bl = false;
        if (this.cellMgr == null) {
            this.cellMgr = "DeploymentManager".equals(processType) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.cellMgr != null) {
            bl = this.cellMgr;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCellManager", new Object[]{new Boolean(bl)});
        }
        return bl;
    }

    protected void helpInfo(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "helpInfo");
        }
        String string2 = this.help(string);
        this._shell.setAndThrowScriptingException("WASX7352E", "wrong number of args for command; help information follows:\n" + string2, new Object[]{string, string2});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "helpInfo");
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification == null) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Received null notf; handback: " + object);
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "Received notf; handback: " + object + "; data: " + notification.getUserData());
            }
        }
    }
}

