/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.config;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.runtime.config.ResourceLocator;
import com.ibm.ws.runtime.service.ConfigRoot;
import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceLocatorImpl
implements ResourceLocator {
    private static final TraceComponent tc = Tr.register(ResourceLocatorImpl.class, "Runtime", "com.ibm.ws.runtime.runtime");
    protected String resourceName;

    public ResourceLocatorImpl(String string) {
        this.resourceName = string;
    }

    public Resource getResource(ConfigRoot configRoot, int n) {
        try {
            return configRoot.getResource(n, this.resourceName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, configRoot.getAbsolutePath(n, this.resourceName) + " not found\n", fileNotFoundException);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, configRoot.getAbsolutePath(n, this.resourceName) + " was not loaded\n", exception);
            }
            throw new WsRuntimeException(exception);
        }
        return null;
    }

    public boolean isResourceUpdated(long l, ConfigRoot configRoot, int n) {
        String string = configRoot.getAbsolutePath(n, this.resourceName);
        File file = new File(string);
        return file.lastModified() > l;
    }
}

