/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.runtime.component.collaborator;

import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.J2EEManagedObjectCollaborator;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ObjectName;

public abstract class J2EEResourceMBean
extends J2EEManagedObjectCollaborator {
    private static final TraceComponent tc = Tr.register(J2EEResourceMBean.class, "Runtime", null);
    private String name;
    private String description;

    public J2EEResourceMBean() {
    }

    public J2EEResourceMBean(J2EEResourceProvider j2EEResourceProvider, String string) {
        this.name = j2EEResourceProvider.getName();
        this.description = j2EEResourceProvider.getDescription();
        this.activate(j2EEResourceProvider, string);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    private ObjectName activate(J2EEResourceProvider j2EEResourceProvider, String string) {
        ObjectName objectName = null;
        try {
            Properties properties = new Properties();
            properties.setProperty("name", j2EEResourceProvider.getName());
            properties.setProperty("Server", string);
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            String string2 = mBeanFactory.getConfigId(j2EEResourceProvider);
            objectName = mBeanFactory.activateMBean(this.getResourceType(), this, string2, null, properties);
        }
        catch (AdminException adminException) {
            if (adminException.getCause() instanceof InstanceAlreadyExistsException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception", adminException);
                }
            }
            FFDCFilter.processException(adminException, this.getClass().getName(), "80");
        }
        return objectName;
    }

    protected abstract String getResourceType();

    protected Properties getAdditionalProps() {
        return null;
    }
}

