/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.wire;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.ws.pmi.wire.WpdCollection;
import com.ibm.ws.pmi.wire.WpdData;
import java.io.Serializable;
import java.util.ArrayList;

public class WpdCollectionImpl
implements WpdCollection,
PmiConstants {
    private static final long serialVersionUID = -3280621639331246909L;
    public String name;
    public int type;
    public int instrumentationLevel = -1;
    public ArrayList dataMembers;
    public ArrayList subCollections;

    public WpdCollectionImpl(String string, int n) {
        this(string, n, -1, null, null);
    }

    public WpdCollectionImpl(String string, int n, int n2) {
        this(string, n, n2, null, null);
    }

    public WpdCollectionImpl(String string, int n, int n2, ArrayList arrayList, ArrayList arrayList2) {
        if (string == null) {
            string = "Undefined";
        }
        this.name = string;
        this.type = n == 11 || n == 12 || n == 13 ? n : 17;
        this.instrumentationLevel = n2;
        this.dataMembers = arrayList;
        this.subCollections = arrayList2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getType() {
        return this.type;
    }

    public int getLevel() {
        return this.instrumentationLevel;
    }

    public void setLevel(int n) {
        this.instrumentationLevel = n;
    }

    public String toXML() {
        int n;
        String string = null;
        String string2 = null;
        if (this.type == 11) {
            string = "<PerfNode";
            string2 = "</PerfNode>\n";
        } else if (this.type == 12) {
            string = "<PerfServer";
            string2 = "</PerfServer>\n";
        } else if (this.type == 13) {
            string = "<PerfModule";
            string2 = "</PerfModule>\n";
        } else {
            string = "PerfCollection";
            string2 = "</PerfCollection>\n";
        }
        string = string + " name=\"" + this.name + "\">\n";
        if (this.dataMembers != null) {
            for (n = 0; n < this.dataMembers.size(); ++n) {
                string = string + ((WpdData)this.dataMembers.get(n)).toXML();
            }
        }
        if (this.subCollections != null) {
            for (n = 0; n < this.subCollections.size(); ++n) {
                string = string + ((WpdCollection)this.subCollections.get(n)).toXML();
            }
        }
        string = string + string2;
        return string;
    }

    public void setDataMembers(ArrayList arrayList) {
        this.dataMembers = arrayList;
    }

    public void setSubcollections(ArrayList arrayList) {
        this.subCollections = arrayList;
    }

    public ArrayList dataMembers() {
        return this.dataMembers;
    }

    public ArrayList subCollections() {
        return this.subCollections;
    }

    public synchronized boolean add(WpdData wpdData) {
        if (this.dataMembers == null) {
            this.dataMembers = new ArrayList();
        }
        if (wpdData == null) {
            return false;
        }
        this.dataMembers.add(wpdData);
        return true;
    }

    public synchronized boolean add(WpdCollection wpdCollection) {
        if (this.subCollections == null) {
            this.subCollections = new ArrayList();
        }
        if (wpdCollection == null) {
            return false;
        }
        this.subCollections.add(wpdCollection);
        return true;
    }

    public synchronized boolean remove(int n) {
        if (this.dataMembers == null || this.dataMembers.size() <= 0) {
            return false;
        }
        for (int i = this.dataMembers.size() - 1; i >= 0; --i) {
            if (((WpdData)this.dataMembers.get(i)).getId() != n) continue;
            this.dataMembers.remove(i);
            return true;
        }
        return false;
    }

    public synchronized boolean remove(String string) {
        if (this.subCollections == null || this.subCollections.size() <= 0) {
            return false;
        }
        for (int i = this.subCollections.size() - 1; i >= 0; --i) {
            WpdCollection wpdCollection = (WpdCollection)this.subCollections.get(i);
            if (!wpdCollection.getName().equals(string)) continue;
            this.subCollections.remove(i);
            return true;
        }
        return false;
    }

    public WpdData getData(int n) {
        if (this.dataMembers == null || this.dataMembers.size() <= 0) {
            return null;
        }
        for (int i = 0; i < this.dataMembers.size(); ++i) {
            WpdData wpdData = (WpdData)this.dataMembers.get(i);
            if (wpdData.getId() != n) continue;
            return wpdData;
        }
        return null;
    }

    public WpdCollection getSubcollection(String string) {
        if (this.subCollections == null || this.subCollections.size() <= 0) {
            return null;
        }
        for (int i = 0; i < this.subCollections.size(); ++i) {
            WpdCollection wpdCollection = (WpdCollection)this.subCollections.get(i);
            if (!wpdCollection.getName().equals(string)) continue;
            return wpdCollection;
        }
        return null;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        Serializable serializable;
        int n;
        String string2 = string + "  ";
        String string3 = null;
        switch (this.type) {
            case 10: {
                string3 = "PMIROOT";
                break;
            }
            case 11: {
                string3 = "NODE";
                break;
            }
            case 12: {
                string3 = "SERVER";
                break;
            }
            case 13: {
                string3 = "MODULE";
                break;
            }
            case 15: {
                string3 = "SUBMODULE";
                break;
            }
            case 14: {
                string3 = "INSTANCE";
                break;
            }
            case 16: {
                string3 = "SUBINSTANCE";
                break;
            }
            case 17: {
                string3 = "COLLECTION";
                break;
            }
            default: {
                string3 = "WRONG_TYPE";
            }
        }
        String string4 = string + "WpdCollection name=" + this.name + " type=" + string3 + "\n";
        if (this.dataMembers != null) {
            for (n = 0; n < this.dataMembers.size(); ++n) {
                serializable = (WpdData)this.dataMembers.get(n);
                string4 = string4 + string2 + serializable.toString() + "\n";
            }
        }
        if (this.subCollections != null) {
            for (n = 0; n < this.subCollections.size(); ++n) {
                serializable = (WpdCollection)this.subCollections.get(n);
                string4 = string4 + serializable.toString(string2);
            }
        }
        return string4;
    }
}

