/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.wsspi.pmi.stat.SPIRangeStatistic;

public class RangeStatisticImpl
extends StatisticImpl
implements SPIRangeStatistic {
    private static final long serialVersionUID = -855214334683355657L;
    protected long highWaterMark = 0L;
    protected long lowWaterMark = 0L;
    protected long current = 0L;
    protected double integral = 0.0;
    protected boolean initWaterMark = false;
    protected RangeStatisticImpl baseValue = null;

    public RangeStatisticImpl(int n) {
        super(n);
    }

    public RangeStatisticImpl(int n, String string, String string2, String string3, long l, long l2) {
        super(n, string, string2, string3, l, l2);
    }

    public RangeStatisticImpl(int n, long l, long l2, long l3, double d, long l4, long l5) {
        super(n, null, null, null, l4, l5);
        this.lowWaterMark = l;
        this.highWaterMark = l2;
        this.current = l3;
        this.integral = d;
    }

    public int getStatisticType() {
        return 5;
    }

    public WSStatistic copy() {
        RangeStatisticImpl rangeStatisticImpl = new RangeStatisticImpl(this.id, this.lowWaterMark, this.highWaterMark, this.current, this.integral, this.startTime, this.lastSampleTime);
        rangeStatisticImpl.baseValue = this.baseValue;
        return rangeStatisticImpl;
    }

    public long getLowWaterMark() {
        return this.lowWaterMark;
    }

    public long getHighWaterMark() {
        return this.highWaterMark;
    }

    public long getCurrent() {
        return this.current;
    }

    public double getIntegral() {
        return this.integral;
    }

    public double getMean() {
        long l = this.lastSampleTime - this.startTime;
        if (l > 0L) {
            return this.integral * 1.0 / (double)l;
        }
        return 0.0;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean bl) {
        if (bl) {
            super.reset();
        }
        this.integral = 0.0;
        this.lowWaterMark = 0L;
        this.highWaterMark = 0L;
        this.initWaterMark = false;
    }

    public void setWaterMark(long l) {
        this.setWaterMark(System.currentTimeMillis(), l);
    }

    public void setWaterMark(long l, long l2) {
        this.lastSampleTime = l;
        if (!this.initWaterMark) {
            this.lowWaterMark = this.highWaterMark = l2;
            this.initWaterMark = true;
        } else {
            if (l2 < this.lowWaterMark) {
                this.lowWaterMark = l2;
            }
            if (l2 > this.highWaterMark) {
                this.highWaterMark = l2;
            }
        }
        this.current = l2;
    }

    private final void updateWaterMark() {
        if (this.initWaterMark) {
            if (this.current < this.lowWaterMark) {
                this.lowWaterMark = this.current;
            }
            if (this.current > this.highWaterMark) {
                this.highWaterMark = this.current;
            }
        } else {
            this.lowWaterMark = this.highWaterMark = this.current;
            this.initWaterMark = true;
        }
    }

    public void set(long l, long l2, long l3, double d, long l4, long l5) {
        this.current = l3;
        this.integral = d;
        this.lowWaterMark = l;
        this.highWaterMark = l2;
        this.startTime = l4;
        this.lastSampleTime = l5;
    }

    public void set(long l) {
        if (this.current == l) {
            return;
        }
        if (this.enabled) {
            long l2 = this.updateIntegral();
            this.setWaterMark(l2, l);
        } else {
            this.current = l;
        }
    }

    public void set(long l, long l2) {
        if (this.current == l2) {
            return;
        }
        if (this.enabled) {
            this.updateIntegral(l);
            this.setWaterMark(l, l2);
        } else {
            this.current = l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void increment() {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral();
            RangeStatisticImpl rangeStatisticImpl = this;
            synchronized (rangeStatisticImpl) {
                ++this.current;
            }
            this.updateWaterMark();
        } else {
            ++this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void increment(long l) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral();
            RangeStatisticImpl rangeStatisticImpl = this;
            synchronized (rangeStatisticImpl) {
                this.current += l;
            }
            this.updateWaterMark();
        } else {
            this.current += l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void increment(long l, long l2) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral(l);
            RangeStatisticImpl rangeStatisticImpl = this;
            synchronized (rangeStatisticImpl) {
                this.current += l2;
            }
            this.updateWaterMark();
        } else {
            this.current += l2;
        }
    }

    public final void incrementWithoutSync(long l, long l2) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral(l);
            this.current += l2;
            this.updateWaterMark();
        } else {
            this.current += l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void incrementWithSyncFlag(long l, long l2) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral(l);
            if (this.sync) {
                RangeStatisticImpl rangeStatisticImpl = this;
                synchronized (rangeStatisticImpl) {
                    this.current += l2;
                }
            } else {
                this.current += l2;
            }
            this.updateWaterMark();
        } else {
            this.current += l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrement() {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral();
            RangeStatisticImpl rangeStatisticImpl = this;
            synchronized (rangeStatisticImpl) {
                --this.current;
            }
            this.updateWaterMark();
        } else {
            --this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrement(long l) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral();
            RangeStatisticImpl rangeStatisticImpl = this;
            synchronized (rangeStatisticImpl) {
                this.current -= l;
            }
            this.updateWaterMark();
        } else {
            this.current -= l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrement(long l, long l2) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral(l);
            RangeStatisticImpl rangeStatisticImpl = this;
            synchronized (rangeStatisticImpl) {
                this.current -= l2;
            }
            this.updateWaterMark();
        } else {
            this.current -= l2;
        }
    }

    public final void decrementWithoutSync(long l, long l2) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral(l);
            this.current -= l2;
            this.updateWaterMark();
        } else {
            this.current -= l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrementWithSyncFlag(long l, long l2) {
        if (this.enabled) {
            this.lastSampleTime = this.updateIntegral(l);
            if (this.sync) {
                RangeStatisticImpl rangeStatisticImpl = this;
                synchronized (rangeStatisticImpl) {
                    this.current -= l2;
                }
            } else {
                this.current -= l2;
                if (this.current < 0L) {
                    this.current = 0L;
                }
            }
            this.updateWaterMark();
        } else {
            this.current -= l2;
        }
    }

    public final long updateIntegral() {
        long l = System.currentTimeMillis();
        this.integral += (double)((l - this.lastSampleTime) * this.current);
        return l;
    }

    public final long updateIntegral(long l) {
        this.integral += (double)((l - this.lastSampleTime) * this.current);
        return l;
    }

    public void setLastValue(long l) {
        this.current = l;
    }

    public void combine(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return;
        }
        RangeStatisticImpl rangeStatisticImpl = (RangeStatisticImpl)wSStatistic;
        this.current += rangeStatisticImpl.current;
        long l = rangeStatisticImpl.updateIntegral();
        rangeStatisticImpl.setLastSampleTime(l);
        if (this.lastSampleTime - this.startTime == 0L) {
            this.updateIntegral(l);
            this.setLastSampleTime(l);
        }
        double d = rangeStatisticImpl.getIntegral() * 1.0 / (double)(l - rangeStatisticImpl.getStartTime());
        this.integral += (double)((long)(d * (double)(this.lastSampleTime - this.startTime)));
        if (rangeStatisticImpl.lowWaterMark < this.lowWaterMark) {
            this.lowWaterMark = rangeStatisticImpl.lowWaterMark;
        }
        if (rangeStatisticImpl.highWaterMark > this.highWaterMark) {
            this.highWaterMark = rangeStatisticImpl.highWaterMark;
        }
    }

    public void update(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return;
        }
        RangeStatisticImpl rangeStatisticImpl = (RangeStatisticImpl)wSStatistic;
        if (this.baseValue == null) {
            this.integral = rangeStatisticImpl.integral;
            this.startTime = rangeStatisticImpl.startTime;
        } else {
            this.integral = rangeStatisticImpl.integral - this.baseValue.integral;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.current = rangeStatisticImpl.current;
        this.lowWaterMark = rangeStatisticImpl.lowWaterMark;
        this.highWaterMark = rangeStatisticImpl.highWaterMark;
        this.lastSampleTime = rangeStatisticImpl.lastSampleTime;
    }

    public WSStatistic delta(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return null;
        }
        RangeStatisticImpl rangeStatisticImpl = (RangeStatisticImpl)wSStatistic;
        RangeStatisticImpl rangeStatisticImpl2 = new RangeStatisticImpl(this.id);
        rangeStatisticImpl2.current = this.current - rangeStatisticImpl.current;
        rangeStatisticImpl2.integral = this.integral - rangeStatisticImpl.integral;
        rangeStatisticImpl2.startTime = rangeStatisticImpl.lastSampleTime;
        rangeStatisticImpl2.lastSampleTime = this.lastSampleTime;
        return rangeStatisticImpl2;
    }

    public WSStatistic rateOfChange(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return null;
        }
        RangeStatisticImpl rangeStatisticImpl = (RangeStatisticImpl)wSStatistic;
        RangeStatisticImpl rangeStatisticImpl2 = new RangeStatisticImpl(this.id);
        long l = (this.lastSampleTime - rangeStatisticImpl.lastSampleTime) / 1000L;
        if (l == 0L) {
            return null;
        }
        rangeStatisticImpl2.current = (this.current - rangeStatisticImpl.current) / l;
        rangeStatisticImpl2.integral = (this.integral - rangeStatisticImpl.integral) / (double)l;
        rangeStatisticImpl2.startTime = this.startTime;
        rangeStatisticImpl2.lastSampleTime = this.lastSampleTime;
        rangeStatisticImpl2.lowWaterMark = this.lowWaterMark;
        rangeStatisticImpl2.highWaterMark = this.highWaterMark;
        return rangeStatisticImpl2;
    }

    public void resetOnClient(WSStatistic wSStatistic) {
        if (wSStatistic == null) {
            if (this.baseValue == null) {
                this.baseValue = new RangeStatisticImpl(this.id);
            }
            this.baseValue.set(this.lowWaterMark, this.highWaterMark, this.current, this.integral, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (this.validate(wSStatistic)) {
            this.baseValue = (RangeStatisticImpl)wSStatistic;
            this.update(this.baseValue);
        }
    }

    private boolean validate(WSStatistic wSStatistic) {
        if (wSStatistic == null) {
            return false;
        }
        if (!(wSStatistic instanceof RangeStatisticImpl)) {
            System.out.println("WARNING: wrong data type: must be CountStatistic");
            return false;
        }
        if (wSStatistic.getId() != this.id) {
            System.out.println("WARNING: wrong data Id: expect dataId=" + this.id + ", got dataId=" + wSStatistic.getId());
            return false;
        }
        return true;
    }

    public void cleanup() {
        this.current = 0L;
        this.integral = 0.0;
        this.lastSampleTime = System.currentTimeMillis();
        this.lowWaterMark = 0L;
        this.highWaterMark = 0L;
        this.initWaterMark = false;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(super.toString(""));
        stringBuffer.append(", type=").append("RangeStatistic");
        stringBuffer.append(", lowWaterMark=");
        stringBuffer.append(this.lowWaterMark);
        stringBuffer.append(", highWaterMark=");
        stringBuffer.append(this.highWaterMark);
        stringBuffer.append(", current=");
        stringBuffer.append(this.current);
        stringBuffer.append(", integral=");
        stringBuffer.append(this.integral);
        return stringBuffer.toString();
    }

    public String toStringforBRS(String string) {
        StringBuffer stringBuffer = new StringBuffer(super.toString(""));
        stringBuffer.append(", type=").append("BoundedRangeStatistic");
        stringBuffer.append(", lowWaterMark=");
        stringBuffer.append(this.lowWaterMark);
        stringBuffer.append(", highWaterMark=");
        stringBuffer.append(this.highWaterMark);
        stringBuffer.append(", current=");
        stringBuffer.append(this.current);
        stringBuffer.append(", integral=");
        stringBuffer.append(this.integral);
        return stringBuffer.toString();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<RS id=\"");
        stringBuffer.append(this.id);
        stringBuffer.append("\" sT=\"");
        stringBuffer.append(this.startTime);
        stringBuffer.append("\" lST=\"");
        stringBuffer.append(this.lastSampleTime);
        stringBuffer.append("\" lWM=\"");
        stringBuffer.append(this.lowWaterMark);
        stringBuffer.append("\" hWM=\"");
        stringBuffer.append(this.highWaterMark);
        stringBuffer.append("\" cur=\"");
        stringBuffer.append(this.current);
        stringBuffer.append("\" int=\"");
        stringBuffer.append(this.integral);
        stringBuffer.append("\"></RS>");
        return stringBuffer.toString();
    }
}

