/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.stat;

import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.wsspi.pmi.stat.SPIAverageStatistic;

public class AverageStatisticImpl
extends StatisticImpl
implements SPIAverageStatistic {
    private static final long serialVersionUID = 532089977446362907L;
    protected long count = 0L;
    protected long min = 0L;
    protected long max = 0L;
    protected long total = 0L;
    protected double sumOfSquares = 0.0;
    protected AverageStatisticImpl baseValue = null;

    public AverageStatisticImpl(int n) {
        super(n);
    }

    public int getStatisticType() {
        return 3;
    }

    public AverageStatisticImpl(int n, int n2, int n3, int n4, double d, int n5, int n6) {
        super(0);
        this.set(n, n2, n3, n4, d, n5, n6);
    }

    public AverageStatisticImpl(int n, long l, long l2, long l3, long l4, double d, long l5, long l6) {
        super(n);
        this.set(l, l2, l3, l4, d, l5, l6);
    }

    public AverageStatisticImpl(int n, String string, String string2, String string3, long l, long l2) {
        super(n, string, string2, string3, l, l2);
    }

    public WSStatistic copy() {
        AverageStatisticImpl averageStatisticImpl = new AverageStatisticImpl(this.id, this.count, this.min, this.max, this.total, this.sumOfSquares, this.startTime, this.lastSampleTime);
        averageStatisticImpl.baseValue = this.baseValue;
        return averageStatisticImpl;
    }

    public void setDataId(int n) {
        this.id = n;
    }

    public void add(long l) {
        if (!this.enabled) {
            return;
        }
        this.add(System.currentTimeMillis(), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(long l, long l2) {
        if (!this.enabled) {
            return;
        }
        this.lastSampleTime = l;
        if (!this.sync) {
            if (l2 > this.max) {
                this.max = l2;
            }
            if (this.count > 0L) {
                if (l2 < this.min) {
                    this.min = l2;
                }
            } else {
                this.min = l2;
            }
            ++this.count;
            this.total += l2;
            this.sumOfSquares += (double)(l2 * l2);
        } else {
            AverageStatisticImpl averageStatisticImpl = this;
            synchronized (averageStatisticImpl) {
                ++this.count;
                this.total += l2;
            }
            if (l2 > this.max) {
                this.max = l2;
            }
            if (this.count > 0L) {
                if (l2 < this.min) {
                    this.min = l2;
                }
            } else {
                this.min = l2;
            }
            this.sumOfSquares += (double)(l2 * l2);
        }
    }

    public void set(long l, long l2, long l3, long l4, double d, long l5, long l6) {
        this.count = l;
        this.min = l2;
        this.max = l3;
        this.total = l4;
        this.sumOfSquares = d;
        this.startTime = l5;
        this.lastSampleTime = l6;
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean bl) {
        if (bl) {
            super.reset();
        }
        this.count = 0L;
        this.total = 0L;
        this.sumOfSquares = 0.0;
        this.min = 0L;
        this.max = 0L;
    }

    public long getCount() {
        return this.count;
    }

    public long getTotal() {
        return this.total;
    }

    public double getMean() {
        if (this.count == 0L) {
            return 0.0;
        }
        return (double)this.total * 1.0 / (double)this.count;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    public void combine(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return;
        }
        AverageStatisticImpl averageStatisticImpl = (AverageStatisticImpl)wSStatistic;
        boolean bl = this.count == 0L;
        this.count += averageStatisticImpl.count;
        this.total += averageStatisticImpl.total;
        this.sumOfSquares += averageStatisticImpl.sumOfSquares;
        if (averageStatisticImpl.count != 0L && (this.min > averageStatisticImpl.min || bl)) {
            this.min = averageStatisticImpl.min;
        }
        if (this.max < averageStatisticImpl.max) {
            this.max = averageStatisticImpl.max;
        }
        if (averageStatisticImpl.lastSampleTime > this.lastSampleTime) {
            this.lastSampleTime = averageStatisticImpl.lastSampleTime;
        }
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(super.toString(""));
        stringBuffer.append(", type=").append("AverageStatistic");
        stringBuffer.append(", avg=").append(this.getMean());
        stringBuffer.append(", min=").append(this.min);
        stringBuffer.append(", max=").append(this.max);
        stringBuffer.append(", total=").append(this.total);
        stringBuffer.append(", count=").append(this.count);
        stringBuffer.append(", sumSq=").append(this.sumOfSquares);
        return stringBuffer.toString();
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<AS");
        stringBuffer.append(" id=\"");
        stringBuffer.append(this.id);
        stringBuffer.append("\" sT=\"");
        stringBuffer.append(this.startTime);
        stringBuffer.append("\" lST=\"");
        stringBuffer.append(this.lastSampleTime);
        stringBuffer.append("\" ct=\"");
        stringBuffer.append(this.count);
        stringBuffer.append("\" max=\"");
        stringBuffer.append(this.max);
        stringBuffer.append("\" min=\"");
        stringBuffer.append(this.min);
        stringBuffer.append("\" sOS=\"");
        stringBuffer.append(this.sumOfSquares);
        stringBuffer.append("\" tot=\"");
        stringBuffer.append(this.total);
        stringBuffer.append("\">\n");
        stringBuffer.append("</AS>");
        return stringBuffer.toString();
    }

    public void update(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return;
        }
        AverageStatisticImpl averageStatisticImpl = (AverageStatisticImpl)wSStatistic;
        if (this.baseValue == null) {
            this.count = averageStatisticImpl.getCount();
            this.total = averageStatisticImpl.getTotal();
            this.sumOfSquares = averageStatisticImpl.sumOfSquares;
            this.startTime = averageStatisticImpl.getStartTime();
        } else {
            this.count = averageStatisticImpl.count - this.baseValue.count;
            this.total = averageStatisticImpl.total - this.baseValue.total;
            this.sumOfSquares = averageStatisticImpl.sumOfSquares - this.baseValue.sumOfSquares;
            this.startTime = this.baseValue.lastSampleTime;
        }
        this.min = averageStatisticImpl.getMin();
        this.max = averageStatisticImpl.getMax();
        this.lastSampleTime = averageStatisticImpl.getLastSampleTime();
    }

    public WSStatistic delta(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return null;
        }
        AverageStatisticImpl averageStatisticImpl = (AverageStatisticImpl)wSStatistic;
        AverageStatisticImpl averageStatisticImpl2 = new AverageStatisticImpl(this.id);
        averageStatisticImpl2.min = this.min;
        averageStatisticImpl2.max = this.max;
        averageStatisticImpl2.count = this.count - averageStatisticImpl.getCount();
        averageStatisticImpl2.total = this.total - averageStatisticImpl.getTotal();
        averageStatisticImpl2.sumOfSquares = this.sumOfSquares - averageStatisticImpl.sumOfSquares;
        averageStatisticImpl2.startTime = this.startTime;
        averageStatisticImpl2.lastSampleTime = this.lastSampleTime;
        return averageStatisticImpl2;
    }

    public WSStatistic rateOfChange(WSStatistic wSStatistic) {
        if (!this.validate(wSStatistic)) {
            return null;
        }
        AverageStatisticImpl averageStatisticImpl = (AverageStatisticImpl)wSStatistic;
        AverageStatisticImpl averageStatisticImpl2 = new AverageStatisticImpl(this.id);
        long l = (this.lastSampleTime - averageStatisticImpl.lastSampleTime) / 1000L;
        if (l == 0L) {
            return null;
        }
        averageStatisticImpl2.count = (this.count - averageStatisticImpl.count) / l;
        averageStatisticImpl2.sumOfSquares = (this.sumOfSquares - averageStatisticImpl.sumOfSquares) / (double)l;
        averageStatisticImpl2.total = (this.total - averageStatisticImpl.total) / l;
        averageStatisticImpl2.startTime = this.startTime;
        averageStatisticImpl2.lastSampleTime = this.lastSampleTime;
        averageStatisticImpl2.max = this.max;
        averageStatisticImpl2.min = this.min;
        return averageStatisticImpl2;
    }

    public void resetOnClient(WSStatistic wSStatistic) {
        if (wSStatistic == null) {
            if (this.baseValue == null) {
                this.baseValue = new AverageStatisticImpl(this.id);
            }
            this.baseValue.set(this.count, this.min, this.max, this.total, this.sumOfSquares, this.startTime, this.lastSampleTime);
            this.update(this.baseValue);
        } else if (this.validate(wSStatistic)) {
            this.baseValue = (AverageStatisticImpl)wSStatistic;
            this.update(this.baseValue);
        }
    }

    private boolean validate(WSStatistic wSStatistic) {
        if (wSStatistic == null) {
            return false;
        }
        if (!(wSStatistic instanceof AverageStatisticImpl)) {
            System.out.println("WARNING: wrong data type: must be AverageStatisticImpl");
            return false;
        }
        if (wSStatistic.getId() != this.id) {
            System.out.println("WARNING: wrong data Id: expect dataId=" + this.id + ", got dataId=" + wSStatistic.getId());
            return false;
        }
        return true;
    }
}

