/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLongExternalValue;
import com.ibm.websphere.pmi.server.SpdStatExternalValue;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.pmi.server.data.SpdLongExternal;
import com.ibm.ws.pmi.server.data.SpdStatExternal;
import com.ibm.ws.pmi.server.system.SystemData;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

public class SystemModule
extends PmiAbstractModule {
    private static final long serialVersionUID = -4785156674247042753L;
    public static String moduleID = "systemModule";
    private static final int defaultLevel = 0;
    private SpdLongExternal freeMemory;
    private SpdLongExternal cpuUtilization;
    private SpdStatExternal avgCpuUtilization;
    public static final int CPU_UTILIZATION = 1;
    public static final int AVG_CPU_UTILIZATION = 2;
    public static final int FREE_MEMORY = 3;
    private SystemData systemData;
    private SystemPerfData avgCPUPerfData;
    private static PlatformHelper platHelp = AdminHelper.getPlatformHelper();
    private static final TraceComponent tc = Tr.register(SystemModule.class, null, "com.ibm.ws.pmi.properties.PMIMessages");

    public SystemModule(String string) {
        boolean bl;
        block5: {
            super(moduleID, string);
            this.freeMemory = null;
            this.cpuUtilization = null;
            this.avgCpuUtilization = null;
            this.systemData = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "new SystemModule");
            }
            this.type = 13;
            bl = true;
            try {
                this.systemData = new SystemData();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = false;
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "SystemModule constructor failed");
            }
        }
        if (bl) {
            this.avgCPUPerfData = new SystemPerfData(2, this.systemData);
            super.registerModule(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "new SystemModule");
        }
    }

    protected SpdData createOneData(PmiDataInfo pmiDataInfo) {
        int n = pmiDataInfo.getId();
        if (n == 3) {
            this.freeMemory = new SpdLongExternal(n, new SystemPerfData(3, this.systemData));
            return this.freeMemory;
        }
        if (n == 1) {
            this.cpuUtilization = new SpdLongExternal(n, new SystemPerfData(1, this.systemData));
            return this.cpuUtilization;
        }
        if (n == 2) {
            this.avgCpuUtilization = new SpdStatExternal(n, this.avgCPUPerfData);
            return this.avgCpuUtilization;
        }
        if (tc.isDebugEnabled()) {
            Tr.warning(tc, "PMI0008W", " ID = " + n);
        }
        return null;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    private class SystemPerfData
    implements SpdLongExternalValue,
    SpdStatExternalValue {
        int type = 0;
        private SystemData systemData;
        private SPIStatistic statistic;

        public SystemPerfData(int n, SystemData systemData) {
            this.type = n;
            this.systemData = systemData;
            this.statistic = n == 1 || n == 3 ? new CountStatisticImpl(n) : new AverageStatisticImpl(n);
        }

        public SPIStatistic getLongValue() {
            return this.statistic;
        }

        public SPIStatistic getStatValue() {
            return this.statistic;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateStatistic() {
            if (!platHelp.isZOS() || !platHelp.isServantJvm()) {
                long l = 0L;
                if (this.type == 1) {
                    l = this.systemData.getCpuUtilization();
                    ((CountStatisticImpl)this.statistic).setCount(l);
                } else if (this.type == 2) {
                    SPIStatistic sPIStatistic = this.statistic;
                    synchronized (sPIStatistic) {
                        AverageStatisticImpl averageStatisticImpl = (AverageStatisticImpl)this.statistic;
                        long l2 = System.currentTimeMillis();
                        long l3 = (l2 - this.statistic.getLastSampleTime()) / 1000L;
                        if (l3 > 0L) {
                            l = this.systemData.getCpuUtilization();
                            long l4 = averageStatisticImpl.getMin();
                            long l5 = averageStatisticImpl.getMax();
                            if (l4 < 0L) {
                                l4 = l;
                            } else if (l < l4) {
                                l4 = l;
                            }
                            if (l > l5) {
                                l5 = l;
                            }
                            averageStatisticImpl.set(averageStatisticImpl.getCount() + l3, l4, l5, averageStatisticImpl.getTotal() + l * l3, 0.0, averageStatisticImpl.getStartTime(), l2);
                        }
                    }
                } else if (this.type == 3) {
                    l = this.systemData.getFreeMemory();
                    ((CountStatisticImpl)this.statistic).setCount(l);
                } else if (tc.isDebugEnabled()) {
                    Tr.warning(tc, "PMI0008W", "dataId=" + this.type);
                }
            }
        }
    }
}

