/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.modules;

import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdLoadExternalValue;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdLongExternalValue;
import com.ibm.ws.pmi.server.data.SpdLoadExternal;
import com.ibm.ws.pmi.server.data.SpdLongExternal;
import com.ibm.ws.pmi.server.jvmpi.JvmpiGroup;
import com.ibm.ws.pmi.server.system.ProcessCPUData;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.wsspi.pmi.stat.SPIStatistic;

public class RuntimeModule
extends PmiAbstractModule {
    private static final long serialVersionUID = 8043659515781921484L;
    public static String moduleID = "jvmRuntimeModule";
    private static final int defaultLevel = 0;
    private SpdLoadExternal totalMemory = null;
    private SpdLongExternal freeMemory = null;
    private SpdLongExternal usedMemory = null;
    private SpdLong upTime = null;
    private SpdLongExternal cpuUsage = null;
    public static long jvmStartTime = 0L;
    public static final int MEMORY_TOTAL = 1;
    public static final int MEMORY_FREE = 2;
    public static final int MEMORY_USED = 3;
    public static final int UP_TIME = 4;
    public static final int CPU_USAGE = 5;
    private static boolean jvmpiLoaded = false;
    private static boolean jvmtiLoaded = false;
    private static boolean init = false;
    private int initialHeapSize = -1;
    private int maxHeapSize = -1;

    public RuntimeModule(int n, int n2) {
        super(moduleID, "jvm.memory");
        this.initialHeapSize = n;
        this.maxHeapSize = n2;
        jvmStartTime = System.currentTimeMillis();
        this.type = 14;
        this.registerModule(this);
        if (jvmtiLoaded || jvmpiLoaded || this.currentLevel >= 15) {
            if (jvmpiLoaded) {
                new JvmpiGroup(true);
            } else {
                new JvmpiGroup(false);
            }
        }
        init = true;
    }

    public String[] getPath() {
        return new String[]{moduleID};
    }

    public String getWCCMStatsType() {
        return "jvmRuntimeModule#";
    }

    public static void setJVMPIEnabled(boolean bl) {
        jvmpiLoaded = bl;
    }

    public static void setJVMTIEnabled(boolean bl) {
        jvmtiLoaded = bl;
    }

    protected SpdData createOneData(PmiDataInfo pmiDataInfo) {
        int n = pmiDataInfo.getId();
        if (n == 1) {
            this.totalMemory = new SpdLoadExternal(n, new JvmLoadData(1, this.initialHeapSize, this.maxHeapSize));
            return this.totalMemory;
        }
        if (n == 2) {
            this.freeMemory = new SpdLongExternal(n, new JvmData(2));
            return this.freeMemory;
        }
        if (n == 3) {
            this.usedMemory = new SpdLongExternal(n, new JvmData(3));
            return this.usedMemory;
        }
        if (n == 4) {
            this.upTime = new SpdLongExternal(n, new JvmData(4));
            return this.upTime;
        }
        if (n == 5) {
            this.upTime = new SpdLongExternal(n, new JvmData(5));
            return this.upTime;
        }
        return null;
    }

    public String getModuleID() {
        return moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    private class JvmLoadData
    implements SpdLoadExternalValue {
        int type = 0;
        BoundedRangeStatisticImpl data = null;

        public JvmLoadData(int n, long l, long l2) {
            this.data = new BoundedRangeStatisticImpl(n);
            this.data.setLowerBound(l);
            this.data.setUpperBound(l2);
            this.getLoadValue();
        }

        public SPIStatistic getLoadValue() {
            return this.data;
        }

        public void updateStatistic() {
            this.data.set(Runtime.getRuntime().totalMemory() / 1024L);
        }
    }

    private class JvmData
    implements SpdLongExternalValue {
        int type = 0;
        CountStatisticImpl data = null;
        ProcessCPUData processCPUData;

        public JvmData(int n) {
            this.type = n;
            this.data = new CountStatisticImpl(n);
            if (n == 5) {
                this.processCPUData = new ProcessCPUData();
            }
        }

        public SPIStatistic getLongValue() {
            return this.data;
        }

        public void updateStatistic() {
            if (this.type == 2) {
                this.data.setCount(Runtime.getRuntime().freeMemory() / 1024L);
            } else if (this.type == 3) {
                this.data.setCount((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
            } else if (this.type == 4) {
                long l = System.currentTimeMillis();
                this.data.setCount((l - jvmStartTime) / 1000L, l);
            } else if (this.type == 5) {
                this.data.setCount(this.processCPUData.getProcessCpuUtilization());
            } else {
                System.err.println("[RuntimeModule.JvmData] WARNING: Invalid type to getLongValue()");
            }
        }
    }
}

