/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.jvmpi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.jvmpi.JvmpiInfo;
import com.ibm.ws.pmi.server.jvmpi.JvmpiJni;
import java.util.ArrayList;

public class JvmpiGroup {
    private ArrayList subGroups = new ArrayList();
    private static final int PMI_JVMPI_GC = 0;
    private static final int PMI_JVMPI_MONITOR = 1;
    private static final int PMI_JVMPI_THREAD = 2;
    private static final int PMI_JVMPI_OBJECT = 3;
    private static final String GC_NAME = "GC";
    private static final String MONITOR_NAME = "Monitor";
    private static final String THREAD_NAME = "Thread";
    private static final String OBJECT_NAME = "Object";
    private static int iJvmpiLoaded = 0;
    protected static TraceComponent tc = Tr.register(JvmpiGroup.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    static int jvmpiDebug = 0;
    private static boolean bJvmpi = false;
    private static boolean libraryLoaded = false;

    public JvmpiGroup(boolean bl) {
        bJvmpi = bl;
        this.initialize();
    }

    public JvmpiGroup() {
        this.initialize();
    }

    private static void initLibrary() {
        if (libraryLoaded) {
            return;
        }
        try {
            if (System.getProperty("os.name").equals("OS/400")) {
                if (bJvmpi) {
                    System.load("/QSYS.LIB/" + System.getProperty("was.install.library") + ".LIB/QWASJVMPI.SRVPGM");
                } else {
                    System.load("/QSYS.LIB/" + System.getProperty("was.install.library") + ".LIB/QWASJVMTI.SRVPGM");
                }
            } else if (bJvmpi) {
                String string = System.getProperty("com.ibm.vm.bitmode");
                int n = Integer.parseInt(string);
                if (n == 64 && System.getProperty("os.name").equals("z/OS")) {
                    System.loadLibrary("pmiJvmpiProfiler64");
                } else {
                    System.loadLibrary("pmiJvmpiProfiler");
                }
            } else {
                String string = System.getProperty("com.ibm.vm.bitmode");
                int n = Integer.parseInt(string);
                if (n == 64 && System.getProperty("os.name").equals("z/OS")) {
                    System.loadLibrary("pmiJvmtiProfiler64");
                } else {
                    System.loadLibrary("pmiJvmtiProfiler");
                }
            }
            libraryLoaded = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            FFDCFilter.processException(unsatisfiedLinkError, "com.ibm.ws.pmi.server.jvmpi.JvmpiGroup", "150");
        }
    }

    private void initialize() {
        JvmpiGroup.initLibrary();
        String[] stringArray = new String[]{GC_NAME, OBJECT_NAME, THREAD_NAME, MONITOR_NAME};
        try {
            iJvmpiLoaded = JvmpiJni.isJVMPIEnabled();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            FFDCFilter.processException((Throwable)unsatisfiedLinkError, "com.ibm.ws.pmi.server.jvmpi.JvmpiGroup.JvmpiGroup", "160", this);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.server.jvmpi.JvmpiGroup.JvmpiGroup", "163", this);
        }
        if (iJvmpiLoaded == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JVMPI library not loaded");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            jvmpiDebug = 1;
            JvmpiJni.setDebug(1);
            Tr.debug(tc, "Enabling JVMPI native debug");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n = -1;
            if (stringArray[i].equals(GC_NAME)) {
                n = 0;
            } else if (stringArray[i].equals(MONITOR_NAME)) {
                n = 1;
            } else if (stringArray[i].equals(THREAD_NAME)) {
                n = 2;
            } else if (stringArray[i].equals(OBJECT_NAME)) {
                n = 3;
            } else {
                System.err.println("WARNING: JvmpiGroup receives wrong group name");
            }
            if (n == -1) continue;
            this.subGroups.add(new JvmpiDataGroup(stringArray[i], n));
        }
    }

    public void setInstrumentationLevel(int n) {
        if (this.subGroups == null || this.subGroups.size() == 0) {
            return;
        }
        PmiModule pmiModule = null;
        for (int i = 0; i < this.subGroups.size(); ++i) {
            pmiModule = (PmiModule)this.subGroups.get(i);
            pmiModule.setInstrumentationLevel(n);
        }
    }

    class JvmpiDataGroup
    extends PmiAbstractModule {
        private static final long serialVersionUID = 5416391206176569362L;
        final String moduleID = "jvmRuntimeModule";
        final int defaultLevel = 0;
        JvmpiInfo[] members;
        int groupId;

        public JvmpiDataGroup(String string, int n) {
            super("jvmRuntimeModule", string);
            this.moduleID = "jvmRuntimeModule";
            this.defaultLevel = 0;
            this.members = null;
            this.groupId = -1;
            this.groupId = n;
            this.members = this.createMembers(n);
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i].pmiData == null) continue;
                this.putToTable(this.members[i].pmiData);
            }
            this.submoduleName = string;
            this.type = 16;
            this.registerModule(this);
        }

        public synchronized void setInstrumentationLevel(int n) {
            JvmpiJni.setLevel(this.groupId, this.getStatID(this.groupId, n), n);
            for (int i = 0; i < this.members.length; ++i) {
                this.members[i].setLevel(n);
            }
            this.currentLevel = n;
            this.updateDataList();
        }

        public synchronized boolean setFineGrainedInstrumentation(int[] nArray, int[] nArray2) {
            if (nArray != null && nArray.length == 1 && nArray[0] == -3) {
                JvmpiJni.setLevel(this.groupId, this.getStatID(this.groupId, 15), -2);
            } else {
                nArray = this.getList(this.groupId, nArray, nArray2);
                JvmpiJni.setLevel(this.groupId, nArray, -2);
            }
            return super.setFineGrainedInstrumentation(nArray, new int[0]);
        }

        public String getModuleID() {
            return "jvmRuntimeModule";
        }

        public int getDefaultLevel() {
            return 0;
        }

        public String[] getPath() {
            return new String[]{"jvmRuntimeModule", this.instanceName};
        }

        public String getWCCMStatsType() {
            if (this.groupId == 0) {
                return "jvmRuntimeModule#GC";
            }
            if (this.groupId == 3) {
                return "jvmRuntimeModule#Object";
            }
            if (this.groupId == 2) {
                return "jvmRuntimeModule#Thread";
            }
            if (this.groupId == 1) {
                return "jvmRuntimeModule#Monitor";
            }
            return "jvmRuntimeModule";
        }

        private JvmpiInfo[] createMembers(int n) {
            JvmpiInfo[] jvmpiInfoArray = null;
            if (n == 0) {
                jvmpiInfoArray = new JvmpiInfo[]{new JvmpiInfo(11, 1, 11, 15), new JvmpiInfo(12, 3, 12, 15), new JvmpiInfo(13, 3, 13, 15)};
            } else if (n == 3) {
                jvmpiInfoArray = new JvmpiInfo[]{new JvmpiInfo(14, 1, 14, 15), new JvmpiInfo(15, 1, 15, 15), new JvmpiInfo(16, 1, 16, 15)};
            } else if (n == 2) {
                jvmpiInfoArray = new JvmpiInfo[]{new JvmpiInfo(17, 1, 17, 15), new JvmpiInfo(18, 1, 18, 15)};
            } else if (n == 1) {
                jvmpiInfoArray = new JvmpiInfo[]{new JvmpiInfo(19, 1, 19, 15), new JvmpiInfo(20, 3, 20, 15)};
            }
            return jvmpiInfoArray;
        }

        private int[] getStatID(int n, int n2) {
            if (n2 != 15) {
                return new int[]{-1};
            }
            if (n == 0) {
                return new int[]{11, 12, 13};
            }
            if (n == 3) {
                return new int[]{14, 15, 16};
            }
            if (n == 2) {
                return new int[]{17, 18};
            }
            if (n == 1) {
                return new int[]{19, 20};
            }
            return new int[]{-1};
        }

        private int[] getList(int n, int[] nArray, int[] nArray2) {
            int n2;
            if (nArray == null) {
                nArray = new int[]{};
            }
            if (nArray2 == null) {
                nArray2 = new int[]{};
            }
            int n3 = nArray.length + nArray2.length;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(3);
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (!this._isValid(n, nArray[n2])) continue;
                arrayList.add(new Integer(nArray[n2]));
            }
            for (n2 = 0; n2 < nArray2.length; ++n2) {
                if (!this._isValid(n, nArray2[n2])) continue;
                arrayList.add(new Integer(nArray2[n2]));
            }
            int[] nArray3 = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                nArray3[i] = (Integer)arrayList.get(i);
            }
            return nArray3;
        }

        private boolean _isValid(int n, int n2) {
            return n == 0 ? n2 == 11 || n2 == 12 || n2 == 13 : (n == 3 ? n2 == 14 || n2 == 15 || n2 == 16 : (n == 2 ? n2 == 17 || n2 == 18 : n == 1 && (n2 == 19 || n2 == 20)));
        }
    }
}

