/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server.data;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.ws.pmi.server.data.SpdGroupBase;
import com.ibm.ws.pmi.stat.AverageStatisticImpl;
import com.ibm.ws.pmi.stat.BoundedRangeStatisticImpl;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.DoubleStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;

public class SpdStatisticAggregate
extends SpdGroupBase
implements PmiConstants {
    private static final long serialVersionUID = -3407297120698502783L;
    protected StatisticImpl aggregateValue = null;
    protected int _type = -1;

    public SpdStatisticAggregate(PmiDataInfo pmiDataInfo) {
        super(pmiDataInfo.getId());
        this._type = pmiDataInfo.getType();
        switch (this._type) {
            case 2: {
                this.aggregateValue = new CountStatisticImpl(this.dataId);
                break;
            }
            case 3: {
                this.aggregateValue = new DoubleStatisticImpl(this.dataId);
                break;
            }
            case 4: {
                this.aggregateValue = new TimeStatisticImpl(this.dataId);
                break;
            }
            case 6: {
                this.aggregateValue = new AverageStatisticImpl(this.dataId);
                break;
            }
            case 7: {
                this.aggregateValue = new RangeStatisticImpl(this.dataId);
                break;
            }
            case 5: {
                this.aggregateValue = new BoundedRangeStatisticImpl(this.dataId);
                break;
            }
            default: {
                this._type = -1;
                System.out.println("[SpdStatisticAggregate] Invalid statistic type");
            }
        }
    }

    public boolean add(SpdData spdData) {
        if (spdData == null) {
            return false;
        }
        return super.add(spdData);
    }

    public boolean remove(SpdData spdData) {
        if (spdData == null) {
            return false;
        }
        return super.remove(spdData);
    }

    public StatisticImpl getStatistic() {
        StatisticImpl statisticImpl = this._getAggregate();
        statisticImpl.setLastSampleTime(System.currentTimeMillis());
        return statisticImpl;
    }

    private StatisticImpl _getAggregate() {
        switch (this._type) {
            case 2: {
                ((CountStatisticImpl)this.aggregateValue).reset(false);
                break;
            }
            case 3: {
                ((DoubleStatisticImpl)this.aggregateValue).reset(false);
                break;
            }
            case 4: {
                ((TimeStatisticImpl)this.aggregateValue).reset(false);
                break;
            }
            case 6: {
                ((AverageStatisticImpl)this.aggregateValue).reset(false);
                break;
            }
            case 5: {
                ((BoundedRangeStatisticImpl)this.aggregateValue).cleanup();
                break;
            }
            case 7: {
                ((RangeStatisticImpl)this.aggregateValue).cleanup();
                break;
            }
            default: {
                this._type = -1;
                System.out.println("[SpdStatisticAggregate] Invalid statistic type");
            }
        }
        for (int i = 0; i < this.members.size(); ++i) {
            Object e = this.members.get(i);
            if (e == null) continue;
            if (e instanceof SpdStatisticAggregate) {
                this.aggregateValue.combine(((SpdStatisticAggregate)e)._getAggregate());
                continue;
            }
            this.aggregateValue.combine(((SpdData)e).getStatistic());
        }
        return this.aggregateValue;
    }

    public void reset(boolean bl) {
    }
}

