/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.CountStatisticImpl;
import com.ibm.ws.pmi.stat.RangeStatisticImpl;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.ws.pmi.stat.TimeStatisticImpl;

public class StatsHelper {
    public static String statsToTclAttrString(StatsImpl statsImpl, DataDescriptor dataDescriptor, String string, String string2) {
        return StatsHelper.statsToTclAttrString(null, statsImpl, dataDescriptor, string, string2);
    }

    public static String statsToTclAttrString(String string, StatsImpl statsImpl, DataDescriptor dataDescriptor, String string2, String string3) {
        StatsImpl[] statsImplArray;
        PmiConstants pmiConstants;
        if (statsImpl == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        String string4 = string;
        String string5 = statsImpl.getStatsType();
        if (string5 == null) {
            string5 = dataDescriptor.getModuleName();
        }
        if (string5 == null) {
            string5 = "pmi";
        }
        if (string == null) {
            if (string5.equals("pmi")) {
                string = "PMI data for server";
                string4 = null;
            } else {
                pmiConstants = PmiRegistry.getConfig(string5);
                string4 = string = pmiConstants.getDescription();
            }
        }
        stringBuffer.append("{Description ").append(string).append("} ");
        stringBuffer.append("{Descriptor ").append(StatsHelper.safeString(StatsHelper.pmiDescriptorToTclAttrString(string5, dataDescriptor, string2, string3))).append("} ");
        stringBuffer.append("{Level ").append(statsImpl.getLevel()).append("}");
        pmiConstants = null;
        StatisticImpl[] statisticImplArray = (StatisticImpl[])statsImpl.listStatistics();
        if (statisticImplArray != null && statisticImplArray.length > 0) {
            stringBuffer.append(" {Data {");
            for (int i = 0; i < statisticImplArray.length; ++i) {
                pmiConstants = new DataDescriptor(dataDescriptor, statisticImplArray[i].getId());
                stringBuffer.append("{").append(StatsHelper.statisticToTclAttrString(statisticImplArray[i], statsImpl.getTime(), string5, (DataDescriptor)pmiConstants, string2, string3)).append("}");
                if (i >= statisticImplArray.length - 1) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.append("}}");
        }
        if ((statsImplArray = (StatsImpl[])statsImpl.listSubStats()) != null && statsImplArray.length > 0) {
            stringBuffer.append(" {SubCollections {");
            for (int i = 0; i < statsImplArray.length; ++i) {
                pmiConstants = new DataDescriptor(dataDescriptor, statsImplArray[i].getName());
                stringBuffer.append("{").append(StatsHelper.statsToTclAttrString(string4, statsImplArray[i], (DataDescriptor)pmiConstants, string2, string3)).append("}");
                if (i >= statsImplArray.length - 1) continue;
                stringBuffer.append(" ");
            }
            stringBuffer.append("}}");
        }
        return stringBuffer.toString();
    }

    public static String statisticToTclAttrString(StatisticImpl statisticImpl, long l, String string, DataDescriptor dataDescriptor, String string2, String string3) {
        if (statisticImpl == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("{Id ").append(statisticImpl.getId()).append("} ");
        stringBuffer.append("{Descriptor ").append(StatsHelper.safeString(StatsHelper.pmiDescriptorToTclAttrString(string, dataDescriptor, string2, string3))).append("} ");
        stringBuffer.append("{PmiDataInfo ").append(StatsHelper.safeString(StatsHelper.pmiDataInfoToTclAttrString(statisticImpl.getDataInfo()))).append("} ");
        stringBuffer.append("{Time ").append(l).append("} ");
        stringBuffer.append("{Value ").append(StatsHelper.statisticToValue(statisticImpl)).append("}");
        return stringBuffer.toString();
    }

    private static String statisticToValue(StatisticImpl statisticImpl) {
        if (statisticImpl == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (statisticImpl instanceof CountStatisticImpl) {
            CountStatisticImpl countStatisticImpl = (CountStatisticImpl)statisticImpl;
            stringBuffer.append("{Count ").append(countStatisticImpl.getCount()).append("} ");
        } else if (statisticImpl instanceof TimeStatisticImpl) {
            TimeStatisticImpl timeStatisticImpl = (TimeStatisticImpl)statisticImpl;
            stringBuffer.append("{Total ").append(timeStatisticImpl.getTotal()).append("} ");
            stringBuffer.append("{Count ").append(timeStatisticImpl.getCount()).append("} ");
            stringBuffer.append("{Mean ").append(timeStatisticImpl.getMean()).append("} ");
        } else if (statisticImpl instanceof RangeStatisticImpl) {
            RangeStatisticImpl rangeStatisticImpl = (RangeStatisticImpl)statisticImpl;
            stringBuffer.append("{Current ").append(rangeStatisticImpl.getCurrent()).append("} ");
            stringBuffer.append("{LowWaterMark ").append(rangeStatisticImpl.getLowWaterMark()).append("} ");
            stringBuffer.append("{HighWaterMark ").append(rangeStatisticImpl.getHighWaterMark()).append("} ");
            stringBuffer.append("{MBean ").append(rangeStatisticImpl.getMean()).append("} ");
        }
        return stringBuffer.toString();
    }

    public static String pmiDataInfoToTclAttrString(PmiDataInfo pmiDataInfo) {
        if (pmiDataInfo == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Name ").append(StatsHelper.safeString(pmiDataInfo.getName())).append("} ");
        stringBuffer.append("{Id ").append(pmiDataInfo.getId()).append("} ");
        stringBuffer.append("{Description ").append(StatsHelper.safeString(pmiDataInfo.getDescription())).append("} ");
        stringBuffer.append("{Level ").append(pmiDataInfo.getLevel()).append("} ");
        stringBuffer.append("{Comment ").append(StatsHelper.safeString(pmiDataInfo.getComment())).append("} ");
        stringBuffer.append("{SubmoduleName ").append(StatsHelper.safeString(pmiDataInfo.getSubmoduleName())).append("} ");
        stringBuffer.append("{Type ").append(pmiDataInfo.getType()).append("} ");
        stringBuffer.append("{Unit ").append(pmiDataInfo.getUnit()).append("} ");
        stringBuffer.append("{Resettable ").append(pmiDataInfo.isResettable()).append("}");
        return stringBuffer.toString();
    }

    public static String pmiDescriptorToTclAttrString(String string, DataDescriptor dataDescriptor, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Node ").append(StatsHelper.safeString(string2)).append("} ");
        stringBuffer.append("{Server ").append(StatsHelper.safeString(string3)).append("} ");
        if (dataDescriptor.getType() != 12) {
            stringBuffer.append("{Module ").append(StatsHelper.safeString(string)).append("} ");
            stringBuffer.append("{Name ").append(StatsHelper.safeString(dataDescriptor.getName())).append("} ");
        }
        stringBuffer.append("{Type ").append(StatsHelper.pdTypeToString(dataDescriptor.getType())).append("}");
        return stringBuffer.toString();
    }

    public static String pdTypeToString(int n) {
        switch (n) {
            case 10: {
                return "ROOT";
            }
            case 11: {
                return "NODE";
            }
            case 12: {
                return "SERVER";
            }
            case 13: {
                return "MODULE";
            }
            case 14: {
                return "INSTANCE";
            }
            case 15: {
                return "SUBMODULE";
            }
            case 16: {
                return "SUBINSTANCE";
            }
            case 17: {
                return "COLLECTION";
            }
            case 18: {
                return "DATA";
            }
            case 24: {
                return "MODULEROOT";
            }
        }
        return "UNKNOWN";
    }

    private static String safeString(String string) {
        if (null == string) {
            return string;
        }
        if (-1 != string.indexOf(" ")) {
            return "{" + string + "}";
        }
        return string;
    }
}

