/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.PmiConstants;
import com.ibm.websphere.pmi.PmiJmxMapper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.xml.ParserFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PmiJmxMapParser
extends DefaultHandler
implements PmiConstants {
    private static final TraceComponent tc = Tr.register(PmiJmxMapParser.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static final String MAPPER = "Mapper";
    private static final String MBEAN_TYPE = "mbeanType";
    private static final String PERF_MODULE = "perfModule";
    private static final String PERF_SUBMODULE = "perfSubmodule";
    private static final String MODULE_ONLY = "moduleOnly";
    private PmiJmxMapper jmxMapper = null;
    private String mbeanType = null;
    private String perfModule = null;
    private String perfInstance = null;
    private String perfSubmodule = null;
    private boolean isModuleOnlyMapping = false;
    private String currentChars = null;
    private Locator locator = null;
    private InputStream istream;
    private XMLReader parser;

    public PmiJmxMapParser(PmiJmxMapper pmiJmxMapper) {
        this.jmxMapper = pmiJmxMapper;
    }

    private void reInit() {
        this.mbeanType = null;
        this.perfModule = null;
        this.perfInstance = null;
        this.perfSubmodule = null;
        this.isModuleOnlyMapping = false;
        this.currentChars = null;
        this.locator = null;
    }

    public void parse(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", string);
        }
        final String string2 = string;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PmiJmxMapParser.this.istream = this.getClass().getResourceAsStream(string2);
                try {
                    PmiJmxMapParser.this.parser = ParserFactory.createXMLReader();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
        });
        this._parse(this.istream, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse");
        }
    }

    public void parseExtensions() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    PmiJmxMapParser.this.getExtensionInfo();
                    HashSet<URL> hashSet = new HashSet<URL>();
                    Enumeration<URL> enumeration = Thread.currentThread().getContextClassLoader().getResources("pmiJmxMapperExtension.xml");
                    while (enumeration.hasMoreElements()) {
                        hashSet.add(enumeration.nextElement());
                    }
                    Iterator iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        URL uRL = (URL)iterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Loading pmiJmxMapperExtension: " + uRL.getFile());
                        }
                        PmiJmxMapParser.this.istream = uRL.openStream();
                        PmiJmxMapParser.this.parser = ParserFactory.createXMLReader();
                        PmiJmxMapParser.this._parse(PmiJmxMapParser.this.istream, uRL.getFile());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
        });
    }

    private void getExtensionInfo() {
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry == null) {
            Tr.error(tc, "Unable to get eclipse extension registry");
            return;
        }
        String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".pmiJmxMapperExtension";
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        if (iExtensionPoint == null) {
            Tr.error(tc, "Unable to get extension point - " + string);
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing extension point " + string);
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        block0: for (int i = 0; i < iExtensionArray.length; ++i) {
            IConfigurationElement[] iConfigurationElementArray;
            IExtension iExtension = iExtensionArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing extension " + iExtension.getUniqueIdentifier());
            }
            if ((iConfigurationElementArray = iExtension.getConfigurationElements()).length != 1) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Invalid number of main elements - " + iConfigurationElementArray.length);
                continue;
            }
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
            if (!iConfigurationElement.getName().equals(MAPPER)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Invalid name of main element - expecting <Mapper> but got <" + iConfigurationElement.getName() + ">");
                continue;
            }
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren();
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = "false";
            for (int j = 0; j < iConfigurationElementArray2.length; ++j) {
                IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[j];
                String string6 = iConfigurationElement2.getName();
                if (string6.equals(MBEAN_TYPE)) {
                    string2 = iConfigurationElement2.getValue();
                    continue;
                }
                if (string6.equals(PERF_MODULE)) {
                    string3 = iConfigurationElement2.getValue();
                    continue;
                }
                if (string6.equals("perfSubModule")) {
                    string4 = iConfigurationElement2.getValue();
                    continue;
                }
                if (string6.equals(MODULE_ONLY)) {
                    string5 = iConfigurationElement2.getValue();
                    continue;
                }
                if (!tc.isDebugEnabled()) continue block0;
                Tr.debug(tc, "Invalid element name under Mapper - " + string6);
                continue block0;
            }
            if (string2 == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Required element <mbeanType> missing under <Mapper>");
                continue;
            }
            if (string3 == null) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Required element <perfModule> missing under <Mapper>");
                continue;
            }
            if (!string5.equals("true") && !string5.equals("false")) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Invalid value for <moduleOnly> - expecting 'true' or 'false' but got '" + string5 + "'");
                continue;
            }
            this.jmxMapper.setMapping(string3, this.perfInstance, this.perfSubmodule, string2);
            if (!string5.equals("true")) continue;
            this.jmxMapper.setModuleOnlyMapping(string3, string2);
        }
    }

    private void _parse(InputStream inputStream, String string) {
        this.reInit();
        if (inputStream == null) {
            Tr.error(tc, "PMI0010W", string);
            return;
        }
        try {
            this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
            boolean bl = Boolean.getBoolean("com.ibm.websphere.pmi.validateDescriptors");
            this.parser.setFeature("http://xml.org/sax/features/validation", bl);
            this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", bl);
            this.parser.setEntityResolver(this);
            this.parser.setContentHandler(this);
            this.parser.setErrorHandler(this);
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(string);
            this.parser.parse(inputSource);
            inputStream.close();
            this.parser = null;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.pmi.server.PmiJmxParser._parse", "97", this);
            return;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "error", sAXParseException);
        }
        throw new SAXException(sAXParseException);
    }

    public void startDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startDocument");
        }
    }

    public void endDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endDocument");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equals(MAPPER)) {
            this.isModuleOnlyMapping = false;
            this.perfSubmodule = null;
            this.perfModule = null;
            this.mbeanType = null;
        } else if (string3.equals(MBEAN_TYPE) || string3.equals(PERF_MODULE) || string3.equals(PERF_SUBMODULE) || string3.equals(MODULE_ONLY)) {
            // empty if block
        }
        this.currentChars = null;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals(MAPPER)) {
            this.jmxMapper.setMapping(this.perfModule, this.perfInstance, this.perfSubmodule, this.mbeanType);
            if (this.isModuleOnlyMapping) {
                this.jmxMapper.setModuleOnlyMapping(this.perfModule, this.mbeanType);
            }
        } else if (string3.equals(MBEAN_TYPE)) {
            this.mbeanType = this.currentChars;
        } else if (string3.equals(PERF_MODULE)) {
            this.perfModule = this.currentChars;
        } else if (string3.equals(PERF_SUBMODULE)) {
            this.perfSubmodule = this.currentChars;
        } else if (string3.equals(MODULE_ONLY) && this.currentChars.equals("true")) {
            this.isModuleOnlyMapping = true;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.currentChars = this.currentChars == null ? string : this.currentChars + string;
    }
}

