/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.websphere.pmi.stat.WSStats;
import com.ibm.ws.pmi.component.PMIImpl;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PMIServiceState;
import com.ibm.ws.pmi.server.PmiConfigManager;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.server.RtPMIModule;
import java.util.ArrayList;
import javax.management.Notification;

public class PerfPrivate
extends RuntimeCollaborator {
    private static TraceComponent tc = Tr.register(PMIImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private static PerfPrivate instance;
    private static int notifySeqNum;
    public static final String NOTIFY_BEFORE_SERVANT_STOP = "websphere.pmi.beforeServantStop";
    public static final String NOTIFY_BEFORE_SERVANT_IDLE = "websphere.pmi.beforeServantIdle";
    public static final int SERVANT_STOP = 1;
    public static final int SERVANT_IDLE = 2;

    private PerfPrivate() {
    }

    public static void init() throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initialize PerfPrivate");
        }
        if (instance == null) {
            instance = new PerfPrivate();
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            mBeanFactory.activateMBean("PerfPrivate", instance, "PerfPrivateMBean", null);
        }
    }

    public static DataDescriptor getDataDescriptor(MBeanStatDescriptor mBeanStatDescriptor) {
        return PmiRegistry.mBeanToDataDescriptor(mBeanStatDescriptor);
    }

    public static WSStats getServerStats() {
        return PmiRegistry.getServerSnapshot();
    }

    public static void sendNotification(int n, String string) throws Exception {
        Notification notification;
        if (instance == null) {
            throw new Exception("PerfPrivate is null");
        }
        if (n == 1) {
            notification = new Notification(NOTIFY_BEFORE_SERVANT_STOP, instance.getObjectName(), notifySeqNum++);
        } else if (n == 2) {
            notification = new Notification(NOTIFY_BEFORE_SERVANT_IDLE, instance.getObjectName(), notifySeqNum++);
        } else {
            throw new Exception("Unknown event type");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(2);
        arrayList.add(string);
        arrayList.add(PmiRegistry.getServerSnapshot());
        notification.setUserData(arrayList);
        instance.sendNotification(notification);
    }

    public static RtPMIModule getPMIConfig() {
        return PmiConfigManager.getRuntimePMISpec();
    }

    public static String getStatisticSetID() {
        return PMIImpl.getStatisticSet();
    }

    public static Boolean getSynchronizedUpdate() {
        return new Boolean(PMIImpl.getSynchronizedUpdate());
    }

    public static void setStatisticSetID(String string) {
        PmiRegistry.setInstrumentationLevel(string);
        PMIImpl.setStatisticSet(string);
    }

    public void setSynchronizedUpdate(Boolean bl) {
        PMIImpl.setSynchronizedUpdate(bl);
        PmiRegistry.setSynchronizedUpdate(bl);
    }

    public static void updatePMIConfig(String[] stringArray, String string, Integer[] integerArray, Integer[] integerArray2, Boolean bl) {
        if (integerArray == null || integerArray2 == null) {
            return;
        }
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        int[] nArray2 = new int[integerArray2.length];
        for (int i = 0; i < integerArray2.length; ++i) {
            nArray2[i] = integerArray2[i];
        }
        ModuleItem moduleItem = PmiRegistry.findModuleItem(stringArray);
        if (moduleItem != null) {
            moduleItem.setInstanceLevel(nArray, new int[0], -2, bl);
        }
    }

    public void persistPMIConfig() {
        PmiConfigManager.saveSpec();
    }

    public PMIServiceState getPMIServiceState() {
        PMIServiceState pMIServiceState = PMIImpl.getStateObject();
        pMIServiceState.setInstrumentationSpec(PmiRegistry.getInstrumentationLevelString60());
        return pMIServiceState;
    }

    static {
        notifySeqNum = 0;
    }
}

