/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.server;

import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.PmiModule;
import com.ibm.websphere.pmi.server.PmiModuleAggregate;
import com.ibm.websphere.pmi.server.SpdData;
import com.ibm.websphere.pmi.server.SpdGroup;

public class ModuleAggregate
extends PmiAbstractModule
implements PmiModuleAggregate {
    private static final long serialVersionUID = -8176996451666384014L;
    private String moduleID = null;
    private final int defaultLevel = 0;
    private String[] path = null;
    private static final String BeanModuleWccmType = "beanModule#";

    public ModuleAggregate(String string) {
        this(string, null);
    }

    public ModuleAggregate(String string, boolean bl) {
        super(string, null);
        this.moduleID = string;
        this.type = this.categoryName == null ? 13 : 19;
        this.aggregateModule = true;
        if (bl) {
            this.registerModule(this);
        }
    }

    public ModuleAggregate(String string, String string2) {
        super(string, null);
        this.moduleID = string;
        this.categoryName = string2;
        this.type = string2 == null ? 13 : 19;
        this.aggregateModule = true;
        this.registerModule(this);
    }

    public ModuleAggregate(String string, String string2, String string3) {
        this(string, null, string2, string3);
    }

    public ModuleAggregate(String string, String string2, String string3, String string4) {
        super(string, string3);
        this.moduleID = string;
        this.categoryName = string2;
        this.submoduleName = string4;
        this.type = 15;
        this.aggregateModule = true;
        this.registerModule(this);
    }

    public ModuleAggregate(String[] stringArray, String string, int n) {
        super(stringArray[0], stringArray[1]);
        this.path = stringArray;
        this.type = n;
        this.moduleID = stringArray[0];
        if (n == 14) {
            this.instanceName = string;
        } else if (n == 15) {
            this.submoduleName = string;
        } else if (n == 19) {
            this.categoryName = string;
        }
        this.aggregateModule = true;
        this.registerModule(this);
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public String[] getPath() {
        if (this.path != null) {
            return this.path;
        }
        if (this.instanceName == null && this.type == 15) {
            return new String[]{this.moduleID, this.submoduleName};
        }
        return super.getPath();
    }

    public synchronized void add(PmiModule pmiModule) {
        if (pmiModule == null) {
            return;
        }
        PmiModuleConfig pmiModuleConfig = null;
        boolean bl = true;
        if (!pmiModule.getModuleID().equals(this.getModuleID())) {
            bl = false;
            this.addModuleID(pmiModule.getModuleID());
            pmiModuleConfig = PerfModules.getConfig(pmiModule.getModuleID());
        } else {
            pmiModuleConfig = this.moduleConfig;
        }
        SpdData[] spdDataArray = pmiModule.listData();
        if (spdDataArray == null || pmiModuleConfig == null) {
            return;
        }
        for (int i = 0; i < spdDataArray.length; ++i) {
            int n = spdDataArray[i].getId();
            PmiDataInfo pmiDataInfo = pmiModuleConfig.getDataInfo(n);
            if (pmiDataInfo == null || !pmiDataInfo.isAggregatable()) continue;
            SpdGroup spdGroup = (SpdGroup)this.dataTable.get(new Integer(n));
            if (spdGroup == null) {
                spdGroup = (SpdGroup)this.createAggregateData(pmiDataInfo);
                if (spdGroup != null) {
                    this.putToTable(spdGroup);
                }
                if (this.currentLevel == -2) {
                    if (!this.isEnabled(n)) {
                        spdGroup.disable();
                    }
                } else if (pmiDataInfo.getLevel() > this.currentLevel) {
                    spdGroup.disable();
                }
            }
            spdGroup.add(spdDataArray[i]);
        }
    }

    public synchronized void remove(PmiModule pmiModule) {
        if (pmiModule == null) {
            return;
        }
        this.remove(pmiModule.listData());
    }

    public synchronized void remove(SpdData[] spdDataArray) {
        if (spdDataArray == null) {
            return;
        }
        for (int i = 0; i < spdDataArray.length; ++i) {
            SpdGroup spdGroup = (SpdGroup)this.dataTable.get(new Integer(spdDataArray[i].getId()));
            if (spdGroup == null) continue;
            spdGroup.remove(spdDataArray[i]);
        }
    }

    public synchronized boolean remove(SpdData spdData) {
        if (spdData == null) {
            return false;
        }
        SpdGroup spdGroup = (SpdGroup)this.dataTable.get(new Integer(spdData.getId()));
        if (spdGroup == null) {
            return false;
        }
        return spdGroup.remove(spdData);
    }

    public void addModuleID(String string) {
    }

    public String getWCCMStatsType() {
        if (this.moduleID.equals("beanModule")) {
            String[] stringArray = this.getPath();
            if (stringArray != null && stringArray.length == 3) {
                return BeanModuleWccmType + stringArray[2];
            }
            return BeanModuleWccmType;
        }
        if (this.moduleID.equals("wlmModule")) {
            String[] stringArray = this.getPath();
            if (stringArray != null && stringArray.length == 1) {
                return "wlmModule#";
            }
            return super.getWCCMStatsType();
        }
        return super.getWCCMStatsType();
    }
}

