/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.preprocessor;

import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.ws.pmi.preprocessor.PmiModuleConfigLookupPrinterJetHelper;
import com.ibm.ws.pmi.server.ModuleConfigParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class PmiModuleConfigLookupPrinter {
    private static char SEPARATOR = (char)47;
    private static String GEN_CLASS_SUFFIX = "_StatsTemplateLookup";
    private static String GEN_CLASS_LOCATION = "com/ibm/ws/pmi/preprocess";
    private static String GEN_CLASS_PACKAGE = "com.ibm.ws.pmi.preprocess";
    private static String TMP_DIR_LOCATION = "_pmitemp";
    private static String className;
    private static String classLoc;
    private static String txtFileLoc;

    public static void main(String[] stringArray) {
        try {
            if (stringArray == null || stringArray.length < 2) {
                System.out.println("PmiModuleConfigLookupPrinter input arguments missing.");
                return;
            }
            className = stringArray[0];
            className = className.replace('.', '_');
            className = className + GEN_CLASS_SUFFIX;
            txtFileLoc = stringArray[1];
            System.out.println("Parsing templates..");
            PmiModuleConfig[] pmiModuleConfigArray = PmiModuleConfigLookupPrinter.parse();
            System.out.println("...complete");
            PmiModuleConfigLookupPrinterJetHelper pmiModuleConfigLookupPrinterJetHelper = new PmiModuleConfigLookupPrinterJetHelper();
            ArrayList<Object> arrayList = new ArrayList<Object>(3);
            int n = className.lastIndexOf(46);
            if (n == -1) {
                arrayList.add(0, className);
                classLoc = GEN_CLASS_LOCATION;
                arrayList.add(1, GEN_CLASS_PACKAGE);
            } else {
                arrayList.add(0, className.substring(n, className.length()));
                classLoc = className.substring(0, n).replace('.', '/');
                arrayList.add(1, classLoc);
            }
            arrayList.add(2, pmiModuleConfigArray);
            System.out.println("Generating " + classLoc + SEPARATOR + className + ".java..");
            PmiModuleConfigLookupPrinter.writeFile(TMP_DIR_LOCATION + SEPARATOR + classLoc + SEPARATOR + className + ".java", pmiModuleConfigLookupPrinterJetHelper.generate(arrayList));
            System.out.println("...complete");
        }
        catch (Exception exception) {
            System.out.println("Exception while generating " + classLoc + SEPARATOR + className + ".java");
            exception.printStackTrace();
        }
    }

    public static PmiModuleConfig[] parse() throws Exception {
        String string = PmiModuleConfigLookupPrinter.consolidateSeperators(txtFileLoc);
        Properties properties = new Properties();
        properties.load(new FileInputStream(string));
        System.out.println(properties.size() + " templates listed in " + txtFileLoc);
        PmiModuleConfig[] pmiModuleConfigArray = new PmiModuleConfig[properties.size()];
        ModuleConfigParser moduleConfigParser = new ModuleConfigParser();
        Iterator<Object> iterator = properties.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 == null) continue;
            string2 = PmiModuleConfigLookupPrinter.consolidateSeperators(string2);
            String string3 = properties.getProperty(string2);
            try {
                pmiModuleConfigArray[n] = string3 != null && string3.equals("NoDTDValidate") ? moduleConfigParser.loadDescriptor(string2, false, true) : moduleConfigParser.loadDescriptor(string2, true, true);
                if (pmiModuleConfigArray[n] != null) {
                    System.out.println("  " + string2);
                } else {
                    System.out.println("Unable to locate " + string2);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception while parsing " + string2 + ": " + exception.getMessage());
            }
            ++n;
        }
        return pmiModuleConfigArray;
    }

    private static String getSrcDirectory() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("src");
        stringBuffer.append(SEPARATOR);
        stringBuffer.append(PmiModuleConfigLookupPrinter.getPackage());
        return stringBuffer.toString();
    }

    private static String getPackage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("com");
        stringBuffer.append(SEPARATOR);
        stringBuffer.append("ibm");
        stringBuffer.append(SEPARATOR);
        stringBuffer.append("ws");
        stringBuffer.append(SEPARATOR);
        stringBuffer.append("pmi");
        stringBuffer.append(SEPARATOR);
        stringBuffer.append("template");
        stringBuffer.append(SEPARATOR);
        return stringBuffer.toString();
    }

    private static void writeFile(String string, String string2) throws Exception {
        int n;
        Object object;
        File file = new File(string);
        if (!file.exists()) {
            object = file.getAbsolutePath();
            n = ((String)object).lastIndexOf(File.separatorChar);
            if (n > -1) {
                object = ((String)object).substring(0, n);
            }
            new File((String)object).mkdirs();
        }
        object = new FileWriter(file);
        n = string2.length();
        int n2 = 0;
        int n3 = 10000;
        if (n < n3) {
            n3 = n;
        }
        do {
            ((OutputStreamWriter)object).write(string2, n2, n3);
            ((OutputStreamWriter)object).flush();
            if ((n2 += n3) < n) {
                if (n - n2 >= n3) continue;
                n3 = n - n2;
                continue;
            }
            n3 = 0;
        } while (n3 > 0);
    }

    private static String consolidateSeperators(String string) {
        if (string == null) {
            return null;
        }
        if (string.lastIndexOf(92) > -1) {
            string = string.replaceAll("\\\\", "/");
        }
        return string;
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("\\\"", "\\\\\"");
        return string;
    }
}

