/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.factory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.server.PmiAbstractModule;
import com.ibm.websphere.pmi.server.SpdDouble;
import com.ibm.websphere.pmi.server.SpdLoad;
import com.ibm.websphere.pmi.server.SpdLong;
import com.ibm.websphere.pmi.server.SpdStat;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.ws.pmi.factory.StatsFactoryUtil;
import com.ibm.ws.pmi.factory.StatsGroupImpl;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.StatisticImpl;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import java.util.ArrayList;
import javax.management.ObjectName;

public class StatsInstanceImpl
extends PmiAbstractModule
implements StatsInstance {
    private static final long serialVersionUID = 7571693856735644184L;
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.pmi.properties.PMIMessages");
    private static final TraceComponent tc = Tr.register(StatsInstanceImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private String[] _path;
    private String _moduleID;
    private String _cInstanceName;
    private boolean _bHasMBean;
    private StatisticImpl[] _stats;
    private int _statCount = 0;

    protected StatsInstanceImpl(String string, PmiModuleConfig pmiModuleConfig, StatisticActions statisticActions) {
        super(pmiModuleConfig, null, statisticActions);
        this.type = 13;
        this._moduleID = pmiModuleConfig.getUID();
        this._cInstanceName = string;
        this._path = new String[]{this._cInstanceName};
        this._stats = new StatisticImpl[pmiModuleConfig.getNumData()];
    }

    protected StatsInstanceImpl(String string, PmiModuleConfig pmiModuleConfig, String[] stringArray, StatisticActions statisticActions) {
        super(pmiModuleConfig, string, statisticActions);
        this.type = 14;
        this._moduleID = pmiModuleConfig.getUID();
        this._cInstanceName = string;
        this._path = stringArray;
        this._stats = new StatisticImpl[pmiModuleConfig.getNumData()];
    }

    private void _register(ObjectName objectName, boolean bl) throws StatsFactoryException {
        MBeanStatDescriptor mBeanStatDescriptor = StatsFactoryUtil.createMBean(this, this._cInstanceName, objectName, bl);
        this._bHasMBean = mBeanStatDescriptor != null;
        StatsFactoryUtil.registerModule(this, mBeanStatDescriptor);
    }

    public static StatsInstanceImpl createInstance(String string, String string2, ObjectName objectName, boolean bl, StatisticActions statisticActions) throws StatsFactoryException {
        PmiModuleConfig pmiModuleConfig = PerfModules.getConfigFromXMLFile(string2);
        if (pmiModuleConfig == null) {
            Tr.warning(tc, "PMI0102W", string2);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0102W", new Object[]{string2}, "Unable to read custom PMI module configuration: {0}") + ". " + PerfModules.getParseExceptionMsg());
        }
        StatsInstanceImpl statsInstanceImpl = new StatsInstanceImpl(string, pmiModuleConfig, statisticActions);
        statsInstanceImpl._register(objectName, bl);
        return statsInstanceImpl;
    }

    public static StatsInstanceImpl createGroupInstance(String string, StatsGroup statsGroup, ObjectName objectName, boolean bl, StatisticActions statisticActions) throws StatsFactoryException {
        StatsGroupImpl statsGroupImpl = (StatsGroupImpl)statsGroup;
        String[] stringArray = statsGroupImpl.getPath();
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = string;
        StatsInstanceImpl statsInstanceImpl = new StatsInstanceImpl(string, statsGroupImpl.getModuleConfig(), stringArray2, statisticActions);
        statsInstanceImpl._register(objectName, bl);
        return statsInstanceImpl;
    }

    public static StatsInstanceImpl createGroupInstance(String string, StatsGroup statsGroup, String string2, ObjectName objectName, boolean bl, StatisticActions statisticActions) throws StatsFactoryException {
        PmiModuleConfig pmiModuleConfig = PerfModules.getConfigFromXMLFile(string2);
        if (pmiModuleConfig == null) {
            Tr.warning(tc, "PMI0102W", string2);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0102W", new Object[]{string2}, "Unable to read custom PMI module configuration: {0}") + ". " + PerfModules.getParseExceptionMsg());
        }
        StatsGroupImpl statsGroupImpl = (StatsGroupImpl)statsGroup;
        StatsFactoryUtil.checkDataIDUniqueness(statsGroupImpl, pmiModuleConfig);
        String[] stringArray = statsGroupImpl.getPath();
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = string;
        StatsInstanceImpl statsInstanceImpl = new StatsInstanceImpl(string, pmiModuleConfig, stringArray2, statisticActions);
        statsInstanceImpl._register(objectName, bl);
        return statsInstanceImpl;
    }

    public SPIStatistic getStatistic(int n) {
        for (int i = 0; i < this._stats.length; ++i) {
            if (this._stats[i] == null || this._stats[i].getId() != n) continue;
            return this._stats[i];
        }
        return null;
    }

    public ObjectName getMBean() {
        if (this._bHasMBean) {
            return this.getMBeanName();
        }
        return null;
    }

    public void setMBean(ObjectName objectName) {
        ModuleItem moduleItem = PmiRegistry.findModuleItem(this._path);
        if (moduleItem != null) {
            StatsFactoryUtil.setMBeanMapping(moduleItem, objectName);
        } else {
            Tr.warning(tc, "PMI0105W", this._path[this._path.length - 1]);
        }
    }

    public String getModuleID() {
        return this._moduleID;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public String[] getPath() {
        return this._path;
    }

    public String getName() {
        return this._cInstanceName;
    }

    public StatsImpl getStats(ArrayList arrayList, ArrayList arrayList2) {
        StatsImpl statsImpl = new StatsImpl(this.getModuleID(), this.getName(), this.type, this.currentLevel, arrayList, arrayList2);
        return statsImpl;
    }

    public boolean isCustomModule() {
        return true;
    }

    protected boolean longCreated(SpdLong spdLong) {
        this._setStatMap(spdLong.getStatistic());
        return true;
    }

    protected boolean doubleCreated(SpdDouble spdDouble) {
        this._setStatMap(spdDouble.getStatistic());
        return true;
    }

    protected boolean statCreated(SpdStat spdStat) {
        this._setStatMap(spdStat.getStatistic());
        return true;
    }

    protected boolean loadCreated(SpdLoad spdLoad) {
        this._setStatMap(spdLoad.getStatistic());
        return true;
    }

    protected boolean externalStatisticCreated(StatisticImpl statisticImpl) {
        this._setStatMap(statisticImpl);
        return true;
    }

    private void _setStatMap(StatisticImpl statisticImpl) {
        if (this.statisticActionLsnr != null) {
            this.statisticActionLsnr.statisticCreated(statisticImpl);
        }
        this._stats[this._statCount] = statisticImpl;
        ++this._statCount;
    }

    public String getWCCMStatsType() {
        return this._moduleID;
    }

    public synchronized boolean setFineGrainedInstrumentation(int[] nArray, int[] nArray2) {
        boolean bl = super.setFineGrainedInstrumentation(nArray, nArray2);
        if (this.statisticActionLsnr != null) {
            int n;
            int n2 = 0;
            int n3 = 0;
            for (n = 0; n < this._statCount; ++n) {
                if (!this._stats[n].isEnabled()) continue;
                ++n2;
            }
            int[] nArray3 = new int[n2];
            int[] nArray4 = new int[this._statCount - n2];
            n2 = 0;
            for (n = 0; n < this._statCount; ++n) {
                if (this._stats[n].isEnabled()) {
                    nArray3[n2++] = this._stats[n].getId();
                    continue;
                }
                nArray4[n3++] = this._stats[n].getId();
            }
            this.statisticActionLsnr.enableStatusChanged(nArray3, nArray4);
        }
        return bl;
    }
}

