/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.factory;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.pmi.PerfModules;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.MBeanStatDescriptor;
import com.ibm.ws.pmi.factory.StatsFactoryUtil;
import com.ibm.ws.pmi.factory.StatsInstanceImpl;
import com.ibm.ws.pmi.server.ModuleAggregate;
import com.ibm.ws.pmi.server.ModuleItem;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.stat.StatsImpl;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import java.util.ArrayList;
import javax.management.ObjectName;

public class StatsGroupImpl
extends ModuleAggregate
implements StatsGroup {
    private static final long serialVersionUID = 7503693980854338755L;
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.pmi.properties.PMIMessages");
    private static final TraceComponent tc = Tr.register(StatsGroupImpl.class, null, "com.ibm.ws.pmi.properties.PMIMessages");
    private String[] _path;
    private String _cGroupName;
    private boolean _bHasMBean;
    private StringBuffer _subModuleID = new StringBuffer();
    private ArrayList subModuleList;

    protected StatsGroupImpl(String string, PmiModuleConfig pmiModuleConfig) {
        super(pmiModuleConfig.getUID(), false);
        this._cGroupName = string;
        this._path = new String[]{this._cGroupName};
    }

    protected StatsGroupImpl(String string, PmiModuleConfig pmiModuleConfig, String[] stringArray) {
        super(pmiModuleConfig.getUID(), false);
        this._cGroupName = string;
        this._path = stringArray;
    }

    private void _register(ObjectName objectName, boolean bl) throws StatsFactoryException {
        MBeanStatDescriptor mBeanStatDescriptor = StatsFactoryUtil.createMBean(this, this._cGroupName, objectName, bl);
        this._bHasMBean = mBeanStatDescriptor != null;
        StatsFactoryUtil.registerModule(this, mBeanStatDescriptor);
    }

    public static StatsGroup createGroup(String string, String string2, ObjectName objectName, boolean bl) throws StatsFactoryException {
        PmiModuleConfig pmiModuleConfig = PerfModules.getConfigFromXMLFile(string2);
        if (pmiModuleConfig == null) {
            Tr.warning(tc, "PMI0102W", string2);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0102W", new Object[]{string2}, "Unable to read custom PMI module configuration: {0}") + ". " + PerfModules.getParseExceptionMsg());
        }
        StatsGroupImpl statsGroupImpl = new StatsGroupImpl(string, pmiModuleConfig);
        statsGroupImpl._register(objectName, bl);
        return statsGroupImpl;
    }

    public static StatsGroup createGroup(String string, StatsGroup statsGroup, String string2, ObjectName objectName, boolean bl) throws StatsFactoryException {
        StatsGroupImpl statsGroupImpl = (StatsGroupImpl)statsGroup;
        PmiModuleConfig pmiModuleConfig = PerfModules.getConfigFromXMLFile(string2);
        if (pmiModuleConfig == null) {
            Tr.warning(tc, "PMI0102W", string2);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0102W", new Object[]{string2}, "Unable to read custom PMI module configuration: {0}") + ". " + PerfModules.getParseExceptionMsg());
        }
        StatsFactoryUtil.checkDataIDUniqueness(statsGroupImpl, pmiModuleConfig);
        String[] stringArray = statsGroupImpl.getPath();
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = string;
        StatsGroupImpl statsGroupImpl2 = new StatsGroupImpl(string, pmiModuleConfig, stringArray2);
        statsGroupImpl2._register(objectName, bl);
        return statsGroupImpl2;
    }

    public static StatsGroup createGroup(String string, StatsInstance statsInstance, String string2, ObjectName objectName, boolean bl) throws StatsFactoryException {
        StatsInstanceImpl statsInstanceImpl = (StatsInstanceImpl)statsInstance;
        PmiModuleConfig pmiModuleConfig = PerfModules.getConfigFromXMLFile(string2);
        if (pmiModuleConfig == null) {
            Tr.warning(tc, "PMI0102W", string2);
            throw new StatsFactoryException(nls.getFormattedMessage("PMI0102W", new Object[]{string2}, "Unable to read custom PMI module configuration: {0}") + ". " + PerfModules.getParseExceptionMsg());
        }
        StatsFactoryUtil.checkDataIDUniqueness(statsInstanceImpl, pmiModuleConfig);
        String[] stringArray = statsInstanceImpl.getPath();
        String[] stringArray2 = new String[stringArray.length + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        stringArray2[stringArray.length] = string;
        StatsGroupImpl statsGroupImpl = new StatsGroupImpl(string, pmiModuleConfig, stringArray2);
        statsGroupImpl._register(objectName, bl);
        return statsGroupImpl;
    }

    public int getDefaultLevel() {
        return 0;
    }

    public String[] getPath() {
        return this._path;
    }

    public String getName() {
        return this._cGroupName;
    }

    public StatsImpl getStats(ArrayList arrayList, ArrayList arrayList2) {
        StatsImpl statsImpl = new StatsImpl(this.getModuleID() + this._subModuleID.toString(), this.getName(), this.type, this.currentLevel, arrayList, arrayList2);
        return statsImpl;
    }

    public boolean isCustomModule() {
        return true;
    }

    public ObjectName getMBean() {
        if (this._bHasMBean) {
            return this.getMBeanName();
        }
        return null;
    }

    public void setMBean(ObjectName objectName) {
        ModuleItem moduleItem = PmiRegistry.findModuleItem(this._path);
        if (moduleItem != null) {
            StatsFactoryUtil.setMBeanMapping(moduleItem, objectName);
        } else {
            Tr.warning(tc, "PMI0105W", this._path[this._path.length - 1]);
        }
    }

    public void addModuleID(String string) {
        if (this.subModuleList == null) {
            this.subModuleList = new ArrayList(2);
        }
        for (int i = 0; i < this.subModuleList.size(); ++i) {
            if (string.compareTo((String)this.subModuleList.get(i)) != 0) continue;
            return;
        }
        this.subModuleList.add(string);
        this._subModuleID.append(",").append(string);
    }

    protected String[] getCustomSubModuleList() {
        if (this.subModuleList == null) {
            return null;
        }
        String[] stringArray = new String[this.subModuleList.size()];
        for (int i = 0; i < this.subModuleList.size(); ++i) {
            stringArray[i] = (String)this.subModuleList.get(i);
        }
        return stringArray;
    }

    public String getWCCMStatsType() {
        return this.getModuleID() + this._subModuleID.toString();
    }

    public int[] getStatisticIDBySet(String string) {
        int n;
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = PerfModules.getConfig(this.getModuleID()).listStatisticsBySet(string);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            arrayList.add(new Integer(nArray[n2]));
        }
        if (this.subModuleList != null) {
            for (n2 = 0; n2 < this.subModuleList.size(); ++n2) {
                nArray = PerfModules.getConfig((String)this.subModuleList.get(n2)).listStatisticsBySet(string);
                for (n = 0; n < nArray.length; ++n) {
                    arrayList.add(new Integer(nArray[n]));
                }
            }
        }
        int[] nArray2 = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            nArray2[n] = (Integer)arrayList.get(n);
        }
        return nArray2;
    }
}

