/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.dynamicproxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.dynamicproxy.ServantProcessStatus;
import com.ibm.ws.pmi.dynamicproxy.PmiStateObject;
import com.ibm.ws.pmi.stat.StatsImpl;
import java.util.ArrayList;
import java.util.HashSet;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class PmiNotificationListener
implements NotificationListener {
    private HashSet aggregatedTermServants = new HashSet();
    private static TraceComponent tc = Tr.register(PmiNotificationListener.class, "PMI", null);

    private PmiNotificationListener() {
    }

    public static void register() throws InstanceNotFoundException {
        PmiNotificationListener pmiNotificationListener;
        ObjectName objectName;
        AdminService adminService;
        block9: {
            block8: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "register");
                }
                adminService = AdminServiceFactory.getAdminService();
                objectName = null;
                try {
                    objectName = new ObjectName("WebSphere:type=PerfPrivate,*");
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "MalformedObjectNameException while creating query bean for PerfPrivate: \n" + malformedObjectNameException);
                }
            }
            ObjectName objectName2 = (ObjectName)adminService.queryNames(objectName, null).iterator().next();
            pmiNotificationListener = new PmiNotificationListener();
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("websphere.pmi.beforeServantStop");
            notificationFilterSupport.enableType("websphere.pmi.beforeServantIdle");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "register - addNotificationListener", objectName2);
            }
            adminService.addNotificationListener(objectName2, pmiNotificationListener, (NotificationFilter)notificationFilterSupport, null);
            try {
                objectName = new ObjectName("WebSphere:type=ControlAdminService,*");
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "MalformedObjectNameException while creating query bean for PerfPrivate: \n" + malformedObjectNameException);
            }
        }
        ObjectName objectName3 = (ObjectName)adminService.queryNames(objectName, null).iterator().next();
        NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
        notificationFilterSupport.enableType("websphere.ws390.servant.terminated");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "register - addNotificationListener", objectName3);
        }
        adminService.addNotificationListener(objectName3, pmiNotificationListener, (NotificationFilter)notificationFilterSupport, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register");
        }
    }

    public void handleNotification(Notification notification, Object object) {
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", new Object[]{notification, object});
        }
        if ((object2 = notification.getUserData()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification", "Notification's UserData is null");
            }
            return;
        }
        String string = null;
        StatsImpl statsImpl = null;
        if (object2 instanceof ArrayList) {
            string = (String)((ArrayList)object2).get(0);
            statsImpl = (StatsImpl)((ArrayList)object2).get(1);
        } else if (object2 instanceof ServantProcessStatus) {
            string = ((ServantProcessStatus)object2).getServantStoken();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleNotification", new Object[]{notification.getType(), string, statsImpl});
        }
        if (notification.getType().equals("websphere.pmi.beforeServantStop")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PerfPrivate.NOTIFY_BEFORE_SERVANT_STOP event");
            }
            this.serverTerminated(string, statsImpl);
        } else if (notification.getType().equals("websphere.pmi.beforeServantIdle")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "PerfPrivate.NOTIFY_BEFORE_SERVANT_IDLE event");
            }
            PmiStateObject.addIdleServerStats(string, statsImpl);
        } else if (notification.getType().equals("websphere.ws390.servant.terminated")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServantProcessStatus.EVENT_TYPE_SERVANT_TERMINATED event");
            }
            this.serverTerminated(string, null);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "PerfPrivate.? event", notification.getType());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private synchronized void serverTerminated(String string, StatsImpl statsImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverTerminated", new Object[]{string, statsImpl});
        }
        if (this.aggregatedTermServants.contains(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "serverTerminated - already aggregated");
            }
            return;
        }
        if (statsImpl == null) {
            StatsImpl statsImpl2 = PmiStateObject.getActiveServerStats(string);
            if (statsImpl2 == null) {
                statsImpl2 = PmiStateObject.getIdleServerStats(string);
            }
            if (statsImpl2 != null) {
                PmiStateObject.addTerminatedServerStats(string, statsImpl2);
                this.aggregatedTermServants.add(string);
            }
        } else {
            PmiStateObject.addTerminatedServerStats(string, statsImpl);
            this.aggregatedTermServants.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serverTerminated");
        }
    }
}

