/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.pmi.dynamicproxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.dynamicproxy.AggregationHandler;
import com.ibm.websphere.management.dynamicproxy.ServantMBeanResult;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.ws.pmi.dynamicproxy.PerfMBeanAggregationHandler;
import com.ibm.ws.pmi.dynamicproxy.PerfPrivateLocal;
import com.ibm.ws.pmi.dynamicproxy.ZMBeanStats;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.stat.StatsImpl;
import javax.management.ObjectName;

public class MBeanStatsAggregationHandler
implements AggregationHandler {
    private static TraceComponent tc = Tr.register(MBeanStatsAggregationHandler.class, "PMI", null);

    public Object aggregateResults(String string, Object[] objectArray, String[] stringArray, ServantMBeanResult[] servantMBeanResultArray, StateObject stateObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aggregateResults", string);
        }
        if (string.equals("getStats")) {
            ServantMBeanResult servantMBeanResult;
            int n;
            if (!PerfPrivateLocal.exists()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "aggregateResults (PMI is NOT enabled)", null);
                }
                return null;
            }
            StatsImpl statsImpl = null;
            StatsImpl[] statsImplArray = null;
            String[] stringArray2 = null;
            ObjectName objectName = null;
            DataDescriptor dataDescriptor = null;
            if (servantMBeanResultArray != null && servantMBeanResultArray.length > 0) {
                statsImplArray = new StatsImpl[servantMBeanResultArray.length];
                stringArray2 = new String[servantMBeanResultArray.length];
                boolean bl = false;
                for (n = 0; n < servantMBeanResultArray.length; ++n) {
                    servantMBeanResult = servantMBeanResultArray[n];
                    if (servantMBeanResult != null) {
                        ZMBeanStats zMBeanStats = (ZMBeanStats)servantMBeanResult.getResult();
                        if (zMBeanStats != null) {
                            statsImplArray[n] = (StatsImpl)zMBeanStats.getZWSImpl();
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "ZMBeanStats is null");
                        }
                        stringArray2[n] = servantMBeanResult.getStoken();
                        if (bl) continue;
                        objectName = servantMBeanResult.getObjectName();
                        dataDescriptor = PerfPrivateLocal.get().getDataDescriptor(objectName);
                        bl = true;
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "ServantMBeanResults is null");
                }
            }
            if (dataDescriptor != null) {
                statsImpl = PerfMBeanAggregationHandler.aggregate(dataDescriptor, stringArray2, statsImplArray);
            }
            ZMBeanStats zMBeanStats = null;
            for (n = 0; servantMBeanResultArray != null && n < servantMBeanResultArray.length; ++n) {
                servantMBeanResult = servantMBeanResultArray[n];
                if (servantMBeanResult == null || (zMBeanStats = (ZMBeanStats)servantMBeanResult.getResult()) == null) continue;
                zMBeanStats.setZWSImpl(statsImpl);
                break;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "aggregateResults", zMBeanStats);
            }
            return zMBeanStats;
        }
        return string + " is NOT handled by " + this.getClass().getName();
    }
}

