/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orbimpl.transport;

import com.ibm.ws.orb.transport.ConnectionData;
import com.ibm.ws.orb.transport.ConnectionInformation;
import com.ibm.ws.orbimpl.transport.WSTransport;
import java.security.cert.X509Certificate;

public class ConnectionInformationImpl
implements ConnectionInformation {
    private ConnectionData connectionData = null;
    private X509Certificate[] theX509Certifate = null;
    private long connectionCreationTime = -1L;
    private String remoteHost = null;
    private int remotePort = -1;

    public ConnectionInformationImpl(ConnectionData connectionData, X509Certificate[] x509CertificateArray, long l, String string, int n) {
        this.connectionData = connectionData;
        this.theX509Certifate = x509CertificateArray;
        this.connectionCreationTime = l;
        this.remoteHost = string;
        this.remotePort = n;
    }

    public Object getConnectionData() {
        return this.connectionData;
    }

    public X509Certificate[] getClientX509Certificate() {
        return this.theX509Certifate;
    }

    public long getConnectionCreationTime() {
        return this.connectionCreationTime;
    }

    public String getRemoteHost() {
        if (this.remoteHost != null) {
            return this.remoteHost;
        }
        return WSTransport.getHostFromKeyString(this.connectionData.getConnectionKey());
    }

    public int getRemotePort() {
        if (this.remotePort != -1 || this.connectionData.getConnectionType() == 4L) {
            return this.remotePort;
        }
        return WSTransport.getPortFromKeyString(this.connectionData.getConnectionKey());
    }

    public String toString() {
        return new String("[" + super.toString() + ",connectionData=" + this.connectionData + ",theX509Certifate=" + this.theX509Certifate + ",connectionCreationTime=" + this.connectionCreationTime + ",remoteHost=" + this.remoteHost + ",remotePort=" + this.remotePort);
    }
}

