/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.orb;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.orb.GlobalORBExistsException;
import com.ibm.ws.security.util.AccessController;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;

public final class GlobalORBFactory {
    private static ORB orb = null;

    private GlobalORBFactory() {
    }

    public static synchronized ORB init(String[] stringArray, Properties properties) throws GlobalORBExistsException {
        if (orb != null) {
            throw new GlobalORBExistsException(orb);
        }
        orb = (ORB)ORB.init((String[])stringArray, (Properties)GlobalORBFactory.readProperties(properties));
        return orb;
    }

    public static synchronized ORB init(Applet applet, Properties properties) {
        orb = (ORB)ORB.init((Applet)applet, (Properties)GlobalORBFactory.readProperties(properties));
        return orb;
    }

    public static synchronized ORB globalORB() {
        return orb;
    }

    public static Properties readProperties(Properties properties) {
        Properties properties2 = new Properties();
        try {
            InputStream inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Thread.currentThread().getContextClassLoader().getResourceAsStream("orb.properties");
                }
            });
            if (inputStream != null) {
                properties2.load(inputStream);
                inputStream.close();
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException(privilegedActionException, "com.ibm.ws.orb.GlobalORBFactory.readProperties", "155");
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.orb.GlobalORBFactory.readProperties", "158");
        }
        if (WSLauncher.isZOS()) {
            try {
                Properties properties3 = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return System.getProperties();
                    }
                });
                properties3.putAll((Map<?, ?>)properties2);
            }
            catch (AccessControlException accessControlException) {
                FFDCFilter.processException(accessControlException, "com.ibm.ws.orb.GlobalORBFactory.readProperties", "185");
            }
        }
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        return properties2;
    }
}

