/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.naming.jndicos.CNContextImpl;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.NameFormatHelper;
import com.ibm.ws.naming.util.WsnInitCtxFactory;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class WsnInitCtx
implements Context {
    private static final TraceComponent _tc = Tr.register(WsnInitCtx.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String _sourceInfo = "SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/WsnInitCtx.java, WAS.naming.client, WAS61.SERV1, cf130745.06, ver. 1.9";
    private Hashtable _env = null;
    private WsnInitCtxFactory _factory = null;
    private Context _context = null;
    private Object _initCtxLock = new Object();
    private boolean _haveInitCtx = false;

    public WsnInitCtx(Hashtable hashtable, WsnInitCtxFactory wsnInitCtxFactory) throws NamingException {
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WsnInitCtx ctor", Helpers.traceHashtable("starting env", hashtable));
        }
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "WsnInitCtxctor", _sourceInfo);
        }
        this._env = hashtable;
        this._factory = wsnInitCtxFactory;
        if (this._env != null && (string = (String)this._env.get("com.ibm.websphere.naming.namespace.connection")) != null && string.equals("eager")) {
            this.getContextIfNull();
        }
        Tr.exit(_tc, "WsnInitCtx ctor", this._context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getContext() throws NamingException {
        Tr.entry(_tc, "getContext", this._context);
        Object object = this._initCtxLock;
        synchronized (object) {
            if (this._haveInitCtx) {
                return;
            }
            this._context = this._factory.getInitialContextInternal(this._env);
            this._haveInitCtx = true;
            this._factory = null;
            this._env = null;
        }
        Tr.exit(_tc, "getContext", this._context);
    }

    public Object lookup(Name name) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "lookup(Name), _context=" + this._context);
        }
        Context context = null;
        if (name != null) {
            context = CNContextImpl.checkForUrlContext(name, this._env);
        }
        if (context != null) {
            return context.lookup(name);
        }
        this.getContextIfNull();
        return this._context.lookup(name);
    }

    public Object lookup(String string) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "lookup(String), _context=" + this._context);
        }
        Context context = null;
        if (string != null) {
            context = CNContextImpl.checkForUrlContext(string, this._env);
        }
        if (context != null) {
            return context.lookup(string);
        }
        this.getContextIfNull();
        return this._context.lookup(string);
    }

    public void bind(Name name, Object object) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "bind(Name, Object), _context=" + this._context);
        }
        CNContextImpl.validateName(name);
        Context context = CNContextImpl.checkForUrlContext(name, this._env);
        if (context != null) {
            context.bind(name, object);
        } else {
            this.getContextIfNull();
            this._context.bind(name, object);
        }
    }

    public void bind(String string, Object object) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "bind(String, Object), _context=" + this._context);
        }
        CNContextImpl.validateName(string);
        Context context = CNContextImpl.checkForUrlContext(string, this._env);
        if (context != null) {
            context.bind(string, object);
        } else {
            this.getContextIfNull();
            this._context.bind(string, object);
        }
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "rebind(Name, Object), _context=" + this._context);
        }
        CNContextImpl.validateName(name);
        Context context = CNContextImpl.checkForUrlContext(name, this._env);
        if (context != null) {
            context.rebind(name, object);
        } else {
            this.getContextIfNull();
            this._context.rebind(name, object);
        }
    }

    public void rebind(String string, Object object) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "rebind(String, Object), _context=" + this._context);
        }
        CNContextImpl.validateName(string);
        Context context = CNContextImpl.checkForUrlContext(string, this._env);
        if (context != null) {
            context.rebind(string, object);
        } else {
            this.getContextIfNull();
            this._context.rebind(string, object);
        }
    }

    public void unbind(Name name) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "unbind(Name), _context=" + this._context);
        }
        CNContextImpl.validateName(name);
        Context context = CNContextImpl.checkForUrlContext(name, this._env);
        if (context != null) {
            context.unbind(name);
        } else {
            this.getContextIfNull();
            this._context.unbind(name);
        }
    }

    public void unbind(String string) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "unbind(String), _context=" + this._context);
        }
        CNContextImpl.validateName(string);
        Context context = CNContextImpl.checkForUrlContext(string, this._env);
        if (context != null) {
            context.unbind(string);
        } else {
            this.getContextIfNull();
            this._context.unbind(string);
        }
    }

    public void rename(Name name, Name name2) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "rename(Name, Name), _context=" + this._context);
        }
        CNContextImpl.validateName(name);
        CNContextImpl.validateName(name2);
        boolean bl = NameFormatHelper.isUrl(name);
        boolean bl2 = NameFormatHelper.isUrl(name2);
        if (bl && bl2) {
            Context context = CNContextImpl.checkForUrlContext(name, this._env);
            context.rename(name, name2);
        } else if (!bl && !bl2) {
            this.getContextIfNull();
            this._context.rename(name, name2);
        } else {
            Tr.exit(_tc, "rename(Name, Name): Crossing name spaces.");
            throw new OperationNotSupportedException("Crossing name spaces is not supported: " + name.toString() + " " + name2.toString());
        }
    }

    public void rename(String string, String string2) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "rename(String, String), _context=" + this._context);
        }
        CNContextImpl.validateName(string);
        CNContextImpl.validateName(string2);
        boolean bl = NameFormatHelper.isUrl(string);
        boolean bl2 = NameFormatHelper.isUrl(string2);
        if (bl && bl2) {
            Context context = CNContextImpl.checkForUrlContext(string, this._env);
            context.rename(string, string2);
        } else if (!bl && !bl2) {
            this.getContextIfNull();
            this._context.rename(string, string2);
        } else {
            Tr.exit(_tc, "rename(Name, Name): Crossing name spaces.");
            throw new OperationNotSupportedException("Crossing name spaces is not supported: " + string.toString() + " " + string2.toString());
        }
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "createSubcontext(Name), _context=" + this._context);
        }
        CNContextImpl.validateName(name);
        Context context = CNContextImpl.checkForUrlContext(name, this._env);
        if (context != null) {
            return context.createSubcontext(name);
        }
        this.getContextIfNull();
        return this._context.createSubcontext(name);
    }

    public Context createSubcontext(String string) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "createSubcontext(String), _context=" + this._context);
        }
        CNContextImpl.validateName(string);
        Context context = CNContextImpl.checkForUrlContext(string, this._env);
        if (context != null) {
            return context.createSubcontext(string);
        }
        this.getContextIfNull();
        return this._context.createSubcontext(string);
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "destroySubcontext(Name), _context=" + this._context);
        }
        CNContextImpl.validateName(name);
        Context context = CNContextImpl.checkForUrlContext(name, this._env);
        if (context != null) {
            context.destroySubcontext(name);
        } else {
            this.getContextIfNull();
            this._context.destroySubcontext(name);
        }
    }

    public void destroySubcontext(String string) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "destroySubcontext(String), _context=" + this._context);
        }
        CNContextImpl.validateName(string);
        Context context = CNContextImpl.checkForUrlContext(string, this._env);
        if (context != null) {
            context.destroySubcontext(string);
        } else {
            this.getContextIfNull();
            this._context.destroySubcontext(string);
        }
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "list(Name), _context=" + this._context);
        }
        Context context = null;
        if (name != null) {
            context = CNContextImpl.checkForUrlContext(name, this._env);
        }
        if (context != null) {
            return context.list(name);
        }
        this.getContextIfNull();
        return this._context.list(name);
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "list(String), _context=" + this._context);
        }
        Context context = null;
        if (string != null) {
            context = CNContextImpl.checkForUrlContext(string, this._env);
        }
        if (context != null) {
            return context.list(string);
        }
        this.getContextIfNull();
        return this._context.list(string);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "listBindings(Name), _context=" + this._context);
        }
        Context context = null;
        if (name != null) {
            context = CNContextImpl.checkForUrlContext(name, this._env);
        }
        if (context != null) {
            return context.listBindings(name);
        }
        this.getContextIfNull();
        return this._context.listBindings(name);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "listBindings(String), _context=" + this._context);
        }
        Context context = null;
        if (string != null) {
            context = CNContextImpl.checkForUrlContext(string, this._env);
        }
        if (context != null) {
            return context.listBindings(string);
        }
        this.getContextIfNull();
        return this._context.listBindings(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "lookupLink(Name), _context=" + this._context);
        }
        Context context = null;
        if (name != null) {
            context = CNContextImpl.checkForUrlContext(name, this._env);
        }
        if (context != null) {
            return context.lookupLink(name);
        }
        this.getContextIfNull();
        return this._context.lookupLink(name);
    }

    public Object lookupLink(String string) throws NamingException {
        Tr.event(_tc, "lookupLink(String), _context=" + this._context);
        Context context = null;
        if (string != null) {
            context = CNContextImpl.checkForUrlContext(string, this._env);
        }
        if (context != null) {
            return context.lookupLink(string);
        }
        this.getContextIfNull();
        return this._context.lookupLink(string);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "getNameParser(Name), _context=" + this._context);
        }
        Context context = null;
        if (name != null) {
            context = CNContextImpl.checkForUrlContext(name, this._env);
        }
        if (context != null) {
            return context.getNameParser(name);
        }
        this.getContextIfNull();
        return this._context.getNameParser(name);
    }

    public NameParser getNameParser(String string) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "getNameParser(String), _context=" + this._context);
        }
        Context context = null;
        if (string != null) {
            context = CNContextImpl.checkForUrlContext(string, this._env);
        }
        if (context != null) {
            return context.getNameParser(string);
        }
        this.getContextIfNull();
        return this._context.getNameParser(string);
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "composeName(Name, Name), _context=" + this._context);
        }
        Context context = null;
        if (name != null) {
            context = CNContextImpl.checkForUrlContext(name, this._env);
        }
        if (context != null) {
            return context.composeName(name, name2);
        }
        this.getContextIfNull();
        return this._context.composeName(name, name2);
    }

    public String composeName(String string, String string2) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "composeName(String, String), _context=" + this._context);
        }
        Context context = null;
        if (string != null) {
            context = CNContextImpl.checkForUrlContext(string, this._env);
        }
        if (context != null) {
            return context.composeName(string, string2);
        }
        this.getContextIfNull();
        return this._context.composeName(string, string2);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "addToEnvironment(String, Object), _context=" + this._context);
        }
        this.getContextIfNull();
        return this._context.addToEnvironment(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "removeFromEnvironment(String), _context=" + this._context);
        }
        this.getContextIfNull();
        return this._context.removeFromEnvironment(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "getEnvironment(), _context=" + this._context);
        }
        this.getContextIfNull();
        return this._context.getEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "close(), _haveInitCtx = " + this._haveInitCtx + ", _context = ", this._context);
        }
        Object object = this._initCtxLock;
        synchronized (object) {
            if (this._haveInitCtx && this._context != null) {
                this._context.close();
            }
        }
        Tr.exit(_tc, "close()");
    }

    public String getNameInNamespace() throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "getNameInNamespace(), _context=" + this._context);
        }
        this.getContextIfNull();
        return this._context.getNameInNamespace();
    }

    private void getContextIfNull() throws NamingException {
        if (this._haveInitCtx) {
            return;
        }
        this.getContext();
    }
}

