/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.NameFormatHelper;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public abstract class CorbaURLContext
implements Context {
    protected Hashtable _env = null;
    protected String _fullName = null;
    protected String _providerUrl = null;
    protected String _stringifiedName = null;
    protected Context _initCtx = null;
    private static final TraceComponent _tc = Tr.register(CorbaURLContext.class, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    protected static Hashtable _insEnv;
    protected static Hashtable _jndiEnv;
    private static final String METHOD_setupForLookup = "setupForLookup()";
    private static final String METHOD_setupForOtherNamingOperations = "setupForOtherNamingOperations()";
    private static final String METHOD_getInitialContext = "getInitialContext()";
    private static final String METHOD_bindS = "bind(String, Object)";
    private static final String METHOD_rebind = "rebind(String, Object)";
    private static final String METHOD_unbind = "unbind(String, Object)";
    private static final String METHOD_createSubcontext = "createSubcontext(String)";
    private static final String METHOD_destroySubcontext = "destroySubcontext(String)";
    private static final String METHOD_getNameParser = "getNameParser(String)";
    private static final String METHOD_list = "list(String)";
    private static final String METHOD_listBindings = "listBindings(String)";
    private static final String METHOD_lookup = "lookup(String)";
    private static final String METHOD_rename = "rename(String, String)";

    public CorbaURLContext(Hashtable hashtable) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "CorbaURLContext(Hashtable) - ctor");
        }
        this._env = hashtable != null ? (Hashtable)hashtable.clone() : new Hashtable();
    }

    protected void setupForLookup(String string, String string2) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_setupForLookup, "inName=" + string);
        }
        if (this._fullName == null || !this._fullName.equals(string)) {
            String[] stringArray = this.getProviderURLAndName(string);
            this._providerUrl = stringArray[0];
            this._stringifiedName = stringArray[1];
            this._fullName = string;
            this.throwIfNullStrName(this._stringifiedName, string2);
            this._initCtx = this.getInitialContext();
        }
        Tr.exit(_tc, METHOD_setupForLookup);
    }

    protected void setupForOtherNamingOperations(String string, String string2) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_setupForOtherNamingOperations, "inName=" + string);
        }
        if (this._fullName == null || !this._fullName.equals(string)) {
            String[] stringArray = this.getProviderURLAndName(string);
            this._providerUrl = stringArray[0];
            this._stringifiedName = stringArray[1];
            this._fullName = string;
            this.throwIfNullOrEmptyStrName(this._stringifiedName, string2);
            this._initCtx = this.getInitialContext();
        }
        Tr.exit(_tc, METHOD_setupForOtherNamingOperations);
    }

    private void throwIfNullStrName(String string, String string2) throws NamingException {
        if (string == null) {
            String string3 = "A null name is not allowed for the method " + string2 + ": ";
            Tr.debug(_tc, string3 + this._fullName);
            throw new InvalidNameException(string3 + this._fullName);
        }
    }

    private void throwIfNullOrEmptyStrName(String string, String string2) throws NamingException {
        String string3 = null;
        this.throwIfNullStrName(string, string2);
        if (string.length() == 0) {
            string3 = this.setErrMsgForEmptyStrName(string2);
            Tr.debug(_tc, string3 + this._fullName);
            throw new InvalidNameException(string3 + this._fullName);
        }
    }

    private Context getInitialContext() throws NamingException {
        Tr.entry(_tc, METHOD_getInitialContext);
        this._env.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
        this._env.put("java.naming.provider.url", this._providerUrl);
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext(this._env);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.util.CorbaURLContext.getInitialContext", "230", this);
            String string = "Failed to get the initial context";
            Tr.debug(_tc, METHOD_getInitialContext, new Object[]{string, "name=" + this._fullName});
            Tr.exit(_tc, METHOD_getInitialContext);
            throw namingException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_getInitialContext, "initCtx name path=" + initialContext.getNameInNamespace());
        }
        return initialContext;
    }

    public void bind(Name name, Object object) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "bind(Name, Object)", "inName=" + name);
        }
        this.bind(name.toString(), object);
    }

    public void bind(String string, Object object) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_bindS, "inName=" + string);
        }
        this.setupForOtherNamingOperations(string, METHOD_bindS);
        this._initCtx.bind(this._stringifiedName, object);
        Tr.exit(_tc, METHOD_bindS);
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "rebind(Name, Object)", "inName=" + name);
        }
        this.rebind(name.toString(), object);
    }

    public void rebind(String string, Object object) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_rebind, "inName=" + string);
        }
        this.setupForOtherNamingOperations(string, METHOD_rebind);
        this._initCtx.rebind(this._stringifiedName, object);
        Tr.exit(_tc, METHOD_rebind);
    }

    public void unbind(Name name) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "unbind(Name, Object)", "inName=" + name);
        }
        this.unbind(name.toString());
    }

    public void unbind(String string) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_unbind, "inName=" + string);
        }
        this.setupForOtherNamingOperations(string, METHOD_unbind);
        this._initCtx.unbind(this._stringifiedName);
        Tr.exit(_tc, METHOD_unbind);
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "composeName(Name, Name)", "inName=" + name + " inPrefix=" + name2);
        }
        return name;
    }

    public String composeName(String string, String string2) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "composeName(String, String)", "inName=" + string + " inPrefix=" + string2);
        }
        return string;
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "createSubcontext(Name)", "inName=" + name);
        }
        Context context = this.createSubcontext(name.toString());
        return context;
    }

    public Context createSubcontext(String string) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_createSubcontext, "inName=" + string);
        }
        this.setupForOtherNamingOperations(string, METHOD_createSubcontext);
        Context context = null;
        context = this._initCtx.createSubcontext(this._stringifiedName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSubcontext(String)Context name = " + context.getNameInNamespace());
        }
        return context;
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "destroySubcontext(Name)", "inName=" + name);
        }
        this.destroySubcontext(name.toString());
    }

    public void destroySubcontext(String string) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_destroySubcontext, "inName=" + string);
        }
        this.setupForOtherNamingOperations(string, METHOD_destroySubcontext);
        this._initCtx.destroySubcontext(this._stringifiedName);
        Tr.exit(_tc, METHOD_destroySubcontext);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getNameParser(Name)", " inName=" + name);
        }
        NameParser nameParser = this.getNameParser(name.toString());
        return nameParser;
    }

    public NameParser getNameParser(String string) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_getNameParser, "inName=" + string);
        }
        this.setupForLookup(string, METHOD_getNameParser);
        NameParser nameParser = this._initCtx.getNameParser(this._stringifiedName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_getNameParser, "retParser = " + nameParser);
        }
        return nameParser;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "list(Name)", "inName=" + name);
        }
        NamingEnumeration namingEnumeration = this.list(name.toString());
        return namingEnumeration;
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_list, "inName=" + string);
        }
        this.setupForLookup(string, METHOD_list);
        NamingEnumeration<NameClassPair> namingEnumeration = this._initCtx.list(this._stringifiedName);
        Tr.exit(_tc, METHOD_list);
        return namingEnumeration;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "listBinding(Name)", "inName=" + name);
        }
        NamingEnumeration namingEnumeration = this.listBindings(name.toString());
        return namingEnumeration;
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_listBindings, "inName=" + string);
        }
        this.setupForLookup(string, METHOD_listBindings);
        NamingEnumeration<Binding> namingEnumeration = this._initCtx.listBindings(this._stringifiedName);
        Tr.exit(_tc, METHOD_listBindings);
        return namingEnumeration;
    }

    public Object lookup(Name name) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "lookup(Name)", "inName=" + name);
        }
        Object object = this.lookup(name.toString());
        return object;
    }

    public Object lookup(String string) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_lookup, "inName=" + string);
        }
        this.setupForLookup(string, METHOD_lookup);
        Object object = this._initCtx.lookup(this._stringifiedName);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, METHOD_lookup, "retObj = " + object);
        }
        return object;
    }

    public Object lookupLink(Name name) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw Helpers.logJndiContextException((Throwable)operationNotSupportedException, (Context)this, "lookupLink(Name)", name, null);
    }

    public Object lookupLink(String string) throws NamingException {
        OperationNotSupportedException operationNotSupportedException = new OperationNotSupportedException();
        throw Helpers.logJndiContextException((Throwable)operationNotSupportedException, (Context)this, "lookupLink(String)", string, null);
    }

    public void rename(Name name, Name name2) throws NamingException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "rename(Name, Name)", "inOldName=" + name + "inNewName=" + name2);
        }
        this.rename(name.toString(), name2.toString());
    }

    public void rename(String string, String string2) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, METHOD_rename, "inOldName=" + string + "inNewName=" + string2);
        }
        if (string.compareTo(string2) == 0) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, METHOD_rename, "The old and new names are the same");
            }
            return;
        }
        this.setupForOtherNamingOperations(string, METHOD_rename);
        String[] stringArray = this.getProviderURLAndName(string2);
        if (!NameFormatHelper.isUrl(string2) || !this._providerUrl.equals(stringArray[0])) {
            throw new OperationNotSupportedException("Do not support rename cross different name spaces:" + string + " " + string2);
        }
        this._initCtx.rename(this._stringifiedName, stringArray[1]);
        Tr.exit(_tc, METHOD_rename);
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void close() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected abstract String setErrMsgForEmptyStrName(String var1);

    protected abstract String[] getProviderURLAndName(String var1) throws NamingException;

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/util/CorbaURLContext.java, WAS.naming.client, WAS61.SERV1, cf130745.06, ver. 1.13");
        }
        _insEnv = Helpers.getINSEnvironment();
        _jndiEnv = Helpers.getJNDIEnvironment();
    }
}

