/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.jcache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.ipbase.ContextID;
import com.ibm.ws.naming.ipbase.NameSpace;
import com.ibm.ws.naming.ipbase.NameSpaceBindingData;
import com.ibm.ws.naming.ipbase.NameSpaceException;
import com.ibm.ws.naming.ipbase.UnresolvedContext;
import com.ibm.ws.naming.ipbase.UuidContext;
import com.ibm.ws.naming.jcache.CacheEntryData;
import com.ibm.ws.naming.jcache.CacheEntryNotFoundException;
import com.ibm.ws.naming.jcache.CacheInvalidPropertyValueException;
import com.ibm.ws.naming.jcache.CacheManager;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.WsnName;
import java.util.Hashtable;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class Cache {
    protected static final String CACHE_OBJECT = "com.ibm.websphere.naming.jndicache.cacheobject";
    protected static final String CACHE_OBJECT_NONE = "none";
    protected static final String CACHE_OBJECT_POPULATED = "populated";
    protected static final String CACHE_OBJECT_CLEARED = "cleared";
    protected static final String CACHE_OBJECT_DEFAULT = "populated";
    protected static final String CACHE_NAME = "com.ibm.websphere.naming.jndicache.cachename";
    protected static final String CACHE_NAME_DEFAULT = "providerURL";
    private static final String CACHE_NAME_DEFAULT_VALUE = "iiop:///";
    protected static final String MAX_CACHE_LIFE = "com.ibm.websphere.naming.jndicache.maxcachelife";
    protected static final int MAX_CACHE_LIFE_DEFAULT = 0;
    protected static final String MAX_ENTRY_LIFE = "com.ibm.websphere.naming.jndicache.maxentrylife";
    protected static final int MAX_ENTRY_LIFE_DEFAULT = 0;
    private static final TraceComponent _tc = Tr.register(Cache.class, "Naming");
    private Hashtable _env;
    private NameSpace _cache;
    private long _lastCacheValidationTime;
    private String _cacheName;
    private ClassLoader _classLoader;
    private int _maxCacheLife;
    private int _maxEntryLife;
    private boolean _debug;

    public Cache(String string, ClassLoader classLoader, Hashtable hashtable) throws CacheInvalidPropertyValueException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Cache(String, Hashtable)", "name=" + string);
        }
        this.init(string, classLoader, hashtable);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Cache(String, Hashtable)");
        }
    }

    private void init(String string, ClassLoader classLoader, Hashtable hashtable) throws CacheInvalidPropertyValueException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init", new Object[]{"name=" + string, "classLoader=" + classLoader});
        }
        this._env = hashtable;
        this._cacheName = string;
        this._classLoader = classLoader;
        try {
            this._cache = new NameSpace(2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._cache = null;
        }
        this._lastCacheValidationTime = Cache.currentTime();
        this.setLifetimeProperties(hashtable);
        this._debug = false;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLifetimeProperties(Hashtable hashtable) throws CacheInvalidPropertyValueException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setLifetimeProperties");
        }
        int n = Cache.maxLifePropertyValue(hashtable, MAX_CACHE_LIFE, 0);
        int n2 = Cache.maxLifePropertyValue(hashtable, MAX_ENTRY_LIFE, 0);
        Cache cache = this;
        synchronized (cache) {
            this._maxCacheLife = n;
            this._maxEntryLife = n2;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Max cache life: " + n);
                Tr.debug(_tc, "Max entry life: " + n2);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setLifetimeProperties");
        }
    }

    public String getCacheName() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getCacheName: " + this._cacheName);
        }
        return this._cacheName;
    }

    public ClassLoader getClassLoader() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getClassLoader: " + this._classLoader);
        }
        return this._classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxCacheLife() {
        Cache cache = this;
        synchronized (cache) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getMaxCacheLife: " + this._maxCacheLife);
            }
            return this._maxCacheLife;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxCacheLife(int n) {
        Cache cache = this;
        synchronized (cache) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setMaxCacheLife: " + n);
            }
            this._maxCacheLife = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxEntryLife() {
        Cache cache = this;
        synchronized (cache) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getMaxEntryLife: " + this._maxEntryLife);
            }
            return this._maxEntryLife;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxEntryLife(int n) {
        Cache cache = this;
        synchronized (cache) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "setMaxEntryLife: " + n);
            }
            this._maxEntryLife = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(UuidContext uuidContext, Name name, ContextID[] contextIDArray, Object object, Object object2, boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "bind");
        }
        Cache cache = this;
        synchronized (cache) {
            block15: {
                this.validateCache();
                UuidContext uuidContext2 = uuidContext;
                if (name.size() > 1 && (uuidContext2 = this.getParentContext(uuidContext, name, contextIDArray)) == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "bind", "getParentContext failed.");
                    }
                    return;
                }
                try {
                    CacheEntryData cacheEntryData = new CacheEntryData();
                    Name name2 = null;
                    name2 = name.size() > 0 ? name.getSuffix(name.size() - 1) : name.getSuffix(name.size());
                    if (bl) {
                        cacheEntryData.setCacheableReference(true);
                        this._cache.bind(uuidContext2, name2, object2, cacheEntryData);
                    } else {
                        this._cache.bind(uuidContext2, name2, object, cacheEntryData);
                    }
                }
                catch (NamingException namingException) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "bind", "Exception returned from NameSpace.bind: " + namingException);
                    }
                }
                catch (NameSpaceException nameSpaceException) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "bind", "Exception returned from NameSpace.bind: " + nameSpaceException);
                    }
                }
                catch (Throwable throwable) {
                    if (!_tc.isDebugEnabled()) break block15;
                    Tr.debug(_tc, "bind: Exception returned from NameSpace.bind:", throwable);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "bind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSubcontext(UuidContext uuidContext, Name name, ContextID[] contextIDArray, UuidContext uuidContext2) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createSubcontext");
        }
        Cache cache = this;
        synchronized (cache) {
            block13: {
                this.validateCache();
                UuidContext uuidContext3 = uuidContext;
                if (name.size() > 1 && (uuidContext3 = this.getParentContext(uuidContext, name, contextIDArray)) == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "createSubcontext", "getParentContext failed.");
                    }
                    return;
                }
                try {
                    CacheEntryData cacheEntryData = new CacheEntryData();
                    Name name2 = null;
                    name2 = name.size() > 0 ? name.getSuffix(name.size() - 1) : name.getSuffix(name.size());
                    this._cache.createSubcontext(uuidContext3, name2, uuidContext2, cacheEntryData);
                }
                catch (NamingException namingException) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "createSubcontext", "Exception returned from NameSpace.createSubcontext: " + namingException);
                    }
                }
                catch (NameSpaceException nameSpaceException) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "createSubcontext", "Exception returned from NameSpace.createSubcontext: " + nameSpaceException);
                    }
                }
                catch (Throwable throwable) {
                    if (!_tc.isDebugEnabled()) break block13;
                    Tr.debug(_tc, "createSubcontext", "Exception returned from NameSpace.createSubcontext:" + throwable);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createSubcontext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroySubcontext(UuidContext uuidContext, Name name, ContextID[] contextIDArray) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "destroySubcontext");
        }
        Cache cache = this;
        synchronized (cache) {
            block13: {
                this.validateCache();
                UuidContext uuidContext2 = this.getParentContext(uuidContext, name, contextIDArray);
                if (uuidContext2 == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "destroySubcontext", "getParentContext failed.");
                    }
                    return;
                }
                try {
                    Name name2 = name.getSuffix(name.size() - 1);
                    this._cache.destroySubcontext(uuidContext2, name2);
                }
                catch (NamingException namingException) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "destroySubcontext", "Exception returned from NameSpace.destroySubcontext: " + namingException);
                    }
                }
                catch (NameSpaceException nameSpaceException) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "destroySubcontext", "Exception returned from NameSpace.destroySubcontext: " + nameSpaceException);
                    }
                }
                catch (Throwable throwable) {
                    if (!_tc.isDebugEnabled()) break block13;
                    Tr.debug(_tc, "destroySubcontext: Exception returned from NameSpace.destroySubcontext:", throwable);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "destroySubcontext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lookup(UuidContext uuidContext, Name name, BooleanWrapper booleanWrapper) throws CacheEntryNotFoundException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "lookup");
        }
        if (_tc.isDebugEnabled()) {
            try {
                if (uuidContext != null) {
                    Tr.debug(_tc, "lookup currCtx=" + uuidContext.getNameInNamespace() + ", name=" + name.toString());
                } else {
                    Tr.debug(_tc, "lookup: currCtx=null, name=" + name.toString());
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        Object object = null;
        Cache cache = this;
        synchronized (cache) {
            this.validateCache();
            try {
                NameSpaceBindingData nameSpaceBindingData = this._cache.lookup(uuidContext, name);
                CacheEntryData cacheEntryData = (CacheEntryData)nameSpaceBindingData.getAdditionalData();
                booleanWrapper.value = cacheEntryData.isCacheableReference();
                object = this.validateEntry(uuidContext, name, nameSpaceBindingData.getBoundObject(), cacheEntryData);
            }
            catch (NamingException namingException) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "lookup: NamingException: " + namingException);
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "lookup: CacheEntryNotFoundException");
                }
                throw new CacheEntryNotFoundException("Entry \"" + name.toString() + "\" not found in cache.");
            }
            catch (NameSpaceException nameSpaceException) {
                FFDCFilter.processException((Throwable)nameSpaceException, "com.ibm.ws.naming.jcache.Cache.lookup", "578", this);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "lookup: NameSpaceException", nameSpaceException);
                }
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "lookup: NameSpaceException");
                }
                throw new CacheEntryNotFoundException("Entry \"" + name.toString() + "\" not found in cache.");
            }
            if (object == null) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "lookup: cached object failed validation.");
                }
                throw new CacheEntryNotFoundException("Entry \"" + name.toString() + "\" not found in cache.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "lookup");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(UuidContext uuidContext, Name name, ContextID[] contextIDArray, Object object, Object object2, boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "rebind");
        }
        Cache cache = this;
        synchronized (cache) {
            block15: {
                this.validateCache();
                UuidContext uuidContext2 = this.getParentContext(uuidContext, name, contextIDArray);
                if (uuidContext2 == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "rebind", "getParentContext failed.");
                    }
                    return;
                }
                try {
                    CacheEntryData cacheEntryData = new CacheEntryData();
                    Name name2 = name.getSuffix(name.size() - 1);
                    if (bl) {
                        cacheEntryData.setCacheableReference(true);
                        this._cache.rebind(uuidContext2, name2, object2, cacheEntryData);
                    } else {
                        this._cache.rebind(uuidContext2, name2, object, cacheEntryData);
                    }
                }
                catch (NamingException namingException) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "rebind", "Exception returned from NameSpace.rebind: " + namingException);
                    }
                }
                catch (NameSpaceException nameSpaceException) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "rebind", "Exception returned from NameSpace.rebind: " + nameSpaceException);
                    }
                }
                catch (Throwable throwable) {
                    if (!_tc.isDebugEnabled()) break block15;
                    Tr.debug(_tc, "rebind: Exception returned from NameSpace.rebind:", throwable);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "rebind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(UuidContext uuidContext, Name name, ContextID[] contextIDArray) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "unbind");
        }
        Cache cache = this;
        synchronized (cache) {
            block13: {
                this.validateCache();
                UuidContext uuidContext2 = this.getParentContext(uuidContext, name, contextIDArray);
                if (uuidContext2 == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "unbind", "getParentContext failed.");
                    }
                    return;
                }
                try {
                    Name name2 = name.getSuffix(name.size() - 1);
                    this._cache.unbind(uuidContext2, name2);
                }
                catch (NamingException namingException) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "unbind", "Exception returned from NameSpace.unbind: " + namingException);
                    }
                }
                catch (NameSpaceException nameSpaceException) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "unbind", "Exception returned from NameSpace.unbind: " + nameSpaceException);
                    }
                }
                catch (Throwable throwable) {
                    if (!_tc.isDebugEnabled()) break block13;
                    Tr.debug(_tc, "unbind: Exception returned from NameSpace.unbind:", throwable);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "unbind");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "clear");
        }
        Cache cache = this;
        synchronized (cache) {
            this._cache.clear();
            this._lastCacheValidationTime = Cache.currentTime();
        }
        CacheManager.clearJavaNameSpaceCaches(this._classLoader);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "clear");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UuidContext getParentContext(UuidContext uuidContext, Name name, ContextID[] contextIDArray) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getParentContext");
        }
        Object object = uuidContext;
        Cache cache = this;
        synchronized (cache) {
            try {
                if (name.size() > 1) {
                    NameSpaceBindingData nameSpaceBindingData = this._cache.getParentContext(uuidContext, name);
                    object = (UuidContext)nameSpaceBindingData.getBoundObject();
                }
            }
            catch (NamingException namingException) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getParentContext", "Exception returned from NameSpace.getParentContext: " + namingException);
                }
                for (int i = 0; i < name.size() - 1; ++i) {
                    try {
                        Object object2;
                        Object object3;
                        WsnName wsnName;
                        try {
                            wsnName = new WsnName(name.get(i), this._env);
                        }
                        catch (Exception exception) {
                            Tr.debug(_tc, "Exception thrown while creating a name component using WsnName", new Object[]{"inputName=" + name.toString(), " compIndex=" + i, namingException});
                            object = null;
                            break;
                        }
                        boolean bl = true;
                        try {
                            object3 = this._cache.intermediateCacheLookup((UuidContext)object, wsnName);
                            object2 = object3.getBoundObject();
                            if (object2 instanceof UuidContext) {
                                object = (UuidContext)object2;
                            } else {
                                bl = false;
                            }
                        }
                        catch (NameNotFoundException nameNotFoundException) {
                            try {
                                if (_tc.isDebugEnabled()) {
                                    if (object != null) {
                                        Tr.debug(_tc, "getParentContext", "Exception returned from NameSpace.lookup. relName=" + ((Object)wsnName).toString() + ", parent ctx name=" + object.getNameInNamespace() + ", parent ctx id=" + ((Object)object.getContextID()).toString() + ", exception=" + nameNotFoundException);
                                    } else {
                                        Tr.debug(_tc, "getParentContext", "Exception returned from NameSpace.lookup. relName=" + ((Object)wsnName).toString() + ", parent ctx name=null" + ", exception=" + nameNotFoundException);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (contextIDArray == null || contextIDArray.length <= i) {
                                object = null;
                                break;
                            }
                            bl = false;
                        }
                        if (bl) continue;
                        object3 = name.getPrefix(i + 1);
                        object2 = new UnresolvedContext(((Object)contextIDArray[i]).toString(), object3.toString());
                        CacheEntryData cacheEntryData = new CacheEntryData();
                        this._cache.createSubcontext((UuidContext)object, wsnName, (UuidContext)object2, cacheEntryData);
                        object = object2;
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "getParentContext: Exception received:", throwable);
                        }
                        object = null;
                    }
                }
            }
            catch (Throwable throwable) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getParentContext: Exception received:", throwable);
                }
                object = null;
            }
        }
        if (_tc.isDebugEnabled()) {
            try {
                if (object != null) {
                    Tr.debug(_tc, "getParentContext", "returning context name=" + object.getNameInNamespace() + "ctx id=" + ((Object)object.getContextID()).toString());
                } else {
                    Tr.debug(_tc, "getParentContext", "returning null context");
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getParentContext");
        }
        return object;
    }

    private boolean validateCache() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "validateCache");
        }
        boolean bl = false;
        if (this.isExpired()) {
            this._cache.clear();
            this._lastCacheValidationTime = Cache.currentTime();
            bl = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "validateCache", new Boolean(bl));
        }
        return bl;
    }

    private Object validateEntry(UuidContext uuidContext, Name name, Object object, CacheEntryData cacheEntryData) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "validateEntry");
        }
        if (this.isExpired(cacheEntryData)) {
            try {
                if (object instanceof UuidContext) {
                    this._cache.destroySubcontext(uuidContext, name);
                } else {
                    this._cache.unbind(uuidContext, name);
                }
                CacheManager.clearJavaNameSpaceCaches(this._classLoader);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = null;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Entry cleared: " + (object == null));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "validateEntry");
        }
        return object;
    }

    private boolean isExpired() {
        return this._maxCacheLife != 0 && this.elapsedTimeInMinutes(this._lastCacheValidationTime) >= (long)this._maxCacheLife;
    }

    private boolean isExpired(CacheEntryData cacheEntryData) {
        return this._maxEntryLife != 0 && this.elapsedTimeInMinutes(cacheEntryData.getCreationTime()) >= (long)this._maxEntryLife;
    }

    private long elapsedTimeInMinutes(long l) {
        long l2 = Cache.currentTime();
        return (l2 - l) / 60000L;
    }

    public static String cacheObjectPropertyValue(Hashtable hashtable) throws CacheInvalidPropertyValueException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cachObjectPropertyValue");
        }
        String string = null;
        if (hashtable != null) {
            Object v = hashtable.get(CACHE_OBJECT);
            if (v == null || v instanceof String) {
                string = (String)v;
            } else {
                throw new CacheInvalidPropertyValueException("Value for the property \"com.ibm.websphere.naming.jndicache.cacheobject\" is not a String.");
            }
        }
        if (string != null) {
            if (!(string.equals(CACHE_OBJECT_NONE) || string.equals(CACHE_OBJECT_CLEARED) || string.equals("populated"))) {
                throw new CacheInvalidPropertyValueException("Value of \"" + string + "\" for the property \"" + CACHE_OBJECT + "\" is not valid.");
            }
        } else {
            string = "populated";
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cachObjectPropertyValue", string);
        }
        return string;
    }

    public static String cacheNamePropertyValue(Hashtable hashtable) throws CacheInvalidPropertyValueException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cachNamePropertyValue");
        }
        String string = null;
        if (hashtable != null) {
            Object v = hashtable.get(CACHE_NAME);
            if (v == null || v instanceof String) {
                string = (String)v;
            } else {
                throw new CacheInvalidPropertyValueException("Value for the property \"com.ibm.websphere.naming.jndicache.cachename\" is not a String.");
            }
        }
        if (string == null) {
            string = CACHE_NAME_DEFAULT;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cachNamePropertyValue", string);
        }
        return string;
    }

    public static String cacheNameFromPropertyValue(Hashtable hashtable) throws CacheInvalidPropertyValueException {
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "cacheNameFromPropertyValue");
        }
        if ((string = Cache.cacheNamePropertyValue(hashtable)) == null || string.equals(CACHE_NAME_DEFAULT)) {
            String string2 = null;
            Object v = hashtable.get("java.naming.provider.url");
            if (v != null && !(v instanceof String)) {
                throw new CacheInvalidPropertyValueException("Value for the property \"java.naming.provider.url\" is not a String.");
            }
            string2 = (String)v;
            try {
                if (string2 == null) {
                    string2 = System.getProperty("java.naming.provider.url");
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string2 == null) {
                string2 = CACHE_NAME_DEFAULT_VALUE;
            }
            string = Cache.normalizeUrl(string2);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "cacheNameFromPropertyValue", string);
        }
        return string;
    }

    private static int maxLifePropertyValue(Hashtable hashtable, String string, int n) throws CacheInvalidPropertyValueException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "maxLifePropertyValue");
        }
        String string2 = null;
        int n2 = n;
        if (hashtable != null) {
            Object v = hashtable.get(string);
            if (v == null || v instanceof String) {
                string2 = (String)v;
            } else {
                throw new CacheInvalidPropertyValueException("Value for the property \"" + string + "\" is not a String.");
            }
        }
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException(numberFormatException, "com.ibm.ws.naming.jcache.Cache.maxLifePropertyValue", "1143");
                throw new CacheInvalidPropertyValueException("Value for the property \"" + string + "\" is not a valid number.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "maxLifePropertyValue", new Integer(n2));
        }
        return n2;
    }

    private static String normalizeUrl(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalized url");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "input url: " + string);
        }
        if (string != null) {
            int n = string.indexOf("//");
            if (n != -1) {
                n += 2;
                n = string.indexOf("/", n);
            }
            if (n != -1) {
                string = string.substring(0, n);
            }
            string = string.toLowerCase();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalized url", string);
        }
        return string;
    }

    private static long currentTime() {
        return System.currentTimeMillis();
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    private void printDebug(String string) {
        if (this._debug) {
            System.out.println("CACHE DEBUG: " + string);
        }
    }

    public void dump() {
        this.printDebug("BEGIN CACHE DUMP OF " + this._cacheName + " for class loader " + this._classLoader);
        this._cache.dumpNameSpace(null);
        this.printDebug("END CACHE DUMP OF " + this._cacheName + " for class loader " + this._classLoader);
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: SERV1/ws/code/naming.client/src/com/ibm/ws/naming/jcache/Cache.java, WAS.naming.client, WAS61.SERV1, cf130745.06, ver. 1.23");
        }
    }
}

