/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class NotificationInfo
implements NotificationFilter {
    private static final long serialVersionUID = 6448465470064588827L;
    private static TraceComponent tc = Tr.register(NotificationInfo.class, "Admin", "com.ibm.ws.management.resources.event");
    private final ObjectName name;
    private final NotificationFilter filter;
    private transient Vector enabledFilterSupportTypes;

    public NotificationInfo(ObjectName objectName, NotificationFilter notificationFilter) {
        this.name = objectName;
        this.filter = notificationFilter;
        this.initializeFilterSupportTypes();
    }

    private void initializeFilterSupportTypes() {
        if (this.enabledFilterSupportTypes == null && this.filter instanceof NotificationFilterSupport) {
            this.enabledFilterSupportTypes = ((NotificationFilterSupport)this.filter).getEnabledTypes();
        }
    }

    public ObjectName getName() {
        return this.name;
    }

    public NotificationFilter getFilter() {
        return this.filter;
    }

    public boolean contains(ObjectName objectName, NotificationFilter notificationFilter) {
        return this.containsName(objectName) && this.containsFilter(notificationFilter);
    }

    public boolean containsName(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsName", objectName);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current name:", this.name);
        }
        boolean bl = NotificationInfo.containsName(this.name, objectName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsName", new Boolean(bl));
        }
        return bl;
    }

    public static boolean containsName(ObjectName objectName, ObjectName objectName2) {
        boolean bl;
        block5: {
            block4: {
                bl = true;
                if (objectName.isPropertyPattern()) break block4;
                if (objectName.getCanonicalName().equals(objectName2.getCanonicalName())) break block5;
                bl = false;
                break block5;
            }
            if (!NotificationInfo.containsDomain(objectName.getDomain(), objectName2.getDomain())) {
                bl = false;
            } else {
                Hashtable<String, String> hashtable = objectName.getKeyPropertyList();
                Enumeration<String> enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    if (string.equals("*")) continue;
                    String string2 = objectName2.getKeyProperty(string);
                    if (string2 == null) {
                        bl = false;
                        break;
                    }
                    if (objectName.getKeyProperty(string).equals(string2)) continue;
                    bl = false;
                    break;
                }
            }
        }
        return bl;
    }

    private static boolean containsDomain(String string, String string2) {
        return NotificationInfo.containsPattern(string, string2);
    }

    private static boolean containsPattern(String string, String string2) {
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            ++n;
            char c = string.charAt(i);
            if (c == '*') {
                return NotificationInfo.matchWildCard(string.substring(i), string2.substring(n));
            }
            if (string2.length() < n + 1) {
                return false;
            }
            char c2 = string2.charAt(n);
            if (c == '?' || c == c2) continue;
            return false;
        }
        return string2.length() <= n + 1;
    }

    private static boolean matchWildCard(String string, String string2) {
        if (string.equals("*")) {
            return true;
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (!NotificationInfo.containsPattern(string.substring(1), string2.substring(i))) continue;
            return true;
        }
        return false;
    }

    public boolean containsFilter(NotificationFilter notificationFilter) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsFilter", this.toFilterString(notificationFilter));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current filter:", this.toFilterString(this.filter));
        }
        boolean bl = false;
        if (this.filter == null) {
            bl = true;
        } else if (notificationFilter == null) {
            bl = false;
        } else {
            this.initializeFilterSupportTypes();
            if (this.enabledFilterSupportTypes != null && notificationFilter instanceof NotificationFilterSupport) {
                Vector<String> vector = ((NotificationFilterSupport)notificationFilter).getEnabledTypes();
                bl = this.enabledFilterSupportTypes.containsAll(vector);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsFilter", new Boolean(bl));
        }
        return bl;
    }

    private String toFilterString(NotificationFilter notificationFilter) {
        if (notificationFilter == null) {
            return "null";
        }
        if (notificationFilter instanceof NotificationFilterSupport) {
            return "NotificationFilterSupport: " + ((NotificationFilterSupport)notificationFilter).getEnabledTypes();
        }
        return notificationFilter.toString();
    }

    public boolean isNotificationEnabled(Notification notification) {
        ObjectName objectName = null;
        try {
            objectName = (ObjectName)notification.getSource();
        }
        catch (ClassCastException classCastException) {
            Tr.warning(tc, "ADME0007W", (Object)new String[]{notification.getType(), notification.getSource().toString()});
            return false;
        }
        return this.containsName(objectName) && (this.filter == null || this.filter.isNotificationEnabled(notification));
    }

    public boolean isFilterEnabled(Notification notification) {
        return this.filter == null || this.filter.isNotificationEnabled(notification);
    }

    public String toString() {
        return "NotificationInfo: [name=" + this.name + ";filter=" + this.filter + "]";
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            NotificationInfo notificationInfo = (NotificationInfo)object;
            return (notificationInfo.name == null && this.name == null || notificationInfo.name.equals(this.name)) && (notificationInfo.filter == null && this.filter == null || notificationInfo.filter.equals(this.filter));
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        if (this.name != null) {
            n = 37 * n + this.name.hashCode();
        }
        if (this.filter != null) {
            n = 57 * n + this.filter.hashCode();
        }
        return n;
    }
}

