/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.event.ListenerInfo;
import com.ibm.ws.management.event.NotificationDispatcher;
import com.ibm.ws.management.event.WsNotifListener;
import com.ibm.ws.management.event.WsNotifListenerContainer;
import com.ibm.ws.util.ThreadPool;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class LocalNotificationService
implements WsNotifListener,
WsNotifListenerContainer {
    private static TraceComponent tc = Tr.register(LocalNotificationService.class, "Admin", "com.ibm.ws.management.resources.event");
    public static final long TIME_TO_WAIT_FOR_LISTENER = 60000L;
    private static final int DISPATCH_POOL_MIN = 1;
    private static final int DISPATCH_POOL_MAX = 100;
    private static final int ZOS_DISPATCH_POOL_MAX = 50;
    private List listeners = new ArrayList();
    private NotificationDispatcher dispatcher;
    private ThreadPool dispatchPool;
    private boolean listenersUpdated = true;

    public LocalNotificationService() {
        long l = (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Long.getLong("com.ibm.ws.management.event.LocalNotificationService.threadKeepAliveTime", 60000L);
            }
        });
        this.dispatchPool = AdminHelper.getPlatformHelper().isZOS() ? new ThreadPool("LocalNotificationServiceDispatcher", 1, 50) : new ThreadPool("LocalNotificationServiceDispatcher", 1, 100);
        this.dispatchPool.setKeepAliveTime(l);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new Object[]{objectName, notificationListener, notificationFilter, object});
        }
        this.addListenerInternal(objectName, notificationListener, notificationFilter, object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener");
        }
    }

    public void addNotificationListenerExtended(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListenerExtended", new Object[]{objectName, notificationListener, notificationFilter, object});
        }
        this.addListenerInternal(objectName, notificationListener, notificationFilter, object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListenerExtended");
        }
    }

    protected boolean addListenerInternal(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        ListenerInfo listenerInfo = this.createListenerInfo(objectName, notificationListener, notificationFilter, object);
        return this.addListener(listenerInfo);
    }

    protected ListenerInfo createListenerInfo(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        return new ListenerInfo(objectName, notificationListener, notificationFilter, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(WsNotifListener wsNotifListener) {
        boolean bl = false;
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(wsNotifListener)) {
                this.listeners.add(wsNotifListener);
                bl = true;
                this.listenersUpdated = true;
            }
        }
        return bl;
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", new Object[]{objectName, notificationListener});
        }
        this.removeListenerInternal(objectName, notificationListener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", new Object[]{objectName, notificationListener});
        }
        this.removeListenerInternal(objectName, notificationListener, notificationFilter, object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void removeNotificationListenerExtended(ObjectName objectName, NotificationListener notificationListener) throws ListenerNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListenerExtended", new Object[]{objectName, notificationListener});
        }
        this.removeListenerInternal(objectName, notificationListener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListenerExtended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListenerInternal(ObjectName objectName, NotificationListener notificationListener) throws ListenerNotFoundException {
        List list = this.listeners;
        synchronized (list) {
            ListenerInfo listenerInfo = this.getListenerInfo(objectName, notificationListener);
            if (listenerInfo == null) {
                throw new ListenerNotFoundException("Did not find listener " + notificationListener);
            }
            while (listenerInfo != null) {
                this.listeners.remove(listenerInfo);
                listenerInfo = this.getListenerInfo(objectName, notificationListener);
            }
            this.listenersUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeListenerInternal(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        List list = this.listeners;
        synchronized (list) {
            ListenerInfo listenerInfo = this.getListenerInfo(objectName, notificationListener, notificationFilter, object);
            if (listenerInfo == null) {
                throw new ListenerNotFoundException("Did not find listener " + notificationListener);
            }
            while (listenerInfo != null) {
                this.listeners.remove(listenerInfo);
                listenerInfo = this.getListenerInfo(objectName, notificationListener, notificationFilter, object);
            }
            this.listenersUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(WsNotifListener wsNotifListener) {
        boolean bl = false;
        List list = this.listeners;
        synchronized (list) {
            bl = this.listeners.remove(wsNotifListener);
            if (bl) {
                this.listenersUpdated = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumListeners() {
        List list = this.listeners;
        synchronized (list) {
            return this.listeners.size();
        }
    }

    private ListenerInfo getListenerInfo(ObjectName objectName, NotificationListener notificationListener) {
        ListenerInfo listenerInfo = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ListenerInfo listenerInfo2 = (ListenerInfo)iterator.next();
            if (!listenerInfo2.isMatching(objectName, notificationListener)) continue;
            listenerInfo = listenerInfo2;
            break;
        }
        return listenerInfo;
    }

    private ListenerInfo getListenerInfo(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        ListenerInfo listenerInfo = null;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ListenerInfo listenerInfo2 = (ListenerInfo)iterator.next();
            if (!listenerInfo2.isMatching(objectName, notificationListener, notificationFilter, object)) continue;
            listenerInfo = listenerInfo2;
            break;
        }
        return listenerInfo;
    }

    public boolean isNotificationEnabled(Notification notification) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", notification.getType() + "[source=" + notification.getSource() + "]");
        }
        List list = this.listeners;
        synchronized (list) {
            if (this.listenersUpdated) {
                WsNotifListener[] wsNotifListenerArray = new ListenerInfo[this.listeners.size()];
                wsNotifListenerArray = this.listeners.toArray(wsNotifListenerArray);
                this.dispatcher = new NotificationDispatcher(this, wsNotifListenerArray, true, this.dispatchPool);
            }
        }
        this.dispatcher.handleNotification(notification);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public String toString() {
        return "LocalNotificationService";
    }
}

