/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.interop.JMXObjectInputStream;
import com.ibm.ws.management.connector.interop.JMXObjectOutputStream;
import com.ibm.ws.management.connector.interop.JMXTransformException;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.connector.soap.GenericSerializer;
import com.ibm.ws.util.WsObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Body;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Element;

public class SOAPUtils {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(SOAPUtils.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    public static final QName targetExceptionType = new QName("admin", "TargetExceptionType");
    public static final QName targetExceptionMessage = new QName("admin", "TargetExceptionMessage");
    public static final QName securityEnabled = new QName("admin", "SecurityEnabled");
    public static final String adminServiceURI = "urn:AdminService";

    public static Call extractSoapCall(InputStream inputStream, int n, String string, SOAPContext sOAPContext, SOAPMappingRegistry sOAPMappingRegistry) throws SOAPException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractCall");
        }
        Call call = null;
        try {
            DocumentBuilder documentBuilder = XMLParserUtils.getXMLDocBuilder();
            Envelope envelope = ServerUtils.readEnvelopeFromInputStream(documentBuilder, inputStream, n, string, null, sOAPContext);
            sOAPContext.setProperty("JMXRemoteVersion", JMXVersionValidation.getRemoteVersion(envelope.getHeader()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Incoming Soap Envelope: " + envelope);
            }
            Body body = envelope.getBody();
            Vector vector = body.getBodyEntries();
            Element element = (Element)vector.elementAt(0);
            String string2 = envelope.getAttribute(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"));
            String string3 = body.getAttribute(new QName("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"));
            String string4 = string3 != null ? string3 : string2;
            String string5 = DOMUtils.getAttributeNS(element, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
            String string6 = string5 != null ? string5 : string4;
            String string7 = element.getLocalName();
            String string8 = element.getNamespaceURI();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "URI=" + string8 + " method=" + string7);
            }
            Element element2 = DOMUtils.getFirstChildElement(element);
            Vector<Parameter> vector2 = new Vector<Parameter>();
            while (element2 != null) {
                String string9 = DOMUtils.getAttributeNS(element2, "http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
                String string10 = string9 != null ? string9 : string6;
                Bean bean = sOAPMappingRegistry.unmarshall(string10, RPCConstants.Q_ELEM_PARAMETER, element2, sOAPContext);
                Parameter parameter = (Parameter)bean.value;
                if (string9 != null) {
                    parameter.setEncodingStyleURI(string9);
                }
                vector2.addElement(parameter);
                element2 = DOMUtils.getNextSiblingElement(element2);
            }
            call = new Call(string8, string7, vector2, null, string5, sOAPContext);
            call.setSOAPMappingRegistry(sOAPMappingRegistry);
            call.setHeader(envelope.getHeader());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unmarshalled RPC call is " + call);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.connector.soap.SOAPUtils.extractSoapCall", "157");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to extract the SOAP Call", exception);
            }
            SOAPException sOAPException = new SOAPException(Constants.FAULT_CODE_SERVER + ".Exception", nls.getString("ADMC0011E", "The Soap RPC call can't be unmarshalled"), exception);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "extractCall");
            }
            throw sOAPException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractCall");
        }
        return call;
    }

    public static String convertObjectToString(Object object, String string) throws IllegalArgumentException {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertObjectToString");
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new JMXObjectOutputStream(byteArrayOutputStream);
            ((JMXObjectOutputStream)objectOutputStream).jmxWriteObject(object, string);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.management.connector.soap.SOAPUtils.convertObjectToString", "187");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failed to convert object to string", iOException);
            }
            throw new IllegalArgumentException(iOException.getMessage());
        }
        catch (JMXTransformException jMXTransformException) {
            FFDCFilter.processException(jMXTransformException, "com.ibm.ws.management.connector.soap.SOAPUtils.convertObjectToString", "187");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JMX transformation failed for this object", jMXTransformException);
            }
            throw new IllegalArgumentException(jMXTransformException.getMessage());
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.management.connector.soap.SOAPUtils.convertObjectToString", "219");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertObjectToString");
        }
        return Base64.encode(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertStringToObject(String string, String string2) throws IllegalArgumentException {
        Object object;
        block21: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "convertStringToObject");
            }
            ObjectInputStream objectInputStream = null;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64.decode(string));
                if (JMXVersionValidation.isRemoteVersionTmx4j(string2)) {
                    Thread thread2 = Thread.currentThread();
                    ClassLoader classLoader = thread2.getContextClassLoader();
                    thread2.setContextClassLoader(GenericSerializer.getJMXClassLoader());
                    try {
                        JMXObjectInputStream jMXObjectInputStream = new JMXObjectInputStream(byteArrayInputStream);
                        object = jMXObjectInputStream.jmxReadObject();
                        break block21;
                    }
                    finally {
                        thread2.setContextClassLoader(classLoader);
                    }
                }
                objectInputStream = new WsObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.management.connector.soap.SOAPUtils.convertStringToObject", "248");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to convert string to object", iOException);
                }
                throw new IllegalArgumentException(iOException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException(classNotFoundException, "com.ibm.ws.management.connector.soap.SOAPUtils.convertStringToObject", "257");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no class definition for to-be-serialized object", classNotFoundException);
                }
                throw new IllegalArgumentException(classNotFoundException.getMessage());
            }
            catch (JMXTransformException jMXTransformException) {
                FFDCFilter.processException(jMXTransformException, "com.ibm.ws.management.connector.soap.SOAPUtils.convertStringToObject", "257");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "JMX transformation failed for this object", jMXTransformException);
                }
                throw new IllegalArgumentException(jMXTransformException.getMessage());
            }
            finally {
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    FFDCFilter.processException(iOException, "com.ibm.ws.management.connector.soap.SOAPUtils.convertStringToObject", "269");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertStringToObject");
        }
        return object;
    }

    public static String encodeDataString(String string) {
        if (string == null) {
            return "";
        }
        boolean bl = false;
        int n = string.length();
        if (n < 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block12: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block12;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block12;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block12;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block12;
                }
                case '+': {
                    stringBuffer.append("&#43;");
                    continue block12;
                }
                case '(': {
                    stringBuffer.append("&#40;");
                    continue block12;
                }
                case ')': {
                    stringBuffer.append("&#41;");
                    continue block12;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    continue block12;
                }
                case '%': {
                    stringBuffer.append("&#37;");
                    continue block12;
                }
                case ';': {
                    stringBuffer.append("&#59;");
                    continue block12;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }
}

