/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.interop;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.connector.interop.JMXTransformException;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.connector.soap.GenericSerializer;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JMXObjectOutputStream
extends ObjectOutputStream {
    private static TraceComponent tc = Tr.register(JMXObjectOutputStream.class, "Admin", "com.ibm.ws.management.resources.connector");
    private String remoteJMXVersion = "";
    private static Object transformWriter = GenericSerializer.getJMXTransformWriter();

    public JMXObjectOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.enableReplaceObject(true);
    }

    protected Object replaceObject(Object object) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceObject");
        }
        if (!(object instanceof Serializable)) {
            Tr.error(tc, "ADMC0001E", object.getClass().getName());
        } else if (JMXVersionValidation.isRemoteVersionTmx4j(this.remoteJMXVersion)) {
            Object object2 = null;
            try {
                Class[] classArray = new Class[]{Object.class};
                Object[] objectArray = new Object[]{object};
                Class<?> clazz = transformWriter.getClass();
                Method method2 = clazz.getMethod("transform", classArray);
                object = object2 = method2.invoke(transformWriter, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException(noSuchMethodException.getLocalizedMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(illegalAccessException.getLocalizedMessage());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IOException(invocationTargetException.getLocalizedMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceObject");
        }
        return object;
    }

    public void jmxWriteObject(Object object, String string) throws IOException, JMXTransformException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jmxWriteObject " + object);
        }
        this.remoteJMXVersion = string;
        this.writeObject(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jmxWriteObject " + object);
        }
    }
}

