/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.interop;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.connector.interop.JMXClassLoader;
import com.ibm.ws.management.connector.interop.JMXTransformException;
import com.ibm.ws.management.connector.interop.JMXTransformReader;
import com.ibm.ws.management.connector.soap.GenericSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;

public class JMXObjectInputStream
extends ObjectInputStream {
    private static TraceComponent tc = Tr.register(JMXObjectInputStream.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static JMXTransformReader jmxTransform = GenericSerializer.getJMXTransformReader();
    private static JMXClassLoader classLoader = GenericSerializer.getJMXClassLoader();

    public JMXObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.enableResolveObject(true);
    }

    public Object jmxReadObject() throws IOException, ClassNotFoundException, JMXTransformException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "jmxReadObject");
        }
        Object object = null;
        object = this.readObject();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Transforming object");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ToTMX4jOutputStream toTMX4jOutputStream = new ToTMX4jOutputStream(byteArrayOutputStream);
        toTMX4jOutputStream.writeObject(object);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        object = objectInputStream.readObject();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "jmxReadObject");
        }
        return object;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveClass", new Object[]{objectStreamClass.getName()});
        }
        String string = objectStreamClass.getName();
        Class clazz = null;
        clazz = classLoader.loadClass(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveClass");
        }
        return clazz;
    }

    public static class ToTMX4jOutputStream
    extends ObjectOutputStream {
        public ToTMX4jOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ToTMX4jOutputStream");
            }
            this.enableReplaceObject(true);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ToTMX4jOutputStream");
            }
        }

        public Object replaceObject(Object object) throws IOException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "replaceObject ", new Object[]{object, object.getClass().getName()});
            }
            try {
                object = jmxTransform.transform(object);
            }
            catch (JMXTransformException jMXTransformException) {
                throw new IOException(jMXTransformException.getLocalizedMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "replaceObject");
            }
            return object;
        }
    }
}

